/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.BooleanOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.EnumOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.LongOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.VerbosityOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.Transformations;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;

public class SolverOptions {
    private final LongOption mTimeout;
    private final LongOption mReproducibleResourceLimit;
    private final BooleanOption mProduceProofs;
    private final LongOption mRandomSeed;
    private final BooleanOption mInterpolantCheckMode;
    private final BooleanOption mProduceInterpolants;
    private final BooleanOption mModelCheckMode;
    private final EnumOption<Transformations.AvailableTransformations> mProofTrans;
    private final BooleanOption mModelsPartial;
    private final EnumOption<SMTInterpol.CheckType> mCheckType;
    private final BooleanOption mSimpIps;
    private final BooleanOption mProofCheckMode;
    private final EnumOption<SMTInterpol.CheckType> mSimpCheckType;
    private final EnumOption<SMTInterpol.ProofMode> mProofLevel;
    private final EnumOption<QuantifierTheory.InstantiationMethod> mInstantiationMethod;
    private final OptionMap mOptions;

    SolverOptions(OptionMap optionMap, LogProxy logProxy) {
        this.mTimeout = new LongOption(0L, true, "Soft timeout in milliseconds for individual check-sat calls.  Values <= 0 deactivate the timeout.");
        this.mReproducibleResourceLimit = new LongOption(0L, true, "Deterministic resource limit for individual check-sat calls. Values <= 0 deactivate the limit.");
        this.mProduceProofs = new BooleanOption(false, false, "Produce proofs for unsatisfiable formulas.");
        this.mRandomSeed = new LongOption(11350294L, true, "Seed for the internal pseudo-random number generator.");
        this.mInterpolantCheckMode = new BooleanOption(false, false, "Check generated interpolants.");
        this.mProduceInterpolants = new BooleanOption(false, false, "Enable interpolant production.");
        this.mModelCheckMode = new BooleanOption(false, true, "Check satisfiable formulas against the produced model.");
        this.mProofTrans = new EnumOption<Transformations.AvailableTransformations>(Transformations.AvailableTransformations.NONE, true, Transformations.AvailableTransformations.class, "Algorithm used to transform the resolution proof tree.");
        this.mModelsPartial = new BooleanOption(false, true, "Don't totalize models.");
        this.mCheckType = new EnumOption<SMTInterpol.CheckType>(SMTInterpol.CheckType.FULL, true, SMTInterpol.CheckType.class, "Strength of check used in check-sat command.");
        this.mSimpIps = new BooleanOption(false, true, "Apply strong context simplification to generated interpolants.");
        this.mProofCheckMode = new BooleanOption(false, false, "Check the produced proof for unsatisfiable formulas.");
        this.mSimpCheckType = new EnumOption<SMTInterpol.CheckType>(SMTInterpol.CheckType.QUICK, true, SMTInterpol.CheckType.class, "Strength of checks used by the strong context simplifier used in the simplify command");
        this.mInstantiationMethod = new EnumOption<QuantifierTheory.InstantiationMethod>(QuantifierTheory.InstantiationMethod.E_MATCHING_CONFLICT, false, QuantifierTheory.InstantiationMethod.class, "Quantifier Theory: Method to instantiate quantified formulas.");
        this.mProofLevel = new EnumOption<SMTInterpol.ProofMode>(SMTInterpol.ProofMode.NONE, false, SMTInterpol.ProofMode.class, "Proof level.");
        optionMap.addOption(":verbosity", new VerbosityOption(logProxy));
        optionMap.addOption(":timeout", this.mTimeout);
        optionMap.addOption(":reproducible-resource-limit", this.mReproducibleResourceLimit);
        optionMap.addOption(":random-seed", this.mRandomSeed);
        optionMap.addOption(":produce-assertions", new BooleanOption(false, false, "Store asserted formulas for later retrieval."));
        optionMap.addAlias(":interactive-mode", ":produce-assertions");
        optionMap.addOption(":produce-models", new BooleanOption(false, true, "Produce models for satisfiable formulas"));
        optionMap.addOption(":models-partial", this.mModelsPartial);
        optionMap.addOption(":model-check-mode", this.mModelCheckMode);
        optionMap.addOption(":produce-assignments", new BooleanOption(false, false, "Produce assignments of named Boolean terms for satisfiable formulas"));
        optionMap.addOption(":produce-proofs", this.mProduceProofs);
        optionMap.addOption(":proof-transformation", this.mProofTrans);
        optionMap.addOption(":proof-check-mode", this.mProofCheckMode);
        optionMap.addOption(":proof-level", this.mProofLevel);
        optionMap.addOption(":produce-interpolants", this.mProduceInterpolants);
        optionMap.addOption(":interpolant-check-mode", this.mInterpolantCheckMode);
        optionMap.addOption(":simplify-interpolants", this.mSimpIps);
        optionMap.addOption(":produce-unsat-cores", new BooleanOption(false, false, "Enable production of unsatisfiable cores."));
        optionMap.addOption(":unsat-core-check-mode", new BooleanOption(false, false, "Check generated unsat cores"));
        optionMap.addOption(":produce-unsat-assumptions", new BooleanOption(false, false, "Enable production of unsatisfiable assumptions."));
        optionMap.addOption(":unsat-assumptions-check-mode", new BooleanOption(false, false, "Check generated unsat assumptions"));
        optionMap.addOption(":check-type", this.mCheckType);
        optionMap.addOption(":epr", new BooleanOption(false, false, "Assume formula is in EPR fragment. This give an error if the formula is outside EPR."));
        optionMap.addOption(":instantiation-method", this.mInstantiationMethod);
        optionMap.addOption(":unknown-term-dawgs", new BooleanOption(true, false, "Quantifier Theory: Use fourth instance value UNKNOWN_TERM as default in literal dawgs."));
        optionMap.addOption(":propagate-unknown-terms", new BooleanOption(false, false, "Quantifier Theory: Allow propagation on atoms with non-existing term."));
        optionMap.addOption(":propagate-unknown-aux", new BooleanOption(false, false, "Quantifier Theory: Allow propagation on atoms with non-existing @AUX applications."));
        optionMap.addOption(":simplify-check-type", this.mSimpCheckType);
        optionMap.addOption(":simplify-repeatedly", new BooleanOption(true, true, "Simplify until the fixpoint is reached."));
        optionMap.addOption(":global-declarations", new BooleanOption(false, false, "Make all declared and defined symbols global.  Global symbols survive pop operations."));
        this.mOptions = optionMap;
    }

    SolverOptions(OptionMap optionMap) {
        this.mTimeout = (LongOption)optionMap.getOption(":timeout");
        this.mReproducibleResourceLimit = (LongOption)optionMap.getOption(":reproducible-resource-limit");
        this.mProduceProofs = (BooleanOption)optionMap.getOption(":produce-proofs");
        this.mRandomSeed = (LongOption)optionMap.getOption(":random-seed");
        this.mInterpolantCheckMode = (BooleanOption)optionMap.getOption(":interpolant-check-mode");
        this.mProduceInterpolants = (BooleanOption)optionMap.getOption(":produce-interpolants");
        this.mModelCheckMode = (BooleanOption)optionMap.getOption(":model-check-mode");
        this.mProofTrans = (EnumOption)optionMap.getOption(":proof-transformation");
        this.mModelsPartial = (BooleanOption)optionMap.getOption(":models-partial");
        this.mCheckType = (EnumOption)optionMap.getOption(":check-type");
        this.mSimpIps = (BooleanOption)optionMap.getOption(":simplify-interpolants");
        this.mProofCheckMode = (BooleanOption)optionMap.getOption(":proof-check-mode");
        this.mSimpCheckType = (EnumOption)optionMap.getOption(":simplify-check-type");
        this.mProofLevel = (EnumOption)optionMap.getOption(":proof-level");
        this.mInstantiationMethod = (EnumOption)optionMap.getOption(":instantiation-method");
        this.mOptions = optionMap;
    }

    public final SMTInterpol.CheckType getCheckType() {
        return this.mCheckType.getValue();
    }

    public final void setCheckType(SMTInterpol.CheckType checkType) {
        this.mCheckType.set((Object)checkType);
    }

    public final boolean isInterpolantCheckModeActive() {
        return this.mInterpolantCheckMode.getValue();
    }

    public final boolean isModelCheckModeActive() {
        return this.mModelCheckMode.getValue();
    }

    public final boolean isModelsPartial() {
        return this.mModelsPartial.getValue();
    }

    public final boolean isProduceInterpolants() {
        return this.mProduceInterpolants.getValue();
    }

    public final boolean isProduceProofs() {
        return this.mProduceProofs.getValue();
    }

    public final boolean isProofCheckModeActive() {
        return this.mProofCheckMode.getValue();
    }

    public final SMTInterpol.ProofMode getProofMode() {
        SMTInterpol.ProofMode proofMode = this.mProofLevel.getValue();
        if (proofMode == SMTInterpol.ProofMode.NONE) {
            if (this.isProduceProofs() || this.isProofCheckModeActive()) {
                proofMode = SMTInterpol.ProofMode.LOWLEVEL;
            } else if (this.isProduceInterpolants() || ((Boolean)this.mOptions.get(":produce-unsat-cores")).booleanValue()) {
                proofMode = SMTInterpol.ProofMode.CLAUSES;
            }
        }
        return proofMode;
    }

    public final Transformations.AvailableTransformations getProofTransformation() {
        return this.mProofTrans.getValue();
    }

    public final long getRandomSeed() {
        return this.mRandomSeed.getValue();
    }

    public final boolean isSimplifyInterpolants() {
        return this.mSimpIps.getValue();
    }

    public final long getTimeout() {
        return this.mTimeout.getValue();
    }

    public final long getReproducibleResourceLimit() {
        return this.mReproducibleResourceLimit.getValue();
    }

    public SMTInterpol.CheckType getSimplifierCheckType() {
        return this.mSimpCheckType.getValue();
    }

    public QuantifierTheory.InstantiationMethod getInstantiationMethod() {
        return this.mInstantiationMethod.getValue();
    }
}

