/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationResultReporter;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.StaticObjectsHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.SymbolTableValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CNamed;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.CDeclaration;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.DeclarationResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.DeclaratorResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.SkipResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.TypesResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.BoogieASTUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.INameHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.LinkedScopedHashMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.SymmetricHashRelation;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;

public class TypeHandler
implements ITypeHandler {
    private final LinkedScopedHashMap<String, TypesResult> mDefinedTypes;
    private final LinkedHashSet<String> mIncompleteType;
    private final Map<String, CStructOrUnion> mIncompleteCStructOrUnionObjects = new HashMap<String, CStructOrUnion>();
    private final HashRelation<String, CEnum> mIncompleteCEnumObjects = new HashRelation();
    private boolean mPointerTypeNeeded = false;
    private boolean mFloatingTypesNeeded = false;
    private final BoogieType mBoogiePointerType;
    private final CTranslationResultReporter mReporter;
    private final INameHandler mNameHandler;
    private final TypeSizes mTypeSizes;
    private final FlatSymbolTable mSymboltable;
    private final TranslationSettings mTranslationSettings;
    private final LocationFactory mLocationFactory;
    private final StaticObjectsHandler mStaticObjectsHandler;
    private final HashRelation<String, String> mNamedIncompleteTypes = new HashRelation();
    private final Map<String, ICType> mLibraryTypes = new HashMap<String, ICType>();

    public TypeHandler(CTranslationResultReporter cTranslationResultReporter, INameHandler iNameHandler, TypeSizes typeSizes, FlatSymbolTable flatSymbolTable, TranslationSettings translationSettings, LocationFactory locationFactory, StaticObjectsHandler staticObjectsHandler) {
        this.mReporter = cTranslationResultReporter;
        this.mNameHandler = iNameHandler;
        this.mTypeSizes = typeSizes;
        this.mDefinedTypes = new LinkedScopedHashMap();
        this.mIncompleteType = new LinkedHashSet();
        this.mSymboltable = flatSymbolTable;
        this.mTranslationSettings = translationSettings;
        this.mLocationFactory = locationFactory;
        this.mStaticObjectsHandler = staticObjectsHandler;
        BoogieType boogieType = (BoogieType)this.cType2AstType(null, this.mTranslationSettings.getCTypeOfPointerComponents()).getBoogieType();
        this.mBoogiePointerType = BoogieType.createStructType((String[])new String[]{"base", "offset"}, (BoogieType[])new BoogieType[]{boogieType, boogieType});
    }

    public TypeHandler(CTranslationResultReporter cTranslationResultReporter, INameHandler iNameHandler, TypeSizes typeSizes, FlatSymbolTable flatSymbolTable, TranslationSettings translationSettings, LocationFactory locationFactory, StaticObjectsHandler staticObjectsHandler, TypeHandler typeHandler) {
        this.mReporter = cTranslationResultReporter;
        this.mNameHandler = iNameHandler;
        this.mTypeSizes = typeSizes;
        this.mSymboltable = flatSymbolTable;
        this.mTranslationSettings = translationSettings;
        this.mLocationFactory = locationFactory;
        this.mStaticObjectsHandler = staticObjectsHandler;
        this.mBoogiePointerType = typeHandler.mBoogiePointerType;
        this.mDefinedTypes = typeHandler.mDefinedTypes;
        this.mIncompleteType = typeHandler.mIncompleteType;
    }

    @Override
    public void requestFloatingTypes() {
        this.mFloatingTypesNeeded = true;
    }

    @Override
    public Result visit(IDispatcher iDispatcher, IASTSimpleDeclSpecifier iASTSimpleDeclSpecifier) {
        Object object;
        CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation((IASTNode)iASTSimpleDeclSpecifier);
        switch (iASTSimpleDeclSpecifier.getType()) {
            case 1: {
                CPrimitive cPrimitive = new CPrimitive((IASTDeclSpecifier)iASTSimpleDeclSpecifier);
                return new TypesResult(null, false, true, cPrimitive);
            }
            case 0: 
            case 2: 
            case 3: 
            case 6: 
            case 13: {
                CPrimitive cPrimitive = new CPrimitive((IASTDeclSpecifier)iASTSimpleDeclSpecifier);
                return new TypesResult(this.cPrimitive2AstType(cACSLLocation, cPrimitive), iASTSimpleDeclSpecifier.isConst(), false, cPrimitive);
            }
            case 4: 
            case 5: 
            case 14: {
                CPrimitive cPrimitive = new CPrimitive((IASTDeclSpecifier)iASTSimpleDeclSpecifier);
                return new TypesResult((ASTType)new PrimitiveType((ILocation)cACSLLocation, (IBoogieType)BoogieType.TYPE_REAL, "real"), iASTSimpleDeclSpecifier.isConst(), false, cPrimitive);
            }
            case 8: {
                object = iDispatcher.dispatch((IASTNode)iASTSimpleDeclSpecifier.getDeclTypeExpression());
                if (object instanceof ExpressionResult) {
                    ICType iCType = ((ExpressionResult)object).getLrValue().getCType();
                    return new TypesResult(this.cType2AstType(cACSLLocation, iCType), iASTSimpleDeclSpecifier.isConst(), false, iCType);
                }
                if (!(object instanceof DeclaratorResult)) break;
                DeclaratorResult declaratorResult = (DeclaratorResult)object;
                if (!declaratorResult.hasNoSideEffects()) {
                    throw new AssertionError((Object)"passing side-effects from DeclaratorResults is not yet implemented");
                }
                ICType iCType = declaratorResult.getDeclaration().getType();
                return new TypesResult(this.cType2AstType(cACSLLocation, iCType), iASTSimpleDeclSpecifier.isConst(), false, iCType);
            }
        }
        if (iASTSimpleDeclSpecifier.isLongLong() || iASTSimpleDeclSpecifier.isLong() || iASTSimpleDeclSpecifier.isShort() || iASTSimpleDeclSpecifier.isUnsigned()) {
            object = new CPrimitive((IASTDeclSpecifier)iASTSimpleDeclSpecifier);
            return new TypesResult((ASTType)new PrimitiveType((ILocation)cACSLLocation, (IBoogieType)BoogieType.TYPE_INT, "int"), iASTSimpleDeclSpecifier.isConst(), false, (ICType)object);
        }
        object = "TypeHandler: We do not support this type: " + iASTSimpleDeclSpecifier.getType() + "!";
        throw new UnsupportedSyntaxException(cACSLLocation, (String)object);
    }

    @Override
    public Result visit(IDispatcher iDispatcher, IASTNamedTypeSpecifier iASTNamedTypeSpecifier) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation((IASTNode)iASTNamedTypeSpecifier);
        String string = iASTNamedTypeSpecifier.getName().toString();
        String string2 = this.mSymboltable.applyMultiparseRenaming(iASTNamedTypeSpecifier.getContainingFilename(), string);
        SymbolTableValue symbolTableValue = this.mSymboltable.findCSymbol((IASTNode)iASTNamedTypeSpecifier, string2);
        if (symbolTableValue == null) {
            ICType iCType = this.mLibraryTypes.get(string);
            if (iCType != null) {
                return new TypesResult(this.cType2AstType(cACSLLocation, iCType), iASTNamedTypeSpecifier.isConst(), iCType.isVoidType(), iCType);
            }
            String string3 = "Undefined type " + string;
            throw new UnsupportedSyntaxException(cACSLLocation, string3);
        }
        ICType iCType = symbolTableValue.getCType();
        BoogieType boogieType = this.getBoogieTypeForCType(iCType);
        String string4 = symbolTableValue.getBoogieName();
        return new TypesResult((ASTType)new NamedType((ILocation)cACSLLocation, (IBoogieType)boogieType, string4, new ASTType[0]), false, false, new CNamed(string4, iCType));
    }

    @Override
    public Result visit(IDispatcher iDispatcher, IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        Object object;
        Object object2;
        TypesResult typesResult;
        IASTEnumerationSpecifier.IASTEnumerator iASTEnumerator;
        CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation((IASTNode)iASTEnumerationSpecifier);
        String string = iASTEnumerationSpecifier.getName().toString();
        String string2 = this.mSymboltable.applyMultiparseRenaming(iASTEnumerationSpecifier.getContainingFilename(), string);
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        String string3 = this.mNameHandler.getUniqueIdentifier((IASTNode)iASTEnumerationSpecifier, iASTEnumerationSpecifier.getName().toString(), this.mSymboltable.getCScopeId((IASTNode)iASTEnumerationSpecifier), false, cPrimitive, DeclarationInformation.DECLARATIONINFO_GLOBAL);
        int n = iASTEnumerationSpecifier.getEnumerators().length;
        String[] stringArray = new String[n];
        ExpressionResult expressionResult = null;
        ArrayList<Pair<ConstDeclaration, Axiom>> arrayList = new ArrayList<Pair<ConstDeclaration, Axiom>>();
        int n2 = 0;
        while (n2 < n) {
            ExpressionResult expressionResult2;
            iASTEnumerator = iASTEnumerationSpecifier.getEnumerators()[n2];
            stringArray[n2] = iASTEnumerator.getName().toString();
            if (iASTEnumerator.getValue() != null) {
                expressionResult2 = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTEnumerator.getValue());
                typesResult = expressionResult2.getLrValue().getValue();
            } else {
                typesResult = null;
            }
            expressionResult2 = this.constructEnumValue(cACSLLocation, (Expression)typesResult, (Expression)expressionResult);
            object2 = this.handleEnumerationConstant(cACSLLocation, string3, stringArray[n2], (Expression)expressionResult2, iASTEnumerationSpecifier);
            arrayList.add((Pair<ConstDeclaration, Axiom>)object2);
            expressionResult = expressionResult2;
            ++n2;
        }
        CEnum cEnum = new CEnum(string3, stringArray);
        iASTEnumerator = this.cPrimitive2AstType(cACSLLocation, cPrimitive);
        typesResult = new TypesResult((ASTType)iASTEnumerator, false, false, cEnum);
        int n3 = 0;
        while (n3 < n) {
            object2 = stringArray[n3];
            object = (Pair)arrayList.get(n3);
            this.mStaticObjectsHandler.addGlobalConstDeclaration((ConstDeclaration)object.getFirst(), new CDeclaration(cEnum, (String)object2), (Axiom)object.getSecond());
            ++n3;
        }
        String string4 = "ENUM~" + string2;
        if (this.mIncompleteType.contains(string4)) {
            this.mIncompleteType.remove(string4);
            object2 = (TypesResult)this.mDefinedTypes.get((Object)string2);
            object = (CEnum)((TypesResult)object2).getCType();
            this.mStaticObjectsHandler.completeTypeDeclaration(cEnum.getName(), cEnum, this);
            CEnum cEnum2 = ((CEnum)object).complete(cEnum);
            this.mDefinedTypes.put((Object)string2, (Object)TypesResult.create((TypesResult)object2, cEnum2));
        }
        if (!string3.equals("")) {
            this.mDefinedTypes.put((Object)string2, (Object)typesResult);
        }
        return typesResult;
    }

    @Override
    public Result visit(IDispatcher iDispatcher, IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier) {
        CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation((IASTNode)iASTElaboratedTypeSpecifier);
        if (iASTElaboratedTypeSpecifier.getKind() == 1 || iASTElaboratedTypeSpecifier.getKind() == 0 || iASTElaboratedTypeSpecifier.getKind() == 2) {
            ICType iCType;
            String string = iASTElaboratedTypeSpecifier.getName().toString();
            String string2 = this.mSymboltable.applyMultiparseRenaming(iASTElaboratedTypeSpecifier.getContainingFilename(), string);
            TypesResult typesResult = (TypesResult)this.mDefinedTypes.get((Object)string2);
            if (typesResult != null) {
                return new TypesResult(typesResult.getAstType(), typesResult.isConst(), typesResult.isVoid(), typesResult.getCType());
            }
            String string3 = iASTElaboratedTypeSpecifier.getKind() == 1 ? "STRUCT~" + string2 : (iASTElaboratedTypeSpecifier.getKind() == 2 ? "UNION~" + string2 : "ENUM~" + string2);
            this.mIncompleteType.add(string3);
            if (iASTElaboratedTypeSpecifier.getKind() == 1) {
                iCType = new CStructOrUnion(CStructOrUnion.StructOrUnion.STRUCT, string);
                this.addIncompleteStructOrUnion(string2, (CStructOrUnion)iCType);
            } else if (iASTElaboratedTypeSpecifier.getKind() == 2) {
                iCType = new CStructOrUnion(CStructOrUnion.StructOrUnion.UNION, string);
                this.addIncompleteStructOrUnion(string2, (CStructOrUnion)iCType);
            } else {
                iCType = new CEnum(string);
                this.mIncompleteCEnumObjects.addPair((Object)string2, (Object)((CEnum)iCType));
            }
            TypesResult typesResult2 = new TypesResult((ASTType)new NamedType((ILocation)cACSLLocation, (IBoogieType)BoogieType.TYPE_ERROR, string3, new ASTType[0]), false, false, iCType);
            this.mDefinedTypes.put((Object)string2, (Object)typesResult2);
            return typesResult2;
        }
        String string = "Not yet implemented: Spec [" + iASTElaboratedTypeSpecifier.getKind() + "] of " + String.valueOf(iASTElaboratedTypeSpecifier.getClass());
        throw new UnsupportedSyntaxException(cACSLLocation, string);
    }

    private void addIncompleteStructOrUnion(String string, CStructOrUnion cStructOrUnion) {
        CStructOrUnion cStructOrUnion2 = this.mIncompleteCStructOrUnionObjects.get(string);
        if (cStructOrUnion2 != null && !cStructOrUnion2.equals(cStructOrUnion)) {
            throw new AssertionError((Object)"too many types");
        }
        this.mIncompleteCStructOrUnionObjects.put(string, cStructOrUnion);
    }

    @Override
    public Result visit(IDispatcher iDispatcher, IASTCompositeTypeSpecifier iASTCompositeTypeSpecifier) {
        CStructOrUnion.StructOrUnion structOrUnion;
        Result result;
        Object object2;
        String string;
        CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation((IASTNode)iASTCompositeTypeSpecifier);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ICType> arrayList2 = new ArrayList<ICType>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        Object object3 = iASTCompositeTypeSpecifier.getDeclarations(false);
        int n = ((IASTDeclaration[])object3).length;
        int n2 = 0;
        while (n2 < n) {
            string = object3[n2];
            object2 = iDispatcher.dispatch((IASTNode)string);
            if (object2 instanceof DeclarationResult) {
                result = (DeclarationResult)object2;
                for (CDeclaration object4 : result.getDeclarations()) {
                    arrayList.add(object4.getName());
                    arrayList2.add(object4.getType());
                    arrayList3.add(object4.getBitfieldSize());
                }
            } else if (!(object2 instanceof SkipResult)) {
                throw new UnsupportedSyntaxException(cACSLLocation, "Unexpected syntax in struct declaration!");
            }
            ++n2;
        }
        string = iASTCompositeTypeSpecifier.getName().toString();
        String string2 = this.mSymboltable.applyMultiparseRenaming(iASTCompositeTypeSpecifier.getContainingFilename(), string);
        if (iASTCompositeTypeSpecifier.getKey() == 1) {
            structOrUnion = CStructOrUnion.StructOrUnion.STRUCT;
        } else if (iASTCompositeTypeSpecifier.getKey() == 2) {
            structOrUnion = CStructOrUnion.StructOrUnion.UNION;
        } else {
            throw new UnsupportedOperationException();
        }
        object3 = CStructOrUnion.getPrefix(structOrUnion) + string2;
        if (this.mIncompleteCStructOrUnionObjects.containsKey(string2)) {
            object2 = this.mIncompleteCStructOrUnionObjects.get(string2);
            ((CStructOrUnion)object2).complete(arrayList, arrayList2, arrayList3);
            this.mStaticObjectsHandler.completeTypeDeclaration(((CStructOrUnion)object2).getName(), (ICType)object2, this);
            result = (TypesResult)this.mDefinedTypes.get((Object)string2);
            this.mDefinedTypes.put((Object)string2, (Object)TypesResult.create((TypesResult)result, (ICType)object2));
            if (this.mNamedIncompleteTypes.getDomain().contains(((CStructOrUnion)object2).getName())) {
                this.redirectNamedType(this.mNamedIncompleteTypes.getImage((Object)((CStructOrUnion)object2).getName()), (CStructOrUnion)object2, iASTCompositeTypeSpecifier.getParent());
            }
            this.mIncompleteCStructOrUnionObjects.remove(string2);
        }
        object2 = new CStructOrUnion(structOrUnion, string2, arrayList, arrayList2, arrayList3);
        DeclarationResult declarationResult = result = new NamedType((ILocation)cACSLLocation, (IBoogieType)BoogieType.TYPE_ERROR, (String)object3, new ASTType[0]);
        TypesResult typesResult = new TypesResult((ASTType)declarationResult, false, false, (ICType)object2);
        this.mIncompleteType.remove(object3);
        if (!string.equals("")) {
            this.mDefinedTypes.put((Object)string2, (Object)typesResult);
        }
        return typesResult;
    }

    private void redirectNamedType(Set<String> set, CStructOrUnion cStructOrUnion, IASTNode iASTNode) {
        HashMap<String, ICType> hashMap = new HashMap<String, ICType>();
        for (String string : set) {
            this.constructUpdatedCNamedAndAddToSymbolTable(string, cStructOrUnion, hashMap, iASTNode);
        }
    }

    private ICType constructUpdatedCNamedAndAddToSymbolTable(String string, CStructOrUnion cStructOrUnion, Map<String, ICType> map, IASTNode iASTNode) {
        ICType iCType;
        Object object;
        Object object2;
        Object object3;
        if (map.containsKey(string)) {
            return map.get(string);
        }
        SymbolTableValue symbolTableValue = this.mSymboltable.findCSymbol(iASTNode, string);
        if (symbolTableValue == null) {
            throw new AssertionError((Object)("Unable to locate " + string + " in the symbol table"));
        }
        if (symbolTableValue.getCType() instanceof CNamed) {
            object3 = ((CNamed)symbolTableValue.getCType()).getName();
            object2 = this.mSymboltable.getCIdForBoogieId((String)object3);
            object = this.constructUpdatedCNamedAndAddToSymbolTable((String)object2, cStructOrUnion, map, iASTNode);
            iCType = new CNamed(string, (ICType)object);
        } else {
            iCType = cStructOrUnion;
        }
        object3 = symbolTableValue.getCDecl();
        object2 = new CDeclaration(iCType, ((CDeclaration)object3).getName(), ((CDeclaration)object3).getIASTInitializer(), ((CDeclaration)object3).getInitializer(), ((CDeclaration)object3).isOnHeap(), ((CDeclaration)object3).getStorageClass(), ((CDeclaration)object3).getBitfieldSize());
        object = new SymbolTableValue(symbolTableValue.getBoogieName(), symbolTableValue.getBoogieDecl(), symbolTableValue.getAstType(), (CDeclaration)object2, symbolTableValue.getDeclarationInformation(), symbolTableValue.getDeclarationNode(), symbolTableValue.isIntFromPointer());
        this.mSymboltable.storeCSymbol(iASTNode, string, (SymbolTableValue)object);
        map.put(string, iCType);
        return iCType;
    }

    @Override
    public ASTType getTypeOfStructLHS(FlatSymbolTable flatSymbolTable, ILocation iLocation, StructLHS structLHS, IASTNode iASTNode) {
        String[] stringArray = BoogieASTUtil.getLHSList((LeftHandSide)structLHS);
        String string = stringArray[0];
        assert (string.equals(BoogieASTUtil.getLHSId((LeftHandSide)structLHS)));
        assert (flatSymbolTable.containsBoogieSymbol(string));
        String string2 = flatSymbolTable.getCIdForBoogieId(string);
        assert (flatSymbolTable.containsCSymbol(iASTNode, string2));
        ASTType aSTType = this.cType2AstType(iLocation, flatSymbolTable.findCSymbol(iASTNode, string2).getCType());
        return TypeHandler.traverseForType(iLocation, aSTType, stringArray, 1);
    }

    @Override
    public Set<String> getUndefinedTypes() {
        return Collections.unmodifiableSet(this.mIncompleteType);
    }

    @Override
    public ASTType cType2AstType(ILocation iLocation, ICType iCType) {
        if (iCType instanceof CPrimitive) {
            CPrimitive cPrimitive = (CPrimitive)iCType;
            return this.cPrimitive2AstType(iLocation, cPrimitive);
        }
        if (iCType instanceof CPointer) {
            return this.constructPointerType(iLocation);
        }
        if (iCType instanceof CArray) {
            CArray cArray = (CArray)iCType;
            ASTType aSTType = this.cType2AstType(iLocation, cArray.getBound().getCType());
            ASTType aSTType2 = this.cType2AstType(iLocation, cArray.getValueType());
            BoogieArrayType boogieArrayType = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{(BoogieType)aSTType.getBoogieType()}, (BoogieType)((BoogieType)aSTType2.getBoogieType()));
            return new ArrayType(iLocation, (IBoogieType)boogieArrayType, new String[0], new ASTType[]{aSTType}, aSTType2);
        }
        if (iCType instanceof CStructOrUnion) {
            CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType;
            VarList[] varListArray = new VarList[cStructOrUnion.getFieldCount()];
            String[] stringArray = new String[cStructOrUnion.getFieldCount()];
            BoogieType[] boogieTypeArray = new BoogieType[cStructOrUnion.getFieldCount()];
            int n = 0;
            while (n < cStructOrUnion.getFieldCount()) {
                ASTType aSTType = this.cType2AstType(iLocation, cStructOrUnion.getFieldTypes()[n]);
                varListArray[n] = new VarList(iLocation, new String[]{cStructOrUnion.getFieldIds()[n]}, aSTType);
                stringArray[n] = cStructOrUnion.getFieldIds()[n];
                boogieTypeArray[n] = (BoogieType)aSTType.getBoogieType();
                ++n;
            }
            BoogieStructType boogieStructType = BoogieType.createStructType((String[])stringArray, (BoogieType[])boogieTypeArray);
            return new StructType(iLocation, (IBoogieType)boogieStructType, varListArray);
        }
        if (iCType instanceof CNamed) {
            CNamed cNamed = (CNamed)iCType;
            BoogieType boogieType = iCType.getUnderlyingType().isIncomplete() ? null : (BoogieType)this.cType2AstType(iLocation, iCType.getUnderlyingType()).getBoogieType();
            return new NamedType(iLocation, (IBoogieType)boogieType, cNamed.getName(), new ASTType[0]);
        }
        if (iCType instanceof CFunction) {
            return this.constructPointerType(iLocation);
        }
        if (iCType instanceof CEnum) {
            return this.cPrimitive2AstType(iLocation, new CPrimitive(CPrimitive.CPrimitives.INT));
        }
        throw new UnsupportedSyntaxException(iLocation, "unknown type");
    }

    @Override
    public ASTType byteSize2AstType(ILocation iLocation, CPrimitive.CPrimitiveCategory cPrimitiveCategory, int n) {
        return switch (cPrimitiveCategory) {
            case CPrimitive.CPrimitiveCategory.VOID -> throw new UnsupportedOperationException();
            case CPrimitive.CPrimitiveCategory.INTTYPE -> {
                if (this.mTranslationSettings.isBitvectorTranslation()) {
                    int var4_4 = n * 8;
                    String var5_6 = "bv" + var4_4;
                    yield new PrimitiveType(iLocation, (IBoogieType)BoogieType.createBitvectorType((int)var4_4), var5_6);
                }
                yield new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_INT, "int");
            }
            case CPrimitive.CPrimitiveCategory.FLOATTYPE -> {
                this.mFloatingTypesNeeded = true;
                if (this.mTranslationSettings.isBitvectorTranslation()) {
                    int var4_5 = n * 8;
                    String var5_7 = "bv" + var4_5;
                    yield new PrimitiveType(iLocation, (IBoogieType)BoogieType.createBitvectorType((int)var4_5), var5_7);
                }
                yield new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_REAL, "real");
            }
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public void beginScope() {
        this.mDefinedTypes.beginScope();
    }

    @Override
    public void endScope() {
        assert (!this.mDefinedTypes.isEmptyScope());
        this.mDefinedTypes.endScope();
    }

    @Override
    public void addDefinedType(String string, TypesResult typesResult) {
        this.mDefinedTypes.put((Object)string, (Object)typesResult);
    }

    @Override
    public ASTType constructPointerType(ILocation iLocation) {
        this.mPointerTypeNeeded = true;
        return new NamedType(iLocation, (IBoogieType)this.getBoogiePointerType(), "$Pointer$", new ASTType[0]);
    }

    public ArrayList<Declaration> constructTranslationDefinedDeclarations(ILocation iLocation, ExpressionTranslation expressionTranslation) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        if (this.mPointerTypeNeeded) {
            VarList varList = new VarList(iLocation, new String[]{"base"}, this.cType2AstType(iLocation, expressionTranslation.getCTypeOfPointerComponents()));
            VarList varList2 = new VarList(iLocation, new String[]{"offset"}, this.cType2AstType(iLocation, expressionTranslation.getCTypeOfPointerComponents()));
            VarList[] varListArray = new VarList[]{varList, varList2};
            BoogieStructType boogieStructType = BoogieType.createStructType((String[])new String[]{"base", "offset"}, (BoogieType[])new BoogieType[]{(BoogieType)varList.getType().getBoogieType(), (BoogieType)varList2.getType().getBoogieType()});
            StructType structType = new StructType(iLocation, (IBoogieType)boogieStructType, varListArray);
            arrayList.add((Declaration)new TypeDeclaration(iLocation, new Attribute[0], false, "$Pointer$", new String[0], (ASTType)structType));
        }
        return arrayList;
    }

    @Override
    public boolean areFloatingTypesNeeded() {
        return this.mFloatingTypesNeeded;
    }

    @Override
    public BoogieType getBoogieTypeForBoogieASTType(ASTType aSTType) {
        if (aSTType == null) {
            return BoogieType.TYPE_ERROR;
        }
        BoogieType boogieType = (BoogieType)aSTType.getBoogieType();
        assert (boogieType != null) : String.valueOf(aSTType) + " has no underlying Boogie type";
        return boogieType;
    }

    @Override
    public BoogieType getBoogieTypeForSizeT() {
        return this.getBoogieTypeForCType(this.mTypeSizes.getSizeT());
    }

    @Override
    public BoogieType getBoogieTypeForCType(ICType iCType) {
        ICType iCType2 = iCType.getUnderlyingType();
        if (iCType2 instanceof CPrimitive) {
            CPrimitive cPrimitive = (CPrimitive)iCType2;
            if (this.mTranslationSettings.isBitvectorTranslation()) {
                Integer n = this.mTypeSizes.getSize(cPrimitive.getType());
                return BoogieType.createBitvectorType((int)(n * 8));
            }
            return switch (cPrimitive.getGeneralType()) {
                case CPrimitive.CPrimitiveCategory.FLOATTYPE -> BoogieType.TYPE_REAL;
                case CPrimitive.CPrimitiveCategory.INTTYPE -> BoogieType.TYPE_INT;
                case CPrimitive.CPrimitiveCategory.VOID -> BoogieType.TYPE_ERROR;
                default -> throw new MatchException(null, null);
            };
        }
        if (iCType2 instanceof CPointer) {
            return this.getBoogiePointerType();
        }
        if (iCType2 instanceof CEnum) {
            return this.getBoogieTypeForCType(new CPrimitive(CPrimitive.CPrimitives.INT));
        }
        if (iCType2 instanceof CArray) {
            CArray cArray = (CArray)iCType2;
            BoogieType[] boogieTypeArray = new BoogieType[]{this.getBoogieTypeForCType(this.mTranslationSettings.getCTypeOfPointerComponents())};
            BoogieType boogieType = this.getBoogieTypeForCType(cArray.getValueType());
            return BoogieType.createArrayType((int)0, (BoogieType[])boogieTypeArray, (BoogieType)boogieType);
        }
        if (iCType2 instanceof CFunction) {
            return this.getBoogiePointerType();
        }
        if (iCType2 instanceof CStructOrUnion) {
            CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType2;
            BoogieType[] boogieTypeArray = new BoogieType[cStructOrUnion.getFieldCount()];
            int n = 0;
            while (n < cStructOrUnion.getFieldCount()) {
                boogieTypeArray[n] = this.getBoogieTypeForCType(cStructOrUnion.getFieldTypes()[n]);
                ++n;
            }
            return BoogieType.createStructType((String[])cStructOrUnion.getFieldIds(), (BoogieType[])boogieTypeArray);
        }
        throw new AssertionError((Object)("unknown type " + String.valueOf(iCType2)));
    }

    @Override
    public BoogieType getBoogiePointerType() {
        return this.mBoogiePointerType;
    }

    @Override
    public BoogieType getBoogieTypeForPointerComponents() {
        return this.getBoogieTypeForCType(this.mTranslationSettings.getCTypeOfPointerComponents());
    }

    private Pair<ConstDeclaration, Axiom> handleEnumerationConstant(ILocation iLocation, String string, String string2, Expression expression, IASTEnumerationSpecifier iASTEnumerationSpecifier) {
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        ASTType aSTType = this.cType2AstType(iLocation, cPrimitive);
        String string3 = string + "~" + string2;
        VarList varList = new VarList(iLocation, new String[]{string3}, aSTType);
        ConstDeclaration constDeclaration = new ConstDeclaration(iLocation, new Attribute[0], false, varList, null, false);
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.getBoogieTypeForBoogieASTType(aSTType), (String)string3, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null));
        this.mSymboltable.storeCSymbol((IASTNode)iASTEnumerationSpecifier, string2, new SymbolTableValue(string3, (Declaration)constDeclaration, aSTType, new CDeclaration(cPrimitive, string2, CHandler.scConstant2StorageClass(iASTEnumerationSpecifier.getStorageClass())), DeclarationInformation.DECLARATIONINFO_GLOBAL, (IASTNode)iASTEnumerationSpecifier, false, expression));
        return new Pair((Object)constDeclaration, (Object)new Axiom(iLocation, new Attribute[0], ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, (Expression)expression)));
    }

    private Expression constructEnumValue(ILocation iLocation, Expression expression, Expression expression2) {
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        if (expression != null) {
            if (expression instanceof IntegerLiteral) {
                return expression;
            }
            BigInteger bigInteger = expression instanceof BooleanLiteral ? (((BooleanLiteral)expression).getValue() ? BigInteger.ONE : BigInteger.ZERO) : this.mTypeSizes.extractIntegerValue(expression, cPrimitive);
            if (bigInteger == null) {
                throw new AssertionError((Object)("not an integer constant: " + String.valueOf(expression)));
            }
            return this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, bigInteger);
        }
        if (expression2 == null) {
            return this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO);
        }
        BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(expression2, cPrimitive);
        if (bigInteger == null) {
            throw new AssertionError((Object)("not an integer constant: " + String.valueOf(expression2)));
        }
        return this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, bigInteger.add(BigInteger.ONE));
    }

    private static ASTType traverseForType(ILocation iLocation, ASTType aSTType, String[] stringArray, int n) {
        assert (n > 0 && n <= stringArray.length);
        if (n >= stringArray.length) {
            return aSTType;
        }
        if (aSTType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)aSTType;
            return TypeHandler.traverseForType(iLocation, arrayType.getValueType(), stringArray, n);
        }
        if (aSTType instanceof StructType) {
            Object object;
            StructType structType = (StructType)aSTType;
            VarList[] varListArray = structType.getFields();
            int n2 = varListArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = varListArray[n3];
                assert (object.getIdentifiers().length == 1);
                if (object.getIdentifiers()[0].equals(stringArray[n])) {
                    return TypeHandler.traverseForType(iLocation, object.getType(), stringArray, n + 1);
                }
                ++n3;
            }
            object = "Field '" + stringArray[n] + "' not found in " + String.valueOf(aSTType);
            throw new IncorrectSyntaxException(iLocation, (String)object);
        }
        throw new UnsupportedSyntaxException(iLocation, "Something went wrong while determining types!");
    }

    private ASTType cPrimitive2AstType(ILocation iLocation, CPrimitive cPrimitive) {
        BoogieType boogieType = this.getBoogieTypeForCType(cPrimitive);
        return switch (cPrimitive.getGeneralType()) {
            case CPrimitive.CPrimitiveCategory.VOID -> null;
            case CPrimitive.CPrimitiveCategory.INTTYPE -> {
                if (this.mTranslationSettings.isBitvectorTranslation()) {
                    yield new NamedType(iLocation, (IBoogieType)boogieType, "C_" + cPrimitive.getType().toString(), new ASTType[0]);
                }
                yield new PrimitiveType(iLocation, (IBoogieType)boogieType, "int");
            }
            case CPrimitive.CPrimitiveCategory.FLOATTYPE -> {
                this.mFloatingTypesNeeded = true;
                if (this.mTranslationSettings.isBitvectorTranslation()) {
                    yield new NamedType(iLocation, (IBoogieType)boogieType, "C_" + cPrimitive.getType().toString(), new ASTType[0]);
                }
                yield new PrimitiveType(iLocation, (IBoogieType)boogieType, "real");
            }
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public void registerNamedIncompleteType(String string, String string2) {
        this.mNamedIncompleteTypes.addPair((Object)string, (Object)string2);
    }

    @Override
    public CPrimitive getThreadIdType() {
        return new CPrimitive(CPrimitive.CPrimitives.ULONG);
    }

    @Override
    public void addLibraryTypes(Map<String, ICType> map) {
        this.mLibraryTypes.putAll(map);
    }

    public static boolean areCompatibleStructOrUnionTypes(ICType iCType, ICType iCType2) {
        return iCType.getUnderlyingType() instanceof CStructOrUnion && iCType2.getUnderlyingType() instanceof CStructOrUnion && TypeHandler.areCompatibleTypes(iCType, iCType2);
    }

    public static boolean areCompatibleTypes(ICType iCType, ICType iCType2) {
        return TypeHandler.areCompatibleTypes(iCType, iCType2, (SymmetricHashRelation<ICType>)new SymmetricHashRelation());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean areCompatibleTypes(ICType iCType, ICType iCType2, SymmetricHashRelation<ICType> symmetricHashRelation) {
        if (iCType == iCType2) {
            return true;
        }
        if (symmetricHashRelation.containsPair((Object)iCType, (Object)iCType2)) {
            return true;
        }
        ICType iCType3 = iCType.getUnderlyingType();
        ICType iCType4 = iCType2.getUnderlyingType();
        ICType iCType5 = iCType3;
        Objects.requireNonNull(iCType5);
        ICType iCType6 = iCType5;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CArray.class, CEnum.class, CFunction.class, CNamed.class, CPointer.class, CPrimitive.class, CStructOrUnion.class}, (Object)iCType6, 0)) {
            case 0: {
                CArray cArray = (CArray)iCType6;
                if (!(iCType4 instanceof CArray)) return false;
                CArray cArray2 = (CArray)iCType4;
                if (!TypeHandler.areCompatibleArrayTypes(cArray, cArray2, symmetricHashRelation)) return false;
                return true;
            }
            case 1: {
                CEnum cEnum = (CEnum)iCType6;
                if (iCType4 instanceof CEnum) {
                    CEnum cEnum2 = (CEnum)iCType4;
                    if (TypeHandler.areCompatibleEnumTypes(cEnum, cEnum2)) return true;
                }
                if (!(iCType4 instanceof CPrimitive)) return false;
                CPrimitive cPrimitive = (CPrimitive)iCType4;
                if (TypeHandler.isCompatiblePrimitiveForEnum(cEnum, cPrimitive)) return true;
                return false;
            }
            case 2: {
                CFunction cFunction = (CFunction)iCType6;
                if (!(iCType4 instanceof CFunction)) return false;
                CFunction cFunction2 = (CFunction)iCType4;
                if (!TypeHandler.areCompatibleFunctionTypes(cFunction, cFunction2, symmetricHashRelation)) return false;
                return true;
            }
            case 3: {
                CNamed cNamed = (CNamed)iCType6;
                throw new AssertionError((Object)"getUnderlyingType() must not return CNamed");
            }
            case 4: {
                CPointer cPointer = (CPointer)iCType6;
                if (!(iCType4 instanceof CPointer)) return false;
                CPointer cPointer2 = (CPointer)iCType4;
                if (!TypeHandler.areCompatibleTypes(cPointer.getPointsToType(), cPointer2.getPointsToType(), symmetricHashRelation)) return false;
                return true;
            }
            case 5: {
                CPrimitive cPrimitive = (CPrimitive)iCType6;
                if (iCType4 instanceof CPrimitive) {
                    CPrimitive cPrimitive2 = (CPrimitive)iCType4;
                    if (cPrimitive.getType() == cPrimitive2.getType()) return true;
                }
                if (!(iCType4 instanceof CEnum)) return false;
                CEnum cEnum = (CEnum)iCType4;
                if (TypeHandler.isCompatiblePrimitiveForEnum(cEnum, cPrimitive)) return true;
                return false;
            }
            case 6: {
                CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType6;
                if (!(iCType4 instanceof CStructOrUnion)) return false;
                CStructOrUnion cStructOrUnion2 = (CStructOrUnion)iCType4;
                if (!TypeHandler.areCompatibleStructOrUnionTypes(cStructOrUnion, cStructOrUnion2, symmetricHashRelation)) return false;
                return true;
            }
            default: {
                throw new MatchException(null, null);
            }
        }
    }

    private static boolean areCompatibleEnumTypes(CEnum cEnum, CEnum cEnum2) {
        if (!Objects.equals(cEnum.getName(), cEnum2.getName())) {
            return false;
        }
        if (cEnum.isIncomplete() || cEnum2.isIncomplete()) {
            return true;
        }
        if (cEnum.getFieldCount() != cEnum2.getFieldCount()) {
            return false;
        }
        int n = 0;
        while (n < cEnum.getFieldCount()) {
            if (!cEnum.getFieldIds()[n].equals(cEnum2.getFieldIds()[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean isCompatiblePrimitiveForEnum(CEnum cEnum, CPrimitive cPrimitive) {
        return cPrimitive.getType() == CPrimitive.CPrimitives.INT;
    }

    private static boolean areCompatibleFunctionTypes(CFunction cFunction, CFunction cFunction2, SymmetricHashRelation<ICType> symmetricHashRelation) {
        symmetricHashRelation.addPair((Object)cFunction, (Object)cFunction2);
        if (!TypeHandler.areCompatibleTypes(cFunction.getResultType(), cFunction2.getResultType(), symmetricHashRelation)) {
            return false;
        }
        if (cFunction.getParameterTypes().length != cFunction2.getParameterTypes().length || cFunction.hasVarArgs() != cFunction2.hasVarArgs()) {
            return false;
        }
        int n = 0;
        while (n < cFunction.getParameterTypes().length) {
            if (!TypeHandler.areCompatibleTypes(cFunction.getParameterTypes()[n].getType(), cFunction2.getParameterTypes()[n].getType(), symmetricHashRelation)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean areCompatibleStructOrUnionTypes(CStructOrUnion cStructOrUnion, CStructOrUnion cStructOrUnion2, SymmetricHashRelation<ICType> symmetricHashRelation) {
        symmetricHashRelation.addPair((Object)cStructOrUnion, (Object)cStructOrUnion2);
        if (cStructOrUnion.isStructOrUnion() != cStructOrUnion2.isStructOrUnion()) {
            return false;
        }
        if (!Objects.equals(cStructOrUnion.getName(), cStructOrUnion2.getName())) {
            return false;
        }
        if (cStructOrUnion.isIncomplete() || cStructOrUnion2.isIncomplete()) {
            return true;
        }
        if (cStructOrUnion.getFieldCount() != cStructOrUnion2.getFieldCount()) {
            return false;
        }
        BiFunction<Integer, String, OptionalInt> biFunction = cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.STRUCT ? TypeHandler.makeStructFieldLookup(cStructOrUnion2) : TypeHandler.makeUnionFieldLookup(cStructOrUnion2);
        int n = 0;
        while (n < cStructOrUnion.getFieldCount()) {
            String string = cStructOrUnion.getFieldIds()[n];
            OptionalInt optionalInt = biFunction.apply(n, string);
            if (optionalInt.isEmpty()) {
                return false;
            }
            if (!TypeHandler.areCompatibleTypes(cStructOrUnion.getFieldTypes()[n], cStructOrUnion2.getFieldTypes()[optionalInt.getAsInt()], symmetricHashRelation)) {
                return false;
            }
            if (cStructOrUnion.getBitfieldWidth(string) != cStructOrUnion2.getBitfieldWidth(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static BiFunction<Integer, String, OptionalInt> makeStructFieldLookup(CStructOrUnion cStructOrUnion) {
        assert (cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.STRUCT);
        return (n, string) -> {
            if (n >= cStructOrUnion.getFieldCount() || !Objects.equals(string, cStructOrUnion.getFieldIds()[n])) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(n);
        };
    }

    private static BiFunction<Integer, String, OptionalInt> makeUnionFieldLookup(CStructOrUnion cStructOrUnion) {
        assert (cStructOrUnion.isStructOrUnion() == CStructOrUnion.StructOrUnion.UNION);
        return (n, string) -> {
            if (n >= cStructOrUnion.getFieldCount()) {
                return OptionalInt.empty();
            }
            if (Objects.equals(string, cStructOrUnion.getFieldIds()[n])) {
                return OptionalInt.of(n);
            }
            int n2 = Arrays.asList(cStructOrUnion.getFieldIds()).indexOf(string);
            return n2 == -1 ? OptionalInt.empty() : OptionalInt.of(n2);
        };
    }

    private static boolean areCompatibleArrayTypes(CArray cArray, CArray cArray2, SymmetricHashRelation<ICType> symmetricHashRelation) {
        if (!TypeHandler.areCompatibleTypes(cArray.getValueType(), cArray2.getValueType(), symmetricHashRelation)) {
            return false;
        }
        if (cArray.isIncomplete() || cArray2.isIncomplete()) {
            return true;
        }
        BigInteger bigInteger = CTranslationUtil.extractIntegerValue(cArray.getBound().getValue());
        BigInteger bigInteger2 = CTranslationUtil.extractIntegerValue(cArray2.getBound().getValue());
        return bigInteger == null || bigInteger2 == null || bigInteger.equals(bigInteger2);
    }

    public static boolean isCharArray(ICType iCType) {
        CPrimitive cPrimitive;
        CArray cArray;
        ICType iCType2;
        ICType iCType3 = iCType.getUnderlyingType();
        return iCType3 instanceof CArray && (iCType2 = (cArray = (CArray)iCType3).getValueType().getUnderlyingType()) instanceof CPrimitive && ((cPrimitive = (CPrimitive)iCType2).getType() == CPrimitive.CPrimitives.CHAR || cPrimitive.getType() == CPrimitive.CPrimitives.UCHAR || cPrimitive.getType() == CPrimitive.CPrimitives.SCHAR);
    }
}

