/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling;

import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.AcceleratedInterpolationCore;
import de.uni_freiburg.informatik.ultimate.lib.mcr.IInterpolantProvider;
import de.uni_freiburg.informatik.ultimate.lib.mcr.SpInterpolantProvider;
import de.uni_freiburg.informatik.ultimate.lib.mcr.WpInterpolantProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.BPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.TaskIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IIpTcStrategyModule;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IPostconditionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IPreconditionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PathProgramCache;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.AssertionOrderModulation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IIpAbStrategyModule;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpAbStrategyModuleAbstractInterpretation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpAbStrategyModuleCanonical;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpAbStrategyModuleMcr;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpAbStrategyModuleStraightlineAll;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpAbStrategyModuleTotalInterpolation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleAbstractInterpretation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleAcceleratedInterpolation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleAcceleratedTraceCheck;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleCvc4;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleCvc5;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleInterpolantConsolidation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleMathsat;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModulePdr;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModulePreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleSifa;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleSmtInterpolCraig;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleSmtInterpolSpWp;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleZ3;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.StrategyModuleMcr;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TraceAbstractionRefinementEngine;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.AcceleratedInterpolationRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.AcceleratedTraceCheckRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.BadgerRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.BearRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.CamelNoAmRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.CamelOnlyBpRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.CamelRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.CamelSmtAmRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.DachshundRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.FixedRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.FoxRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.LazyTaipanRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.LizardRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.MammothNoAmRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.MammothRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.McrRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.PenguinRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.RubberTaipanRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.SifaTaipanRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.SmtInterpolRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.TaipanRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.ToothlessSifaTaipanRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.ToothlessTaipanRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.WalrusRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.WarthogNoAmRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.WarthogRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy.WolfRefinementStrategy;

public class StrategyFactory<L extends IIcfgTransition<?>> {
    private final TAPreferences mTaPrefs;
    private final TaCheckAndRefinementPreferences<L> mPrefs;
    private final ILogger mLogger;
    private final IIcfg<?> mInitialIcfg;
    private final PredicateFactory mPredicateFactory;
    private final PredicateFactoryForInterpolantAutomata mPredicateFactoryInterpolAut;
    private final PathProgramCache<L> mPathProgramCache;
    private final CfgSmtToolkit mCfgSmtToolkit;
    private final Class<L> mTransitionClazz;

    public StrategyFactory(ILogger iLogger, TAPreferences tAPreferences, TaCheckAndRefinementPreferences<L> taCheckAndRefinementPreferences, IIcfg<?> iIcfg, PredicateFactory predicateFactory, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata, Class<L> clazz) {
        this.mLogger = iLogger;
        this.mTaPrefs = tAPreferences;
        this.mPrefs = taCheckAndRefinementPreferences;
        this.mInitialIcfg = iIcfg;
        this.mCfgSmtToolkit = iIcfg.getCfgSmtToolkit();
        this.mPredicateFactory = predicateFactory;
        this.mPredicateFactoryInterpolAut = predicateFactoryForInterpolantAutomata;
        this.mPathProgramCache = new PathProgramCache(this.mLogger);
        this.mTransitionClazz = clazz;
    }

    public PathProgramCache<L> getPathProgramCache() {
        return this.mPathProgramCache;
    }

    public TraceAbstractionRefinementEngine.ITARefinementStrategy<L> constructStrategy(IUltimateServiceProvider iUltimateServiceProvider, Counterexample<L> counterexample, IAutomaton<L, IPredicate> iAutomaton, TaskIdentifier taskIdentifier, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, IPreconditionProvider iPreconditionProvider, IPostconditionProvider iPostconditionProvider) {
        IPredicateUnifier iPredicateUnifier = this.constructPredicateUnifier(iUltimateServiceProvider);
        IPredicate iPredicate = iPreconditionProvider.constructPrecondition(iPredicateUnifier);
        IPredicate iPredicate2 = iPostconditionProvider.constructPostcondition(iPredicateUnifier);
        return this.constructStrategy(iUltimateServiceProvider, counterexample, iAutomaton, taskIdentifier, iEmptyStackStateFactory, iPredicateUnifier, iPredicate, iPredicate2, this.mPrefs.getRefinementStrategy());
    }

    public TraceAbstractionRefinementEngine.ITARefinementStrategy<L> constructStrategy(IUltimateServiceProvider iUltimateServiceProvider, Counterexample<L> counterexample, IAutomaton<L, IPredicate> iAutomaton, TaskIdentifier taskIdentifier, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, IPredicateUnifier iPredicateUnifier, IPredicate iPredicate, IPredicate iPredicate2, TraceAbstractionPreferenceInitializer.RefinementStrategy refinementStrategy) {
        this.mPathProgramCache.addRun((Word<L>)counterexample.getWord());
        StrategyModuleFactory strategyModuleFactory = new StrategyModuleFactory(taskIdentifier, iUltimateServiceProvider, counterexample, iPredicate, iPredicate2, iPredicateUnifier, iAutomaton, iEmptyStackStateFactory);
        TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist refinementStrategyExceptionBlacklist = this.mPrefs.getExceptionBlacklist();
        switch (refinementStrategy) {
            case FIXED_PREFERENCES: {
                return new FixedRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case PENGUIN: {
                return new PenguinRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case CAMEL: {
                return new CamelRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case CAMEL_NO_AM: {
                return new CamelNoAmRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case CAMEL_SMT_AM: {
                return new CamelSmtAmRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case CAMEL_BP_ONLY: {
                return new CamelOnlyBpRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case LIZARD: {
                return new LizardRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case BADGER: {
                return new BadgerRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case WALRUS: {
                return new WalrusRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case WOLF: {
                return new WolfRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case FOX: {
                return new FoxRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case BEAR: {
                return new BearRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case WARTHOG_NO_AM: {
                return new WarthogNoAmRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case WARTHOG: {
                return new WarthogRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case RUBBER_TAIPAN: {
                return new RubberTaipanRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case TAIPAN: {
                return new TaipanRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case LAZY_TAIPAN: {
                return new LazyTaipanRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case TOOTHLESS_TAIPAN: {
                return new ToothlessTaipanRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case SMTINTERPOL: {
                return new SmtInterpolRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case MAMMOTH: {
                return new MammothRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case MAMMOTH_NO_AM: {
                return new MammothNoAmRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case DACHSHUND: {
                return new DachshundRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case SIFA_TAIPAN: {
                return new SifaTaipanRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case TOOTHLESS_SIFA_TAIPAN: {
                return new ToothlessSifaTaipanRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case MCR: {
                return new McrRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist, this);
            }
            case ACCELERATED_INTERPOLATION: {
                return new AcceleratedInterpolationRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
            case ACCELERATED_TRACE_CHECK: {
                return new AcceleratedTraceCheckRefinementStrategy(strategyModuleFactory, refinementStrategyExceptionBlacklist);
            }
        }
        throw new IllegalArgumentException("Unknown refinement strategy specified: " + String.valueOf((Object)this.mPrefs.getRefinementStrategy()));
    }

    private IPredicateUnifier constructPredicateUnifier(IUltimateServiceProvider iUltimateServiceProvider) {
        ManagedScript managedScript = this.mPrefs.getCfgSmtToolkit().getManagedScript();
        IIcfgSymbolTable iIcfgSymbolTable = this.mInitialIcfg.getCfgSmtToolkit().getSymbolTable();
        if (this.mPrefs.usePredicateTrieBasedPredicateUnifier()) {
            return new BPredicateUnifier(iUltimateServiceProvider, this.mLogger, managedScript, (BasicPredicateFactory)this.mPredicateFactory, iIcfgSymbolTable);
        }
        return new PredicateUnifier(this.mLogger, iUltimateServiceProvider, managedScript, (BasicPredicateFactory)this.mPredicateFactory, iIcfgSymbolTable, this.mTaPrefs.getSimplificationTechnique(), new IPredicate[0]);
    }

    public class StrategyModuleFactory {
        private final TaskIdentifier mTaskIdentifier;
        private final IUltimateServiceProvider mServices;
        private final Counterexample<L> mCounterexample;
        private final IPredicateUnifier mPredicateUnifier;
        private final IPredicate mPrecondition;
        private final IPredicate mPostcondition;
        private final IAutomaton<L, IPredicate> mAbstraction;
        private final IEmptyStackStateFactory<IPredicate> mEmptyStackFactory;

        public StrategyModuleFactory(TaskIdentifier taskIdentifier, IUltimateServiceProvider iUltimateServiceProvider, Counterexample<L> counterexample, IPredicate iPredicate, IPredicate iPredicate2, IPredicateUnifier iPredicateUnifier, IAutomaton<L, IPredicate> iAutomaton, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory) {
            this.mServices = iUltimateServiceProvider;
            this.mCounterexample = counterexample;
            this.mPredicateUnifier = iPredicateUnifier;
            this.mPrecondition = iPredicate;
            this.mPostcondition = iPredicate2;
            this.mTaskIdentifier = taskIdentifier;
            this.mAbstraction = iAutomaton;
            this.mEmptyStackFactory = iEmptyStackStateFactory;
        }

        public StrategyModuleMcr<L> createStrategyModuleMcr(StrategyFactory<L> strategyFactory) {
            this.isOnlyDefaultPrePostConditions();
            boolean bl = StrategyFactory.this.mPrefs.getUseInterpolantConsolidation();
            if (bl) {
                throw new UnsupportedOperationException("Interpolant consolidation and MCR cannot be combined");
            }
            return new StrategyModuleMcr(this.mServices, StrategyFactory.this.mLogger, StrategyFactory.this.mPrefs, this.mPredicateUnifier, this.mEmptyStackFactory, strategyFactory, this.mCounterexample.getWord(), this.mAbstraction, this.mTaskIdentifier, this.createMcrInterpolantProvider());
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleAcceleratedInterpolation() {
            this.isOnlyDefaultPrePostConditions();
            boolean bl = StrategyFactory.this.mPrefs.getUseInterpolantConsolidation();
            if (bl) {
                throw new UnsupportedOperationException("Interpolant consolidation and AcceleratedInterpolation cannot be combined");
            }
            TraceAbstractionPreferenceInitializer.RefinementStrategy refinementStrategy = StrategyFactory.this.mPrefs.getAcceleratedInterpolationRefinementStrategy();
            AcceleratedInterpolationCore.IStrategySupplier iStrategySupplier = counterexample -> StrategyFactory.this.constructStrategy(this.mServices, counterexample, this.mAbstraction, this.mTaskIdentifier, this.mEmptyStackFactory, this.mPredicateUnifier, this.mPrecondition, this.mPostcondition, refinementStrategy);
            return new IpTcStrategyModuleAcceleratedInterpolation(this.mServices, StrategyFactory.this.mLogger, this.mCounterexample, this.mPredicateUnifier, StrategyFactory.this.mPrefs, iStrategySupplier, StrategyFactory.this.mTransitionClazz);
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleAcceleratedTraceCheck() {
            this.isOnlyDefaultPrePostConditions();
            boolean bl = StrategyFactory.this.mPrefs.getUseInterpolantConsolidation();
            if (bl) {
                throw new UnsupportedOperationException("Interpolant consolidation and AcceleratedInterpolation cannot be combined");
            }
            return new IpTcStrategyModuleAcceleratedTraceCheck(this.mServices, StrategyFactory.this.mLogger, this.mCounterexample, this.mPrecondition, this.mPostcondition, this.mPredicateUnifier, StrategyFactory.this.mPrefs, StrategyFactory.this.mPredicateFactory, this.mTaskIdentifier);
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleSmtInterpolCraig(InterpolationTechnique interpolationTechnique, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
            return this.createIpTcStrategyModuleSmtInterpolCraig(-1L, interpolationTechnique, assertCodeBlockOrderArray);
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleSmtInterpolCraig(long l, InterpolationTechnique interpolationTechnique, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
            return this.createModuleWrapperIfNecessary(new IpTcStrategyModuleSmtInterpolCraig(this.mTaskIdentifier, this.mServices, StrategyFactory.this.mPrefs, this.mCounterexample, this.mPrecondition, this.mPostcondition, new AssertionOrderModulation(StrategyFactory.this.mPathProgramCache, StrategyFactory.this.mLogger, assertCodeBlockOrderArray), this.mPredicateUnifier, StrategyFactory.this.mPredicateFactory, l, interpolationTechnique));
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleSmtInterpolSpWp(InterpolationTechnique interpolationTechnique, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
            return this.createIpTcStrategyModuleSmtInterpolSpWp(-1L, interpolationTechnique, assertCodeBlockOrderArray);
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleSmtInterpolSpWp(long l, InterpolationTechnique interpolationTechnique, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
            return this.createModuleWrapperIfNecessary(new IpTcStrategyModuleSmtInterpolSpWp(this.mTaskIdentifier, this.mServices, StrategyFactory.this.mPrefs, this.mCounterexample, this.mPrecondition, this.mPostcondition, new AssertionOrderModulation(StrategyFactory.this.mPathProgramCache, StrategyFactory.this.mLogger, assertCodeBlockOrderArray), this.mPredicateUnifier, StrategyFactory.this.mPredicateFactory, l, interpolationTechnique));
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleZ3(InterpolationTechnique interpolationTechnique, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
            return this.createIpTcStrategyModuleZ3(-1L, interpolationTechnique, assertCodeBlockOrderArray);
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleZ3(long l, InterpolationTechnique interpolationTechnique, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
            return this.createModuleWrapperIfNecessary(new IpTcStrategyModuleZ3(this.mTaskIdentifier, this.mServices, StrategyFactory.this.mPrefs, this.mCounterexample, this.mPrecondition, this.mPostcondition, new AssertionOrderModulation(StrategyFactory.this.mPathProgramCache, StrategyFactory.this.mLogger, assertCodeBlockOrderArray), this.mPredicateUnifier, StrategyFactory.this.mPredicateFactory, l, interpolationTechnique));
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleMathsat(InterpolationTechnique interpolationTechnique, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
            return this.createModuleWrapperIfNecessary(new IpTcStrategyModuleMathsat(this.mTaskIdentifier, this.mServices, StrategyFactory.this.mPrefs, this.mCounterexample, this.mPrecondition, this.mPostcondition, new AssertionOrderModulation(StrategyFactory.this.mPathProgramCache, StrategyFactory.this.mLogger, assertCodeBlockOrderArray), this.mPredicateUnifier, StrategyFactory.this.mPredicateFactory, interpolationTechnique));
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleCVC4(InterpolationTechnique interpolationTechnique, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
            return this.createIpTcStrategyModuleCVC4(-1L, interpolationTechnique, assertCodeBlockOrderArray);
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleCVC4(long l, InterpolationTechnique interpolationTechnique, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
            return this.createModuleWrapperIfNecessary(new IpTcStrategyModuleCvc4(this.mTaskIdentifier, this.mServices, StrategyFactory.this.mPrefs, this.mCounterexample, this.mPrecondition, this.mPostcondition, new AssertionOrderModulation(StrategyFactory.this.mPathProgramCache, StrategyFactory.this.mLogger, assertCodeBlockOrderArray), this.mPredicateUnifier, StrategyFactory.this.mPredicateFactory, l, interpolationTechnique));
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleCVC5(InterpolationTechnique interpolationTechnique, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
            return this.createIpTcStrategyModuleCVC5(-1L, interpolationTechnique, assertCodeBlockOrderArray);
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleCVC5(long l, InterpolationTechnique interpolationTechnique, ITraceCheckPreferences.AssertCodeBlockOrder ... assertCodeBlockOrderArray) {
            return this.createModuleWrapperIfNecessary(new IpTcStrategyModuleCvc5(this.mTaskIdentifier, this.mServices, StrategyFactory.this.mPrefs, this.mCounterexample, this.mPrecondition, this.mPostcondition, new AssertionOrderModulation(StrategyFactory.this.mPathProgramCache, StrategyFactory.this.mLogger, assertCodeBlockOrderArray), this.mPredicateUnifier, StrategyFactory.this.mPredicateFactory, l, interpolationTechnique));
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleAbstractInterpretation() {
            this.isOnlyDefaultPrePostConditions();
            return this.createModuleWrapperIfNecessary(new IpTcStrategyModuleAbstractInterpretation(this.mCounterexample.getWord(), this.mPredicateUnifier, this.mServices, StrategyFactory.this.mPrefs.getIcfgContainer(), StrategyFactory.this.mPathProgramCache, StrategyFactory.this.mTaPrefs));
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModuleSifa() {
            this.isOnlyDefaultPrePostConditions();
            return this.createModuleWrapperIfNecessary(new IpTcStrategyModuleSifa(this.mServices, StrategyFactory.this.mLogger, StrategyFactory.this.mPrefs.getIcfgContainer(), this.mCounterexample.getWord(), this.mPredicateUnifier));
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModulePdr() {
            return this.createModuleWrapperIfNecessary(new IpTcStrategyModulePdr(this.mServices, StrategyFactory.this.mLogger, this.mPrecondition, this.mPostcondition, this.mCounterexample.getWord(), this.mPredicateUnifier, StrategyFactory.this.mPrefs, StrategyFactory.this.mTransitionClazz));
        }

        public IIpTcStrategyModule<?, L> createIpTcStrategyModulePreferences() {
            return this.createModuleWrapperIfNecessary(new IpTcStrategyModulePreferences(this.mTaskIdentifier, this.mServices, StrategyFactory.this.mPrefs, this.mCounterexample, this.mPrecondition, this.mPostcondition, new AssertionOrderModulation(StrategyFactory.this.mPathProgramCache, StrategyFactory.this.mLogger, StrategyFactory.this.mPrefs.getAssertCodeBlockOrder()), this.mPredicateUnifier, StrategyFactory.this.mPredicateFactory, StrategyFactory.this.mTransitionClazz));
        }

        private IIpTcStrategyModule<?, L> createModuleWrapperIfNecessary(IIpTcStrategyModule<?, L> iIpTcStrategyModule) {
            boolean bl = StrategyFactory.this.mPrefs.getUseInterpolantConsolidation();
            if (bl) {
                this.isOnlyDefaultPrePostConditions();
                return new IpTcStrategyModuleInterpolantConsolidation(this.mServices, StrategyFactory.this.mLogger, StrategyFactory.this.mPrefs, StrategyFactory.this.mPredicateFactory, iIpTcStrategyModule);
            }
            return iIpTcStrategyModule;
        }

        public IIpAbStrategyModule<L> createInterpolantAutomatonBuilderStrategyModulePreferences(IIpTcStrategyModule<?, L> iIpTcStrategyModule) {
            return this.createInterpolantAutomatonBuilderStrategyModulePreferences(StrategyFactory.this.mTaPrefs.interpolantAutomaton(), iIpTcStrategyModule);
        }

        private IIpAbStrategyModule<L> createInterpolantAutomatonBuilderStrategyModulePreferences(TraceAbstractionPreferenceInitializer.InterpolantAutomaton interpolantAutomaton, IIpTcStrategyModule<?, L> iIpTcStrategyModule) {
            TraceAbstractionPreferenceInitializer.InterpolantAutomaton interpolantAutomaton2 = StrategyFactory.this.mTaPrefs.overrideInterpolantAutomaton() ? StrategyFactory.this.mTaPrefs.interpolantAutomaton() : interpolantAutomaton;
            switch (interpolantAutomaton2) {
                case STRAIGHT_LINE: {
                    return new IpAbStrategyModuleStraightlineAll(this.mServices, StrategyFactory.this.mLogger, this.mAbstraction, this.mCounterexample.getWord(), this.mEmptyStackFactory);
                }
                case CANONICAL: {
                    return new IpAbStrategyModuleCanonical(this.mServices, StrategyFactory.this.mLogger, this.mAbstraction, this.mCounterexample, this.mEmptyStackFactory, this.mPredicateUnifier);
                }
                case TOTALINTERPOLATION2: {
                    return new IpAbStrategyModuleTotalInterpolation(this.mServices, this.mAbstraction, this.mCounterexample.getControlConfigurations(), this.mPredicateUnifier, StrategyFactory.this.mPrefs, StrategyFactory.this.mCfgSmtToolkit, StrategyFactory.this.mPredicateFactoryInterpolAut);
                }
                case ABSTRACT_INTERPRETATION: {
                    IIpTcStrategyModule iIpTcStrategyModule2 = iIpTcStrategyModule == null ? this.createIpTcStrategyModulePreferences() : iIpTcStrategyModule;
                    return new IpAbStrategyModuleAbstractInterpretation(this.mAbstraction, this.mCounterexample, this.mPredicateUnifier, (IpTcStrategyModuleAbstractInterpretation)iIpTcStrategyModule2, this.mEmptyStackFactory);
                }
                case MCR: {
                    return new IpAbStrategyModuleMcr(this.mCounterexample.getWord().asList(), this.mPredicateUnifier, this.mEmptyStackFactory, this.mServices, StrategyFactory.this.mLogger, this.mAbstraction.getAlphabet(), this.createMcrInterpolantProvider());
                }
            }
            throw new IllegalArgumentException("Setting " + String.valueOf((Object)StrategyFactory.this.mTaPrefs.interpolantAutomaton()) + " is unsupported");
        }

        private IInterpolantProvider<L> createMcrInterpolantProvider() {
            ManagedScript managedScript = StrategyFactory.this.mPrefs.getCfgSmtToolkit().getManagedScript();
            SmtUtils.SimplificationTechnique simplificationTechnique = StrategyFactory.this.mPrefs.getSimplificationTechnique();
            switch (StrategyFactory.this.mTaPrefs.getMcrInterpolantMethod()) {
                case WP: {
                    return new WpInterpolantProvider(this.mServices, StrategyFactory.this.mLogger, managedScript, simplificationTechnique, this.mPredicateUnifier);
                }
                case SP: {
                    return new SpInterpolantProvider(this.mServices, StrategyFactory.this.mLogger, managedScript, simplificationTechnique, this.mPredicateUnifier);
                }
            }
            throw new IllegalArgumentException("Setting " + String.valueOf((Object)StrategyFactory.this.mTaPrefs.getMcrInterpolantMethod()) + " is unsupported");
        }

        public IIpAbStrategyModule<L> createIpAbStrategyModuleStraightlineAll() {
            return this.createInterpolantAutomatonBuilderStrategyModulePreferences(TraceAbstractionPreferenceInitializer.InterpolantAutomaton.STRAIGHT_LINE, null);
        }

        public IIpAbStrategyModule<L> createIpAbStrategyModuleAbstractInterpretation(IpTcStrategyModuleAbstractInterpretation<L> ipTcStrategyModuleAbstractInterpretation) {
            return this.createInterpolantAutomatonBuilderStrategyModulePreferences(TraceAbstractionPreferenceInitializer.InterpolantAutomaton.ABSTRACT_INTERPRETATION, null);
        }

        public IIpAbStrategyModule<L> createIpAbStrategyModuleTotalInterpolation() {
            return this.createInterpolantAutomatonBuilderStrategyModulePreferences(TraceAbstractionPreferenceInitializer.InterpolantAutomaton.TOTALINTERPOLATION, null);
        }

        public IIpAbStrategyModule<L> createIpAbStrategyModuleCanonical() {
            return this.createInterpolantAutomatonBuilderStrategyModulePreferences(TraceAbstractionPreferenceInitializer.InterpolantAutomaton.CANONICAL, null);
        }

        public IIpAbStrategyModule<L> createIpAbStrategyModuleMcr() {
            return this.createInterpolantAutomatonBuilderStrategyModulePreferences(TraceAbstractionPreferenceInitializer.InterpolantAutomaton.MCR, null);
        }

        public TermClassifier getTermClassifierForTrace() {
            return TraceCheckUtils.classifyTermsInTrace((Word)this.mCounterexample.getWord(), (SmtFunctionsAndAxioms)StrategyFactory.this.mCfgSmtToolkit.getSmtFunctionsAndAxioms());
        }

        public IPredicateUnifier getDefaultPredicateUnifier() {
            return this.mPredicateUnifier;
        }

        private void isOnlyDefaultPrePostConditions() {
            if (!SmtUtils.isTrueLiteral((Term)this.mPrecondition.getFormula())) {
                throw new UnsupportedOperationException("Currently, only precondition true is supported");
            }
            if (!SmtUtils.isFalseLiteral((Term)this.mPostcondition.getFormula())) {
                throw new UnsupportedOperationException("Currently, only postcondition false is supported");
            }
        }
    }
}

