/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EqualityInformation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ElimStore3 {
    private int mQuantifier = 0;
    private final Script mScript;
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private static final String s_FreshVariableString = "arrayElim";

    public ElimStore3(Script script, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mScript = script;
        this.mMgdScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
    }

    private static MultiDimensionalStore getArrayStore(Term term, Term term2) {
        List<MultiDimensionalStore> list = MultiDimensionalStore.extractArrayStoresDeep(term2);
        MultiDimensionalStore multiDimensionalStore = null;
        for (MultiDimensionalStore multiDimensionalStore2 : list) {
            if (!multiDimensionalStore2.getArray().equals(term)) continue;
            if (multiDimensionalStore != null && !multiDimensionalStore.equals(multiDimensionalStore2)) {
                throw new UnsupportedOperationException("unsupported: several stores");
            }
            multiDimensionalStore = multiDimensionalStore2;
        }
        return multiDimensionalStore;
    }

    private ArrayUpdate getArrayUpdate(Term term, Term[] termArray) {
        ArrayUpdate.ArrayUpdateExtractor arrayUpdateExtractor = new ArrayUpdate.ArrayUpdateExtractor(this.mQuantifier == 1, true, termArray);
        ArrayUpdate arrayUpdate = null;
        for (ArrayUpdate arrayUpdate2 : arrayUpdateExtractor.getArrayUpdates()) {
            if (!arrayUpdate2.getNewArray().equals(term)) continue;
            if (arrayUpdate != null && !arrayUpdate.equals(arrayUpdate2)) {
                throw new UnsupportedOperationException("unsupported: several updates");
            }
            arrayUpdate = arrayUpdate2;
        }
        return arrayUpdate;
    }

    public Term elim(int n, TermVariable termVariable, Term term, Set<TermVariable> set) {
        Term term2;
        Object object;
        List list;
        List list2;
        Term term3;
        Object object2;
        Object object3;
        Object object4;
        Term term4;
        ArrayUpdate arrayUpdate;
        Term term5;
        this.mQuantifier = n;
        ArrayUpdate arrayUpdate2 = null;
        Term term6 = null;
        Object object5 = termVariable;
        Object object6 = term;
        object6 = this.eliminateSelfUpdates(this.mScript, n, (Term)object6);
        while (true) {
            assert (object5.getSort().isArraySort());
            if (n == 0) {
                term5 = SmtUtils.getConjuncts(object6);
            } else {
                assert (n == 1);
                term5 = SmtUtils.getDisjuncts(object6);
            }
            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(this.getClass(), "eliminating quantified array variable from " + ((Term[])term5).length + " xjuncts");
            }
            MultiDimensionalStore multiDimensionalStore = ElimStore3.getArrayStore((Term)object5, object6);
            arrayUpdate = this.getArrayUpdate((Term)object5, (Term[])term5);
            term4 = new HashSet();
            object4 = term5;
            int n2 = ((Term[])object4).length;
            int n3 = 0;
            while (n3 < n2) {
                object3 = object4[n3];
                try {
                    object2 = new ArrayUpdate((Term)object3, n == 1, false);
                    if (object2.getOldArray().equals(object5)) {
                        if (arrayUpdate2 != null) {
                            throw new UnsupportedOperationException("unsupported: write into several arrays");
                        }
                        arrayUpdate2 = object2;
                        if (object2.getNewArray().equals(object5)) {
                            throw new UnsupportedOperationException("unsupported: self update");
                        }
                    } else if (object2.getNewArray().equals(object5)) {
                        if (term6 != null) {
                            throw new UnsupportedOperationException("unsupported: written from several arrayas");
                        }
                        term6 = object2;
                    } else {
                        term4.add(object3);
                    }
                }
                catch (ArrayUpdate.ArrayUpdateException arrayUpdateException) {
                    term4.add(object3);
                }
                ++n3;
            }
            if (term6 != null && arrayUpdate2 != null) {
                term4.add(arrayUpdate2.getArrayUpdateTerm());
                arrayUpdate2 = null;
            }
            if (n == 0) {
                term3 = SmtUtils.and(this.mScript, term4.toArray(new Term[term4.size()]));
            } else {
                assert (n == 1);
                term3 = SmtUtils.or(this.mScript, term4.toArray(new Term[term4.size()]));
            }
            if (multiDimensionalStore == null && arrayUpdate == null || arrayUpdate2 != null || term6 != null) break;
            object3 = this.mMgdScript.constructFreshTermVariable(s_FreshVariableString, object5.getSort());
            if (multiDimensionalStore == null) {
                multiDimensionalStore = arrayUpdate.getMultiDimensionalStore();
            }
            Map<Term, Term> map = Collections.singletonMap(multiDimensionalStore.toTerm(this.mScript), object3);
            Term term7 = Substitution.apply(this.mMgdScript, map, object6);
            object4 = SmtUtils.binaryEquality(this.mScript, (Term)object3, multiDimensionalStore.toTerm(this.mScript));
            if (n == 0) {
                term7 = SmtUtils.and(this.mScript, new Term[]{term7, object4});
            } else {
                assert (n == 1);
                term7 = SmtUtils.or(this.mScript, term7, SmtUtils.not(this.mScript, (Term)object4));
            }
            object2 = new HashSet();
            list2 = this.elim(n, (TermVariable)object5, term7, set);
            object6 = list2;
            object5 = object3;
            set.addAll((Collection<TermVariable>)object2);
        }
        boolean bl = arrayUpdate2 != null || term6 != null;
        arrayUpdate = this.mScript;
        term4 = term3;
        if (arrayUpdate2 != null) {
            object3 = Collections.singletonMap(arrayUpdate2.getMultiDimensionalStore().toTerm(this.mScript), arrayUpdate2.getNewArray());
            term4 = Substitution.apply(this.mMgdScript, (Map<? extends Term, ? extends Term>)object3, term4);
        }
        object3 = new IndicesAndValues(this.mMgdScript, n, (TermVariable)object5, (Term[])term5);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        term4 = Substitution.apply(this.mMgdScript, ((IndicesAndValues)object3).getMapping(), term4);
        if (term6 == null && Arrays.asList(term4.getFreeVars()).contains(object5)) {
            throw new AssertionError((Object)("var is still there " + String.valueOf(object5) + "  quantifier " + n + "  term size " + String.valueOf(new DagSizePrinter((Term)object6)) + "   " + String.valueOf(object6)));
        }
        if (bl) {
            TermVariable termVariable2;
            if (arrayUpdate2 != null) {
                termVariable2 = arrayUpdate2.getNewArray();
                object4 = arrayUpdate2.getIndex();
                object2 = arrayUpdate2.getValue();
            } else {
                assert (term6 != null);
                termVariable2 = term6.getOldArray();
                object4 = term6.getIndex();
                object2 = term6.getValue();
            }
            arrayList.addAll(this.disjointIndexImpliesValueEquality(n, (Term)termVariable2, (ArrayIndex)object4, (IndicesAndValues)object3, (TermVariable)object5));
            list2 = ((ArrayIndex)object4).applySubstitution(this.mMgdScript, ((IndicesAndValues)object3).getMapping());
            list = Substitution.apply(this.mMgdScript, ((IndicesAndValues)object3).getMapping(), object2);
            if (arrayUpdate2 != null) {
                assert (arrayUpdate2.getOldArray() == object5) : "array not eliminatee";
                object = SmtUtils.binaryEquality(this.mScript, SmtUtils.multiDimensionalSelect(this.mScript, (Term)termVariable2, (ArrayIndex)list2), (Term)list);
                assert (!Arrays.asList(object.getFreeVars()).contains(object5)) : "var is still there - maybe you have to switch off the flattening of multi-dimensional arrays";
                arrayList.add((Term)object);
            }
            if (term6 != null) {
                term2 = SmtUtils.multiDimensionalStore((Script)arrayUpdate, (Term)termVariable2, (ArrayIndex)list2, (Term)list);
                object = Collections.singletonMap(object5, term2);
            } else {
                object = null;
            }
            if (n == 0) {
                term2 = SmtUtils.and((Script)arrayUpdate, arrayList.toArray(new Term[arrayList.size()]));
                term4 = SmtUtils.and((Script)arrayUpdate, term4, term2);
            } else {
                assert (n == 1);
                term2 = SmtUtils.or((Script)arrayUpdate, SmtUtils.negateElementwise(this.mScript, arrayList).toArray(new Term[arrayList.size()]));
                term4 = SmtUtils.or((Script)arrayUpdate, term4, term2);
            }
            if (object != null) {
                term4 = Substitution.apply(this.mMgdScript, (Map<? extends Term, ? extends Term>)object, term4);
            }
        }
        object4 = this.mMgdScript;
        object2 = ElimStore3.buildIndicesAndValues((ManagedScript)object4, (IndicesAndValues)object3);
        list2 = (List)object2.getFirst();
        list = (List)object2.getSecond();
        if (term6 != null) {
            assert (term6.getNewArray() == object5) : "array not eliminatee";
            object = term6.getIndex().applySubstitution((ManagedScript)object4, ((IndicesAndValues)object3).getMapping());
            term2 = Substitution.apply(this.mMgdScript, ((IndicesAndValues)object3).getMapping(), term6.getValue());
            list2.add(object);
            list.add(term2);
        }
        ArrayList<Term> arrayList2 = ElimStore3.constructIndexValueConstraints((Script)arrayUpdate, n, list2, list);
        object4 = QuantifierUtils.applyDualFiniteConnective(this.mScript, this.mQuantifier, arrayList2);
        assert (!Arrays.asList(object4.getFreeVars()).contains(object5)) : "var is still there";
        object2 = QuantifierUtils.applyDualFiniteConnective(this.mScript, this.mQuantifier, Arrays.asList(object4, term4));
        this.mMgdScript.getScript().echo(new QuotedObject("started simplification for array quantifier elimination"));
        object2 = SmtUtils.simplify(this.mMgdScript, object2, this.mServices, this.mSimplificationTechnique);
        this.mMgdScript.getScript().echo(new QuotedObject("finished simplification for array quantifier elimination"));
        set.addAll(((IndicesAndValues)object3).getNewAuxVars());
        return object2;
    }

    public static Pair<List<ArrayIndex>, List<Term>> buildIndicesAndValues(ManagedScript managedScript, IndicesAndValues indicesAndValues) {
        ArrayList<ArrayIndex> arrayList = new ArrayList<ArrayIndex>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        int n = 0;
        while (n < indicesAndValues.getIndices().length) {
            ArrayIndex arrayIndex = indicesAndValues.getIndices()[n].applySubstitution(managedScript, indicesAndValues.getMapping());
            Term term = Substitution.apply(managedScript, indicesAndValues.getMapping(), indicesAndValues.getValues()[n]);
            arrayList.add(arrayIndex);
            arrayList2.add(term);
            ++n;
        }
        Pair pair = new Pair(arrayList, arrayList2);
        return pair;
    }

    public static ArrayList<Term> constructIndexValueConstraints(Script script, int n, List<ArrayIndex> list, List<Term> list2) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n2 = 0;
        while (n2 < list.size()) {
            int n3 = n2;
            while (n3 < list.size()) {
                Term term = SmtUtils.indexEqualityImpliesValueEquality(script, list.get(n2), list.get(n3), list2.get(n2), list2.get(n3));
                if (n == 1) {
                    term = SmtUtils.not(script, term);
                }
                arrayList.add(term);
                ++n3;
            }
            ++n2;
        }
        ArrayList<Term> arrayList2 = arrayList;
        return arrayList2;
    }

    private ArrayList<Term> disjointIndexImpliesValueEquality(int n, Term term, ArrayIndex arrayIndex, IndicesAndValues indicesAndValues, TermVariable termVariable) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n2 = 0;
        while (n2 < indicesAndValues.getIndices().length) {
            Term term2 = SmtUtils.multiDimensionalSelect(this.mScript, term, indicesAndValues.getIndices()[n2]);
            IndexValueConnection indexValueConnection = new IndexValueConnection(indicesAndValues.getIndices()[n2], arrayIndex, indicesAndValues.getValues()[n2], term2, false);
            Term term3 = indexValueConnection.getTerm();
            term3 = Substitution.apply(this.mMgdScript, indicesAndValues.getMapping(), term3);
            arrayList.add(term3);
            assert (!Arrays.asList(term3.getFreeVars()).contains(termVariable)) : "var is still there";
            if (indexValueConnection.indexInequality() && !indexValueConnection.valueEquality()) assert (!indexValueConnection.valueInequality()) : "term would be false!";
            ++n2;
        }
        return arrayList;
    }

    private Term eliminateSelfUpdates(Script script, int n, Term term) {
        Term[] termArray;
        if (n == 0) {
            termArray = SmtUtils.getConjuncts(term);
        } else {
            assert (n == 1);
            termArray = SmtUtils.getDisjuncts(term);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        boolean bl = false;
        Term[] termArray2 = termArray;
        int n2 = termArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block13: {
                ArrayUpdate arrayUpdate;
                Term term2 = termArray2[n3];
                try {
                    arrayUpdate = new ArrayUpdate(term2, false, false);
                }
                catch (ArrayUpdate.ArrayUpdateException arrayUpdateException) {
                    try {
                        arrayUpdate = new ArrayUpdate(term2, true, false);
                    }
                    catch (ArrayUpdate.ArrayUpdateException arrayUpdateException2) {
                        arrayList.add(term2);
                        break block13;
                    }
                }
                if (ElimStore3.isSelfUpdate(arrayUpdate)) {
                    bl = true;
                    Term term3 = this.buildEquivalentSelect(script, arrayUpdate);
                    arrayList.add(term3);
                } else {
                    arrayList.add(arrayUpdate.getArrayUpdateTerm());
                }
            }
            ++n3;
        }
        if (bl) {
            if (n == 0) {
                return SmtUtils.and(script, arrayList);
            }
            assert (n == 1);
            return SmtUtils.or(script, arrayList);
        }
        return term;
    }

    private Term buildEquivalentSelect(Script script, ArrayUpdate arrayUpdate) {
        assert (ElimStore3.isSelfUpdate(arrayUpdate)) : "no self-update";
        Term term = SmtUtils.multiDimensionalSelect(this.mScript, (Term)arrayUpdate.getNewArray(), arrayUpdate.getIndex());
        String string = arrayUpdate.isNegatedEquality() ? "distinct" : "=";
        return script.term(string, new Term[]{term, arrayUpdate.getValue()});
    }

    private static boolean isSelfUpdate(ArrayUpdate arrayUpdate) {
        if (arrayUpdate.getOldArray().equals(arrayUpdate.getNewArray())) {
            return true;
        }
        if (Arrays.asList(arrayUpdate.getOldArray().getFreeVars()).contains(arrayUpdate.getNewArray())) {
            throw new UnsupportedOperationException("nested self-update " + String.valueOf(arrayUpdate.getArrayUpdateTerm()));
        }
        return false;
    }

    private class IndexValueConnection {
        private final ArrayIndex mfstIndex;
        private final ArrayIndex msndIndex;
        private final Term mfstValue;
        private final Term msndValue;
        private final boolean mSelectConnection;
        private final Term mIndexEquality;
        private final Term mValueEquality;

        public IndexValueConnection(ArrayIndex arrayIndex, ArrayIndex arrayIndex2, Term term, Term term2, boolean bl) {
            this.mfstIndex = arrayIndex;
            this.msndIndex = arrayIndex2;
            this.mfstValue = term;
            this.msndValue = term2;
            this.mSelectConnection = bl;
            this.mIndexEquality = SmtUtils.and(ElimStore3.this.mScript, SmtUtils.pairwiseEquality(ElimStore3.this.mScript, arrayIndex, arrayIndex2));
            this.mValueEquality = SmtUtils.binaryEquality(ElimStore3.this.mScript, term, term2);
        }

        public boolean indexInequality() {
            return this.mIndexEquality.equals(ElimStore3.this.mScript.term("false", new Term[0]));
        }

        public boolean valueEquality() {
            return this.mValueEquality.equals(ElimStore3.this.mScript.term("true", new Term[0]));
        }

        public boolean valueInequality() {
            return this.mValueEquality.equals(ElimStore3.this.mScript.term("false", new Term[0]));
        }

        public Term getTerm() {
            Term term = this.mIndexEquality;
            if (this.mSelectConnection) {
                term = SmtUtils.not(ElimStore3.this.mScript, term);
            }
            return SmtUtils.or(ElimStore3.this.mScript, term, this.mValueEquality);
        }
    }

    public static class IndicesAndValues {
        private final Term[] mSelectTerm;
        private final ArrayIndex[] mIndices;
        private final Term[] mValues;
        private final Set<TermVariable> mNewAuxVars;
        private final Map<Term, Term> mSelectTerm2Value = new HashMap<Term, Term>();
        private final int mQuantifier;
        private final ManagedScript mMgdScript;

        public IndicesAndValues(ManagedScript managedScript, int n, TermVariable termVariable, Term ... term) {
            MultiDimensionalSelect[] multiDimensionalSelectArray;
            this.mMgdScript = managedScript;
            this.mQuantifier = n;
            HashSet<MultiDimensionalSelect> hashSet = new HashSet<MultiDimensionalSelect>();
            Term term2 = term;
            int n2 = ((Term[])term2).length;
            int n3 = 0;
            while (n3 < n2) {
                multiDimensionalSelectArray = term2[n3];
                for (MultiDimensionalSelect multiDimensionalSelect : MultiDimensionalSelect.extractSelectDeep((Term)multiDimensionalSelectArray)) {
                    if (!multiDimensionalSelect.getArray().equals(termVariable)) continue;
                    hashSet.add(multiDimensionalSelect);
                }
                ++n3;
            }
            multiDimensionalSelectArray = hashSet.toArray(new MultiDimensionalSelect[hashSet.size()]);
            this.mSelectTerm = new Term[multiDimensionalSelectArray.length];
            this.mIndices = new ArrayIndex[multiDimensionalSelectArray.length];
            this.mValues = new Term[multiDimensionalSelectArray.length];
            this.mNewAuxVars = new HashSet<TermVariable>();
            n3 = 0;
            while (n3 < multiDimensionalSelectArray.length) {
                this.mSelectTerm[n3] = multiDimensionalSelectArray[n3].toTerm(managedScript.getScript());
                this.mIndices[n3] = multiDimensionalSelectArray[n3].getIndex();
                EqualityInformation equalityInformation = EqualityInformation.getEqinfo(this.mMgdScript.getScript(), multiDimensionalSelectArray[n3].toTerm(managedScript.getScript()), (Term[])term, (Term)termVariable, this.mQuantifier);
                if (equalityInformation == null) {
                    MultiDimensionalSelect multiDimensionalSelect;
                    term2 = multiDimensionalSelectArray[n3].toTerm(managedScript.getScript());
                    multiDimensionalSelect = this.mMgdScript.constructFreshTermVariable(ElimStore3.s_FreshVariableString, term2.getSort());
                    this.mNewAuxVars.add((TermVariable)multiDimensionalSelect);
                    this.mValues[n3] = multiDimensionalSelect;
                } else {
                    this.mValues[n3] = equalityInformation.getRelatedTerm();
                }
                this.mSelectTerm2Value.put(this.mSelectTerm[n3], this.mValues[n3]);
                ++n3;
            }
        }

        public ArrayIndex[] getIndices() {
            return this.mIndices;
        }

        public Term[] getValues() {
            return this.mValues;
        }

        public Set<TermVariable> getNewAuxVars() {
            return this.mNewAuxVars;
        }

        public Map<Term, Term> getMapping() {
            return this.mSelectTerm2Value;
        }
    }
}

