/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.testgen;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.CounterTrace;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.InitialTransition;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseBits;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.pea.Transition;
import de.uni_freiburg.informatik.ultimate.lib.srparse.Durations;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.IReq2Pea;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.IReq2PeaAnnotator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.Req2CauseTrackingCDD;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.ReqEffectStore;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.ReqTestAnnotator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.ReqSymboltableBuilder;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Req2CauseTrackingPea
implements IReq2Pea {
    private final ILogger mLogger;
    private final List<DeclarationPattern> mInitPattern;
    private final List<PatternType.ReqPeas> mReqPeas;
    private IReqSymbolTable mSymbolTable;
    private boolean mHasErrors;
    private final IUltimateServiceProvider mServices;
    private final Map<PhaseEventAutomata, ReqEffectStore> mPea2EffectStore;
    private final Req2CauseTrackingCDD mCddTransformer;
    private final Durations mDurations;
    private static final String LOWER_AUTOMATON_SUFFIX = "_tt";

    public Req2CauseTrackingPea(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, List<DeclarationPattern> list) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mInitPattern = list;
        this.mPea2EffectStore = new HashMap<PhaseEventAutomata, ReqEffectStore>();
        this.mReqPeas = new ArrayList<PatternType.ReqPeas>();
        this.mCddTransformer = new Req2CauseTrackingCDD(this.mLogger);
        this.mDurations = new Durations();
    }

    @Override
    public void transform(IReq2Pea iReq2Pea) {
        List<PatternType.ReqPeas> list = iReq2Pea.getReqPeas();
        IReqSymbolTable iReqSymbolTable = iReq2Pea.getSymboltable();
        ReqSymboltableBuilder reqSymboltableBuilder = new ReqSymboltableBuilder(this.mServices, this.mLogger);
        for (DeclarationPattern declarationPattern : this.mInitPattern) {
            reqSymboltableBuilder.addInitPattern(declarationPattern);
            this.mDurations.addInitPattern(declarationPattern);
            if (declarationPattern.getCategory() != DeclarationPattern.VariableCategory.OUT) continue;
            reqSymboltableBuilder.addAuxvar(ReqTestAnnotator.getTrackingVar(declarationPattern.getId()), "bool", (PatternType<?>)declarationPattern);
        }
        for (PatternType.ReqPeas reqPeas : list) {
            PatternType patternType = reqPeas.getPattern();
            this.mDurations.addNonInitPattern(patternType);
            List list2 = reqPeas.getCounterTrace2Pea();
            ArrayList<Pair> arrayList = new ArrayList<Pair>(list2.size());
            for (Map.Entry entry : list2) {
                PhaseEventAutomata phaseEventAutomata = this.transformPea(patternType, (PhaseEventAutomata)entry.getValue(), iReqSymbolTable, ((CounterTrace)entry.getKey()).getPhases());
                arrayList.add(new Pair((Object)((CounterTrace)entry.getKey()), (Object)phaseEventAutomata));
                reqSymboltableBuilder.addPea(patternType, phaseEventAutomata);
            }
            this.mReqPeas.add(new PatternType.ReqPeas(patternType, arrayList));
        }
        this.mSymbolTable = reqSymboltableBuilder.constructSymbolTable();
    }

    private PhaseEventAutomata transformPea(PatternType<?> patternType, PhaseEventAutomata phaseEventAutomata, IReqSymbolTable iReqSymbolTable, CounterTrace.DCPhase[] dCPhaseArray) {
        CDD cDD = Req2CauseTrackingCDD.getEffectCDD(patternType);
        Set<String> set = Req2CauseTrackingCDD.getCddVariables(cDD);
        set.removeAll(iReqSymbolTable.getConstVars());
        Req2CauseTrackingPea.setFlags(phaseEventAutomata.getInit());
        List list = phaseEventAutomata.getPhases();
        int n = Req2CauseTrackingPea.getHighestDCPhase(list, dCPhaseArray);
        this.mLogger.info((Object)("Effect Variables of " + patternType.toString() + ": " + set.toString() + ", with effect phase: " + Integer.toString(n)));
        List<Phase> list2 = this.transformLocations(phaseEventAutomata, iReqSymbolTable, set, n, dCPhaseArray);
        List<Phase> list3 = Req2CauseTrackingPea.getInitialLocations(list);
        Req2CauseTrackingPea.copyOldTransitions(phaseEventAutomata.getPhases(), list2);
        this.copyTransitionsToLower(list, list2, set, iReqSymbolTable, n, cDD);
        this.connectUpperToLowerAutomaton(list2, list, new ArrayList<String>(phaseEventAutomata.getClocks()), n);
        ArrayList arrayList = new ArrayList(phaseEventAutomata.getClocks());
        HashMap<String, String> hashMap = new HashMap<String, String>(phaseEventAutomata.getVariables());
        hashMap.putAll(this.mCddTransformer.getTrackingVars());
        PhaseEventAutomata phaseEventAutomata2 = new PhaseEventAutomata(phaseEventAutomata.getName() + LOWER_AUTOMATON_SUFFIX, list2, list3.stream().map(phase -> new InitialTransition(CDD.TRUE, phase)).collect(Collectors.toList()), arrayList, hashMap, null);
        ReqEffectStore reqEffectStore = new ReqEffectStore();
        reqEffectStore.addEffectVars(set);
        Req2CauseTrackingPea.getOutputEffectLocations(phaseEventAutomata, reqEffectStore, set, iReqSymbolTable, n, cDD);
        this.mPea2EffectStore.put(phaseEventAutomata2, reqEffectStore);
        return phaseEventAutomata2;
    }

    private static void getOutputEffectLocations(PhaseEventAutomata phaseEventAutomata, ReqEffectStore reqEffectStore, Set<String> set, IReqSymbolTable iReqSymbolTable, int n, CDD cDD) {
        List list;
        List list2 = list = phaseEventAutomata.getPhases();
        int n2 = 0;
        while (n2 < list.size()) {
            int n3 = phaseEventAutomata.getPhases().size();
            int n4 = n3 + n2;
            if (Req2CauseTrackingPea.isEffectLocation((Phase)list.get(n2), n)) {
                reqEffectStore.addEffectPhaseIndex(n4);
                if (!Collections.disjoint(set, iReqSymbolTable.getOutputVars())) {
                    reqEffectStore.addOutputEffectPhaseIndex(n4);
                }
            }
            for (Transition transition : ((Phase)list.get(n2)).getTransitions()) {
                if (!Req2CauseTrackingPea.isEffectTransition(transition.getSrc(), transition, n, cDD)) continue;
                Integer n5 = n3 + list2.indexOf(transition.getDest());
                reqEffectStore.addEffectEdgeIndex(n4, n5);
                if (Collections.disjoint(set, iReqSymbolTable.getOutputVars())) continue;
                reqEffectStore.addOutputEffectEdgeIndex(n4, n5);
            }
            ++n2;
        }
    }

    private static boolean isEffectLocation(Phase phase, int n) {
        if (phase.getPhaseBits() == null) {
            return false;
        }
        PhaseBits phaseBits = phase.getPhaseBits();
        return phaseBits.isActive(n) && !phaseBits.isWaiting(n) || phaseBits.isExact(n);
    }

    private static boolean isEffectTransition(Phase phase, Transition transition, int n, CDD cDD) {
        return phase.getPhaseBits() != null && phase.getPhaseBits().isActive(n) && transition.getGuard().and(cDD.negate().prime(Collections.emptySet())) == CDD.FALSE;
    }

    private static void setFlags(List<Phase> list) {
        for (Phase phase : list) {
            phase.setInit(true);
        }
    }

    private List<Phase> transformLocations(PhaseEventAutomata phaseEventAutomata, IReqSymbolTable iReqSymbolTable, Set<String> set, int n, CounterTrace.DCPhase[] dCPhaseArray) {
        List list = phaseEventAutomata.getPhases();
        ArrayList<Phase> arrayList = new ArrayList<Phase>();
        int n2 = 0;
        while (n2 < list.size()) {
            Phase phase = (Phase)list.get(n2);
            Set<String> set2 = Req2CauseTrackingPea.getAllToTrackVars(phase, dCPhaseArray, n, set);
            set2.removeAll(iReqSymbolTable.getConstVars());
            set2.removeAll(iReqSymbolTable.getInputVars());
            CDD cDD = phase.getStateInvariant();
            arrayList.set(n2, new Phase(phase.getName(), cDD, phase.getClockInvariant()));
            CDD cDD2 = this.mCddTransformer.transformInvariantTracking(phase.getStateInvariant(), set2, set, Req2CauseTrackingPea.isEffectLocation(phase, n));
            Phase phase2 = new Phase(phase.getName() + LOWER_AUTOMATON_SUFFIX, cDD2, phase.getClockInvariant());
            arrayList.set(list.size() + n2, phase2);
            if (phase.isInit()) {
                phase2.setInit(true);
            }
            ++n2;
        }
        return arrayList;
    }

    private static Set<String> getAllToTrackVars(Phase phase, CounterTrace.DCPhase[] dCPhaseArray, int n, Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        PhaseBits phaseBits = phase.getPhaseBits();
        CDD cDD = dCPhaseArray[n].getInvariant();
        if (phaseBits == null) {
            return Collections.emptySet();
        }
        int n2 = 0;
        while (n2 < dCPhaseArray.length) {
            if (phaseBits.isActive(n2) && !phaseBits.isWaiting(n2) || phaseBits.isExact(n2)) {
                CDD cDD2 = dCPhaseArray[n2].getInvariant();
                Set<String> set2 = Req2CauseTrackingCDD.getCddVariables(cDD2);
                if (cDD2 == CDD.TRUE && n2 == n) {
                    set2.addAll(Req2CauseTrackingCDD.getCddVariables(dCPhaseArray[n2 + 1].getInvariant()));
                }
                if (n == n2) {
                    set2.removeAll(set);
                }
                if (phaseBits.isWaiting(n)) {
                    Set<Decision<?>> set3 = Req2CauseTrackingCDD.getDecisions(cDD);
                    Set<Decision<Decision<?>>> set4 = Req2CauseTrackingCDD.getDecisions(cDD2);
                    set4.removeAll(set3);
                    set2.retainAll(Req2CauseTrackingCDD.getCddVariables(set4));
                }
                hashSet.addAll(set2);
            }
            ++n2;
        }
        return hashSet;
    }

    private static int getHighestDCPhase(List<Phase> list, CounterTrace.DCPhase[] dCPhaseArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < dCPhaseArray.length) {
            for (Phase phase : list) {
                PhaseBits phaseBits = phase.getPhaseBits();
                if (phaseBits == null || !phaseBits.isActive(n2) && !phaseBits.isWaiting(n2) && !phaseBits.isExact(n2) || n2 <= n) continue;
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    private static List<Phase> getInitialLocations(List<Phase> list) {
        ArrayList<Phase> arrayList = new ArrayList<Phase>();
        for (Phase phase : list) {
            if (!phase.isInit()) continue;
            arrayList.add(phase);
        }
        return arrayList;
    }

    private static void copyOldTransitions(List<Phase> list, List<Phase> list2) {
        List<Phase> list3 = list;
        int n = 0;
        while (n < list.size()) {
            for (Transition transition : list.get(n).getTransitions()) {
                int n2 = list3.indexOf(transition.getDest());
                list2.get(n).addTransition(list2.get(n2), transition.getGuard(), transition.getResets());
            }
            ++n;
        }
    }

    private void copyTransitionsToLower(List<Phase> list, List<Phase> list2, Set<String> set, IReqSymbolTable iReqSymbolTable, int n, CDD cDD) {
        int n2 = list2.size() / 2;
        List<Phase> list3 = list2;
        int n3 = 0;
        while (n3 < n2) {
            for (Transition transition : list2.get(n3).getTransitions()) {
                int n4 = list3.indexOf(transition.getDest());
                Phase phase = list2.get(n2 + 1);
                boolean bl = Req2CauseTrackingPea.isEffectTransition(phase, transition, n, cDD);
                CDD cDD2 = this.mCddTransformer.transformGurad(transition.getGuard(), set, iReqSymbolTable.getInputVars(), iReqSymbolTable.getConstVars(), bl);
                PhaseBits phaseBits = list.get(n3).getPhaseBits();
                PhaseBits phaseBits2 = list.get(n4).getPhaseBits();
                if (phaseBits != null && phaseBits.isWaiting(n) && (phaseBits2 == null || !phaseBits2.isWaiting(n))) {
                    cDD2 = cDD2.and(this.mCddTransformer.upperToLowerBoundCdd(phase.getClockInvariant(), true));
                }
                phase.addTransition(list2.get(n2 + 1), cDD2, transition.getResets());
            }
            ++n3;
        }
    }

    private void connectUpperToLowerAutomaton(List<Phase> list, List<Phase> list2, List<String> list3, int n) {
        int n2 = list.size() / 2;
        int n3 = 0;
        while (n3 < n2) {
            CDD cDD = CDD.TRUE;
            if (Req2CauseTrackingPea.isEffectLocation(list2.get(n3), n)) {
                CDD cDD2 = list2.get(n3).getClockInvariant();
                cDD = this.mCddTransformer.upperToLowerBoundCdd(cDD2, false);
            }
            if (list2.get(n3).getOutgoingTransition(list2.get(0)) != null) {
                list.get(n2 + 1).addTransition(list.get(n3), cDD, new String[0]);
            }
            if (list2.get(n3).isInit()) {
                list.get(n3).addTransition(list.get(n2 + 1), CDD.TRUE, list3.toArray(new String[list3.size()]));
            }
            ++n3;
        }
    }

    public Map<PhaseEventAutomata, ReqEffectStore> getReqEffectStore() {
        return this.mPea2EffectStore;
    }

    @Override
    public List<PatternType.ReqPeas> getReqPeas() {
        return this.mReqPeas;
    }

    @Override
    public IReqSymbolTable getSymboltable() {
        return this.mSymbolTable;
    }

    public Map<PhaseEventAutomata, ReqEffectStore> getEffectStore() {
        return this.mPea2EffectStore;
    }

    @Override
    public boolean hasErrors() {
        return this.mHasErrors;
    }

    @Override
    public IReq2PeaAnnotator getAnnotator() {
        return new ReqTestAnnotator(this.mServices, this.mLogger, this);
    }

    @Override
    public Durations getDurations() {
        return this.mDurations;
    }
}

