/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.LoggingScriptForNonIncrementalBenchmarks;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.SmtCommandUtils;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LoggingScriptForMainTrackBenchmarks
extends LoggingScriptForNonIncrementalBenchmarks {
    public static final String SOURCE_INVSYNTH = "(set-info :source |" + System.lineSeparator() + "SMT script generated by Ultimate Automizer [1,2]." + System.lineSeparator() + "Ultimate Automizer is a software verifier for C programs that implements an" + System.lineSeparator() + "automata-based approach [3]." + System.lineSeparator() + "The commands in this SMT scripts are used for a constraint-based synthesis" + System.lineSeparator() + "of invariants [4]." + System.lineSeparator() + System.lineSeparator() + "2016-04-30, Matthias Heizmann (heizmann@informatik.uni-freiburg.de)" + System.lineSeparator() + System.lineSeparator() + System.lineSeparator() + "[1] http://http://ultimate.informatik.uni-freiburg.de/automizer/" + System.lineSeparator() + "[2] Matthias Heizmann, Daniel Dietsch, Marius Greitschus, Jan Leike," + System.lineSeparator() + "Betim Musa, Claus Sch\u00e4tzle, Andreas Podelski: Ultimate Automizer with" + System.lineSeparator() + "Two-track Proofs - (Competition Contribution). TACAS 2016: 950-953" + System.lineSeparator() + "[3] Matthias Heizmann, Jochen Hoenicke, Andreas Podelski: Software Model" + System.lineSeparator() + "Checking for People Who Love Automata. CAV 2013:36-52" + System.lineSeparator() + "[4] Michael Colon, Sriram Sankaranarayanan, Henny Sipma: Linear Invariant" + System.lineSeparator() + "Generation Using Non-linear Constraint Solving. CAV 2003: 420-432" + System.lineSeparator() + System.lineSeparator() + "|)" + System.lineSeparator();
    public static final String SOURCE_GNTA = "(set-info :source |" + System.lineSeparator() + System.lineSeparator() + "SMT script generated by Ultimate LassoRanker [1]." + System.lineSeparator() + "Ultimate LassoRanker is a tool that analyzes termination and nontermination of" + System.lineSeparator() + "lasso-shaped programs. This script contains the SMT commands that Ultimate " + System.lineSeparator() + "LassoRanker used while checking if a lasso-shaped program has a geometric " + System.lineSeparator() + "nontermination argument. (See [2] for a preliminary definition of" + System.lineSeparator() + "geometric nontermination argument.)" + System.lineSeparator() + System.lineSeparator() + "This SMT script belongs to a set of SMT scripts that was generated by applying" + System.lineSeparator() + "Ultimate Buchi Automizer [3,4] to benchmarks from the SV-COMP 2016 [5,6] " + System.lineSeparator() + "which are available at [7]. Ultimate Buchi Automizer takes omega-traces" + System.lineSeparator() + "(lasso-shaped programs) and uses LassoRanker in order to check if the " + System.lineSeparator() + "lasso-shaped program is terminating." + System.lineSeparator() + System.lineSeparator() + "2016-04-30, Matthias Heizmann (heizmann@informatik.uni-freiburg.de)" + System.lineSeparator() + System.lineSeparator() + System.lineSeparator() + "[1] https://ultimate.informatik.uni-freiburg.de/LassoRanker/" + System.lineSeparator() + "[2] Jan Leike, Matthias Heizmann: Geometric Series as Nontermination" + System.lineSeparator() + "Arguments for Linear Lasso Programs. CoRR abs/1405.4413 (2014)" + System.lineSeparator() + "http://arxiv.org/abs/1405.4413" + System.lineSeparator() + "[3] http://ultimate.informatik.uni-freiburg.de/BuchiAutomizer/" + System.lineSeparator() + "[4] Matthias Heizmann, Jochen Hoenicke, Andreas Podelski: Software Model" + System.lineSeparator() + "Checking for People Who Love Automata. CAV 2013:36-52" + System.lineSeparator() + "[5] http://sv-comp.sosy-lab.org/2016/" + System.lineSeparator() + "[6] Dirk Beyer: Reliable and Reproducible Competition Results with BenchExec" + System.lineSeparator() + "and Witnesses (Report on SV-COMP 2016). TACAS 2016: 887-904" + System.lineSeparator() + "[7] https://github.com/dbeyer/sv-benchmarks" + System.lineSeparator() + System.lineSeparator() + "|)" + System.lineSeparator();
    public static final String SOURCE_AUTOMIZER = "|" + System.lineSeparator() + "Generated by the tool Ultimate Automizer [1,2] which implements" + System.lineSeparator() + "an automata theoretic approach [3] to software verification." + System.lineSeparator() + System.lineSeparator() + "This SMT script belongs to a set of SMT scripts that was generated by" + System.lineSeparator() + "applying Ultimate Automizer to benchmarks [4] from the SV-COMP 2024 [5,6]." + System.lineSeparator() + "This script may not contain all SMT commands that Ultimate Automizer" + System.lineSeparator() + "issued. In order to meet the restrictions for SMT-COMP benchmarks " + System.lineSeparator() + "we dropped the commands for getting values (resp. models), " + System.lineSeparator() + "unsatisfiable cores, and interpolants." + System.lineSeparator() + System.lineSeparator() + "2024-04-13, Matthias Heizmann (heizmann@informatik.uni-freiburg.de)" + System.lineSeparator() + System.lineSeparator() + "[1] https://ultimate.informatik.uni-freiburg.de/automizer/" + System.lineSeparator() + "[2] Matthias Heizmann, Max Barth, Daniel Dietsch, Leonard Fichtner," + System.lineSeparator() + "     Jochen Hoenicke, Dominik Klumpp, Mehdi Naouar, Tanja Schindler," + System.lineSeparator() + "     Frank Sch\u00fcssele, Andreas Podelski: Ultimate Automizer and the" + System.lineSeparator() + "     CommuHash Normal Form (Competition Contribution). TACAS 2023" + System.lineSeparator() + "[3] Matthias Heizmann, Jochen Hoenicke, Andreas Podelski: Software Model" + System.lineSeparator() + "     Checking for People Who Love Automata. CAV 2013" + System.lineSeparator() + "[4] https://github.com/sosy-lab/sv-benchmarks" + System.lineSeparator() + "[5] Dirk Beyer: State of the Art in Software Verification and" + System.lineSeparator() + "     Witness Validation: SV-COMP 2024.  TACAS 2024" + System.lineSeparator() + "[6] https://sv-comp.sosy-lab.org/2024/" + System.lineSeparator() + "|";
    public static final String SOURCE_POLYNOMIAL_RELATION_TEST = "|" + System.lineSeparator() + "Generated by a testsuite for polynomials of the Ultimate framework [1]." + System.lineSeparator() + "This testsuite runs transformations on polynomials and uses an SMT solver" + System.lineSeparator() + "to check that the input and the output are logically equivalent." + System.lineSeparator() + "These transformations are mainly used by the quantifier elimination " + System.lineSeparator() + "implemented in Ultimate Eliminator [2] which itself is used by " + System.lineSeparator() + "the software verifier Ultimate Automizer[3,4,5] to generate state " + System.lineSeparator() + "assertions from unsatisfiable cores [6]." + System.lineSeparator() + System.lineSeparator() + "2020-06-14, Matthias Heizmann (heizmann@informatik.uni-freiburg.de)" + System.lineSeparator() + System.lineSeparator() + "[1] https://ultimate.informatik.uni-freiburg.de/" + System.lineSeparator() + "[2] https://ultimate.informatik.uni-freiburg.de/eliminator/" + System.lineSeparator() + "[3] https://ultimate.informatik.uni-freiburg.de/automizer/" + System.lineSeparator() + "[4] Matthias Heizmann, Yu-Fang Chen, Daniel Dietsch, Marius Greitschus," + System.lineSeparator() + "     Jochen Hoenicke, Yong Li, Alexander Nutz, Betim Musa, Christian" + System.lineSeparator() + "     Schilling, Tanja Schindler, Andreas Podelski: Ultimate Automizer" + System.lineSeparator() + "     and the Search for Perfect Interpolants - (Competition Contribution)." + System.lineSeparator() + "     TACAS (2) 2018: 447-451" + System.lineSeparator() + "[5] Matthias Heizmann, Jochen Hoenicke, Andreas Podelski: Software Model" + System.lineSeparator() + "     Checking for People Who Love Automata. CAV 2013:36-52" + System.lineSeparator() + "[6] Daniel Dietsch, Matthias Heizmann, Betim Musa, Alexander Nutz, Andreas Podelski" + System.lineSeparator() + "    Craig vs. Newton in software model checking. ESEC/SIGSOFT FSE 2017: 487-497" + System.lineSeparator() + "|";
    private int mWrittenScriptCounter = 0;
    private final int mBenchmarkTooSimpleThreshold = 10000;
    private final boolean mWriteUnsolvedBenchmarks = true;

    public LoggingScriptForMainTrackBenchmarks(Script script, String string, String string2) {
        super(script, string, string2);
    }

    @Override
    public Script.LBool checkSat() throws SMTLIBException {
        boolean bl;
        long l = System.nanoTime();
        Script.LBool lBool = this.mScript.checkSat();
        long l2 = (System.nanoTime() - l) / 1000L / 1000L;
        boolean bl2 = bl = lBool == Script.LBool.SAT || lBool == Script.LBool.UNSAT;
        if (bl && l2 >= 10000L || !bl) {
            File file = this.constructFile("_" + String.valueOf(this.mWrittenScriptCounter));
            List<ArrayList<SmtCommandUtils.ISmtCommand<?>>> list = this.postprocessCommandStack(this.mCommandStack, lBool);
            this.writeCommandStackToFile(file, list);
            ++this.mWrittenScriptCounter;
        }
        return lBool;
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        Term term2 = term instanceof AnnotatedTerm ? ((AnnotatedTerm)term).getSubterm() : term;
        if (term2 != this.mScript.term("true", new Term[0])) {
            this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.AssertCommand(term2));
        }
        return this.mScript.assertTerm(term);
    }

    @Override
    public Map<Term, Term> getValue(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        return this.mScript.getValue(termArray);
    }

    private List<ArrayList<SmtCommandUtils.ISmtCommand<?>>> process(LinkedList<ArrayList<SmtCommandUtils.ISmtCommand<?>>> linkedList, Script.LBool lBool) {
        ArrayList arrayList = new ArrayList();
        this.addInvarSynthCommands(arrayList, lBool);
        boolean bl = false;
        for (ArrayList arrayList2 : linkedList) {
            for (SmtCommandUtils.ISmtCommand iSmtCommand : arrayList2) {
                if (!bl && iSmtCommand.toString().contains("declare-fun")) {
                    bl = true;
                }
                if (!bl) continue;
                arrayList.add(iSmtCommand);
            }
        }
        arrayList.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.CheckSatCommand());
        arrayList.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.ExitCommand());
        return Collections.singletonList(arrayList);
    }

    private void addInvarSynthCommands(ArrayList<SmtCommandUtils.ISmtCommand<?>> arrayList, Script.LBool lBool) {
    }

    public static String getSourceInfo() {
        return SOURCE_AUTOMIZER;
    }

    public static String getLogic() {
        return "BV";
    }

    private List<SmtCommandUtils.ISmtCommand<?>> buildPreamble(Logics logics, Script.LBool lBool, String string) {
        ArrayList arrayList = new ArrayList();
        arrayList.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetInfoCommand(":smt-lib-version", (Object)new BigDecimal("2.6")));
        arrayList.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetLogicCommand(logics.name()));
        arrayList.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetInfoCommand(":source", (Object)string));
        arrayList.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetInfoCommand(":license", (Object)new QuotedObject("https://creativecommons.org/licenses/by/4.0/")));
        arrayList.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetInfoCommand(":category", (Object)new QuotedObject("industrial")));
        arrayList.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetInfoCommand(":status", (Object)lBool.toString()));
        return arrayList;
    }

    private List<ArrayList<SmtCommandUtils.ISmtCommand<?>>> postprocessCommandStack(LinkedList<ArrayList<SmtCommandUtils.ISmtCommand<?>>> linkedList, Script.LBool lBool) {
        Logics logics;
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        TermClassifier termClassifier = new TermClassifier();
        Iterator<ArrayList<SmtCommandUtils.ISmtCommand<?>>> iterator = linkedList.descendingIterator();
        while (iterator.hasNext()) {
            logics = iterator.next();
            int n = logics.size() - 1;
            while (n >= 0) {
                SmtCommandUtils.ISmtCommand<?> iSmtCommand = logics.get(n);
                if (iSmtCommand instanceof SmtCommandUtils.AssertCommand) {
                    var9_10 = (SmtCommandUtils.AssertCommand)iSmtCommand;
                    termClassifier.checkTerm(var9_10.getTerm());
                    arrayDeque.addFirst(iSmtCommand);
                } else if (iSmtCommand instanceof SmtCommandUtils.DeclareFunCommand) {
                    var9_10 = (SmtCommandUtils.DeclareFunCommand)iSmtCommand;
                    if (termClassifier.getOccuringFunctionNames().contains(var9_10.getFun())) {
                        arrayDeque.addFirst(iSmtCommand);
                    }
                }
                --n;
            }
        }
        arrayDeque.add(new SmtCommandUtils.CheckSatCommand());
        arrayDeque.add(new SmtCommandUtils.ExitCommand());
        logics = this.determineLogic(termClassifier);
        ArrayList arrayList = new ArrayList(this.buildPreamble(logics, lBool, LoggingScriptForMainTrackBenchmarks.getSourceInfo()));
        arrayList.addAll(arrayDeque);
        return Collections.singletonList(arrayList);
    }

    private Logics determineLogic(TermClassifier termClassifier) {
        ArrayList<Logics> arrayList = new ArrayList<Logics>();
        Logics[] logicsArray = Logics.values();
        int n = logicsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Logics logics = logicsArray[n2];
            if (!(logics == Logics.ALL || logics.isString() || logics.isDifferenceLogic() || logics.isUF() || logics.isDatatype() || logics.isFloatingPoint() && logics.hasReals() || logics.isNonLinearArithmetic() != termClassifier.hasNonlinearArithmetic() || termClassifier.getOccuringQuantifiers().isEmpty() == logics.isQuantified() || termClassifier.hasArrays() != logics.isArray() || termClassifier.getOccuringSortNames().contains("Int") != logics.hasIntegers() || termClassifier.getOccuringSortNames().contains("Real") != logics.hasReals() && !termClassifier.getOccuringSortNames().contains("FloatingPoint") || termClassifier.getOccuringSortNames().contains("BitVec") != logics.isBitVector() || (termClassifier.getOccuringSortNames().contains("FloatingPoint") || termClassifier.getOccuringSortNames().contains("RoundingMode")) != logics.isFloatingPoint())) {
                arrayList.add(logics);
            }
            ++n2;
        }
        if (arrayList.isEmpty()) {
            throw new AssertionError((Object)"no applicable logic");
        }
        if (arrayList.size() == 1) {
            return (Logics)arrayList.iterator().next();
        }
        throw new AssertionError((Object)("too many candiate logics " + String.valueOf(arrayList)));
    }
}

