/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BreakStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.type.StructExpanderUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.DataRaceChecker;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.FunctionDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TypeHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.BaseMemoryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.HeapDataArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.LocalLValueILocationPair;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModel_MultiBitprecise;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModel_SingleBitprecise;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModel_Unbounded;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.RequiredMemoryModelFeatures;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizeAndOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.memoryhandler.ConstructMemcpyOrMemmove;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.memoryhandler.ConstructRealloc;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CNamed;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValueFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.INameHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.LinkedScopedHashMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class MemoryHandler {
    private static final boolean SUPPORT_FLOATS_ON_HEAP = true;
    private static final String FLOAT_ON_HEAP_UNSOUND_MESSAGE = "Analysis for floating types on heap by default disabled (soundness first).";
    private static final String SIZE = "~size";
    private static final String ADDR = "~addr";
    private static final boolean ADD_IMPLEMENTATIONS = false;
    public static final boolean FIXED_ADDRESSES_FOR_INITIALIZATION = true;
    private final ITypeHandler mTypeHandler;
    private final LinkedScopedHashMap<LocalLValueILocationPair, Integer> mVariablesToBeMalloced;
    private final LinkedScopedHashMap<LocalLValueILocationPair, Integer> mVariablesToBeFreed;
    private final ExpressionTranslation mExpressionTranslation;
    private final TypeSizeAndOffsetComputer mTypeSizeAndOffsetComputer;
    private final TypeSizes mTypeSizes;
    private final RequiredMemoryModelFeatures mRequiredMemoryModelFeatures;
    private final BaseMemoryModel mMemoryModel;
    private final INameHandler mNameHandler;
    private final IBooleanArrayHelper mBooleanArrayHelper;
    private final ProcedureManager mProcedureManager;
    private final Map<MemoryModelDeclarations, MemoryModelDeclarationInfo> mMemoryModelDeclarationInfos;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final TranslationSettings mSettings;
    private int mFixedAddressCounter = 1;

    public MemoryHandler(TypeSizes typeSizes, INameHandler iNameHandler, boolean bl, ITypeHandler iTypeHandler, ExpressionTranslation expressionTranslation, ProcedureManager procedureManager, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer, AuxVarInfoBuilder auxVarInfoBuilder, TranslationSettings translationSettings) {
        this.mTypeHandler = iTypeHandler;
        this.mTypeSizes = typeSizes;
        this.mExpressionTranslation = expressionTranslation;
        this.mNameHandler = iNameHandler;
        this.mTypeSizeAndOffsetComputer = typeSizeAndOffsetComputer;
        this.mProcedureManager = procedureManager;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mSettings = translationSettings;
        this.mRequiredMemoryModelFeatures = new RequiredMemoryModelFeatures();
        this.mBooleanArrayHelper = bl ? (this.mSettings.isBitvectorTranslation() ? new BooleanArrayHelper_Bitvector() : new BooleanArrayHelper_Integer()) : new BooleanArrayHelper_Bool();
        this.mMemoryModel = this.getMemoryModel(translationSettings.isBitvectorTranslation(), translationSettings.getMemoryModelPreference());
        this.mVariablesToBeMalloced = new LinkedScopedHashMap();
        this.mVariablesToBeFreed = new LinkedScopedHashMap();
        this.mMemoryModelDeclarationInfos = new LinkedHashMap<MemoryModelDeclarations, MemoryModelDeclarationInfo>();
    }

    public MemoryHandler(MemoryHandler memoryHandler, TypeSizes typeSizes, INameHandler iNameHandler, ITypeHandler iTypeHandler, ExpressionTranslation expressionTranslation, ProcedureManager procedureManager, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer, AuxVarInfoBuilder auxVarInfoBuilder, TranslationSettings translationSettings) {
        this.mTypeHandler = iTypeHandler;
        this.mTypeSizes = typeSizes;
        this.mExpressionTranslation = expressionTranslation;
        this.mNameHandler = iNameHandler;
        this.mTypeSizeAndOffsetComputer = typeSizeAndOffsetComputer;
        this.mProcedureManager = procedureManager;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mSettings = translationSettings;
        this.mRequiredMemoryModelFeatures = new RequiredMemoryModelFeatures();
        this.mBooleanArrayHelper = memoryHandler.mBooleanArrayHelper;
        this.mMemoryModel = memoryHandler.mMemoryModel;
        this.mVariablesToBeMalloced = memoryHandler.mVariablesToBeMalloced;
        this.mVariablesToBeFreed = memoryHandler.mVariablesToBeFreed;
        this.mMemoryModelDeclarationInfos = memoryHandler.mMemoryModelDeclarationInfos;
    }

    public RequiredMemoryModelFeatures getRequiredMemoryModelFeatures() {
        return this.mRequiredMemoryModelFeatures;
    }

    public BaseMemoryModel getMemoryModel() {
        return this.mMemoryModel;
    }

    public Expression calculateSizeOf(ILocation iLocation, ICType iCType) {
        return this.mTypeSizeAndOffsetComputer.constructBytesizeExpression(iLocation, iCType);
    }

    public ExpressionResult handleAlignOf(ILocation iLocation, ICType iCType, ICType iCType2) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addOverapprox(new Overapprox("alignof", iLocation));
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType2, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), iCType2));
        return expressionResultBuilder.build();
    }

    public List<Declaration> declareMemoryModelInfrastructure(CHandler cHandler, ILocation iLocation, DataRaceChecker dataRaceChecker) {
        this.mRequiredMemoryModelFeatures.finish(this.mSettings);
        if (!this.mRequiredMemoryModelFeatures.isMemoryModelInfrastructureRequired()) {
            return Collections.emptyList();
        }
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        arrayList.add((Declaration)this.constructValidArrayDeclaration());
        arrayList.add((Declaration)this.constuctLengthArrayDeclaration());
        Collection<HeapDataArray> collection = this.mMemoryModel.getDataHeapArrays(this.mRequiredMemoryModelFeatures);
        for (HeapDataArray object2 : collection) {
            arrayList.add((Declaration)this.constructMemoryArrayDeclaration(iLocation, object2.getName(), object2.getASTType()));
            arrayList.addAll(this.constructWriteProcedures(cHandler, iLocation, collection, object2));
            arrayList.addAll(this.constructReadProcedures(cHandler, iLocation, object2));
        }
        for (CPrimitive.CPrimitives cPrimitives : this.mRequiredMemoryModelFeatures.getDataOnHeapRequired()) {
            if (!this.mRequiredMemoryModelFeatures.isDataOnHeapStoreFunctionRequired(cPrimitives)) continue;
            this.declareDataOnHeapStoreFunction(this.mMemoryModel.getDataHeapArray(cPrimitives));
            this.declareDataOnHeapSelectFunction(this.mMemoryModel.getDataHeapArray(cPrimitives));
        }
        if (this.mRequiredMemoryModelFeatures.isPointerOnHeapStoreFunctionRequired()) {
            this.declareDataOnHeapStoreFunction(this.mMemoryModel.getPointerHeapArray());
            this.declareDataOnHeapSelectFunction(this.mMemoryModel.getPointerHeapArray());
        }
        for (CPrimitive.CPrimitives cPrimitives : this.mRequiredMemoryModelFeatures.getDataOnHeapRequired()) {
            if (!this.mRequiredMemoryModelFeatures.isDataOnHeapInitFunctionRequired(cPrimitives)) continue;
            this.declareDataOnHeapInitFunction(this.mMemoryModel.getDataHeapArray(cPrimitives));
        }
        if (this.mRequiredMemoryModelFeatures.isPointerOnHeapInitFunctionRequired()) {
            this.declareDataOnHeapInitFunction(this.mMemoryModel.getPointerHeapArray());
        }
        arrayList.addAll(this.declareDeallocation(cHandler, iLocation));
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_ALLOC_STACK)) {
            arrayList.addAll(this.declareMalloc(cHandler, this.mTypeHandler, iLocation, MemoryArea.STACK));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_ALLOC_INIT)) {
            this.declareAllocInit(cHandler, this.mTypeHandler, iLocation);
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_ALLOC_HEAP)) {
            arrayList.addAll(this.declareMalloc(cHandler, this.mTypeHandler, iLocation, MemoryArea.HEAP));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.C_MEMSET)) {
            arrayList.addAll(this.declareMemset(cHandler, collection));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_MEMINIT)) {
            arrayList.addAll(this.declareUltimateMeminit(cHandler, collection));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.C_MEMCPY)) {
            ConstructMemcpyOrMemmove constructMemcpyOrMemmove = new ConstructMemcpyOrMemmove(this, this.mProcedureManager, (TypeHandler)this.mTypeHandler, this.mTypeSizeAndOffsetComputer, this.mExpressionTranslation, this.mAuxVarInfoBuilder, this.mTypeSizes, dataRaceChecker);
            arrayList.addAll(constructMemcpyOrMemmove.declareMemcpyOrMemmove(cHandler, MemoryModelDeclarations.C_MEMCPY));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.C_MEMMOVE)) {
            ConstructMemcpyOrMemmove constructMemcpyOrMemmove = new ConstructMemcpyOrMemmove(this, this.mProcedureManager, (TypeHandler)this.mTypeHandler, this.mTypeSizeAndOffsetComputer, this.mExpressionTranslation, this.mAuxVarInfoBuilder, this.mTypeSizes, dataRaceChecker);
            arrayList.addAll(constructMemcpyOrMemmove.declareMemcpyOrMemmove(cHandler, MemoryModelDeclarations.C_MEMMOVE));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.C_STRCPY)) {
            arrayList.addAll(this.declareStrCpy(cHandler, collection));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.C_REALLOC)) {
            ConstructRealloc constructRealloc = new ConstructRealloc(this, this.mProcedureManager, (TypeHandler)this.mTypeHandler, this.mTypeSizeAndOffsetComputer, this.mExpressionTranslation);
            arrayList.addAll(constructRealloc.declareRealloc(cHandler, collection));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_PTHREADS_FORK_COUNT)) {
            arrayList.add((Declaration)this.declarePthreadsForkCount(iLocation));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX)) {
            arrayList.add((Declaration)this.declarePThreadsMutexArray(iLocation));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX_LOCK)) {
            arrayList.addAll(this.declarePthreadMutexLock(cHandler, this.mTypeHandler, iLocation));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX_UNLOCK)) {
            arrayList.addAll(this.declarePthreadMutexUnlock(cHandler, this.mTypeHandler, iLocation));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX_TRYLOCK)) {
            arrayList.addAll(this.declarePthreadMutexTryLock(cHandler, this.mTypeHandler, iLocation));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK)) {
            arrayList.add((Declaration)this.declarePthreadRwLock(iLocation));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_READLOCK)) {
            arrayList.addAll(this.declarePthreadRwLockReadLock(cHandler, this.mTypeHandler, iLocation));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_WRITELOCK)) {
            arrayList.addAll(this.declarePthreadRwLockWriteLock(cHandler, this.mTypeHandler, iLocation));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_UNLOCK)) {
            arrayList.addAll(this.declarePthreadRwLockUnlock(cHandler, this.mTypeHandler, iLocation));
        }
        if (this.mRequiredMemoryModelFeatures.getRequiredMemoryModelDeclarations().contains((Object)MemoryModelDeclarations.ULTIMATE_STACK_HEAP_BARRIER)) {
            arrayList.add((Declaration)this.constructStackHeapBarrierConstant());
        }
        assert (MemoryHandler.assertContainsNodeProcedureDeclarations(arrayList)) : "add procedure declarations via function handler!";
        return arrayList;
    }

    public CallStatement constructUltimateMeminitCall(ILocation iLocation, Expression expression, Expression expression2, Expression expression3, Expression expression4) {
        return this.constructCall(MemoryModelDeclarations.ULTIMATE_MEMINIT, iLocation, null, expression4, expression, expression2, expression3);
    }

    public CallStatement constructUltimateMemsetCall(ILocation iLocation, Expression expression, Expression expression2, Expression expression3, VariableLHS variableLHS) {
        return this.constructCall(MemoryModelDeclarations.C_MEMSET, iLocation, variableLHS, expression, expression2, expression3);
    }

    private static AtomicStatement makeAtomic(ILocation iLocation, Statement statement) {
        return new AtomicStatement(iLocation, new Statement[]{statement});
    }

    public Statement constructPthreadMutexLockCall(ILocation iLocation, Expression expression, VariableLHS variableLHS) {
        return MemoryHandler.makeAtomic(iLocation, (Statement)this.constructCall(MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX_LOCK, iLocation, variableLHS, expression));
    }

    public Statement constructPthreadMutexUnlockCall(ILocation iLocation, Expression expression, VariableLHS variableLHS) {
        return MemoryHandler.makeAtomic(iLocation, (Statement)this.constructCall(MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX_UNLOCK, iLocation, variableLHS, expression));
    }

    public Statement constructPthreadMutexTryLockCall(ILocation iLocation, Expression expression, VariableLHS variableLHS) {
        return MemoryHandler.makeAtomic(iLocation, (Statement)this.constructCall(MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX_TRYLOCK, iLocation, variableLHS, expression));
    }

    public Statement constructPthreadRwLockReadLockCall(ILocation iLocation, Expression expression, VariableLHS variableLHS) {
        return MemoryHandler.makeAtomic(iLocation, (Statement)this.constructCall(MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_READLOCK, iLocation, variableLHS, expression));
    }

    public Statement constructPthreadRwLockWriteLockCall(ILocation iLocation, Expression expression, VariableLHS variableLHS) {
        return MemoryHandler.makeAtomic(iLocation, (Statement)this.constructCall(MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_WRITELOCK, iLocation, variableLHS, expression));
    }

    public Statement constructPthreadRwLockUnlockCall(ILocation iLocation, Expression expression, VariableLHS variableLHS) {
        return MemoryHandler.makeAtomic(iLocation, (Statement)this.constructCall(MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_UNLOCK, iLocation, variableLHS, expression));
    }

    private CallStatement constructCall(MemoryModelDeclarations memoryModelDeclarations, ILocation iLocation, VariableLHS variableLHS, Expression ... expressionArray) {
        VariableLHS[] variableLHSArray;
        this.requireMemoryModelFeature(memoryModelDeclarations);
        if (variableLHS == null) {
            variableLHSArray = new VariableLHS[]{};
        } else {
            VariableLHS[] variableLHSArray2 = new VariableLHS[1];
            variableLHSArray = variableLHSArray2;
            variableLHSArray2[0] = variableLHS;
        }
        VariableLHS[] variableLHSArray3 = variableLHSArray;
        return StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])variableLHSArray3, (String)memoryModelDeclarations.getName(), (Expression[])expressionArray);
    }

    public static AssignmentStatement constructOneDimensionalArrayUpdate(ILocation iLocation, Expression expression, VariableLHS variableLHS, Expression expression2) {
        LeftHandSide[] leftHandSideArray = new LeftHandSide[]{ExpressionFactory.constructNestedArrayLHS((ILocation)iLocation, (LeftHandSide)variableLHS, (Expression[])new Expression[]{expression})};
        Expression[] expressionArray = new Expression[]{expression2};
        return StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])leftHandSideArray, (Expression[])expressionArray);
    }

    public Expression constructPointerBaseValidityCheckExpr(ILocation iLocation, Expression expression) {
        Expression expression2 = MemoryHandler.getPointerBaseAddress(expression, iLocation);
        ArrayAccessExpression arrayAccessExpression = ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)this.getValidArray(iLocation), (Expression[])new Expression[]{expression2});
        return this.mBooleanArrayHelper.compareWithTrue((Expression)arrayAccessExpression);
    }

    public Expression getLengthArray(ILocation iLocation) {
        return this.getMemoryModelFeatureExpression(iLocation, MemoryModelDeclarations.ULTIMATE_LENGTH);
    }

    public VariableLHS getLengthArrayLhs(ILocation iLocation) {
        return this.getMemoryModelFeatureLhs(iLocation, MemoryModelDeclarations.ULTIMATE_LENGTH);
    }

    public Expression getValidArray(ILocation iLocation) {
        return this.getMemoryModelFeatureExpression(iLocation, MemoryModelDeclarations.ULTIMATE_VALID);
    }

    public VariableLHS getValidArrayLhs(ILocation iLocation) {
        return this.getMemoryModelFeatureLhs(iLocation, MemoryModelDeclarations.ULTIMATE_VALID);
    }

    public Expression getStackHeapBarrier(ILocation iLocation) {
        return this.getMemoryModelFeatureExpression(iLocation, MemoryModelDeclarations.ULTIMATE_STACK_HEAP_BARRIER);
    }

    public Expression getMemoryRaceArray(ILocation iLocation) {
        return this.getMemoryModelFeatureExpression(iLocation, MemoryModelDeclarations.ULTIMATE_DATA_RACE_MEMORY);
    }

    public VariableLHS getMemoryRaceArrayLhs(ILocation iLocation) {
        return this.getMemoryModelFeatureLhs(iLocation, MemoryModelDeclarations.ULTIMATE_DATA_RACE_MEMORY);
    }

    private Expression getMemoryModelFeatureExpression(ILocation iLocation, MemoryModelDeclarations memoryModelDeclarations) {
        this.requireMemoryModelFeature(memoryModelDeclarations);
        MemoryModelDeclarationInfo memoryModelDeclarationInfo = this.getMemoryModelDeclarationInfo(memoryModelDeclarations);
        return memoryModelDeclarationInfo.constructIdentifierExpression(iLocation);
    }

    private VariableLHS getMemoryModelFeatureLhs(ILocation iLocation, MemoryModelDeclarations memoryModelDeclarations) {
        this.requireMemoryModelFeature(memoryModelDeclarations);
        MemoryModelDeclarationInfo memoryModelDeclarationInfo = this.getMemoryModelDeclarationInfo(memoryModelDeclarations);
        return memoryModelDeclarationInfo.constructVariableLHS(iLocation);
    }

    public Collection<Statement> getChecksForFreeCall(ILocation iLocation, RValue rValue) {
        assert (rValue.getCType().getUnderlyingType() instanceof CPointer);
        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ZERO);
        Expression expression2 = this.getValidArray(iLocation);
        Expression expression3 = MemoryHandler.getPointerOffset(rValue.getValue(), iLocation);
        Expression expression4 = MemoryHandler.getPointerBaseAddress(rValue.getValue(), iLocation);
        Expression[] expressionArray = new Expression[]{expression4};
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        if (this.mSettings.checkIfFreedPointerIsValid()) {
            Check check = new Check(Spec.MEMORY_FREE);
            AssertStatement assertStatement = new AssertStatement(iLocation, ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression3, (Expression)expression));
            check.annotate((IElement)assertStatement);
            arrayList.add((Statement)assertStatement);
            assertStatement = this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 8, MemoryHandler.getPointerBaseAddress(rValue.getValue(), iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents(), this.getStackHeapBarrier(iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents());
            AssertStatement assertStatement2 = new AssertStatement(iLocation, (Expression)assertStatement);
            check.annotate((IElement)assertStatement2);
            arrayList.add((Statement)assertStatement2);
            assertStatement = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ZERO);
            assertStatement2 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression4, (Expression)assertStatement);
            Expression expression5 = this.mBooleanArrayHelper.compareWithTrue((Expression)ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)expression2, (Expression[])expressionArray));
            AssertStatement assertStatement3 = new AssertStatement(iLocation, ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)assertStatement2, (Expression)expression5));
            check.annotate((IElement)assertStatement3);
            arrayList.add((Statement)assertStatement3);
        }
        return arrayList;
    }

    public CallStatement getDeallocCall(LRValue lRValue, ILocation iLocation) {
        assert (lRValue instanceof RValue || lRValue instanceof LocalLValue);
        this.requireMemoryModelFeature(MemoryModelDeclarations.ULTIMATE_DEALLOC);
        return StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[0], (String)MemoryModelDeclarations.ULTIMATE_DEALLOC.getName(), (Expression[])new Expression[]{lRValue.getValue()});
    }

    public CallStatement getUltimateMemAllocCall(LocalLValue localLValue, ILocation iLocation, MemoryArea memoryArea) {
        return this.getUltimateMemAllocCall(this.calculateSizeOf(iLocation, localLValue.getCType()), (VariableLHS)localLValue.getLhs(), iLocation, memoryArea);
    }

    public CallStatement getUltimateMemAllocCall(Expression expression, VariableLHS variableLHS, ILocation iLocation, MemoryArea memoryArea) {
        MemoryModelDeclarations memoryModelDeclarations = memoryArea.getMemoryModelDeclaration();
        this.requireMemoryModelFeature(memoryModelDeclarations);
        Expression expression2 = this.mExpressionTranslation.applyWraparound(iLocation, this.mTypeSizes.getSizeT(), expression);
        CallStatement callStatement = StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[]{variableLHS}, (String)memoryModelDeclarations.getName(), (Expression[])new Expression[]{expression2});
        this.mProcedureManager.registerProcedure(memoryModelDeclarations.getName());
        return callStatement;
    }

    public CallStatement getUltimateMemAllocInitCall(Expression expression, RValue rValue, ILocation iLocation) {
        this.requireMemoryModelFeature(MemoryModelDeclarations.ULTIMATE_ALLOC_INIT);
        CallStatement callStatement = StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[0], (String)MemoryModelDeclarations.ULTIMATE_ALLOC_INIT.getName(), (Expression[])new Expression[]{expression, rValue.getValue()});
        this.mProcedureManager.registerProcedure(MemoryModelDeclarations.ULTIMATE_ALLOC_INIT.getName());
        return callStatement;
    }

    public Pair<RValue, CallStatement> getUltimateMemAllocInitCall(ILocation iLocation, ICType iCType) {
        BigInteger bigInteger = BigInteger.valueOf(this.mFixedAddressCounter);
        Expression expression = this.mExpressionTranslation.constructPointerForIntegerValues(iLocation, bigInteger, BigInteger.ZERO);
        RValue rValue = new RValue(expression, iCType);
        RValue rValue2 = new RValue(this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), bigInteger), this.mExpressionTranslation.getCTypeOfPointerComponents());
        Expression expression2 = this.mTypeSizeAndOffsetComputer.constructBytesizeExpression(iLocation, iCType);
        CallStatement callStatement = this.getUltimateMemAllocInitCall(expression2, rValue2, iLocation);
        ++this.mFixedAddressCounter;
        return new Pair((Object)rValue, (Object)callStatement);
    }

    private HeapDataArray determineMemoryArrayForType(ICType iCType) {
        if (iCType instanceof CPointer) {
            this.mRequiredMemoryModelFeatures.reportPointerOnHeapRequired();
            return this.mMemoryModel.getPointerHeapArray();
        }
        if (iCType instanceof CPrimitive) {
            CPrimitive cPrimitive = (CPrimitive)iCType;
            this.mRequiredMemoryModelFeatures.reportDataOnHeapRequired(cPrimitive.getType());
            return this.mMemoryModel.getDataHeapArray(cPrimitive.getType());
        }
        throw new AssertionError((Object)("There is no memory array for the type " + String.valueOf(iCType)));
    }

    public ExpressionResult getReadCall(Expression expression, ICType iCType) {
        ILocation iLocation = expression.getLocation();
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType, SFO.AUXVAR.MEMREAD);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        VariableLHS[] variableLHSArray = new VariableLHS[]{auxVarInfo.getLhs()};
        CallStatement callStatement = StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])variableLHSArray, (String)this.determineReadProcedure(iCType, iLocation), (Expression[])new Expression[]{expression, this.calculateSizeOf(iLocation, iCType)});
        if (iCType.isAtomic()) {
            expressionResultBuilder.addStatement((Statement)new AtomicStatement(iLocation, new Statement[]{callStatement}));
        } else {
            expressionResultBuilder.addStatement((Statement)callStatement);
        }
        assert (CTranslationUtil.isAuxVarMapComplete(this.mNameHandler, expressionResultBuilder));
        expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), iCType));
        return expressionResultBuilder.build();
    }

    public ExpressionResult getReadUnchecked(Expression expression, ICType iCType) {
        int n;
        if (iCType instanceof CPointer) {
            n = this.mTypeSizes.getSizeOfPointer();
        } else if (iCType instanceof CPrimitive) {
            CPrimitive cPrimitive = (CPrimitive)iCType;
            n = this.mTypeSizes.getSize(cPrimitive.getType());
        } else {
            throw new AssertionError((Object)"We only support reading primitive or pointer types");
        }
        ILocation iLocation = expression.getLocation();
        return new ExpressionResult(new RValue(this.readFromHeap(iLocation, this.determineMemoryArrayForType(iCType), expression, iCType, n), iCType));
    }

    private String determineReadProcedure(ICType iCType, ILocation iLocation) throws AssertionError {
        ICType iCType2 = iCType.getUnderlyingType();
        if (iCType2 instanceof CPrimitive) {
            CPrimitive cPrimitive = (CPrimitive)iCType2;
            MemoryHandler.checkFloatOnHeapSupport(iLocation, cPrimitive);
            this.mRequiredMemoryModelFeatures.reportDataOnHeapRequired(cPrimitive.getType());
            return this.determineReadProcedureForPrimitive(cPrimitive.getType());
        }
        if (iCType2 instanceof CPointer) {
            this.mRequiredMemoryModelFeatures.reportPointerOnHeapRequired();
            return this.determineReadProcedureForPointer();
        }
        if (iCType2 instanceof CArray) {
            this.mRequiredMemoryModelFeatures.reportPointerOnHeapRequired();
            return this.determineReadProcedureForPointer();
        }
        if (iCType2 instanceof CEnum) {
            this.mRequiredMemoryModelFeatures.reportDataOnHeapRequired(CPrimitive.CPrimitives.INT);
            return this.determineReadProcedureForPrimitive(CPrimitive.CPrimitives.INT);
        }
        throw new UnsupportedOperationException("unsupported type " + String.valueOf(iCType2));
    }

    private String determineReadProcedureForPointer() {
        this.mRequiredMemoryModelFeatures.reportPointerOnHeapRequired();
        return this.mMemoryModel.getReadPointerProcedureName();
    }

    private String determineReadProcedureForPrimitive(CPrimitive.CPrimitives cPrimitives) {
        return this.mMemoryModel.getReadProcedureName(cPrimitives);
    }

    public List<Statement> getWriteCall(ILocation iLocation, HeapLValue heapLValue, Expression expression, ICType iCType, boolean bl) {
        ICType iCType2 = iCType.getUnderlyingType();
        HeapWriteMode heapWriteMode = bl ? HeapWriteMode.STORE_UNCHECKED : HeapWriteMode.STORE_CHECKED;
        List<Statement> list = this.getWriteCall(iLocation, heapLValue, expression, iCType2, heapWriteMode);
        if (iCType.isAtomic()) {
            return List.of(StatementFactory.constructAtomicStatement((ILocation)iLocation, list));
        }
        return list;
    }

    private List<Statement> getWriteCall(ILocation iLocation, HeapLValue heapLValue, Expression expression, ICType iCType, HeapWriteMode heapWriteMode) {
        ICType iCType2;
        ICType iCType3 = iCType2 = iCType.getUnderlyingType();
        Objects.requireNonNull(iCType3);
        ICType iCType4 = iCType3;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CPrimitive.class, CEnum.class, CPointer.class, CStructOrUnion.class, CArray.class, CNamed.class, CFunction.class}, (Object)iCType4, 0)) {
            case 0 -> {
                CPrimitive var8_8 = (CPrimitive)iCType4;
                yield this.getWriteCallPrimitive(iLocation, heapLValue, expression, var8_8, heapWriteMode);
            }
            case 1 -> {
                CEnum var9_9 = (CEnum)iCType4;
                yield this.getWriteCallEnum(iLocation, heapLValue, expression, heapWriteMode);
            }
            case 2 -> {
                CPointer var10_10 = (CPointer)iCType4;
                yield this.getWriteCallPointer(iLocation, heapLValue, expression, heapWriteMode);
            }
            case 3 -> {
                CStructOrUnion var11_11 = (CStructOrUnion)iCType4;
                yield this.getWriteCallStruct(iLocation, heapLValue, expression, var11_11, heapWriteMode);
            }
            case 4 -> {
                CArray var12_12 = (CArray)iCType4;
                yield this.getWriteCallArray(iLocation, heapLValue, expression, var12_12, heapWriteMode);
            }
            case 5 -> {
                CNamed var13_13 = (CNamed)iCType4;
                throw new AssertionError((Object)"getUnderlyingType() must not return CNamed");
            }
            case 6 -> {
                CFunction var14_14 = (CFunction)iCType4;
                throw new UnsupportedSyntaxException(iLocation, "Write calls for function types unsupported: " + String.valueOf(var14_14));
            }
            default -> throw new MatchException(null, null);
        };
    }

    public List<Statement> getInitCall(ILocation iLocation, HeapLValue heapLValue, Expression expression, ICType iCType, IASTNode iASTNode) {
        ICType iCType2 = iCType.getUnderlyingType();
        return this.getWriteCall(iLocation, heapLValue, expression, iCType2, HeapWriteMode.SELECT);
    }

    public static Expression getPointerBaseAddress(Expression expression, ILocation iLocation) {
        if (expression instanceof StructConstructor) {
            return ((StructConstructor)expression).getFieldValues()[0];
        }
        return ExpressionFactory.constructStructAccessExpression((ILocation)iLocation, (Expression)expression, (String)"base");
    }

    public static Expression getPointerOffset(Expression expression, ILocation iLocation) {
        if (expression instanceof StructConstructor) {
            return ((StructConstructor)expression).getFieldValues()[1];
        }
        return ExpressionFactory.constructStructAccessExpression((ILocation)iLocation, (Expression)expression, (String)"offset");
    }

    public static StructConstructor constructPointerFromBaseAndOffset(Expression expression, Expression expression2, ILocation iLocation) {
        return ExpressionFactory.constructStructConstructor((ILocation)iLocation, (String[])new String[]{"base", "offset"}, (Expression[])new Expression[]{expression, expression2});
    }

    public List<Statement> insertMallocs(List<Statement> list) {
        ArrayList<Statement> arrayList3;
        Object object2;
        ArrayList<CallStatement> arrayList2 = new ArrayList<CallStatement>();
        for (Object object2 : this.mVariablesToBeMalloced.currentScopeKeys()) {
            arrayList2.add(this.getUltimateMemAllocCall(((LocalLValueILocationPair)object2).llv, ((LocalLValueILocationPair)object2).loc, MemoryArea.STACK));
        }
        object2 = new ArrayList();
        for (ArrayList<Statement> arrayList3 : this.mVariablesToBeFreed.currentScopeKeys()) {
            object2.add(this.getDeallocCall(((LocalLValueILocationPair)((Object)arrayList3)).llv, ((LocalLValueILocationPair)((Object)arrayList3)).loc));
            object2.add(new HavocStatement(((LocalLValueILocationPair)((Object)arrayList3)).loc, new VariableLHS[]{(VariableLHS)((LocalLValueILocationPair)((Object)arrayList3)).llv.getLhs()}));
        }
        arrayList3 = new ArrayList<Statement>(arrayList2);
        arrayList3.addAll(list);
        arrayList3.addAll((Collection<Statement>)object2);
        return arrayList3;
    }

    public void addVariableToBeMalloced(LocalLValueILocationPair localLValueILocationPair) {
        this.mVariablesToBeMalloced.put((Object)localLValueILocationPair, (Object)this.mVariablesToBeMalloced.getActiveScopeNum());
    }

    public void addVariableToBeFreed(LocalLValueILocationPair localLValueILocationPair) {
        this.mVariablesToBeFreed.put((Object)localLValueILocationPair, (Object)this.mVariablesToBeFreed.getActiveScopeNum());
    }

    public Map<LocalLValueILocationPair, Integer> getVariablesToBeFreed() {
        return Collections.unmodifiableMap(this.mVariablesToBeFreed);
    }

    public IBooleanArrayHelper getBooleanArrayHelper() {
        return this.mBooleanArrayHelper;
    }

    public Expression doPointerArithmetic(int n, ILocation iLocation, Expression expression, RValue rValue, ICType iCType) {
        if (this.mTypeSizes.getSize(((CPrimitive)rValue.getCType().getUnderlyingType()).getType()) != this.mTypeSizes.getSize(this.mExpressionTranslation.getCTypeOfPointerComponents().getType())) {
            throw new UnsupportedOperationException("not yet implemented, conversion is needed");
        }
        Expression expression2 = MemoryHandler.getPointerBaseAddress(expression, iLocation);
        Expression expression3 = MemoryHandler.getPointerOffset(expression, iLocation);
        Expression expression4 = this.multiplyWithSizeOfAnotherType(iLocation, iCType, rValue.getValue(), this.mExpressionTranslation.getCTypeOfPointerComponents());
        Expression expression5 = this.mExpressionTranslation.constructArithmeticExpression(iLocation, n, expression3, this.mExpressionTranslation.getCTypeOfPointerComponents(), expression4, this.mExpressionTranslation.getCTypeOfPointerComponents());
        return MemoryHandler.constructPointerFromBaseAndOffset(expression2, expression5, iLocation);
    }

    public ExpressionResult doPointerArithmeticWithConversion(int n, ILocation iLocation, Expression expression, RValue rValue, ICType iCType) {
        ExpressionResult expressionResult = this.mExpressionTranslation.convertIntToInt(iLocation, new ExpressionResult(rValue), this.mExpressionTranslation.getCTypeOfPointerComponents());
        Expression expression2 = this.doPointerArithmetic(n, iLocation, expression, (RValue)expressionResult.getLrValue(), iCType);
        RValue rValue2 = new RValue(expression2, this.mExpressionTranslation.getCTypeOfPointerComponents());
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue2).build();
    }

    public Expression multiplyWithSizeOfAnotherType(ILocation iLocation, ICType iCType, Expression expression, CPrimitive cPrimitive) {
        return this.mExpressionTranslation.constructArithmeticExpression(iLocation, 1, expression, cPrimitive, this.calculateSizeOf(iLocation, iCType), cPrimitive);
    }

    public void beginScope() {
        this.mVariablesToBeMalloced.beginScope();
        this.mVariablesToBeFreed.beginScope();
    }

    public void endScope() {
        this.mVariablesToBeMalloced.endScope();
        this.mVariablesToBeFreed.endScope();
    }

    public IdentifierExpression getPthreadForkCount(ILocation iLocation) {
        BoogieType boogieType = this.mTypeHandler.getBoogieTypeForCType(this.mTypeHandler.getThreadIdType());
        return ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)boogieType, (String)"#pthreadsForks", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null));
    }

    public Expression constructMutexArrayIdentifierExpression(ILocation iLocation) {
        this.requireMemoryModelFeature(MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX);
        BoogieArrayType boogieArrayType = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)((BoogieType)this.mBooleanArrayHelper.constructBoolReplacementType().getBoogieType()));
        return ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)boogieArrayType, (String)"#pthreadsMutex", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null));
    }

    public AssignmentStatement constructMutexArrayAssignment(ILocation iLocation, Expression expression, boolean bl) {
        BoogieArrayType boogieArrayType = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)((BoogieType)this.getBooleanArrayHelper().constructBoolReplacementType().getBoogieType()));
        return MemoryHandler.constructOneDimensionalArrayUpdate(iLocation, expression, new VariableLHS(iLocation, (IBoogieType)boogieArrayType, "#pthreadsMutex", new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null)), this.getBooleanArrayHelper().constructValue(bl));
    }

    public Expression constructRwLockArrayIdentifierExpression(ILocation iLocation) {
        this.requireMemoryModelFeature(MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK);
        BoogieArrayType boogieArrayType = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(MemoryHandler.getRwLockCounterType()));
        return ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)boogieArrayType, (String)"#pthreadsRwLock", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null));
    }

    public void requireMemoryModelFeature(MemoryModelDeclarations memoryModelDeclarations) {
        this.mRequiredMemoryModelFeatures.require(memoryModelDeclarations);
        MemoryModelDeclarationInfo memoryModelDeclarationInfo = this.mMemoryModelDeclarationInfos.get((Object)memoryModelDeclarations);
        if (memoryModelDeclarationInfo == null) {
            memoryModelDeclarationInfo = this.constructMemoryModelDeclarationInfo(memoryModelDeclarations);
            this.mMemoryModelDeclarationInfos.put(memoryModelDeclarations, memoryModelDeclarationInfo);
        }
    }

    public boolean isNullPointerLiteral(Expression expression) {
        Object object;
        Expression[] expressionArray;
        if (expression instanceof StructConstructor && (expressionArray = (object = (StructConstructor)expression).getFieldValues()).length == 2) {
            BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(expressionArray[0], new CPrimitive(CPrimitive.CPrimitives.LONG));
            BigInteger bigInteger2 = this.mTypeSizes.extractIntegerValue(expressionArray[1], new CPrimitive(CPrimitive.CPrimitives.LONG));
            if (BigInteger.ZERO.equals(bigInteger) && BigInteger.ZERO.equals(bigInteger2)) {
                return true;
            }
        }
        return BigInteger.ZERO.equals(object = this.mTypeSizes.extractIntegerValue(expression, new CPrimitive(CPrimitive.CPrimitives.LONG)));
    }

    private MemoryModelDeclarationInfo getMemoryModelDeclarationInfo(MemoryModelDeclarations memoryModelDeclarations) {
        MemoryModelDeclarationInfo memoryModelDeclarationInfo = this.mMemoryModelDeclarationInfos.get((Object)memoryModelDeclarations);
        if (memoryModelDeclarationInfo == null) {
            throw new AssertionError((Object)"call  requireMemoryModelFeature first!");
        }
        return memoryModelDeclarationInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BaseMemoryModel getMemoryModel(boolean bl, CACSLPreferenceInitializer.MemoryModel memoryModel) throws AssertionError {
        if (bl) {
            switch (memoryModel) {
                case HoenickeLindenmann_1ByteResolution: 
                case HoenickeLindenmann_2ByteResolution: 
                case HoenickeLindenmann_4ByteResolution: 
                case HoenickeLindenmann_8ByteResolution: {
                    BaseMemoryModel baseMemoryModel = new MemoryModel_SingleBitprecise(memoryModel.getByteSize(), this.mTypeSizes, (TypeHandler)this.mTypeHandler, this.mExpressionTranslation);
                    return baseMemoryModel;
                }
                case HoenickeLindenmann_Original: {
                    BaseMemoryModel baseMemoryModel = new MemoryModel_MultiBitprecise(this.mTypeSizes, this.mTypeHandler, this.mExpressionTranslation);
                    return baseMemoryModel;
                }
                default: {
                    throw new MatchException(null, null);
                }
            }
        }
        switch (memoryModel) {
            case HoenickeLindenmann_Original: {
                return new MemoryModel_Unbounded(this.mTypeSizes, this.mTypeHandler, this.mExpressionTranslation);
            }
            case HoenickeLindenmann_1ByteResolution: 
            case HoenickeLindenmann_2ByteResolution: 
            case HoenickeLindenmann_4ByteResolution: 
            case HoenickeLindenmann_8ByteResolution: {
                throw new UnsupportedOperationException("Memory model " + String.valueOf((Object)memoryModel) + " only available in bitprecise translation");
            }
            default: {
                throw new MatchException(null, null);
            }
        }
    }

    private static boolean assertContainsNodeProcedureDeclarations(Collection<Declaration> collection) {
        for (Declaration declaration : collection) {
            if (!(declaration instanceof Procedure) || ((Procedure)declaration).getBody() != null) continue;
            assert (false) : "found a procedure declaration";
            return false;
        }
        return true;
    }

    private VariableDeclaration constuctLengthArrayDeclaration() {
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        ASTType aSTType = this.mTypeHandler.cType2AstType(cACSLLocation, this.mExpressionTranslation.getCTypeOfPointerComponents());
        BoogieArrayType boogieArrayType = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{(BoogieType)aSTType.getBoogieType()}, (BoogieType)((BoogieType)aSTType.getBoogieType()));
        ArrayType arrayType = new ArrayType((ILocation)cACSLLocation, (IBoogieType)boogieArrayType, new String[0], new ASTType[]{aSTType}, aSTType);
        VarList varList = new VarList((ILocation)cACSLLocation, new String[]{"#length"}, (ASTType)arrayType);
        return new VariableDeclaration((ILocation)cACSLLocation, new Attribute[0], new VarList[]{varList});
    }

    private VariableDeclaration constructValidArrayDeclaration() {
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        ASTType aSTType = this.mTypeHandler.cType2AstType(cACSLLocation, this.mExpressionTranslation.getCTypeOfPointerComponents());
        BoogieArrayType boogieArrayType = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{(BoogieType)aSTType.getBoogieType()}, (BoogieType)((BoogieType)this.mBooleanArrayHelper.constructBoolReplacementType().getBoogieType()));
        ArrayType arrayType = new ArrayType((ILocation)cACSLLocation, (IBoogieType)boogieArrayType, new String[0], new ASTType[]{aSTType}, this.mBooleanArrayHelper.constructBoolReplacementType());
        VarList varList = new VarList((ILocation)cACSLLocation, new String[]{MemoryModelDeclarations.ULTIMATE_VALID.getName()}, (ASTType)arrayType);
        return new VariableDeclaration((ILocation)cACSLLocation, new Attribute[0], new VarList[]{varList});
    }

    private VariableDeclaration constructStackHeapBarrierConstant() {
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        return new VariableDeclaration((ILocation)cACSLLocation, new Attribute[0], new VarList[]{new VarList((ILocation)cACSLLocation, new String[]{MemoryModelDeclarations.ULTIMATE_STACK_HEAP_BARRIER.getName()}, this.mTypeHandler.cType2AstType(cACSLLocation, this.mExpressionTranslation.getCTypeOfPointerComponents()))});
    }

    private List<Declaration> declareUltimateMeminit(CHandler cHandler, Collection<HeapDataArray> collection) {
        Object object;
        CPrimitive cPrimitive;
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        String string = MemoryModelDeclarations.ULTIMATE_MEMINIT.getName();
        VarList varList = new VarList((ILocation)cACSLLocation, new String[]{"#ptr"}, this.mTypeHandler.constructPointerType(cACSLLocation));
        VarList varList2 = new VarList((ILocation)cACSLLocation, new String[]{"#amountOfFields"}, this.mTypeHandler.cType2AstType(cACSLLocation, this.mTypeSizeAndOffsetComputer.getSizeT()));
        VarList varList3 = new VarList((ILocation)cACSLLocation, new String[]{"#sizeOfFields"}, this.mTypeHandler.cType2AstType(cACSLLocation, this.mTypeSizeAndOffsetComputer.getSizeT()));
        VarList varList4 = new VarList((ILocation)cACSLLocation, new String[]{"#product"}, this.mTypeHandler.cType2AstType(cACSLLocation, this.mTypeSizeAndOffsetComputer.getSizeT()));
        VarList[] varListArray = new VarList[]{varList, varList2, varList3, varList4};
        VarList[] varListArray2 = new VarList[]{};
        Procedure procedure = new Procedure((ILocation)cACSLLocation, new Attribute[0], string, new String[0], varListArray, varListArray2, new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(cHandler, cACSLLocation, string, procedure);
        ArrayList<VariableDeclaration> arrayList2 = new ArrayList<VariableDeclaration>();
        ArrayList<Statement> arrayList3 = new ArrayList<Statement>();
        if (this.mSettings.useConstantArrays()) {
            cPrimitive = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)"#ptr", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string));
            object = LRValueFactory.constructHeapLValue(this.mTypeHandler, (Expression)cPrimitive, CPointer.voidPointer(), null);
            Set<ICType> set = this.mRequiredMemoryModelFeatures.getDataOnHeapRequired().stream().map(CPrimitive::new).collect(Collectors.toSet());
            arrayList3.addAll(this.getInitializationForHeapAtPointer(cACSLLocation, (HeapLValue)object, set));
        } else {
            IdentifierExpression identifierExpression;
            cPrimitive = this.mTypeSizeAndOffsetComputer.getSizeT();
            object = this.mAuxVarInfoBuilder.constructAuxVarInfo((ILocation)cACSLLocation, cPrimitive, SFO.AUXVAR.LOOPCTR);
            arrayList2.add(((AuxVarInfo)object).getVarDec());
            Expression expression = this.mTypeSizes.constructLiteralForIntegerType(cACSLLocation, new CPrimitive(CPrimitive.CPrimitives.UCHAR), BigInteger.ZERO);
            ArrayList<Statement> arrayList4 = this.constructMemsetLoopBody(collection, (AuxVarInfo)object, "#ptr", expression, string);
            IdentifierExpression identifierExpression2 = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForSizeT(), (String)"#product", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string));
            if (this.mMemoryModel instanceof MemoryModel_SingleBitprecise) {
                int n = ((MemoryModel_SingleBitprecise)this.mMemoryModel).getResolution();
                identifierExpression = this.mTypeSizes.constructLiteralForIntegerType(cACSLLocation, cPrimitive, BigInteger.valueOf(n));
            } else {
                IdentifierExpression identifierExpression3;
                identifierExpression = identifierExpression3 = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)BoogieType.TYPE_INT, (String)"#sizeOfFields", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string));
            }
            arrayList3.addAll(this.constructCountingLoop(this.constructBoundExitCondition((Expression)identifierExpression2, (AuxVarInfo)object), (AuxVarInfo)object, (Expression)identifierExpression, arrayList4));
        }
        cPrimitive = this.mProcedureManager.constructBody(cACSLLocation, arrayList2.toArray(new VariableDeclaration[arrayList2.size()]), arrayList3.toArray(new Statement[arrayList3.size()]), string);
        object = new Procedure((ILocation)cACSLLocation, new Attribute[0], string, new String[0], varListArray, varListArray2, null, (Body)cPrimitive);
        arrayList.add((Declaration)object);
        this.mProcedureManager.endCustomProcedure(cHandler, string);
        return arrayList;
    }

    public Expression constructBoundExitCondition(Expression expression, AuxVarInfo auxVarInfo) {
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        return this.mExpressionTranslation.constructBinaryComparisonExpression(cACSLLocation, 8, (Expression)auxVarInfo.getExp(), this.mTypeSizeAndOffsetComputer.getSizeT(), expression, this.mTypeSizeAndOffsetComputer.getSizeT());
    }

    private List<Declaration> declareStrCpy(CHandler cHandler, Collection<HeapDataArray> collection) {
        MemoryModelDeclarations memoryModelDeclarations = MemoryModelDeclarations.C_STRCPY;
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        VarList varList = new VarList((ILocation)cACSLLocation, new String[]{"dest"}, this.mTypeHandler.constructPointerType(cACSLLocation));
        VarList varList2 = new VarList((ILocation)cACSLLocation, new String[]{"src"}, this.mTypeHandler.constructPointerType(cACSLLocation));
        VarList varList3 = new VarList((ILocation)cACSLLocation, new String[]{"#res"}, this.mTypeHandler.constructPointerType(cACSLLocation));
        VarList[] varListArray = new VarList[]{varList, varList2};
        VarList[] varListArray2 = new VarList[]{varList3};
        Object object = new Procedure((ILocation)cACSLLocation, new Attribute[0], memoryModelDeclarations.getName(), new String[0], varListArray, varListArray2, new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(cHandler, cACSLLocation, memoryModelDeclarations.getName(), (Procedure)object);
        object = new ArrayList();
        CPrimitive cPrimitive = this.mTypeSizeAndOffsetComputer.getSizeT();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo((ILocation)cACSLLocation, cPrimitive, SFO.AUXVAR.OFFSET);
        object.add(auxVarInfo.getVarDec());
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)"src", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, memoryModelDeclarations.getName()));
        IdentifierExpression identifierExpression2 = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)"dest", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, memoryModelDeclarations.getName()));
        ArrayList<Statement> arrayList2 = new ArrayList<Statement>();
        Expression expression = this.doPointerArithmetic(4, cACSLLocation, (Expression)identifierExpression, new RValue((Expression)auxVarInfo.getExp(), this.mExpressionTranslation.getCTypeOfPointerComponents()), new CPrimitive(CPrimitive.CPrimitives.CHAR));
        Expression expression2 = this.doPointerArithmetic(4, cACSLLocation, (Expression)identifierExpression2, new RValue((Expression)auxVarInfo.getExp(), this.mExpressionTranslation.getCTypeOfPointerComponents()), new CPrimitive(CPrimitive.CPrimitives.CHAR));
        Object object2 = this.constructMemsafetyChecksForPointerExpression(cACSLLocation, expression);
        arrayList2.addAll((Collection<Statement>)object2);
        Expression expression3 = this.constructMemsafetyChecksForPointerExpression(cACSLLocation, expression2);
        arrayList2.addAll((Collection<Statement>)expression3);
        expression3 = this.getReadCall(expression, new CPrimitive(CPrimitive.CPrimitives.CHAR));
        object2 = expression3.getLrValue().getValue();
        arrayList2.addAll(expression3.getStatements());
        object.addAll(expression3.getDeclarations());
        assert (expression3.getOverapprs().isEmpty());
        expression3 = this.getWriteCall((ILocation)cACSLLocation, LRValueFactory.constructHeapLValue(this.mTypeHandler, expression2, new CPrimitive(CPrimitive.CPrimitives.CHAR), null), (Expression)object2, (ICType)new CPrimitive(CPrimitive.CPrimitives.CHAR), true);
        arrayList2.addAll((Collection<Statement>)expression3);
        expression3 = this.mTypeSizes.constructLiteralForIntegerType(cACSLLocation, new CPrimitive(CPrimitive.CPrimitives.CHAR), BigInteger.ZERO);
        Object object3 = this.mExpressionTranslation.constructBinaryComparisonExpression(cACSLLocation, 28, (Expression)object2, new CPrimitive(CPrimitive.CPrimitives.CHAR), expression3, new CPrimitive(CPrimitive.CPrimitives.CHAR));
        IfStatement ifStatement = new IfStatement((ILocation)cACSLLocation, (Expression)object3, new Statement[]{new BreakStatement((ILocation)cACSLLocation)}, new Statement[0]);
        arrayList2.add((Statement)ifStatement);
        expression = ExpressionFactory.createBooleanLiteral((ILocation)cACSLLocation, (boolean)true);
        expression2 = this.mTypeSizes.constructLiteralForIntegerType(cACSLLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ONE);
        object2 = this.constructCountingLoop(expression, auxVarInfo, expression2, arrayList2);
        expression3 = this.mProcedureManager.constructBody(cACSLLocation, object.toArray(new VariableDeclaration[object.size()]), object2.toArray(new Statement[object2.size()]), memoryModelDeclarations.getName());
        object3 = new ArrayList();
        ifStatement = this.mProcedureManager.constructEnsuresSpecification(cACSLLocation, true, ExpressionFactory.newBinaryExpression((ILocation)cACSLLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)"#res", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, memoryModelDeclarations.getName())), (Expression)ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)"dest", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, memoryModelDeclarations.getName()))), Collections.emptySet());
        ((ArrayList)object3).add(ifStatement);
        this.mProcedureManager.addSpecificationsToCurrentProcedure((List<Specification>)object3);
        Procedure procedure = new Procedure((ILocation)cACSLLocation, new Attribute[0], memoryModelDeclarations.getName(), new String[0], varListArray, varListArray2, null, (Body)expression3);
        arrayList.add((Declaration)procedure);
        this.mProcedureManager.endCustomProcedure(cHandler, memoryModelDeclarations.getName());
        return arrayList;
    }

    public List<Statement> constructCountingLoop(Expression expression, AuxVarInfo auxVarInfo, Expression expression2, List<Statement> list) {
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        Expression expression3 = this.mTypeSizes.constructLiteralForIntegerType(cACSLLocation, this.mTypeSizeAndOffsetComputer.getSizeT(), BigInteger.ZERO);
        arrayList.add((Statement)StatementFactory.constructAssignmentStatement((ILocation)cACSLLocation, (LeftHandSide[])new LeftHandSide[]{auxVarInfo.getLhs()}, (Expression[])new Expression[]{expression3}));
        ArrayList<Statement> arrayList2 = new ArrayList<Statement>(list);
        VariableLHS variableLHS = auxVarInfo.getLhs();
        Expression expression4 = this.mExpressionTranslation.constructArithmeticExpression(cACSLLocation, 4, (Expression)auxVarInfo.getExp(), this.mExpressionTranslation.getCTypeOfPointerComponents(), expression2, this.mExpressionTranslation.getCTypeOfPointerComponents());
        arrayList2.add((Statement)StatementFactory.constructAssignmentStatement((ILocation)cACSLLocation, (LeftHandSide[])new LeftHandSide[]{variableLHS}, (Expression[])new Expression[]{expression4}));
        Statement[] statementArray = arrayList2.toArray(new Statement[arrayList2.size()]);
        WhileStatement whileStatement = new WhileStatement((ILocation)cACSLLocation, expression, new LoopInvariantSpecification[0], statementArray);
        arrayList.add((Statement)whileStatement);
        return arrayList;
    }

    private ArrayList<Statement> constructMemsetLoopBody(Collection<HeapDataArray> collection, AuxVarInfo auxVarInfo, String string, Expression expression, String string2) {
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)string, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string2));
        Expression expression2 = this.doPointerArithmetic(4, cACSLLocation, (Expression)identifierExpression, new RValue((Expression)auxVarInfo.getExp(), this.mExpressionTranslation.getCTypeOfPointerComponents()), new CPrimitive(CPrimitive.CPrimitives.VOID));
        for (HeapDataArray heapDataArray : collection) {
            Expression expression3;
            CPrimitive.CPrimitives cPrimitives;
            ExpressionResult expressionResult = new ExpressionResult(new RValue(expression, new CPrimitive(CPrimitive.CPrimitives.UCHAR)));
            if (heapDataArray.getName().equals("$Pointer$")) {
                expressionResult = this.mExpressionTranslation.convertIntToInt(cACSLLocation, expressionResult, this.mExpressionTranslation.getCTypeOfPointerComponents());
                cPrimitives = this.mTypeSizes.constructLiteralForIntegerType(cACSLLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ZERO);
                expression3 = MemoryHandler.constructPointerFromBaseAndOffset((Expression)cPrimitives, expressionResult.getLrValue().getValue(), cACSLLocation);
            } else if (heapDataArray.getName().equals("real")) {
                cPrimitives = this.getFloatingCprimitiveThatFitsBest(heapDataArray.getSize());
                expressionResult = this.mExpressionTranslation.convertIntToFloat(cACSLLocation, expressionResult, new CPrimitive(cPrimitives));
                expression3 = expressionResult.getLrValue().getValue();
            } else {
                cPrimitives = this.getCprimitiveThatFitsBest(heapDataArray.getSize());
                expressionResult = this.mExpressionTranslation.convertIntToInt(cACSLLocation, expressionResult, new CPrimitive(cPrimitives));
                expression3 = expressionResult.getLrValue().getValue();
            }
            cPrimitives = ExpressionFactory.constructNestedArrayLHS((ILocation)cACSLLocation, (LeftHandSide)heapDataArray.getVariableLHS(), (Expression[])new Expression[]{expression2});
            arrayList.add((Statement)StatementFactory.constructAssignmentStatement((ILocation)cACSLLocation, (LeftHandSide[])new LeftHandSide[]{cPrimitives}, (Expression[])new Expression[]{expression3}));
        }
        return arrayList;
    }

    private CPrimitive.CPrimitives getCprimitiveThatFitsBest(int n) {
        if (n == 0) {
            return CPrimitive.CPrimitives.UCHAR;
        }
        CPrimitive.CPrimitives[] cPrimitivesArray = new CPrimitive.CPrimitives[]{CPrimitive.CPrimitives.UCHAR, CPrimitive.CPrimitives.USHORT, CPrimitive.CPrimitives.UINT, CPrimitive.CPrimitives.ULONG, CPrimitive.CPrimitives.ULONGLONG, CPrimitive.CPrimitives.UINT128};
        int n2 = cPrimitivesArray.length;
        int n3 = 0;
        while (n3 < n2) {
            CPrimitive.CPrimitives cPrimitives = cPrimitivesArray[n3];
            if (this.mTypeSizes.getSize(cPrimitives) == n) {
                return cPrimitives;
            }
            ++n3;
        }
        throw new AssertionError((Object)"don't know how to store value on heap");
    }

    private CPrimitive.CPrimitives getFloatingCprimitiveThatFitsBest(int n) {
        if (n == 0) {
            return CPrimitive.CPrimitives.FLOAT;
        }
        CPrimitive.CPrimitives[] cPrimitivesArray = new CPrimitive.CPrimitives[]{CPrimitive.CPrimitives.FLOAT, CPrimitive.CPrimitives.DOUBLE, CPrimitive.CPrimitives.LONGDOUBLE};
        int n2 = cPrimitivesArray.length;
        int n3 = 0;
        while (n3 < n2) {
            CPrimitive.CPrimitives cPrimitives = cPrimitivesArray[n3];
            if (this.mTypeSizes.getSize(cPrimitives) == n) {
                return cPrimitives;
            }
            ++n3;
        }
        throw new AssertionError((Object)"don't know how to store value on heap");
    }

    private List<Declaration> declareMemset(CHandler cHandler, Collection<HeapDataArray> collection) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        String string = MemoryModelDeclarations.C_MEMSET.getName();
        VarList varList = new VarList((ILocation)cACSLLocation, new String[]{"#ptr"}, this.mTypeHandler.constructPointerType(cACSLLocation));
        VarList varList2 = new VarList((ILocation)cACSLLocation, new String[]{"#value"}, this.mTypeHandler.cType2AstType(cACSLLocation, new CPrimitive(CPrimitive.CPrimitives.INT)));
        VarList varList3 = new VarList((ILocation)cACSLLocation, new String[]{"#amount"}, this.mTypeHandler.cType2AstType(cACSLLocation, this.mTypeSizeAndOffsetComputer.getSizeT()));
        VarList varList4 = new VarList((ILocation)cACSLLocation, new String[]{"#res"}, this.mTypeHandler.constructPointerType(cACSLLocation));
        VarList[] varListArray = new VarList[]{varList, varList2, varList3};
        VarList[] varListArray2 = new VarList[]{varList4};
        Object object = new Procedure((ILocation)cACSLLocation, new Attribute[0], string, new String[0], varListArray, varListArray2, new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(cHandler, cACSLLocation, string, (Procedure)object);
        object = new ArrayList();
        CPrimitive cPrimitive = this.mTypeSizeAndOffsetComputer.getSizeT();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo((ILocation)cACSLLocation, cPrimitive, SFO.AUXVAR.LOOPCTR);
        object.add(auxVarInfo.getVarDec());
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)((BoogieType)this.mTypeHandler.cType2AstType(cACSLLocation, new CPrimitive(CPrimitive.CPrimitives.INT)).getBoogieType()), (String)"#value", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string));
        ExpressionResult expressionResult = new ExpressionResult(new RValue((Expression)identifierExpression, new CPrimitive(CPrimitive.CPrimitives.INT)));
        ExpressionResult expressionResult2 = this.mExpressionTranslation.convertIntToInt(cACSLLocation, expressionResult, new CPrimitive(CPrimitive.CPrimitives.UCHAR));
        Expression expression = expressionResult2.getLrValue().getValue();
        ArrayList<Statement> arrayList2 = this.constructMemsetLoopBody(collection, auxVarInfo, "#ptr", expression, string);
        Expression expression2 = this.mTypeSizes.constructLiteralForIntegerType(cACSLLocation, this.mTypeSizeAndOffsetComputer.getSizeT(), BigInteger.ONE);
        IdentifierExpression identifierExpression2 = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForSizeT(), (String)"#amount", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string));
        List<Statement> list = this.constructCountingLoop(this.constructBoundExitCondition((Expression)identifierExpression2, auxVarInfo), auxVarInfo, expression2, arrayList2);
        Body body = this.mProcedureManager.constructBody(cACSLLocation, object.toArray(new VariableDeclaration[object.size()]), list.toArray(new Statement[list.size()]), string);
        ArrayList<Specification> arrayList3 = new ArrayList<Specification>(this.constructPointerBaseValidityCheck(cACSLLocation, "#ptr", string));
        IdentifierExpression identifierExpression3 = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForSizeT(), (String)"#amount", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
        arrayList3.addAll(this.constructPointerTargetFullyAllocatedCheck(cACSLLocation, (Expression)identifierExpression3, "#ptr", string));
        EnsuresSpecification ensuresSpecification = this.mProcedureManager.constructEnsuresSpecification(cACSLLocation, true, ExpressionFactory.newBinaryExpression((ILocation)cACSLLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)"#res", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, string)), (Expression)ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)"#ptr", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string))), Collections.emptySet());
        arrayList3.add((Specification)ensuresSpecification);
        this.mProcedureManager.addSpecificationsToCurrentProcedure(arrayList3);
        Procedure procedure = new Procedure((ILocation)cACSLLocation, new Attribute[0], string, new String[0], varListArray, varListArray2, null, body);
        arrayList.add((Declaration)procedure);
        this.mProcedureManager.endCustomProcedure(cHandler, string);
        return arrayList;
    }

    private VariableDeclaration constructMemoryArrayDeclaration(ILocation iLocation, String string, ASTType aSTType) {
        String string2 = "#memory_" + string;
        return this.constructDeclOfPointerIndexedArray(iLocation, aSTType, string2);
    }

    private VariableDeclaration constructDeclOfPointerIndexedArray(ILocation iLocation, ASTType aSTType, String string) {
        BoogieArrayType boogieArrayType = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)((BoogieType)aSTType.getBoogieType()));
        ArrayType arrayType = new ArrayType(iLocation, (IBoogieType)boogieArrayType, new String[0], new ASTType[]{this.mTypeHandler.constructPointerType(iLocation)}, aSTType);
        VarList varList = new VarList(iLocation, new String[]{string}, (ASTType)arrayType);
        return new VariableDeclaration(iLocation, new Attribute[0], new VarList[]{varList});
    }

    private List<Declaration> constructWriteProcedures(CHandler cHandler, ILocation iLocation, Collection<HeapDataArray> collection, HeapDataArray heapDataArray) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        for (BaseMemoryModel.ReadWriteDefinition readWriteDefinition : this.mMemoryModel.getReadWriteDefinitionForHeapDataArray(heapDataArray, this.mRequiredMemoryModelFeatures)) {
            Collection<Procedure> collection2 = this.constructWriteProcedure(cHandler, iLocation, collection, heapDataArray, readWriteDefinition);
            arrayList.addAll(collection2);
        }
        return arrayList;
    }

    private List<Declaration> constructReadProcedures(CHandler cHandler, ILocation iLocation, HeapDataArray heapDataArray) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        for (BaseMemoryModel.ReadWriteDefinition readWriteDefinition : this.mMemoryModel.getReadWriteDefinitionForHeapDataArray(heapDataArray, this.mRequiredMemoryModelFeatures)) {
            arrayList.addAll(this.constructSingleReadProcedure(cHandler, iLocation, heapDataArray, readWriteDefinition));
        }
        return arrayList;
    }

    private VariableDeclaration declarePthreadsForkCount(ILocation iLocation) {
        ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, this.mTypeHandler.getThreadIdType());
        VarList varList = new VarList(iLocation, new String[]{"#pthreadsForks"}, aSTType);
        return new VariableDeclaration(iLocation, new Attribute[0], new VarList[]{varList});
    }

    private VariableDeclaration declarePThreadsMutexArray(ILocation iLocation) {
        return this.constructDeclOfPointerIndexedArray(iLocation, this.mBooleanArrayHelper.constructBoolReplacementType(), "#pthreadsMutex");
    }

    private static CPrimitive getRwLockCounterType() {
        return new CPrimitive(CPrimitive.CPrimitives.SCHAR);
    }

    private VariableDeclaration declarePthreadRwLock(ILocation iLocation) {
        return this.constructDeclOfPointerIndexedArray(iLocation, this.mTypeHandler.cType2AstType(iLocation, MemoryHandler.getRwLockCounterType()), "#pthreadsRwLock");
    }

    private Collection<Procedure> constructWriteProcedure(CHandler cHandler, ILocation iLocation, Collection<HeapDataArray> collection, HeapDataArray heapDataArray, BaseMemoryModel.ReadWriteDefinition readWriteDefinition) {
        if (readWriteDefinition.alsoUncheckedWrite()) {
            this.constructSingleWriteProcedure(cHandler, iLocation, collection, heapDataArray, readWriteDefinition, HeapWriteMode.STORE_UNCHECKED);
        }
        if (readWriteDefinition.alsoInit()) {
            this.constructSingleWriteProcedure(cHandler, iLocation, collection, heapDataArray, readWriteDefinition, HeapWriteMode.SELECT);
        }
        this.constructSingleWriteProcedure(cHandler, iLocation, collection, heapDataArray, readWriteDefinition, HeapWriteMode.STORE_CHECKED);
        return Collections.emptySet();
    }

    private void constructSingleWriteProcedure(CHandler cHandler, ILocation iLocation, Collection<HeapDataArray> collection, HeapDataArray heapDataArray, BaseMemoryModel.ReadWriteDefinition readWriteDefinition, HeapWriteMode heapWriteMode) {
        UnaryOperator unaryOperator;
        BigInteger bigInteger;
        Object object;
        Object object2;
        Object object3;
        CPrimitive.CPrimitives cPrimitives;
        ASTType aSTType = readWriteDefinition.getASTType();
        String string = switch (heapWriteMode) {
            case HeapWriteMode.SELECT -> readWriteDefinition.getInitWriteProcedureName();
            case HeapWriteMode.STORE_CHECKED -> readWriteDefinition.getWriteProcedureName();
            case HeapWriteMode.STORE_UNCHECKED -> readWriteDefinition.getUncheckedWriteProcedureName();
            default -> throw new MatchException(null, null);
        };
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)"#ptr", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
        ASTType aSTType2 = this.mTypeHandler.cType2AstType(iLocation, this.mTypeSizeAndOffsetComputer.getSizeT());
        VarList[] varListArray = new VarList[]{new VarList(iLocation, new String[]{"#value"}, aSTType), new VarList(iLocation, new String[]{"#ptr"}, this.mTypeHandler.constructPointerType(iLocation)), new VarList(iLocation, new String[]{"#sizeOfWrittenType"}, aSTType2)};
        Procedure procedure = new Procedure(iLocation, new Attribute[0], string, new String[0], varListArray, new VarList[0], new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(cHandler, iLocation, string, procedure);
        ArrayList<Specification> arrayList = new ArrayList<Specification>();
        if (heapWriteMode == HeapWriteMode.STORE_CHECKED) {
            arrayList.addAll(this.constructPointerBaseValidityCheck(iLocation, "#ptr", string));
            IdentifierExpression identifierExpression2 = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForPointerComponents(), (String)"#sizeOfWrittenType", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
            arrayList.addAll(this.constructPointerTargetFullyAllocatedCheck(iLocation, (Expression)identifierExpression2, "#ptr", string));
        }
        boolean bl = this.mMemoryModel instanceof MemoryModel_SingleBitprecise && readWriteDefinition.getRepresentativeType().isFloatingType();
        IdentifierExpression identifierExpression3 = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType), (String)"#value", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
        if (bl) {
            cPrimitives = ((CPrimitive)readWriteDefinition.getRepresentativeType()).getType();
            object3 = this.mSettings.useFpToIeeeBvExtension() ? this.mExpressionTranslation.transformFloatToBitvector(iLocation, (Expression)identifierExpression3, cPrimitives) : ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType), (String)"#valueAsBitvector", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null));
        } else {
            cPrimitives = null;
            object3 = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType), (String)"#value", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
        }
        boolean bl2 = heapWriteMode == HeapWriteMode.SELECT;
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        ArrayList<Expression> arrayList3 = new ArrayList<Expression>();
        if (readWriteDefinition.getBytesize() == heapDataArray.getSize()) {
            arrayList2.add((Expression)identifierExpression);
            arrayList3.add((Expression)object3);
        } else if (readWriteDefinition.getBytesize() < heapDataArray.getSize()) {
            object2 = expression -> this.mExpressionTranslation.signExtend(iLocation, (Expression)expression, readWriteDefinition.getBytesize() * 8, heapDataArray.getSize() * 8);
            arrayList2.add((Expression)identifierExpression);
            arrayList3.add((Expression)object2.apply(object3));
        } else {
            assert (readWriteDefinition.getBytesize() % heapDataArray.getSize() == 0) : "incompatible sizes";
            int n = 0;
            while (n < readWriteDefinition.getBytesize() / heapDataArray.getSize()) {
                int n2 = n;
                object = expression -> this.mExpressionTranslation.extractBits(iLocation, (Expression)expression, heapDataArray.getSize() * (n2 + 1) * 8, heapDataArray.getSize() * n2 * 8);
                if (n == 0) {
                    arrayList2.add((Expression)identifierExpression);
                    arrayList3.add((Expression)object.apply(object3));
                } else {
                    bigInteger = BigInteger.valueOf(n * heapDataArray.getSize());
                    unaryOperator = expression -> this.addIntegerConstantToPointer(iLocation, (Expression)expression, bigInteger);
                    arrayList2.add((Expression)unaryOperator.apply(identifierExpression));
                    arrayList3.add((Expression)object.apply(object3));
                }
                ++n;
            }
        }
        object2 = new ArrayList<Expression>(MemoryHandler.constructConjunctsForWriteEnsuresSpecification(iLocation, collection, heapDataArray, arrayList3, arrayList2, bl2));
        Object object4 = object = bl2 ? Collections.emptySet() : collection.stream().map(HeapDataArray::getVariableLHS).collect(Collectors.toSet());
        if (bl && !this.mSettings.useFpToIeeeBvExtension()) {
            IdentifierExpression identifierExpression4 = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType), (String)"#valueAsBitvector", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null));
            bigInteger = this.mExpressionTranslation.transformBitvectorToFloat(iLocation, (Expression)identifierExpression4, cPrimitives);
            unaryOperator = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)((BoogieType)bigInteger.getType()), (String)"#value", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
            Expression expression2 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)bigInteger, (Expression)unaryOperator);
            object2.add(expression2);
            Expression expression3 = ExpressionFactory.and((ILocation)iLocation, (List)object2);
            ASTType aSTType3 = ((TypeHandler)this.mTypeHandler).byteSize2AstType(iLocation, cPrimitives.getPrimitiveCategory(), this.mTypeSizes.getSize(cPrimitives));
            VarList[] varListArray2 = new VarList[]{new VarList(iLocation, new String[]{"#valueAsBitvector"}, aSTType3)};
            QuantifierExpression quantifierExpression = new QuantifierExpression(iLocation, false, new String[0], varListArray2, new Attribute[0], expression3);
            arrayList.add((Specification)this.mProcedureManager.constructEnsuresSpecification(iLocation, false, (Expression)quantifierExpression, (Set<VariableLHS>)object));
        } else {
            arrayList.add((Specification)this.mProcedureManager.constructEnsuresSpecification(iLocation, false, ExpressionFactory.and((ILocation)iLocation, (List)object2), (Set<VariableLHS>)object));
        }
        this.mProcedureManager.addSpecificationsToCurrentProcedure(arrayList);
        this.mProcedureManager.endCustomProcedure(cHandler, string);
    }

    private static List<Expression> constructConjunctsForWriteEnsuresSpecification(ILocation iLocation, Collection<HeapDataArray> collection, HeapDataArray heapDataArray, List<Expression> list, List<Expression> list2, boolean bl) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (HeapDataArray heapDataArray2 : collection) {
            if (heapDataArray == heapDataArray2) {
                arrayList.add(MemoryHandler.constructHeapArrayUpdateForWriteEnsures(iLocation, list, list2, heapDataArray2, bl));
                continue;
            }
            if (bl) continue;
            arrayList.add(MemoryHandler.constructHeapArrayHardlyModifiedForWriteEnsures(iLocation, list2, heapDataArray2));
        }
        return arrayList;
    }

    private List<Procedure> constructSingleReadProcedure(CHandler cHandler, ILocation iLocation, HeapDataArray heapDataArray, BaseMemoryModel.ReadWriteDefinition readWriteDefinition) {
        ASTType aSTType = readWriteDefinition.getASTType();
        String string = readWriteDefinition.getReadProcedureName();
        Object object = this.mTypeHandler.cType2AstType(iLocation, this.mTypeSizeAndOffsetComputer.getSizeT());
        IdentifierExpression identifierExpression = new IdentifierExpression[]{new VarList(iLocation, new String[]{"#ptr"}, this.mTypeHandler.constructPointerType(iLocation)), new VarList(iLocation, new String[]{"#sizeOfReadType"}, (ASTType)object)};
        IdentifierExpression identifierExpression2 = new IdentifierExpression[]{new VarList(iLocation, new String[]{"#value"}, aSTType)};
        Procedure procedure = new Procedure(iLocation, new Attribute[0], string, new String[0], (VarList[])identifierExpression, (VarList[])identifierExpression2, new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(cHandler, iLocation, string, procedure);
        object = new ArrayList<Specification>(this.constructPointerBaseValidityCheck(iLocation, "#ptr", string));
        identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForPointerComponents(), (String)"#sizeOfReadType", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
        ((ArrayList)object).addAll(this.constructPointerTargetFullyAllocatedCheck(iLocation, (Expression)identifierExpression, "#ptr", string));
        identifierExpression2 = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)"#ptr", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
        procedure = this.readFromHeap(iLocation, heapDataArray, (Expression)identifierExpression2, readWriteDefinition.getRepresentativeType(), readWriteDefinition.getBytesize());
        IdentifierExpression identifierExpression3 = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType), (String)"#value", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, string));
        Expression expression = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression3, (Expression)procedure);
        ((ArrayList)object).add(this.mProcedureManager.constructEnsuresSpecification(iLocation, false, expression, Collections.emptySet()));
        this.mProcedureManager.addSpecificationsToCurrentProcedure((List<Specification>)object);
        this.mProcedureManager.endCustomProcedure(cHandler, string);
        return Collections.emptyList();
    }

    private Expression readFromHeap(ILocation iLocation, HeapDataArray heapDataArray, Expression expression, ICType iCType, int n) {
        Expression expression2;
        IdentifierExpression identifierExpression = heapDataArray.getIdentifierExpression();
        if (n == heapDataArray.getSize() || heapDataArray.getSize() == 0) {
            expression2 = MemoryHandler.constructOneDimensionalArrayAccess(iLocation, (Expression)identifierExpression, expression);
        } else if (n < heapDataArray.getSize()) {
            expression2 = this.mExpressionTranslation.extractBits(iLocation, MemoryHandler.constructOneDimensionalArrayAccess(iLocation, (Expression)identifierExpression, expression), n * 8, 0);
        } else {
            assert (n % heapDataArray.getSize() == 0) : "incompatible sizes";
            Expression[] expressionArray = new Expression[n / heapDataArray.getSize()];
            int n2 = 0;
            while (n2 < expressionArray.length) {
                if (n2 == 0) {
                    expressionArray[expressionArray.length - 1 - 0] = MemoryHandler.constructOneDimensionalArrayAccess(iLocation, (Expression)identifierExpression, expression);
                } else {
                    Expression expression3 = this.addIntegerConstantToPointer(iLocation, expression, BigInteger.valueOf(n2 * heapDataArray.getSize()));
                    expressionArray[expressionArray.length - 1 - n2] = MemoryHandler.constructOneDimensionalArrayAccess(iLocation, (Expression)identifierExpression, expression3);
                }
                ++n2;
            }
            expression2 = this.mExpressionTranslation.concatBits(iLocation, Arrays.asList(expressionArray), heapDataArray.getSize());
        }
        if (this.mMemoryModel instanceof MemoryModel_SingleBitprecise && iCType.isFloatingType()) {
            return this.mExpressionTranslation.transformBitvectorToFloat(iLocation, expression2, ((CPrimitive)iCType).getType());
        }
        return expression2;
    }

    public Expression addIntegerConstantToPointer(ILocation iLocation, Expression expression, BigInteger bigInteger) {
        Expression expression2 = MemoryHandler.getPointerBaseAddress(expression, iLocation);
        Expression expression3 = MemoryHandler.getPointerOffset(expression, iLocation);
        Expression expression4 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mTypeSizeAndOffsetComputer.getSizeT(), bigInteger);
        Expression expression5 = this.mExpressionTranslation.constructArithmeticExpression(iLocation, 4, expression3, this.mTypeSizeAndOffsetComputer.getSizeT(), expression4, this.mTypeSizeAndOffsetComputer.getSizeT());
        return MemoryHandler.constructPointerFromBaseAndOffset(expression2, expression5, iLocation);
    }

    private static Expression constructOneDimensionalArrayAccess(ILocation iLocation, Expression expression, Expression expression2) {
        Expression[] expressionArray = new Expression[]{expression2};
        return ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)expression, (Expression[])expressionArray);
    }

    private static Expression constructOneDimensionalArrayStore(ILocation iLocation, Expression expression, Expression expression2, Expression expression3) {
        Expression[] expressionArray = new Expression[]{expression2};
        return ExpressionFactory.constructArrayStoreExpression((ILocation)iLocation, (Expression)expression, (Expression[])expressionArray, (Expression)expression3);
    }

    private static Expression constructNestedOneDimensionalArrayStore(ILocation iLocation, Expression expression, List<Expression> list, List<Expression> list2) {
        assert (list.size() == list2.size());
        Expression expression2 = expression;
        int n = 0;
        while (n < list.size()) {
            Expression[] expressionArray = new Expression[]{list.get(n)};
            expression2 = ExpressionFactory.constructArrayStoreExpression((ILocation)iLocation, (Expression)expression2, (Expression[])expressionArray, (Expression)list2.get(n));
            ++n;
        }
        return expression2;
    }

    private static Expression constructHeapArrayUpdateForWriteEnsures(ILocation iLocation, List<Expression> list, List<Expression> list2, HeapDataArray heapDataArray, boolean bl) {
        IdentifierExpression identifierExpression = heapDataArray.getIdentifierExpression();
        if (bl) {
            return MemoryHandler.ensuresArrayHasValues(iLocation, list, list2, (Expression)identifierExpression);
        }
        return MemoryHandler.ensuresArrayNestedUpdate(iLocation, list, list2, (Expression)identifierExpression);
    }

    private static Expression constructHeapArrayHardlyModifiedForWriteEnsures(ILocation iLocation, List<Expression> list, HeapDataArray heapDataArray) {
        IdentifierExpression identifierExpression = heapDataArray.getIdentifierExpression();
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        int n = 0;
        while (n < list.size()) {
            arrayList.add(MemoryHandler.constructOneDimensionalArrayAccess(iLocation, (Expression)identifierExpression, list.get(n)));
            ++n;
        }
        return MemoryHandler.ensuresArrayNestedUpdate(iLocation, arrayList, list, (Expression)identifierExpression);
    }

    private static Expression ensuresArrayUpdate(ILocation iLocation, Expression expression, Expression expression2, Expression expression3) {
        Expression expression4 = ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression3);
        Expression expression5 = MemoryHandler.constructOneDimensionalArrayStore(iLocation, expression4, expression2, expression);
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression3, (Expression)expression5);
    }

    private static Expression ensuresArrayNestedUpdate(ILocation iLocation, List<Expression> list, List<Expression> list2, Expression expression) {
        Expression expression2 = ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression);
        Expression expression3 = MemoryHandler.constructNestedOneDimensionalArrayStore(iLocation, expression2, list2, list);
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression, (Expression)expression3);
    }

    private static Expression ensuresArrayHasValue(ILocation iLocation, Expression expression, Expression expression2, Expression expression3) {
        ArrayAccessExpression arrayAccessExpression = ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)expression3, (Expression[])new Expression[]{expression2});
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)arrayAccessExpression, (Expression)expression);
    }

    private static Expression ensuresArrayHasValues(ILocation iLocation, List<Expression> list, List<Expression> list2, Expression expression) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        int n = 0;
        while (n < list.size()) {
            arrayList.add(MemoryHandler.ensuresArrayHasValue(iLocation, list.get(n), list2.get(n), expression));
            ++n;
        }
        return ExpressionFactory.and((ILocation)iLocation, arrayList);
    }

    public List<Specification> constructPointerTargetFullyAllocatedCheck(ILocation iLocation, Expression expression, String string, String string2) {
        boolean bl;
        if (this.mSettings.checkPointerDerefValidity() == CACSLPreferenceInitializer.CheckMode.IGNORE) {
            return Collections.emptyList();
        }
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)string, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string2));
        Expression expression2 = MemoryHandler.getPointerBaseAddress((Expression)identifierExpression, iLocation);
        ArrayAccessExpression arrayAccessExpression = ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)this.getLengthArray(iLocation), (Expression[])new Expression[]{expression2});
        Expression expression3 = MemoryHandler.getPointerOffset((Expression)identifierExpression, iLocation);
        Expression expression4 = this.constructPointerBinaryArithmeticExpression(iLocation, 4, expression, expression3);
        Expression expression5 = this.constructPointerBinaryComparisonExpression(iLocation, 10, expression4, (Expression)arrayAccessExpression);
        expression2 = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)string, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string2));
        arrayAccessExpression = MemoryHandler.getPointerOffset(expression2, iLocation);
        expression3 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ZERO);
        identifierExpression = this.constructPointerBinaryComparisonExpression(iLocation, 10, expression3, (Expression)arrayAccessExpression);
        if (this.mSettings.isBitvectorTranslation()) {
            expression2 = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)string, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string2));
            arrayAccessExpression = MemoryHandler.getPointerOffset(expression2, iLocation);
            expression3 = this.constructPointerBinaryArithmeticExpression(iLocation, 4, expression, (Expression)arrayAccessExpression);
            expression4 = this.constructPointerBinaryComparisonExpression(iLocation, 10, (Expression)arrayAccessExpression, expression3);
            expression5 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression5, (Expression)expression4);
        }
        expression2 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression5, (Expression)identifierExpression);
        if (this.mSettings.checkPointerDerefValidity() == CACSLPreferenceInitializer.CheckMode.CHECK) {
            bl = false;
        } else {
            assert (this.mSettings.checkPointerDerefValidity() == CACSLPreferenceInitializer.CheckMode.ASSUME);
            bl = true;
        }
        expression3 = new RequiresSpecification(iLocation, bl, expression2);
        expression4 = new Check(Spec.MEMORY_DEREFERENCE);
        expression4.annotate((IElement)expression3);
        return Collections.singletonList(expression3);
    }

    public List<Specification> constructPointerBaseValidityCheck(ILocation iLocation, String string, String string2) {
        boolean bl;
        if (this.mSettings.checkPointerDerefValidity() == CACSLPreferenceInitializer.CheckMode.IGNORE) {
            return Collections.emptyList();
        }
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)string, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string2));
        Expression expression = this.constructPointerBaseValidityCheckExpr(iLocation, (Expression)identifierExpression);
        if (this.mSettings.checkPointerDerefValidity() == CACSLPreferenceInitializer.CheckMode.CHECK) {
            bl = false;
        } else {
            assert (this.mSettings.checkPointerDerefValidity() == CACSLPreferenceInitializer.CheckMode.ASSUME);
            bl = true;
        }
        RequiresSpecification requiresSpecification = new RequiresSpecification(iLocation, bl, expression);
        Check check = new Check(Spec.MEMORY_DEREFERENCE);
        check.annotate((IElement)requiresSpecification);
        return Collections.singletonList(requiresSpecification);
    }

    private Expression constructPointerBinaryComparisonExpression(ILocation iLocation, int n, Expression expression, Expression expression2) {
        return this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, n, expression, this.mExpressionTranslation.getCTypeOfPointerComponents(), expression2, this.mExpressionTranslation.getCTypeOfPointerComponents());
    }

    private Expression constructPointerBinaryArithmeticExpression(ILocation iLocation, int n, Expression expression, Expression expression2) {
        return this.mExpressionTranslation.constructArithmeticExpression(iLocation, n, expression, this.mExpressionTranslation.getCTypeOfPointerComponents(), expression2, this.mExpressionTranslation.getCTypeOfPointerComponents());
    }

    private List<Declaration> declareDeallocation(CHandler cHandler, ILocation iLocation) {
        Expression expression = this.mBooleanArrayHelper.constructFalse();
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)ADDR, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, MemoryModelDeclarations.ULTIMATE_DEALLOC.getName()));
        Expression expression2 = this.getValidArray(iLocation);
        StructAccessExpression structAccessExpression = ExpressionFactory.constructStructAccessExpression((ILocation)iLocation, (Expression)identifierExpression, (String)"base");
        Expression[] expressionArray = new Expression[]{structAccessExpression};
        Object object = new Procedure(iLocation, new Attribute[0], MemoryModelDeclarations.ULTIMATE_DEALLOC.getName(), new String[0], new VarList[]{new VarList(iLocation, new String[]{ADDR}, this.mTypeHandler.constructPointerType(iLocation))}, new VarList[0], new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(cHandler, iLocation, MemoryModelDeclarations.ULTIMATE_DEALLOC.getName(), (Procedure)object);
        object = new ArrayList();
        ArrayStoreExpression arrayStoreExpression = ExpressionFactory.constructArrayStoreExpression((ILocation)iLocation, (Expression)ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression2), (Expression[])expressionArray, (Expression)expression);
        Expression expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression2, (Expression)arrayStoreExpression);
        ((ArrayList)object).add(this.mProcedureManager.constructEnsuresSpecification(iLocation, true, expression3, Collections.singleton((VariableLHS)CTranslationUtil.convertExpressionToLHS(expression2))));
        this.mProcedureManager.addSpecificationsToCurrentProcedure((List<Specification>)object);
        this.mProcedureManager.endCustomProcedure(cHandler, MemoryModelDeclarations.ULTIMATE_DEALLOC.getName());
        return Collections.emptyList();
    }

    private ArrayList<Declaration> declareMalloc(CHandler cHandler, ITypeHandler iTypeHandler, ILocation iLocation, MemoryArea memoryArea) {
        MemoryModelDeclarations memoryModelDeclarations = memoryArea.getMemoryModelDeclaration();
        ASTType aSTType = iTypeHandler.cType2AstType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents());
        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ZERO);
        Expression expression2 = this.getValidArray(iLocation);
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)"#res", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, memoryModelDeclarations.getName()));
        Expression expression3 = this.getLengthArray(iLocation);
        StructAccessExpression structAccessExpression = ExpressionFactory.constructStructAccessExpression((ILocation)iLocation, (Expression)identifierExpression, (String)"base");
        Expression[] expressionArray = new Expression[]{structAccessExpression};
        Expression expression4 = this.mBooleanArrayHelper.constructTrue();
        Expression expression5 = this.mBooleanArrayHelper.constructFalse();
        IdentifierExpression identifierExpression2 = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForSizeT(), (String)SIZE, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, memoryModelDeclarations.getName()));
        Object object = new Procedure(iLocation, new Attribute[0], memoryModelDeclarations.getName(), new String[0], new VarList[]{new VarList(iLocation, new String[]{SIZE}, aSTType)}, new VarList[]{new VarList(iLocation, new String[]{"#res"}, iTypeHandler.constructPointerType(iLocation))}, new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(cHandler, iLocation, memoryModelDeclarations.getName(), (Procedure)object);
        object = new ArrayList();
        object.add(this.mProcedureManager.constructEnsuresSpecification(iLocation, false, ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression2), (Expression[])expressionArray), (Expression)expression5), Collections.emptySet()));
        object.add(this.mProcedureManager.constructEnsuresSpecification(iLocation, false, MemoryHandler.ensuresArrayUpdate(iLocation, expression4, (Expression)structAccessExpression, expression2), Collections.singleton((VariableLHS)CTranslationUtil.convertExpressionToLHS(expression2))));
        object.add(this.mProcedureManager.constructEnsuresSpecification(iLocation, false, ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)ExpressionFactory.constructStructAccessExpression((ILocation)iLocation, (Expression)identifierExpression, (String)"offset"), (Expression)expression), Collections.emptySet()));
        object.add(this.mProcedureManager.constructEnsuresSpecification(iLocation, false, ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPNEQ, (Expression)ExpressionFactory.constructStructAccessExpression((ILocation)iLocation, (Expression)identifierExpression, (String)"base"), (Expression)expression), Collections.emptySet()));
        if (memoryArea == MemoryArea.STACK) {
            object.add(this.mProcedureManager.constructEnsuresSpecification(iLocation, false, this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 8, this.getStackHeapBarrier(iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents(), (Expression)ExpressionFactory.constructStructAccessExpression((ILocation)iLocation, (Expression)identifierExpression, (String)"base"), this.mExpressionTranslation.getCTypeOfPointerComponents()), Collections.emptySet()));
        }
        if (memoryArea == MemoryArea.HEAP) {
            object.add(this.mProcedureManager.constructEnsuresSpecification(iLocation, false, this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 8, (Expression)ExpressionFactory.constructStructAccessExpression((ILocation)iLocation, (Expression)identifierExpression, (String)"base"), this.mExpressionTranslation.getCTypeOfPointerComponents(), this.getStackHeapBarrier(iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents()), Collections.emptySet()));
        }
        object.add(this.mProcedureManager.constructEnsuresSpecification(iLocation, false, ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression3, (Expression)ExpressionFactory.constructArrayStoreExpression((ILocation)iLocation, (Expression)ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression3), (Expression[])expressionArray, (Expression)identifierExpression2)), Collections.singleton((VariableLHS)CTranslationUtil.convertExpressionToLHS(expression3))));
        this.mProcedureManager.addSpecificationsToCurrentProcedure((List<Specification>)object);
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        this.mProcedureManager.endCustomProcedure(cHandler, memoryModelDeclarations.getName());
        return arrayList;
    }

    private void declareAllocInit(CHandler cHandler, ITypeHandler iTypeHandler, ILocation iLocation) {
        String string = MemoryModelDeclarations.ULTIMATE_ALLOC_INIT.getName();
        ASTType aSTType = iTypeHandler.cType2AstType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents());
        Expression expression = this.getValidArray(iLocation);
        Expression expression2 = this.getLengthArray(iLocation);
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForSizeT(), (String)SIZE, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
        IdentifierExpression identifierExpression2 = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForPointerComponents(), (String)"ptrBase", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
        Object object = new Procedure(iLocation, new Attribute[0], string, new String[0], new VarList[]{new VarList(iLocation, new String[]{SIZE, "ptrBase"}, aSTType)}, new VarList[0], new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(cHandler, iLocation, string, (Procedure)object);
        object = new ArrayList();
        Expression expression3 = this.mBooleanArrayHelper.constructTrue();
        object.add(this.mProcedureManager.constructEnsuresSpecification(iLocation, false, MemoryHandler.ensuresArrayHasValue(iLocation, expression3, (Expression)identifierExpression2, expression), Collections.emptySet()));
        object.add(this.mProcedureManager.constructEnsuresSpecification(iLocation, false, MemoryHandler.ensuresArrayHasValue(iLocation, (Expression)identifierExpression, (Expression)identifierExpression2, expression2), Collections.emptySet()));
        this.mProcedureManager.addSpecificationsToCurrentProcedure((List<Specification>)object);
        this.mProcedureManager.endCustomProcedure(cHandler, string);
    }

    private static void checkFloatOnHeapSupport(ILocation iLocation, CPrimitive cPrimitive) {
    }

    private List<Statement> getWriteCallArray(ILocation iLocation, HeapLValue heapLValue, Expression expression, CArray cArray, HeapWriteMode heapWriteMode) {
        Expression expression2;
        Expression expression3;
        if (cArray.getValueType().getUnderlyingType() instanceof CArray) {
            throw new UnsupportedSyntaxException(iLocation, "we need to generalize this to nested and/or variable length arrays");
        }
        BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(cArray.getBound());
        if (bigInteger == null) {
            throw new UnsupportedSyntaxException(iLocation, "variable length arrays not yet supported by this method");
        }
        Expression expression4 = heapLValue.getAddress();
        if (expression4 instanceof StructConstructor) {
            expression3 = ((StructConstructor)expression4).getFieldValues()[0];
            expression2 = ((StructConstructor)expression4).getFieldValues()[1];
        } else {
            expression3 = MemoryHandler.getPointerBaseAddress(expression4, iLocation);
            expression2 = MemoryHandler.getPointerOffset(expression4, iLocation);
        }
        Expression expression5 = this.calculateSizeOf(iLocation, cArray.getValueType());
        int n = bigInteger.intValue();
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        Expression expression6 = expression2;
        int n2 = 0;
        while (n2 < n) {
            Expression expression7 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.valueOf(n2));
            RValue rValue = new RValue((Expression)ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)expression, (Expression[])new Expression[]{expression7}), cArray.getValueType());
            HeapLValue heapLValue2 = LRValueFactory.constructHeapLValue(this.mTypeHandler, (Expression)MemoryHandler.constructPointerFromBaseAndOffset(expression3, expression6, iLocation), cArray.getValueType(), null);
            arrayList.addAll(this.getWriteCall(iLocation, heapLValue2, rValue.getValue(), rValue.getCType(), heapWriteMode));
            expression6 = this.mExpressionTranslation.constructArithmeticExpression(iLocation, 4, expression6, this.mExpressionTranslation.getCTypeOfPointerComponents(), expression5, this.mExpressionTranslation.getCTypeOfPointerComponents());
            ++n2;
        }
        return arrayList;
    }

    private List<Statement> getWriteCallStruct(ILocation iLocation, HeapLValue heapLValue, Expression expression, CStructOrUnion cStructOrUnion, HeapWriteMode heapWriteMode) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        boolean bl = CStructOrUnion.isUnion(cStructOrUnion) && this.mSettings.getMemoryModelPreference() == CACSLPreferenceInitializer.MemoryModel.HoenickeLindenmann_Original;
        String[] stringArray = cStructOrUnion.getFieldIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Expression expression2 = heapLValue.getAddress();
            Expression expression3 = MemoryHandler.getPointerBaseAddress(expression2, iLocation);
            Expression expression4 = MemoryHandler.getPointerOffset(expression2, iLocation);
            ICType iCType = cStructOrUnion.getFieldType(string);
            if (bl && iCType.getUnderlyingType().isFloatingType()) {
                arrayList.add(ExpressionTranslation.modelUnsupportedFeature(iLocation, "write for union with floats in the HoenickeLindenmann_Original memory model"));
            }
            StructAccessExpression structAccessExpression = ExpressionFactory.constructStructAccessExpression((ILocation)iLocation, (Expression)expression, (String)string);
            TypeSizeAndOffsetComputer.Offset offset = this.mTypeSizeAndOffsetComputer.constructOffsetForField(iLocation, cStructOrUnion, string);
            if (offset.isBitfieldOffset()) {
                throw new UnsupportedOperationException("Bitfield write");
            }
            Expression expression5 = this.mExpressionTranslation.constructArithmeticExpression(iLocation, 4, expression4, this.mExpressionTranslation.getCTypeOfPointerComponents(), offset.getAddressOffsetAsExpression(iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents());
            HeapLValue heapLValue2 = LRValueFactory.constructHeapLValue(this.mTypeHandler, (Expression)MemoryHandler.constructPointerFromBaseAndOffset(expression3, expression5, iLocation), iCType, null);
            arrayList.addAll(this.getWriteCall(iLocation, heapLValue2, (Expression)structAccessExpression, iCType, heapWriteMode));
            ++n2;
        }
        return arrayList;
    }

    private List<Statement> getWriteCallPointer(ILocation iLocation, HeapLValue heapLValue, Expression expression, HeapWriteMode heapWriteMode) {
        this.mRequiredMemoryModelFeatures.reportPointerOnHeapRequired();
        String string = this.determineWriteProcedureForPointer(heapWriteMode);
        return Collections.singletonList(StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[0], (String)string, (Expression[])new Expression[]{expression, heapLValue.getAddress(), this.calculateSizeOf(iLocation, heapLValue.getCType())}));
    }

    private String determineWriteProcedureForPointer(HeapWriteMode heapWriteMode) throws AssertionError {
        return switch (heapWriteMode) {
            case HeapWriteMode.SELECT -> {
                this.mRequiredMemoryModelFeatures.reportPointerInitWriteRequired();
                yield this.mMemoryModel.getInitPointerProcedureName();
            }
            case HeapWriteMode.STORE_CHECKED -> this.mMemoryModel.getWritePointerProcedureName();
            case HeapWriteMode.STORE_UNCHECKED -> {
                this.mRequiredMemoryModelFeatures.reportPointerUncheckedWriteRequired();
                yield this.mMemoryModel.getUncheckedWritePointerProcedureName();
            }
            default -> throw new MatchException(null, null);
        };
    }

    private List<Statement> getWriteCallEnum(ILocation iLocation, HeapLValue heapLValue, Expression expression, HeapWriteMode heapWriteMode) {
        return this.getWriteCallPrimitive(iLocation, heapLValue, expression, new CPrimitive(CPrimitive.CPrimitives.INT), heapWriteMode);
    }

    private List<Statement> getWriteCallPrimitive(ILocation iLocation, HeapLValue heapLValue, Expression expression, CPrimitive cPrimitive, HeapWriteMode heapWriteMode) {
        MemoryHandler.checkFloatOnHeapSupport(iLocation, cPrimitive);
        this.mRequiredMemoryModelFeatures.reportDataOnHeapRequired(cPrimitive.getType());
        String string = this.determineWriteProcedureForPrimitive(cPrimitive, heapWriteMode);
        return Collections.singletonList(StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[0], (String)string, (Expression[])new Expression[]{expression, heapLValue.getAddress(), this.calculateSizeOf(iLocation, heapLValue.getCType())}));
    }

    private String determineWriteProcedureForPrimitive(CPrimitive cPrimitive, HeapWriteMode heapWriteMode) throws AssertionError {
        return switch (heapWriteMode) {
            case HeapWriteMode.SELECT -> {
                this.mRequiredMemoryModelFeatures.reportInitWriteRequired(cPrimitive.getType());
                yield this.mMemoryModel.getInitWriteProcedureName(cPrimitive.getType());
            }
            case HeapWriteMode.STORE_CHECKED -> this.mMemoryModel.getWriteProcedureName(cPrimitive.getType());
            case HeapWriteMode.STORE_UNCHECKED -> {
                this.mRequiredMemoryModelFeatures.reportUncheckedWriteRequired(cPrimitive.getType());
                yield this.mMemoryModel.getUncheckedWriteProcedureName(cPrimitive.getType());
            }
            default -> throw new MatchException(null, null);
        };
    }

    private MemoryModelDeclarationInfo constructMemoryModelDeclarationInfo(MemoryModelDeclarations memoryModelDeclarations) {
        switch (memoryModelDeclarations) {
            case C_MEMCPY: {
                break;
            }
            case C_MEMMOVE: {
                break;
            }
            case C_MEMSET: {
                break;
            }
            case ULTIMATE_ALLOC_STACK: {
                break;
            }
            case ULTIMATE_ALLOC_HEAP: {
                break;
            }
            case ULTIMATE_DEALLOC: {
                break;
            }
            case ULTIMATE_LENGTH: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogieTypeForPointerComponents()}, (BoogieType)this.mTypeHandler.getBoogieTypeForSizeT()));
            }
            case ULTIMATE_MEMINIT: {
                break;
            }
            case ULTIMATE_PTHREADS_FORK_COUNT: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, this.mTypeHandler.getBoogieTypeForCType(this.mTypeHandler.getThreadIdType()));
            }
            case ULTIMATE_PTHREADS_MUTEX: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(this.getBooleanArrayHelper().constructBoolReplacementType())));
            }
            case ULTIMATE_PTHREADS_RWLOCK: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(MemoryHandler.getRwLockCounterType())));
            }
            case ULTIMATE_VALID: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogieTypeForPointerComponents()}, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(this.getBooleanArrayHelper().constructBoolReplacementType())));
            }
            case ULTIMATE_STACK_HEAP_BARRIER: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, this.mTypeHandler.getBoogieTypeForPointerComponents());
            }
            case ULTIMATE_DATA_RACE_MEMORY: {
                return new MemoryModelDeclarationInfo(memoryModelDeclarations, (BoogieType)BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(this.getBooleanArrayHelper().constructBoolReplacementType())));
            }
        }
        return new MemoryModelDeclarationInfo(memoryModelDeclarations);
    }

    private ArrayList<Declaration> declarePthreadMutexLock(CHandler cHandler, ITypeHandler iTypeHandler, ILocation iLocation) {
        Expression expression = this.constructMutexArrayIdentifierExpression(iLocation);
        Expression expression2 = this.mBooleanArrayHelper.constructTrue();
        this.declareProcedureWithPointerParam(cHandler, iTypeHandler, iLocation, MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX_LOCK.getName(), (expression3, expression4) -> new Specification[]{this.mProcedureManager.constructEnsuresSpecification(iLocation, true, this.constructOldMutexUnlockedCheckExpression(iLocation, (Expression)expression3), Collections.emptySet()), this.mProcedureManager.constructEnsuresSpecification(iLocation, true, MemoryHandler.ensuresArrayUpdate(iLocation, expression2, expression3, expression), Collections.singleton((VariableLHS)CTranslationUtil.convertExpressionToLHS(expression))), this.ensuresSuccess(iLocation, (Expression)expression4)});
        return new ArrayList<Declaration>();
    }

    private ArrayList<Declaration> declarePthreadMutexUnlock(CHandler cHandler, ITypeHandler iTypeHandler, ILocation iLocation) {
        Expression expression = this.constructMutexArrayIdentifierExpression(iLocation);
        Expression expression2 = this.mBooleanArrayHelper.constructFalse();
        this.declareProcedureWithPointerParam(cHandler, iTypeHandler, iLocation, MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX_UNLOCK.getName(), (expression3, expression4) -> new Specification[]{this.mProcedureManager.constructEnsuresSpecification(iLocation, true, MemoryHandler.ensuresArrayUpdate(iLocation, expression2, expression3, expression), Collections.singleton((VariableLHS)CTranslationUtil.convertExpressionToLHS(expression))), this.ensuresSuccess(iLocation, (Expression)expression4)});
        return new ArrayList<Declaration>();
    }

    private ArrayList<Declaration> declarePthreadMutexTryLock(CHandler cHandler, ITypeHandler iTypeHandler, ILocation iLocation) {
        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, new CPrimitive(CPrimitive.CPrimitives.INT), BigInteger.ZERO);
        Expression expression2 = this.constructMutexArrayIdentifierExpression(iLocation);
        Expression expression3 = this.mBooleanArrayHelper.constructTrue();
        this.declareProcedureWithPointerParam(cHandler, iTypeHandler, iLocation, MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX_TRYLOCK.getName(), (expression4, expression5) -> {
            Expression expression6 = this.constructOldMutexUnlockedCheckExpression(iLocation, (Expression)expression4);
            Expression expression7 = MemoryHandler.ensuresArrayUpdate(iLocation, expression3, expression4, expression2);
            Expression expression8 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression5, (Expression)expression);
            Expression expression9 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression2, (Expression)ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression2));
            Expression expression10 = ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.LOGICNEG, (Expression)expression8);
            return new Specification[]{this.mProcedureManager.constructEnsuresSpecification(iLocation, true, ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression6, (Expression)ExpressionFactory.and((ILocation)iLocation, List.of(expression7, expression8)), (Expression)ExpressionFactory.and((ILocation)iLocation, List.of(expression9, expression10))), Collections.singleton((VariableLHS)CTranslationUtil.convertExpressionToLHS(expression2)))};
        });
        return new ArrayList<Declaration>();
    }

    private ArrayList<Declaration> declarePthreadRwLockReadLock(CHandler cHandler, ITypeHandler iTypeHandler, ILocation iLocation) {
        Expression expression = this.constructRwLockArrayIdentifierExpression(iLocation);
        this.declareProcedureWithPointerParam(cHandler, iTypeHandler, iLocation, MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_READLOCK.getName(), (expression2, expression3) -> new Specification[]{this.mProcedureManager.constructEnsuresSpecification(iLocation, true, this.constructOldRwLockComparisonExpression(iLocation, (Expression)expression2, 11), Collections.emptySet()), this.mProcedureManager.constructEnsuresSpecification(iLocation, true, this.constructRwLockReadLockUpdate(iLocation, (Expression)expression2), Collections.singleton((VariableLHS)CTranslationUtil.convertExpressionToLHS(expression))), this.ensuresSuccess(iLocation, (Expression)expression3)});
        return new ArrayList<Declaration>();
    }

    private ArrayList<Declaration> declarePthreadRwLockWriteLock(CHandler cHandler, ITypeHandler iTypeHandler, ILocation iLocation) {
        Expression expression = this.constructRwLockArrayIdentifierExpression(iLocation);
        this.declareProcedureWithPointerParam(cHandler, iTypeHandler, iLocation, MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_WRITELOCK.getName(), (expression2, expression3) -> new Specification[]{this.mProcedureManager.constructEnsuresSpecification(iLocation, true, this.constructOldRwLockComparisonExpression(iLocation, (Expression)expression2, 28), Collections.emptySet()), this.mProcedureManager.constructEnsuresSpecification(iLocation, true, this.constructRwLockWriteLockUpdate(iLocation, (Expression)expression2), Collections.singleton((VariableLHS)CTranslationUtil.convertExpressionToLHS(expression))), this.ensuresSuccess(iLocation, (Expression)expression3)});
        return new ArrayList<Declaration>();
    }

    private ArrayList<Declaration> declarePthreadRwLockUnlock(CHandler cHandler, ITypeHandler iTypeHandler, ILocation iLocation) {
        Expression expression = this.constructRwLockArrayIdentifierExpression(iLocation);
        Expression expression2 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, MemoryHandler.getRwLockCounterType(), BigInteger.ZERO);
        this.declareProcedureWithPointerParam(cHandler, iTypeHandler, iLocation, MemoryModelDeclarations.ULTIMATE_PTHREADS_RWLOCK_UNLOCK.getName(), (expression3, expression4) -> {
            ArrayAccessExpression arrayAccessExpression = ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression), (Expression[])new Expression[]{expression3});
            Expression expression5 = this.mExpressionTranslation.constructArithmeticExpression(iLocation, 5, (Expression)arrayAccessExpression, MemoryHandler.getRwLockCounterType(), this.mTypeSizes.constructLiteralForIntegerType(iLocation, MemoryHandler.getRwLockCounterType(), BigInteger.valueOf(1L)), MemoryHandler.getRwLockCounterType());
            return new Specification[]{this.mProcedureManager.constructEnsuresSpecification(iLocation, true, MemoryHandler.ensuresArrayUpdate(iLocation, ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)this.constructOldRwLockComparisonExpression(iLocation, (Expression)expression3, 9), (Expression)expression5, (Expression)expression2), expression3, expression), Collections.emptySet()), this.ensuresSuccess(iLocation, (Expression)expression4)};
        });
        return new ArrayList<Declaration>();
    }

    private Expression constructRwLockReadLockUpdate(ILocation iLocation, Expression expression) {
        Expression expression2 = this.constructRwLockArrayIdentifierExpression(iLocation);
        ArrayAccessExpression arrayAccessExpression = ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression2), (Expression[])new Expression[]{expression});
        Expression expression3 = this.mExpressionTranslation.constructArithmeticExpression(iLocation, 4, (Expression)arrayAccessExpression, MemoryHandler.getRwLockCounterType(), this.mTypeSizes.constructLiteralForIntegerType(iLocation, MemoryHandler.getRwLockCounterType(), BigInteger.valueOf(1L)), MemoryHandler.getRwLockCounterType());
        return MemoryHandler.ensuresArrayUpdate(iLocation, expression3, expression, expression2);
    }

    private Expression constructRwLockWriteLockUpdate(ILocation iLocation, Expression expression) {
        Expression expression2 = this.constructRwLockArrayIdentifierExpression(iLocation);
        Expression expression3 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, MemoryHandler.getRwLockCounterType(), BigInteger.valueOf(-1L));
        return MemoryHandler.ensuresArrayUpdate(iLocation, expression3, expression, expression2);
    }

    private EnsuresSpecification ensuresSuccess(ILocation iLocation, Expression expression) {
        Expression expression2 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, new CPrimitive(CPrimitive.CPrimitives.INT), BigInteger.ZERO);
        return this.mProcedureManager.constructEnsuresSpecification(iLocation, true, ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression, (Expression)expression2), Collections.emptySet());
    }

    private Expression constructOldMutexUnlockedCheckExpression(ILocation iLocation, Expression expression) {
        Expression expression2 = this.constructMutexArrayIdentifierExpression(iLocation);
        Expression expression3 = this.mBooleanArrayHelper.constructFalse();
        return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression2), (Expression[])new Expression[]{expression}), (Expression)expression3);
    }

    private Expression constructOldRwLockComparisonExpression(ILocation iLocation, Expression expression, int n) {
        Expression expression2 = this.constructRwLockArrayIdentifierExpression(iLocation);
        ArrayAccessExpression arrayAccessExpression = ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.OLD, (Expression)expression2), (Expression[])new Expression[]{expression});
        Expression expression3 = this.mExpressionTranslation.constructZero(iLocation, MemoryHandler.getRwLockCounterType());
        return this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, n, (Expression)arrayAccessExpression, MemoryHandler.getRwLockCounterType(), expression3, MemoryHandler.getRwLockCounterType());
    }

    private void declareProcedureWithPointerParam(CHandler cHandler, ITypeHandler iTypeHandler, ILocation iLocation, String string, BiFunction<Expression, Expression, Specification[]> biFunction) {
        ASTType aSTType = iTypeHandler.cType2AstType(iLocation, CPointer.voidPointer());
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        ASTType aSTType2 = iTypeHandler.cType2AstType(iLocation, cPrimitive);
        BoogieType boogieType = iTypeHandler.getBoogieTypeForCType(cPrimitive);
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogiePointerType(), (String)"#inputPtr", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string));
        IdentifierExpression identifierExpression2 = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)boogieType, (String)"#res", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, string));
        Procedure procedure = new Procedure(iLocation, new Attribute[0], string, new String[0], new VarList[]{new VarList(iLocation, new String[]{"#inputPtr"}, aSTType)}, new VarList[]{new VarList(iLocation, new String[]{"#res"}, aSTType2)}, new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(cHandler, iLocation, string, procedure);
        this.mProcedureManager.addSpecificationsToCurrentProcedure(Arrays.asList(biFunction.apply((Expression)identifierExpression, (Expression)identifierExpression2)));
        this.mProcedureManager.endCustomProcedure(cHandler, string);
    }

    public List<Statement> getInitializationForOnHeapVariableOfAggregateOrUnionType(ILocation iLocation, HeapLValue heapLValue, ICType iCType) {
        assert (CTranslationUtil.isAggregateOrUnionType(iCType)) : "Argument is not aggregate or union but " + String.valueOf(iCType);
        Set<ICType> set = CTranslationUtil.extractNonAggregateNonUnionTypes(iCType);
        return this.getInitializationForHeapAtPointer(iLocation, heapLValue, set);
    }

    private List<Statement> getInitializationForHeapAtPointer(ILocation iLocation, HeapLValue heapLValue, Set<ICType> set) throws AssertionError {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        for (ICType object2 : set) {
            HeapDataArray heapDataArray;
            CPrimitive.CPrimitives cPrimitives;
            Object object;
            assert (!(object2 instanceof CNamed));
            if (object2 instanceof CPointer) {
                this.mRequiredMemoryModelFeatures.reportPointerOnHeapRequired();
                object = this.mMemoryModel.getPointerHeapArray();
                this.mRequiredMemoryModelFeatures.reportPointerOnHeapInitFunctionRequired();
                linkedHashSet.add(object);
                continue;
            }
            if (object2 instanceof CPrimitive) {
                object = (CPrimitive)object2;
                cPrimitives = ((CPrimitive)object).getType();
                this.mRequiredMemoryModelFeatures.reportDataOnHeapRequired(cPrimitives);
                heapDataArray = this.mMemoryModel.getDataHeapArray(cPrimitives);
                this.mRequiredMemoryModelFeatures.reportDataOnHeapInitFunctionRequired(cPrimitives);
                linkedHashSet.add(heapDataArray);
                continue;
            }
            if (object2 instanceof CEnum) {
                cPrimitives = CPrimitive.CPrimitives.INT;
                this.mRequiredMemoryModelFeatures.reportDataOnHeapRequired(cPrimitives);
                heapDataArray = this.mMemoryModel.getDataHeapArray(cPrimitives);
                this.mRequiredMemoryModelFeatures.reportDataOnHeapInitFunctionRequired(cPrimitives);
                linkedHashSet.add(heapDataArray);
                continue;
            }
            throw new AssertionError((Object)"unforseen case");
        }
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (Object object4 : linkedHashSet) {
            arrayList.add(MemoryHandler.getInitializationForHeapArrayAtAddress(iLocation, (HeapDataArray)object4, heapLValue));
        }
        return arrayList;
    }

    private static Statement getInitializationForHeapArrayAtAddress(ILocation iLocation, HeapDataArray heapDataArray, HeapLValue heapLValue) {
        return StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new VariableLHS[]{heapDataArray.getVariableLHS()}, (Expression[])new Expression[]{ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)MemoryHandler.getNameOfHeapInitFunction(heapDataArray), (Expression[])new Expression[]{heapDataArray.getIdentifierExpression(), MemoryHandler.getPointerBaseAddress(heapLValue.getAddress(), iLocation)}, (BoogieType)((BoogieType)heapDataArray.getIdentifierExpression().getType()))});
    }

    private static String getNameOfHeapInitFunction(HeapDataArray heapDataArray) {
        return "~initToZeroAtPointerBaseAddress~" + heapDataArray.getName();
    }

    public String getNameOfHeapStoreFunction(HeapDataArray heapDataArray) {
        return "~storeAtPointerBaseAddress~" + heapDataArray.getName();
    }

    public String getNameOfHeapSelectFunction(HeapDataArray heapDataArray) {
        return "~selectAtPointerBaseAddress~" + heapDataArray.getName();
    }

    private void declareDataOnHeapStoreFunction(HeapDataArray heapDataArray) {
        String string;
        String[] stringArray;
        Attribute[] attributeArray;
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        CPrimitive cPrimitive = this.mExpressionTranslation.getCTypeOfPointerComponents();
        ASTType aSTType = this.mTypeHandler.cType2AstType(cACSLLocation, cPrimitive);
        BoogieType boogieType = heapDataArray.getArrayContentBoogieType();
        BoogieType boogieType2 = StructExpanderUtil.flattenType((IBoogieType)boogieType, new HashMap(), new HashMap());
        if (boogieType2 instanceof BoogieStructType) {
            attributeArray = (BoogieStructType)boogieType2;
            stringArray = new String[attributeArray.getFieldCount()];
            int n = 0;
            while (n < attributeArray.getFieldCount()) {
                string = FunctionDeclarations.constructNameForFunctionInParam(2);
                stringArray[n] = string + "." + attributeArray.getFieldIds()[n];
                ++n;
            }
        } else {
            attributeArray = FunctionDeclarations.constructNameForFunctionInParam(2);
            stringArray = new String[]{attributeArray};
        }
        attributeArray = this.constructExpandAndSmtDefinedAttributesForSubArrayStore(heapDataArray, stringArray);
        BoogieType boogieType3 = (BoogieType)heapDataArray.getIdentifierExpression().getType();
        string = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogieTypeForPointerComponents()}, (BoogieType)boogieType);
        this.mExpressionTranslation.getFunctionDeclarations().declareFunction((ILocation)cACSLLocation, this.getNameOfHeapStoreFunction(heapDataArray), attributeArray, boogieType3.toASTType((ILocation)cACSLLocation), boogieType3.toASTType((ILocation)cACSLLocation), aSTType, string.toASTType((ILocation)cACSLLocation));
    }

    private void declareDataOnHeapSelectFunction(HeapDataArray heapDataArray) {
        String[] stringArray;
        Attribute[] attributeArray;
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        CPrimitive cPrimitive = this.mExpressionTranslation.getCTypeOfPointerComponents();
        ASTType aSTType = this.mTypeHandler.cType2AstType(cACSLLocation, cPrimitive);
        BoogieType boogieType = heapDataArray.getArrayContentBoogieType();
        BoogieType boogieType2 = (BoogieType)heapDataArray.getIdentifierExpression().getType();
        BoogieType boogieType3 = StructExpanderUtil.flattenType((IBoogieType)boogieType, new HashMap(), new HashMap());
        BoogieArrayType boogieArrayType = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogieTypeForPointerComponents()}, (BoogieType)boogieType);
        if (boogieType3 instanceof BoogieStructType) {
            attributeArray = (BoogieStructType)boogieType3;
            stringArray = new String[attributeArray.getFieldCount()];
            int n = 0;
            while (n < attributeArray.getFieldCount()) {
                String string;
                stringArray[n] = string = FunctionDeclarations.constructNameForFunctionInParam(1);
                ++n;
            }
        } else {
            attributeArray = FunctionDeclarations.constructNameForFunctionInParam(1);
            stringArray = new String[]{attributeArray};
        }
        attributeArray = this.constructExpandAndSmtDefinedAttributesForSubArraySelect(heapDataArray, stringArray);
        this.mExpressionTranslation.getFunctionDeclarations().declareFunction((ILocation)cACSLLocation, this.getNameOfHeapSelectFunction(heapDataArray), attributeArray, boogieArrayType.toASTType((ILocation)cACSLLocation), boogieType2.toASTType((ILocation)cACSLLocation), aSTType);
    }

    private void declareDataOnHeapInitFunction(HeapDataArray heapDataArray) {
        String[] stringArray;
        Attribute[] attributeArray;
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        CPrimitive cPrimitive = this.mExpressionTranslation.getCTypeOfPointerComponents();
        ASTType aSTType = this.mTypeHandler.cType2AstType(cACSLLocation, cPrimitive);
        BoogieType boogieType = this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType);
        String string = CTranslationUtil.getSmtSortStringForBoogieType(boogieType);
        BoogieType boogieType2 = heapDataArray.getArrayContentBoogieType();
        BoogieType boogieType3 = StructExpanderUtil.flattenType((IBoogieType)boogieType2, new HashMap(), new HashMap());
        if (boogieType3 instanceof BoogieStructType) {
            attributeArray = (BoogieStructType)boogieType3;
            stringArray = new String[attributeArray.getFieldCount()];
            int n = 0;
            while (n < attributeArray.getFieldCount()) {
                String string2 = CTranslationUtil.getSmtZeroStringForBoogieType(attributeArray.getFieldType(n));
                String string3 = CTranslationUtil.getSmtSortStringForBoogieType(attributeArray.getFieldType(n));
                stringArray[n] = String.format("((as const (Array %s %s)) %s)", string, string3, string2);
                ++n;
            }
        } else {
            attributeArray = CTranslationUtil.getSmtZeroStringForBoogieType(boogieType2);
            String string4 = CTranslationUtil.getSmtSortStringForBoogieType(boogieType2);
            String string5 = String.format("((as const (Array %s %s)) %s)", string, string4, attributeArray);
            stringArray = new String[]{string5};
        }
        attributeArray = this.constructExpandAndSmtDefinedAttributesForSubArrayStore(heapDataArray, stringArray);
        this.mExpressionTranslation.getFunctionDeclarations().declareFunction((ILocation)cACSLLocation, MemoryHandler.getNameOfHeapInitFunction(heapDataArray), attributeArray, ((BoogieType)heapDataArray.getIdentifierExpression().getType()).toASTType((ILocation)cACSLLocation), ((BoogieType)heapDataArray.getIdentifierExpression().getType()).toASTType((ILocation)cACSLLocation), aSTType);
    }

    private Attribute[] constructExpandAndSmtDefinedAttributesForSubArrayStore(HeapDataArray heapDataArray, String ... stringArray) {
        ArrayList<NamedAttribute> arrayList = new ArrayList<NamedAttribute>();
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        CPrimitive cPrimitive = this.mExpressionTranslation.getCTypeOfPointerComponents();
        this.mTypeHandler.cType2AstType(cACSLLocation, cPrimitive);
        BoogieType boogieType = heapDataArray.getArrayContentBoogieType();
        BoogieType boogieType2 = StructExpanderUtil.flattenType((IBoogieType)boogieType, new HashMap(), new HashMap());
        if (boogieType2 instanceof BoogieStructType) {
            BoogieStructType boogieStructType = (BoogieStructType)boogieType2;
            int n = 0;
            while (n < boogieStructType.getFieldCount()) {
                NamedAttribute namedAttribute = new NamedAttribute((ILocation)cACSLLocation, "expand_struct", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)cACSLLocation, (String)boogieStructType.getFieldIds()[n])});
                arrayList.add(namedAttribute);
                String string = String.format("(store %s %s %s)", FunctionDeclarations.constructNameForFunctionInParam(0) + "." + boogieStructType.getFieldIds()[n], FunctionDeclarations.constructNameForFunctionInParam(1), stringArray[n]);
                NamedAttribute namedAttribute2 = new NamedAttribute((ILocation)cACSLLocation, "smtdefined", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)cACSLLocation, (String)string)});
                arrayList.add(namedAttribute2);
                ++n;
            }
        } else {
            String string = String.format("(store %s %s %s)", FunctionDeclarations.constructNameForFunctionInParam(0), FunctionDeclarations.constructNameForFunctionInParam(1), stringArray[0]);
            NamedAttribute namedAttribute = new NamedAttribute((ILocation)cACSLLocation, "smtdefined", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)cACSLLocation, (String)string)});
            arrayList.add(namedAttribute);
        }
        return arrayList.toArray(new Attribute[arrayList.size()]);
    }

    private Attribute[] constructExpandAndSmtDefinedAttributesForSubArraySelect(HeapDataArray heapDataArray, String ... stringArray) {
        ArrayList<NamedAttribute> arrayList = new ArrayList<NamedAttribute>();
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        CPrimitive cPrimitive = this.mExpressionTranslation.getCTypeOfPointerComponents();
        this.mTypeHandler.cType2AstType(cACSLLocation, cPrimitive);
        BoogieType boogieType = heapDataArray.getArrayContentBoogieType();
        BoogieType boogieType2 = StructExpanderUtil.flattenType((IBoogieType)boogieType, new HashMap(), new HashMap());
        if (boogieType2 instanceof BoogieStructType) {
            BoogieStructType boogieStructType = (BoogieStructType)boogieType2;
            int n = 0;
            while (n < boogieStructType.getFieldCount()) {
                NamedAttribute namedAttribute = new NamedAttribute((ILocation)cACSLLocation, "expand_struct", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)cACSLLocation, (String)boogieStructType.getFieldIds()[n])});
                arrayList.add(namedAttribute);
                String string = String.format("(select %s %s)", FunctionDeclarations.constructNameForFunctionInParam(0) + "." + boogieStructType.getFieldIds()[n], FunctionDeclarations.constructNameForFunctionInParam(1), stringArray[n]);
                NamedAttribute namedAttribute2 = new NamedAttribute((ILocation)cACSLLocation, "smtdefined", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)cACSLLocation, (String)string)});
                arrayList.add(namedAttribute2);
                ++n;
            }
        } else {
            String string = String.format("(select %s %s)", FunctionDeclarations.constructNameForFunctionInParam(0), FunctionDeclarations.constructNameForFunctionInParam(1), stringArray[0]);
            NamedAttribute namedAttribute = new NamedAttribute((ILocation)cACSLLocation, "smtdefined", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)cACSLLocation, (String)string)});
            arrayList.add(namedAttribute);
        }
        return arrayList.toArray(new Attribute[arrayList.size()]);
    }

    public List<Statement> constructMemsafetyChecksForPointerExpression(ILocation iLocation, Expression expression) {
        Check check;
        AssertStatement assertStatement;
        Expression expression2;
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        if (this.mSettings.checkPointerDerefValidity() != CACSLPreferenceInitializer.CheckMode.IGNORE) {
            expression2 = this.constructPointerBaseValidityCheckExpr(iLocation, expression);
            if (this.mSettings.checkPointerDerefValidity() == CACSLPreferenceInitializer.CheckMode.CHECK) {
                assertStatement = new AssertStatement(iLocation, expression2);
                check = new Check(Spec.MEMORY_DEREFERENCE);
                check.annotate((IElement)assertStatement);
                arrayList.add((Statement)assertStatement);
            } else {
                assert (this.mSettings.checkPointerDerefValidity() == CACSLPreferenceInitializer.CheckMode.ASSUME) : "missed a case?";
                assertStatement = new AssumeStatement(iLocation, expression2);
                arrayList.add((Statement)assertStatement);
            }
        }
        if (this.mSettings.checkPointerDerefValidity() != CACSLPreferenceInitializer.CheckMode.IGNORE) {
            expression2 = this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 8, MemoryHandler.getPointerOffset(expression, iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents(), (Expression)ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)this.getLengthArray(iLocation), (Expression[])new Expression[]{MemoryHandler.getPointerBaseAddress(expression, iLocation)}), this.mExpressionTranslation.getCTypeOfPointerComponents());
            assertStatement = this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 11, MemoryHandler.getPointerOffset(expression, iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents(), this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), new BigInteger("0")), this.mExpressionTranslation.getCTypeOfPointerComponents());
            check = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICAND, (Expression)expression2, (Expression)assertStatement);
            if (this.mSettings.checkPointerDerefValidity() == CACSLPreferenceInitializer.CheckMode.CHECK) {
                AssertStatement assertStatement2 = new AssertStatement(iLocation, (Expression)check);
                Check check2 = new Check(Spec.MEMORY_DEREFERENCE);
                check2.annotate((IElement)assertStatement2);
                arrayList.add((Statement)assertStatement2);
            } else {
                assert (this.mSettings.checkPointerDerefValidity() == CACSLPreferenceInitializer.CheckMode.ASSUME) : "missed a case?";
                AssumeStatement assumeStatement = new AssumeStatement(iLocation, (Expression)check);
                arrayList.add((Statement)assumeStatement);
            }
        }
        return arrayList;
    }

    public static final class BooleanArrayHelper_Bitvector
    implements IBooleanArrayHelper {
        @Override
        public ASTType constructBoolReplacementType() {
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            return new PrimitiveType((ILocation)cACSLLocation, (IBoogieType)BoogieType.createBitvectorType((int)1), "bv1");
        }

        @Override
        public Expression constructTrue() {
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            return ExpressionFactory.createBitvecLiteral((ILocation)cACSLLocation, (String)"1", (int)1);
        }

        @Override
        public Expression constructFalse() {
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            return ExpressionFactory.createBitvecLiteral((ILocation)cACSLLocation, (String)"0", (int)1);
        }

        @Override
        public Expression compareWithTrue(Expression expression) {
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            return ExpressionFactory.newBinaryExpression((ILocation)cACSLLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression, (Expression)this.constructTrue());
        }
    }

    public static final class BooleanArrayHelper_Bool
    implements IBooleanArrayHelper {
        @Override
        public ASTType constructBoolReplacementType() {
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            return new PrimitiveType((ILocation)cACSLLocation, (IBoogieType)BoogieType.TYPE_BOOL, "bool");
        }

        @Override
        public Expression constructTrue() {
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            return ExpressionFactory.createBooleanLiteral((ILocation)cACSLLocation, (boolean)true);
        }

        @Override
        public Expression constructFalse() {
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            return ExpressionFactory.createBooleanLiteral((ILocation)cACSLLocation, (boolean)false);
        }

        @Override
        public Expression compareWithTrue(Expression expression) {
            return expression;
        }
    }

    public static final class BooleanArrayHelper_Integer
    implements IBooleanArrayHelper {
        @Override
        public ASTType constructBoolReplacementType() {
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            return new PrimitiveType((ILocation)cACSLLocation, (IBoogieType)BoogieType.TYPE_INT, "int");
        }

        @Override
        public Expression constructTrue() {
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            return ExpressionFactory.createIntegerLiteral((ILocation)cACSLLocation, (String)"1");
        }

        @Override
        public Expression constructFalse() {
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            return ExpressionFactory.createIntegerLiteral((ILocation)cACSLLocation, (String)"0");
        }

        @Override
        public Expression compareWithTrue(Expression expression) {
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            return ExpressionFactory.newBinaryExpression((ILocation)cACSLLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression, (Expression)this.constructTrue());
        }
    }

    private static enum HeapWriteMode {
        STORE_CHECKED,
        STORE_UNCHECKED,
        SELECT;

    }

    public static interface IBooleanArrayHelper {
        public ASTType constructBoolReplacementType();

        public Expression constructTrue();

        public Expression constructFalse();

        public Expression compareWithTrue(Expression var1);

        default public Expression constructValue(boolean bl) {
            return bl ? this.constructTrue() : this.constructFalse();
        }
    }

    public static enum MemoryArea {
        STACK,
        HEAP;


        MemoryModelDeclarations getMemoryModelDeclaration() {
            return switch (this) {
                case HEAP -> MemoryModelDeclarations.ULTIMATE_ALLOC_HEAP;
                case STACK -> MemoryModelDeclarations.ULTIMATE_ALLOC_STACK;
                default -> throw new MatchException(null, null);
            };
        }
    }

    static class MemoryModelDeclarationInfo {
        private final MemoryModelDeclarations mMmd;
        private final BoogieType mBoogieType;

        public MemoryModelDeclarationInfo(MemoryModelDeclarations memoryModelDeclarations) {
            this.mMmd = memoryModelDeclarations;
            this.mBoogieType = null;
        }

        public MemoryModelDeclarationInfo(MemoryModelDeclarations memoryModelDeclarations, BoogieType boogieType) {
            this.mMmd = memoryModelDeclarations;
            this.mBoogieType = boogieType;
        }

        IdentifierExpression constructIdentifierExpression(ILocation iLocation) {
            return ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mBoogieType, (String)this.mMmd.getName(), (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
        }

        VariableLHS constructVariableLHS(ILocation iLocation) {
            return ExpressionFactory.constructVariableLHS((ILocation)iLocation, (BoogieType)this.mBoogieType, (String)this.mMmd.getName(), (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
        }

        BoogieType getBoogieType() {
            if (this.mBoogieType == null) {
                throw new IllegalStateException();
            }
            return this.mBoogieType;
        }
    }
}

