/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import java.util.Set;
import java.util.function.Predicate;

public final class SemanticConditionEliminator<L extends IAction>
implements IIndependenceRelation<IPredicate, L> {
    private final IIndependenceRelation<IPredicate, L> mUnderlying;
    private final Predicate<IPredicate> mIsInconsistent;
    private final EliminatorStatistics mStatistics;

    public SemanticConditionEliminator(IIndependenceRelation<IPredicate, L> iIndependenceRelation, Predicate<IPredicate> predicate) {
        assert (iIndependenceRelation.isConditional()) : "Condition elimination for non-conditional relations is useless";
        this.mUnderlying = iIndependenceRelation;
        this.mIsInconsistent = predicate;
        this.mStatistics = new EliminatorStatistics();
    }

    public boolean isSymmetric() {
        return this.mUnderlying.isSymmetric();
    }

    public boolean isConditional() {
        return this.mUnderlying.isConditional();
    }

    public IIndependenceRelation.Dependence isIndependent(IPredicate iPredicate, L l, L l2) {
        IPredicate iPredicate2 = iPredicate == null ? null : this.normalize(iPredicate, l, l2);
        IIndependenceRelation.Dependence dependence = this.mUnderlying.isIndependent((Object)iPredicate2, l, l2);
        this.mStatistics.reportQuery(dependence, iPredicate2 != null);
        return dependence;
    }

    public ISymbolicIndependenceRelation<L, IPredicate> getSymbolicRelation() {
        return this.mUnderlying.getSymbolicRelation();
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    private IPredicate normalize(IPredicate iPredicate, L l, L l2) {
        if (this.mIsInconsistent.test(iPredicate) || SemanticConditionEliminator.isRelevant(iPredicate, l) || SemanticConditionEliminator.isRelevant(iPredicate, l2)) {
            return iPredicate;
        }
        this.mStatistics.reportEliminatedCondition();
        return null;
    }

    public static <L extends IAction> boolean isRelevant(IPredicate iPredicate, L l) {
        return DataStructureUtils.haveNonEmptyIntersection((Set)iPredicate.getVars(), l.getTransformula().getInVars().keySet());
    }

    private class EliminatorStatistics
    extends IndependenceStatisticsDataProvider {
        public static final String ELIMINATED_CONDITIONS = "Eliminated conditions";
        private int mEliminatedConditions;

        public EliminatorStatistics() {
            super(SemanticConditionEliminator.class, SemanticConditionEliminator.this.mUnderlying);
            this.declare(ELIMINATED_CONDITIONS, () -> this.mEliminatedConditions, KeyType.COUNTER);
        }

        private void reportEliminatedCondition() {
            ++this.mEliminatedConditions;
        }
    }
}

