/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.yaml;

import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.FormatVersion;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class MetadataProvider {
    private final FormatVersion mFormatVersion;
    private final String mProducer;
    private final String mProducerVersion;
    private final Map<String, String> mProgramHashes;
    private final String mSpecification;
    private final String mDataModel;
    private final String mLanguage;

    public MetadataProvider(FormatVersion formatVersion, String string, String string2, Map<String, String> map, String string3, String string4, String string5) {
        this.mFormatVersion = formatVersion;
        this.mProducer = string;
        this.mProducerVersion = string2;
        this.mProgramHashes = map;
        this.mSpecification = string3;
        this.mDataModel = MetadataProvider.getDataModel(string4);
        this.mLanguage = string5;
    }

    private static String getDataModel(String string) {
        if (string.contains("32")) {
            return "ILP32";
        }
        if (string.contains("64")) {
            return "LP64";
        }
        return string;
    }

    public Map<String, Object> getFreshMetadata() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("format_version", this.mFormatVersion.toString());
        linkedHashMap.put("uuid", UUID.randomUUID().toString());
        linkedHashMap.put("creation_time", OffsetDateTime.now().truncatedTo(ChronoUnit.SECONDS).toString());
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        linkedHashMap2.put("name", this.mProducer);
        linkedHashMap2.put("version", this.mProducerVersion);
        linkedHashMap.put("producer", linkedHashMap2);
        LinkedHashMap<String, Object> linkedHashMap3 = new LinkedHashMap<String, Object>();
        linkedHashMap3.put("input_files", new ArrayList<String>(this.mProgramHashes.keySet()));
        linkedHashMap3.put("input_file_hashes", new HashMap<String, String>(this.mProgramHashes));
        linkedHashMap3.put("specification", this.mSpecification);
        linkedHashMap3.put("data_model", this.mDataModel);
        linkedHashMap3.put("language", this.mLanguage);
        linkedHashMap.put("task", linkedHashMap3);
        return linkedHashMap;
    }
}

