/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IntervalValue
implements Comparable<IntervalValue> {
    private static int sId;
    private final int mId;
    private final BigDecimal mValue;
    private final boolean mIsInfty;

    public IntervalValue() {
        this.mIsInfty = true;
        this.mValue = null;
        this.mId = ++sId;
    }

    public IntervalValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("val may not be null");
        }
        this.mValue = bigDecimal;
        this.mIsInfty = false;
        this.mId = ++sId;
    }

    public IntervalValue(IntervalValue intervalValue) {
        this.mValue = intervalValue.mValue;
        this.mIsInfty = intervalValue.mIsInfty;
        this.mId = ++sId;
    }

    public IntervalValue(int n) {
        this(new BigDecimal(n));
    }

    public IntervalValue(double d) {
        this(BigDecimal.valueOf(d));
    }

    public IntervalValue(String string) {
        this(AbsIntUtil.sanitizeBigDecimalValue(string));
    }

    public BigDecimal getValue() {
        return this.mValue;
    }

    public boolean isInfinity() {
        return this.mIsInfty;
    }

    public static IntervalValue multiply(IntervalValue intervalValue, IntervalValue intervalValue2) {
        if (intervalValue == null || intervalValue2 == null) {
            throw new IllegalArgumentException("Arguments may not be null");
        }
        if (intervalValue.isInfinity() && intervalValue2.isInfinity()) {
            return new IntervalValue();
        }
        if (intervalValue.isInfinity()) {
            if (intervalValue2.getValue().signum() == 0) {
                return new IntervalValue(0);
            }
            return new IntervalValue();
        }
        if (intervalValue2.isInfinity()) {
            if (intervalValue.getValue().signum() == 0) {
                return new IntervalValue(0);
            }
            return new IntervalValue();
        }
        return new IntervalValue(intervalValue.getValue().multiply(intervalValue2.getValue()));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        IntervalValue intervalValue = (IntervalValue)object;
        if (this.mIsInfty && intervalValue.mIsInfty) {
            return true;
        }
        if (this.mIsInfty && !intervalValue.mIsInfty || !this.mIsInfty && intervalValue.mIsInfty) {
            return false;
        }
        return this.mValue.compareTo(intervalValue.mValue) == 0;
    }

    public int hashCode() {
        return this.mId;
    }

    @Override
    public int compareTo(IntervalValue intervalValue) {
        if (intervalValue == null) {
            throw new UnsupportedOperationException("Empty comparator is not allowed.");
        }
        if (this.mIsInfty && intervalValue.isInfinity()) {
            return 0;
        }
        if (this.mIsInfty && !intervalValue.isInfinity()) {
            return 1;
        }
        if (!this.mIsInfty && intervalValue.isInfinity()) {
            return -1;
        }
        return this.mValue.compareTo(intervalValue.mValue);
    }

    public String toString() {
        if (this.mIsInfty) {
            return "\\infty";
        }
        return this.mValue.toString();
    }

    public Term getTerm(Sort sort, Script script) {
        assert (!this.isInfinity()) : "Cannot convert infinity to Term";
        assert (SmtSortUtils.isNumericSort((Sort)sort)) : "Sort has to be numeric";
        if (SmtSortUtils.isIntSort((Sort)sort)) {
            return SmtUtils.constructIntValue((Script)script, (BigInteger)this.mValue.toBigIntegerExact());
        }
        assert (SmtSortUtils.isRealSort((Sort)sort)) : "Seems that numeric sort now has something different then Int or Real";
        return script.decimal(this.mValue);
    }

    public IntervalValue add(IntervalValue intervalValue) {
        if (this.isInfinity()) {
            return this;
        }
        if (intervalValue.isInfinity()) {
            return intervalValue;
        }
        return new IntervalValue(this.getValue().add(intervalValue.getValue()));
    }

    public IntervalValue subtract(IntervalValue intervalValue) {
        if (this.isInfinity()) {
            return this;
        }
        if (intervalValue.isInfinity()) {
            return intervalValue;
        }
        return new IntervalValue(this.getValue().subtract(intervalValue.getValue()));
    }
}

