/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.HashSet;
import java.util.Set;

public class SymbolCollector
extends NonRecursive {
    private HashSet<FunctionSymbol> mSymbols = new HashSet();
    private HashSet<Term> mVisited = new HashSet();

    public final void collect(Term term) {
        this.run(new CollectWalker(term));
    }

    public Set<FunctionSymbol> getSymbols() {
        HashSet<FunctionSymbol> hashSet = this.mSymbols;
        this.mSymbols = new HashSet();
        this.mVisited = new HashSet();
        return hashSet;
    }

    public static class CollectWalker
    implements NonRecursive.Walker {
        protected Term mTerm;

        public CollectWalker(Term term) {
            this.mTerm = term;
        }

        public void walk(NonRecursive nonRecursive) {
            SymbolCollector symbolCollector = (SymbolCollector)nonRecursive;
            if (!symbolCollector.mVisited.add(this.mTerm)) {
                return;
            }
            if (this.mTerm instanceof ApplicationTerm) {
                Term term;
                ApplicationTerm applicationTerm = (ApplicationTerm)this.mTerm;
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                if (!functionSymbol.isIntern()) {
                    symbolCollector.mSymbols.add(applicationTerm.getFunction());
                }
                if ((term = functionSymbol.getDefinition()) != null) {
                    symbolCollector.enqueueWalker(new CollectWalker(term));
                }
                Term[] termArray = applicationTerm.getParameters();
                int n = 0;
                while (n < termArray.length) {
                    symbolCollector.enqueueWalker(new CollectWalker(termArray[n]));
                    ++n;
                }
            } else if (this.mTerm instanceof LetTerm) {
                LetTerm letTerm = (LetTerm)this.mTerm;
                Term[] termArray = letTerm.getValues();
                int n = 0;
                while (n < termArray.length) {
                    symbolCollector.enqueueWalker(new CollectWalker(termArray[n]));
                    ++n;
                }
                symbolCollector.enqueueWalker(new CollectWalker(letTerm.getSubTerm()));
            } else if (this.mTerm instanceof AnnotatedTerm) {
                symbolCollector.enqueueWalker(new CollectWalker(((AnnotatedTerm)this.mTerm).getSubterm()));
            } else if (this.mTerm instanceof QuantifiedFormula) {
                symbolCollector.enqueueWalker(new CollectWalker(((QuantifiedFormula)this.mTerm).getSubformula()));
            }
        }
    }
}

