/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.CDeclaration;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

final class BoogieProcedureInfo {
    private final String mProcedureName;
    private CFunction mCType;
    private Procedure mDeclaration;
    private Procedure mImplementation;
    private final Set<VariableLHS> mModifiedGlobals;
    private boolean mModifiedGlobalsIsUsedDefined;

    BoogieProcedureInfo(String string) {
        this.mProcedureName = string;
        this.mModifiedGlobals = new LinkedHashSet<VariableLHS>();
    }

    public void resetDeclaration(Procedure procedure) {
        assert (procedure.getSpecification() != null);
        assert (procedure.getBody() == null);
        this.mDeclaration = procedure;
    }

    public boolean hasDeclaration() {
        return this.mDeclaration != null;
    }

    public boolean hasImplementation() {
        return this.mImplementation != null;
    }

    public boolean hasCType() {
        return this.mCType != null;
    }

    public void addModifiedGlobals(Collection<VariableLHS> collection) {
        this.mModifiedGlobals.addAll(collection);
    }

    public void addModifiedGlobal(VariableLHS variableLHS) {
        this.mModifiedGlobals.add(variableLHS);
    }

    public CFunction getCType() {
        if (this.mCType == null) {
            throw new IllegalStateException("query hasCType before calling this");
        }
        return this.mCType;
    }

    public void updateCFunctionAddParam(CDeclaration cDeclaration) {
        CDeclaration[] cDeclarationArray;
        if (this.hasCType()) {
            CDeclaration[] cDeclarationArray2 = this.getCType().getParameterTypes();
            cDeclarationArray = Arrays.copyOf(cDeclarationArray2, cDeclarationArray2.length + 1);
            cDeclarationArray[cDeclarationArray.length - 1] = cDeclaration;
        } else {
            cDeclarationArray = new CDeclaration[]{cDeclaration};
        }
        this.updateCFunctionReplaceParams(cDeclarationArray);
    }

    public void updateCFunctionReplaceParams(CDeclaration[] cDeclarationArray) {
        this.mCType = this.hasCType() ? this.mCType.newParameter(cDeclarationArray) : CFunction.createEmptyCFunction().newParameter(cDeclarationArray);
    }

    public void updateCFunction(CFunction cFunction) {
        this.mCType = cFunction;
    }

    public Procedure getDeclaration() {
        if (this.mDeclaration == null) {
            throw new IllegalStateException("query hasDeclaration() first");
        }
        return this.mDeclaration;
    }

    public void setDefaultDeclarationAndCType(ILocation iLocation, ASTType aSTType) {
        this.setDefaultDeclaration(iLocation, aSTType);
        this.mCType = CFunction.createDefaultCFunction();
    }

    void setDefaultDeclaration(ILocation iLocation, ASTType aSTType) {
        this.setDeclaration(new Procedure(iLocation, new Attribute[0], this.mProcedureName, new String[0], new VarList[0], new VarList[]{new VarList(iLocation, new String[]{"#res"}, aSTType)}, new Specification[0], null));
    }

    void setDeclaration(Procedure procedure) {
        assert (this.mDeclaration == null) : "can only be set once!";
        assert (procedure.getSpecification() != null);
        assert (procedure.getBody() == null);
        this.mDeclaration = procedure;
    }

    public Procedure getImplementation() {
        return this.mImplementation;
    }

    void setImplementation(Procedure procedure) {
        assert (this.mImplementation == null) : "can only be set once!";
        assert (procedure.getSpecification() == null);
        assert (procedure.getBody() != null);
        this.mImplementation = procedure;
    }

    public boolean isModifiedGlobalsIsUsedDefined() {
        return this.mModifiedGlobalsIsUsedDefined;
    }

    public void setModifiedGlobalsIsUsedDefined(boolean bl) {
        this.mModifiedGlobalsIsUsedDefined = bl;
    }

    public String getProcedureName() {
        return this.mProcedureName;
    }

    public Set<VariableLHS> getModifiedGlobals() {
        return Collections.unmodifiableSet(this.mModifiedGlobals);
    }

    public String toString() {
        return this.mProcedureName + " : " + String.valueOf(this.mCType);
    }
}

