/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RangeDecision
extends Decision<RangeDecision> {
    public static final int OP_LT = -2;
    public static final int OP_LTEQ = -1;
    public static final int OP_EQ = 0;
    public static final int OP_GTEQ = 1;
    public static final int OP_GT = 2;
    public static final int OP_NEQ = 4;
    public static final int OP_INVALID = 5;
    private static final CDD[] FTF = new CDD[]{CDD.FALSE, CDD.TRUE, CDD.FALSE};
    private static final CDD[] TFT = new CDD[]{CDD.TRUE, CDD.FALSE, CDD.TRUE};
    private final String mVar;
    private final int[] mLimits;

    public RangeDecision(String string, int[] nArray) {
        this.mVar = string;
        this.mLimits = nArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        RangeDecision rangeDecision = (RangeDecision)object;
        if (!this.mVar.equals(rangeDecision.mVar)) {
            return false;
        }
        int n = 0;
        while (n < this.mLimits.length) {
            if (this.mLimits[n] != rangeDecision.mLimits[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.mVar.hashCode();
        int n2 = 0;
        while (n2 < this.mLimits.length) {
            n = n * (n2 + 13) ^ this.mLimits[n2];
            ++n2;
        }
        return n;
    }

    @Override
    public CDD simplify(CDD[] cDDArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.mLimits.length) {
            if (cDDArray[n2] != cDDArray[n2 + 1]) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return cDDArray[0];
        }
        if (n < this.mLimits.length) {
            int[] nArray = new int[n];
            CDD[] cDDArray2 = new CDD[++n];
            n = 0;
            int n3 = 0;
            while (n3 < this.mLimits.length) {
                if (cDDArray[n3] != cDDArray[n3 + 1]) {
                    cDDArray2[n] = cDDArray[n3];
                    nArray[n] = this.mLimits[n3];
                    ++n;
                }
                ++n3;
            }
            cDDArray2[n] = cDDArray[this.mLimits.length];
            return CDD.create(new RangeDecision(this.mVar, nArray), cDDArray2);
        }
        return CDD.create(this, cDDArray);
    }

    public static CDD create(String string, int n, int n2) {
        switch (n) {
            case 0: {
                return CDD.create(new RangeDecision(string, new int[]{2 * n2, 2 * n2 + 1}), FTF);
            }
            case 4: {
                return CDD.create(new RangeDecision(string, new int[]{2 * n2, 2 * n2 + 1}), TFT);
            }
            case -2: {
                return CDD.create(new RangeDecision(string, new int[]{2 * n2}), CDD.TRUE_CHILDS);
            }
            case -1: {
                return CDD.create(new RangeDecision(string, new int[]{2 * n2 + 1}), CDD.TRUE_CHILDS);
            }
            case 2: {
                return CDD.create(new RangeDecision(string, new int[]{2 * n2 + 1}), CDD.FALSE_CHILDS);
            }
            case 1: {
                return CDD.create(new RangeDecision(string, new int[]{2 * n2}), CDD.FALSE_CHILDS);
            }
        }
        throw new IllegalArgumentException("op = " + n);
    }

    @Override
    public CDD and(Decision<?> decision, CDD[] cDDArray, CDD[] cDDArray2, Map<CDD, Map<CDD, CDD>> map) {
        int[] nArray = ((RangeDecision)decision).mLimits;
        CDD[] cDDArray3 = new CDD[cDDArray.length + cDDArray2.length - 1];
        int[] nArray2 = new int[this.mLimits.length + nArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray.length || n3 < this.mLimits.length) {
            cDDArray3[n] = cDDArray[n3].and(cDDArray2[n2], map);
            if (n > 0 && cDDArray3[n] == cDDArray3[n - 1]) {
                --n;
            }
            if (n2 == nArray.length || n3 < this.mLimits.length && this.mLimits[n3] < nArray[n2]) {
                nArray2[n] = this.mLimits[n3];
                ++n3;
            } else {
                if (n3 < this.mLimits.length && this.mLimits[n3] == nArray[n2]) {
                    ++n3;
                }
                nArray2[n] = nArray[n2];
                ++n2;
            }
            ++n;
        }
        cDDArray3[n] = cDDArray[n3].and(cDDArray2[n2], map);
        if (n > 0 && cDDArray3[n] == cDDArray3[n - 1]) {
            --n;
        }
        if (n == 0) {
            return cDDArray3[0];
        }
        if (n != nArray2.length) {
            int[] nArray3 = new int[n];
            System.arraycopy(nArray2, 0, nArray3, 0, n);
            nArray2 = nArray3;
            CDD[] cDDArray4 = new CDD[n + 1];
            System.arraycopy(cDDArray3, 0, cDDArray4, 0, n + 1);
            cDDArray3 = cDDArray4;
        }
        return CDD.create(new RangeDecision(this.mVar, nArray2), cDDArray3);
    }

    @Override
    public CDD or(Decision<?> decision, CDD[] cDDArray, CDD[] cDDArray2, Map<CDD, Map<CDD, CDD>> map) {
        int[] nArray = ((RangeDecision)decision).mLimits;
        CDD[] cDDArray3 = new CDD[cDDArray.length + cDDArray2.length - 1];
        int[] nArray2 = new int[this.mLimits.length + nArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray.length || n3 < this.mLimits.length) {
            cDDArray3[n] = cDDArray[n3].or(cDDArray2[n2], map);
            if (n > 0 && cDDArray3[n] == cDDArray3[n - 1]) {
                --n;
            }
            if (n2 == nArray.length || n3 < this.mLimits.length && this.mLimits[n3] < nArray[n2]) {
                nArray2[n] = this.mLimits[n3];
                ++n3;
            } else {
                if (n3 < this.mLimits.length && this.mLimits[n3] == nArray[n2]) {
                    ++n3;
                }
                nArray2[n] = nArray[n2];
                ++n2;
            }
            ++n;
        }
        cDDArray3[n] = cDDArray[n3].or(cDDArray2[n2], map);
        if (n > 0 && cDDArray3[n] == cDDArray3[n - 1]) {
            --n;
        }
        if (n == 0) {
            return cDDArray3[0];
        }
        if (n != nArray2.length) {
            int[] nArray3 = new int[n];
            System.arraycopy(nArray2, 0, nArray3, 0, n);
            nArray2 = nArray3;
            CDD[] cDDArray4 = new CDD[n + 1];
            System.arraycopy(cDDArray3, 0, cDDArray4, 0, n + 1);
            cDDArray3 = cDDArray4;
        }
        return CDD.create(new RangeDecision(this.mVar, nArray2), cDDArray3);
    }

    @Override
    public CDD assume(Decision<?> decision, CDD[] cDDArray, CDD[] cDDArray2) {
        int[] nArray = ((RangeDecision)decision).mLimits;
        CDD[] cDDArray3 = new CDD[cDDArray.length + cDDArray2.length - 1];
        int[] nArray2 = new int[this.mLimits.length + nArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        CDD cDD = null;
        while (n2 < nArray.length || n3 < this.mLimits.length) {
            cDDArray3[n] = cDDArray[n3].assume(cDDArray2[n2]);
            if (n > 0 && cDDArray3[n].and(cDDArray2[n2]).implies(cDDArray3[n - 1]) && cDDArray3[n - 1].and(cDD).implies(cDDArray3[n])) {
                cDDArray3[n - 1] = cDDArray3[n].and(cDDArray3[n - 1]);
                --n;
            }
            cDD = cDDArray2[n2];
            if (n2 == nArray.length || n3 < this.mLimits.length && this.mLimits[n3] < nArray[n2]) {
                nArray2[n] = this.mLimits[n3];
                ++n3;
            } else {
                if (n3 < this.mLimits.length && this.mLimits[n3] == nArray[n2]) {
                    ++n3;
                }
                nArray2[n] = nArray[n2];
                ++n2;
            }
            ++n;
        }
        cDDArray3[n] = cDDArray[n3].assume(cDDArray2[n2]);
        if (n > 0 && cDDArray3[n].and(cDDArray2[n2]).implies(cDDArray3[n - 1]) && cDDArray3[n - 1].and(cDD).implies(cDDArray3[n])) {
            cDDArray3[n - 1] = cDDArray3[n].and(cDDArray3[n - 1]);
            --n;
        }
        if (n == 0) {
            return cDDArray3[0];
        }
        if (n != nArray2.length) {
            int[] nArray3 = new int[n];
            System.arraycopy(nArray2, 0, nArray3, 0, n);
            nArray2 = nArray3;
            CDD[] cDDArray4 = new CDD[n + 1];
            System.arraycopy(cDDArray3, 0, cDDArray4, 0, n + 1);
            cDDArray3 = cDDArray4;
        }
        return CDD.create(new RangeDecision(this.mVar, nArray2), cDDArray3);
    }

    @Override
    public boolean implies(Decision<?> decision, CDD[] cDDArray, CDD[] cDDArray2) {
        int[] nArray = ((RangeDecision)decision).mLimits;
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length || n < this.mLimits.length) {
            if (!cDDArray[n].implies(cDDArray2[n2])) {
                return false;
            }
            if (n2 == nArray.length || n < this.mLimits.length && this.mLimits[n] < nArray[n2]) {
                ++n;
                continue;
            }
            if (n < this.mLimits.length && this.mLimits[n] == nArray[n2]) {
                ++n;
            }
            ++n2;
        }
        return cDDArray[n].implies(cDDArray2[n2]);
    }

    @Override
    public String toString(int n) {
        return this.getInfixString(this.mVar, " \u2264 ", " < ", " \u2265 ", " > ", " == ", " \u02c4 ", n);
    }

    @Override
    public String toTexString(int n) {
        return this.getInfixString(this.mVar, " \\leq ", " < ", " \\geq ", " > ", " == ", " \\land ", n);
    }

    @Override
    public String toBoogieString(int n) {
        return this.getInfixString(this.mVar, " <= ", " < ", " >= ", " > ", " == ", " && ", n);
    }

    @Override
    public String toUppaalString(int n) {
        String string = this.mVar;
        if (string.charAt(string.length() - 1) == '\'') {
            string = string.substring(0, string.length() - 1);
        }
        return this.getInfixString(string, " &lt;= ", " &lt; ", " &gt;= ", " &gt; ", " == ", " &amp;&amp;", n);
    }

    @Override
    public String toUppaalStringDOM(int n) {
        String string = this.mVar;
        if (string.charAt(string.length() - 1) == '\'') {
            string = string.substring(0, string.length() - 1);
        }
        return this.getInfixString(string, " <= ", " < ", " >= ", " > ", " == ", " && ", n);
    }

    private String getInfixString(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n) {
        if (n == 0) {
            return string + ((this.mLimits[0] & 1) == 0 ? string3 : string2) + this.mLimits[0] / 2;
        }
        if (n == this.mLimits.length) {
            return string + ((this.mLimits[this.mLimits.length - 1] & 1) == 1 ? string5 : string4) + this.mLimits[this.mLimits.length - 1] / 2;
        }
        if (this.mLimits[n - 1] / 2 == this.mLimits[n] / 2) {
            return string + string6 + this.mLimits[n] / 2;
        }
        return string + ((this.mLimits[n - 1] & 1) == 1 ? string5 : string4) + this.mLimits[n - 1] / 2 + string7 + string + ((this.mLimits[n] & 1) == 0 ? string3 : string2) + this.mLimits[n] / 2;
    }

    @Override
    public String toSmtString(int n) {
        String string = "(- T_ " + this.mVar + ")";
        if (n == 0) {
            return "( " + ((this.mLimits[0] & 1) == 0 ? " < " : " <= ") + string + " " + this.mLimits[0] / 2 + ".0)";
        }
        if (n == this.mLimits.length) {
            return "( " + ((this.mLimits[this.mLimits.length - 1] & 1) == 1 ? " > " : " >= ") + string + " " + this.mLimits[this.mLimits.length - 1] / 2 + ".0)";
        }
        if (this.mLimits[n - 1] / 2 == this.mLimits[n] / 2) {
            return " (= " + string + " " + this.mLimits[n] / 2 + ".0)";
        }
        return "(and (" + ((this.mLimits[n - 1] & 1) == 1 ? " < " : " <= ") + this.mLimits[n - 1] / 2 + ".0 " + string + ") (" + ((this.mLimits[n] & 1) == 0 ? " < " : ".0 <= ") + string + " " + this.mLimits[n] / 2 + "0. ))";
    }

    public int getVal(int n) {
        if (n == 0 || n == 1) {
            return this.mLimits[0] / 2;
        }
        return -1;
    }

    public int getOp(int n) {
        if (n == 0) {
            return (this.mLimits[0] & 1) == 0 ? -2 : -1;
        }
        if (n == this.mLimits.length) {
            return (this.mLimits[this.mLimits.length - 1] & 1) == 1 ? 2 : 1;
        }
        if (this.mLimits[n - 1] / 2 == this.mLimits[n] / 2) {
            return 0;
        }
        return 5;
    }

    @Override
    public String getVar() {
        return this.mVar;
    }

    public int[] getLimits() {
        return this.mLimits;
    }

    @Override
    public RangeDecision prime(Set<String> set) {
        if (set.contains(this.mVar)) {
            return this;
        }
        String string = this.mVar + "'";
        int[] nArray = (int[])this.mLimits.clone();
        return new RangeDecision(string, nArray);
    }

    @Override
    public RangeDecision unprime(Set<String> set) {
        if (set.contains(this.mVar)) {
            return this;
        }
        String string = this.mVar;
        if (this.mVar.endsWith("'")) {
            string = this.mVar.substring(0, this.mVar.length() - 1);
        }
        int[] nArray = (int[])this.mLimits.clone();
        return new RangeDecision(string, nArray);
    }

    @Override
    public int compareToSimilar(Decision<?> decision) {
        return this.mVar.compareTo(((RangeDecision)decision).mVar);
    }

    public static CDD filterCdd(CDD cDD, String[] stringArray) {
        List<List<Pair<Decision<?>, int[]>>> list = cDD.getDecisionsDNF();
        List<String> list2 = Arrays.asList(stringArray);
        ArrayList<CDD> arrayList = new ArrayList<CDD>();
        CDD cDD2 = CDD.FALSE;
        for (List<Pair<Decision<?>, int[]>> object : list) {
            CDD cDD3 = CDD.TRUE;
            for (Pair<Decision<?>, int[]> pair : object) {
                Decision decision = (Decision)pair.getFirst();
                assert (decision instanceof RangeDecision);
                RangeDecision rangeDecision = (RangeDecision)decision;
                String string = rangeDecision.getVar();
                if (list2.contains(string)) continue;
                int n = ((int[])pair.getSecond())[0];
                CDD cDD4 = RangeDecision.create(string, rangeDecision.getOp(n), rangeDecision.getVal(n));
                cDD3 = cDD3.and(cDD4);
            }
            arrayList.add(cDD3);
        }
        for (CDD cDD5 : arrayList) {
            cDD2 = cDD2.or(cDD5);
        }
        return cDD2;
    }

    public static CDD strict(CDD cDD) {
        List<List<Pair<Decision<?>, int[]>>> list = cDD.getDecisionsDNF();
        ArrayList<CDD> arrayList = new ArrayList<CDD>();
        CDD cDD2 = CDD.FALSE;
        for (List<Pair<Decision<?>, int[]>> object : list) {
            CDD cDD3 = CDD.TRUE;
            for (Pair<Decision<?>, int[]> pair : object) {
                CDD cDD4;
                Decision decision = (Decision)pair.getFirst();
                int n = ((int[])pair.getSecond())[0];
                assert (decision instanceof RangeDecision);
                RangeDecision rangeDecision = (RangeDecision)decision;
                String string = rangeDecision.getVar();
                int n2 = rangeDecision.getOp(n);
                int[] nArray = rangeDecision.getLimits();
                assert (nArray.length == 1);
                if (n2 == -1) {
                    cDD4 = RangeDecision.create(string, -2, rangeDecision.getVal(n));
                    cDD3 = cDD3.and(cDD4);
                    continue;
                }
                if (n2 == 1) {
                    cDD4 = RangeDecision.create(string, 2, rangeDecision.getVal(n));
                    cDD3 = cDD3.and(cDD4);
                    continue;
                }
                cDD4 = RangeDecision.create(string, n2, rangeDecision.getVal(n));
                cDD3 = cDD3.and(cDD4);
            }
            arrayList.add(cDD3);
        }
        for (CDD cDD5 : arrayList) {
            cDD2 = cDD2.or(cDD5);
        }
        return cDD2;
    }

    public static boolean isStrictLess(CDD cDD) {
        if (cDD == CDD.TRUE || cDD == CDD.FALSE) {
            return false;
        }
        RangeDecision rangeDecision = (RangeDecision)cDD.getDecision();
        if (rangeDecision.getOp(0) == -2) {
            return true;
        }
        assert (cDD.getChilds().length == 2);
        return RangeDecision.isStrictLess(cDD.getChilds()[0]) || RangeDecision.isStrictLess(cDD.getChilds()[1]);
    }
}

