/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models.annotation;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.DefaultLocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MergedLocation
extends DefaultLocation {
    private static final String MSG_UNKNOWN = "UNKNOWN";
    private static final long serialVersionUID = 1L;
    private final List<ILocation> mOriginLocations;

    private MergedLocation(String string, int n, int n2, int n3, int n4, List<ILocation> list) {
        super(string, n, n2, n3, n4);
        this.mOriginLocations = Objects.requireNonNull(list);
    }

    @Visualizable
    public List<ILocation> getOriginLocations() {
        return Collections.unmodifiableList(this.mOriginLocations);
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        if (iAnnotations instanceof MergedLocation) {
            MergedLocation mergedLocation = (MergedLocation)iAnnotations;
            ArrayList<ILocation> arrayList = new ArrayList<ILocation>(this.getOriginLocations());
            arrayList.addAll(mergedLocation.getOriginLocations());
            return MergedLocation.mergeNonMergeLocation(this, mergedLocation, arrayList);
        }
        if (iAnnotations instanceof ILocation) {
            return MergedLocation.mergeToMergeLocation(this, (ILocation)iAnnotations);
        }
        return super.merge(iAnnotations);
    }

    private static ILocation mergeNonMergeLocation(ILocation iLocation, ILocation iLocation2, List<ILocation> list) {
        int n;
        int n2;
        int n3;
        int n4;
        String string;
        if (Objects.equals(iLocation.getFileName(), iLocation2.getFileName())) {
            string = iLocation.getFileName();
            Pair<Integer, Integer> pair = MergedLocation.mergeInterval(iLocation.getStartLine(), iLocation.getEndLine(), iLocation2.getStartLine(), iLocation2.getEndLine());
            Pair<Integer, Integer> pair2 = MergedLocation.mergeInterval(iLocation.getStartColumn(), iLocation.getEndColumn(), iLocation2.getStartColumn(), iLocation2.getEndColumn());
            n4 = (Integer)pair.getFirst();
            n3 = (Integer)pair.getSecond();
            n2 = (Integer)pair2.getFirst();
            n = (Integer)pair2.getSecond();
        } else {
            string = MSG_UNKNOWN;
            n4 = -1;
            n3 = -1;
            n2 = -1;
            n = -1;
        }
        return new MergedLocation(string, n4, n3, n2, n, list);
    }

    public static Pair<Integer, Integer> mergeInterval(int n, int n2, int n3, int n4) {
        int n5 = n < 0 || n3 < 0 ? -1 : (n <= n3 ? n : n3);
        int n6 = n2 < 0 || n4 < 0 ? -1 : (n2 <= n4 ? n4 : n2);
        return new Pair((Object)n5, (Object)n6);
    }

    public static ILocation mergeToMergeLocation(ILocation iLocation, ILocation iLocation2) {
        if (iLocation == null) {
            return iLocation2;
        }
        if (iLocation2 == null) {
            return iLocation;
        }
        if (iLocation instanceof MergedLocation && iLocation2 instanceof MergedLocation) {
            return (ILocation)iLocation.merge((IAnnotations)iLocation2);
        }
        ArrayList<ILocation> arrayList = new ArrayList<ILocation>(2);
        arrayList.add(iLocation);
        arrayList.add(iLocation2);
        return MergedLocation.mergeNonMergeLocation(iLocation, iLocation2, arrayList);
    }

    @Override
    public String toString() {
        return "Merged: " + this.getOriginLocations().stream().map(iLocation -> iLocation.toString()).collect(Collectors.joining(", "));
    }
}

