/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.UnknownState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.TraceCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheck;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ConstantTermNormalizer;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class NestedInterpolantsBuilder<L extends IAction> {
    private static final int SKIPPED_POSITION_FOR_RECURSIVE_COMPUTATION = -47;
    private static final int SKIPPED_POSITION_FOR_REPETITION = -82;
    private static final boolean ALLOW_AT_DIFF = true;
    public static final String DIFF_IS_UNSUPPORTED = "@diff is unsupported";
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final boolean mInstantiateArrayExt;
    private final ManagedScript mMgdScriptCfg;
    private final IPredicateUnifier mPredicateUnifier;
    private final BasicPredicateFactory mPredicateFactory;
    private final Set<Integer> mSkippedInnerProcedurePositions;
    private final Function<Term, Term> mConst2RepTvSubst;
    private final int[] mPositionMapping;
    private final Term[] mCraigInterpolants;
    private final IPredicate[] mInterpolants;
    private final NestedWord<L> mTrace;
    private final IPredicate mPrecondition;
    private final IPredicate mPostcondition;

    public NestedInterpolantsBuilder(ManagedScript managedScript, TraceCheck.TraceCheckLock traceCheckLock, NestedFormulas<L, Term, Term> nestedFormulas, Map<Term, IProgramVar> map, IPredicateUnifier iPredicateUnifier, BasicPredicateFactory basicPredicateFactory, Set<Integer> set, boolean bl, IUltimateServiceProvider iUltimateServiceProvider, TraceCheck<L> traceCheck, ManagedScript managedScript2, boolean bl2, SmtUtils.SimplificationTechnique simplificationTechnique, IPredicate iPredicate, IPredicate iPredicate2) {
        Map.Entry<Term, IProgramVar> entry2;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(TraceCheckerUtils.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
        this.mMgdScriptCfg = managedScript2;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mPredicateFactory = basicPredicateFactory;
        this.mSkippedInnerProcedurePositions = set;
        this.mTrace = nestedFormulas.getTrace();
        this.mPrecondition = iPredicate;
        this.mPostcondition = iPredicate2;
        this.mInstantiateArrayExt = bl2;
        HashMap<Term, TermVariable> hashMap = new HashMap<Term, TermVariable>();
        for (Map.Entry<Term, IProgramVar> entry2 : map.entrySet()) {
            hashMap.put(entry2.getKey(), entry2.getValue().getTermVariable());
        }
        this.mConst2RepTvSubst = managedScript != managedScript2 ? term -> new TermTransferrer(managedScript.getScript(), this.mMgdScriptCfg.getScript(), (Map)hashMap, true).transform(term) : term -> Substitution.apply((ManagedScript)this.mMgdScriptCfg, (Map)hashMap, (Term)term);
        entry2 = NestedInterpolantsBuilder.generateInterpolationInput(managedScript, nestedFormulas, this.mSkippedInnerProcedurePositions);
        Term[] termArray = (Term[])entry2.getFirst();
        int[] nArray = (int[])entry2.getSecond();
        int[] nArray2 = (int[])entry2.getThird();
        this.mPositionMapping = nArray2;
        this.mCraigInterpolants = bl ? managedScript.getInterpolants((Object)traceCheckLock, termArray, nArray) : managedScript.getInterpolants((Object)traceCheckLock, termArray);
        traceCheck.cleanupAndUnlockSolver();
        int n = 0;
        while (n < this.mCraigInterpolants.length) {
            this.mLogger.debug((Object)new DebugMessage("NestedInterpolant {0}: {1}", new Object[]{n, this.mCraigInterpolants[n]}));
            ++n;
        }
        this.mInterpolants = this.buildPredicates();
        assert (this.mInterpolants != null);
    }

    private static <L extends IAction> Triple<Term[], int[], int[]> generateInterpolationInput(ManagedScript managedScript, NestedFormulas<L, Term, Term> nestedFormulas, Set<Integer> set) {
        List<Term> list;
        NestedWord<L> nestedWord = nestedFormulas.getTrace();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int[] nArray = new int[nestedWord.length() - 1];
        int n = 0;
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        int n2 = 0;
        while (n2 < nestedFormulas.getTrace().length()) {
            boolean bl;
            if (nestedWord.isInternalPosition(n2)) {
                list = NestedInterpolantsBuilder.getAnnotatedFormulasForInternalPosition(nestedFormulas, n2);
            } else if (nestedWord.isCallPosition(n2)) {
                if (!nestedWord.isPendingCall(n2)) {
                    int n3 = arrayList.size();
                    arrayDeque.push(n);
                    n = n3;
                    list = NestedInterpolantsBuilder.getAnnotatedFormulasForNonPendingCallPosition(nestedFormulas, n2);
                } else {
                    list = NestedInterpolantsBuilder.getAnnotatedFormulasForPendingCallPosition(nestedFormulas, n2);
                }
            } else if (nestedWord.isReturnPosition(n2)) {
                if (nestedWord.isPendingReturn(n2)) {
                    list = NestedInterpolantsBuilder.getAnnotatedFormulasForPendingReturnPosition(nestedFormulas, n2);
                } else {
                    n = (Integer)arrayDeque.pop();
                    int n4 = nestedWord.getCallPosition(n2);
                    list = NestedInterpolantsBuilder.getAnnotatedFormulasForNonPendingReturnPosition(nestedFormulas, n2, n4);
                }
            } else {
                throw new AssertionError((Object)"Each position must be either internal, call, or return");
            }
            if (n2 == nestedFormulas.getTrace().length() - 1) {
                list.add(nestedFormulas.getPostcondition());
            }
            if (n2 == 0 && (!nestedWord.isCallPosition(n2) || nestedWord.isPendingCall(n2))) {
                list.add(nestedFormulas.getPrecondition());
            }
            if (nestedWord.isReturnPosition(n2) && !nestedWord.isPendingReturn(n2) && nestedWord.getCallPosition(n2) == 0) {
                list.add(nestedFormulas.getPrecondition());
            }
            Term term = SmtUtils.and((Script)managedScript.getScript(), list);
            boolean bl2 = arrayList.size() > n;
            boolean bl3 = bl = (!bl2 || !set.contains(n2 - 1)) && !list.isEmpty();
            if (bl) {
                arrayList.add(term);
                arrayList2.add(n);
            } else if (!list.isEmpty()) {
                int n5 = arrayList.size() - 1;
                Term term2 = SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{(Term)arrayList.get(n5), term});
                assert (term2 != null) : "newFormula must be != null";
                arrayList.set(n5, term2);
            }
            if (n2 != nestedFormulas.getTrace().length() - 1) {
                nArray[n2] = set.contains(n2) ? -47 : (list.isEmpty() ? -82 : arrayList.size() - 1);
            }
            ++n2;
        }
        Term[] termArray = arrayList.toArray(new Term[arrayList.size()]);
        list = (List<Term>)NestedInterpolantsBuilder.integerListToIntArray(arrayList2);
        return new Triple((Object)termArray, (Object)list, (Object)nArray);
    }

    private static <L extends IAction> List<Term> getAnnotatedFormulasForInternalPosition(NestedFormulas<L, Term, Term> nestedFormulas, int n) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Term term = nestedFormulas.getFormulaFromNonCallPos(n);
        if (term != null) {
            arrayList.add(term);
        }
        return arrayList;
    }

    private static <L extends IAction> List<Term> getAnnotatedFormulasForNonPendingCallPosition(NestedFormulas<L, Term, Term> nestedFormulas, int n) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Term term = nestedFormulas.getGlobalVarAssignment(n);
        if (term != null) {
            arrayList.add(term);
        }
        return arrayList;
    }

    private static <L extends IAction> List<Term> getAnnotatedFormulasForPendingCallPosition(NestedFormulas<L, Term, Term> nestedFormulas, int n) {
        Term term;
        Term term2;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Term term3 = nestedFormulas.getLocalVarAssignment(n);
        if (term3 != null) {
            arrayList.add(term3);
        }
        if ((term2 = nestedFormulas.getGlobalVarAssignment(n)) != null) {
            arrayList.add(term2);
        }
        if ((term = nestedFormulas.getOldVarAssignment(n)) != null) {
            arrayList.add(term);
        }
        return arrayList;
    }

    private static <L extends IAction> List<Term> getAnnotatedFormulasForNonPendingReturnPosition(NestedFormulas<L, Term, Term> nestedFormulas, int n, int n2) {
        Term term;
        Term term2;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Term term3 = nestedFormulas.getFormulaFromNonCallPos(n);
        if (term3 != null) {
            arrayList.add(term3);
        }
        if ((term2 = nestedFormulas.getLocalVarAssignment(n2)) != null) {
            arrayList.add(term2);
        }
        if ((term = nestedFormulas.getOldVarAssignment(n2)) != null) {
            arrayList.add(term);
        }
        return arrayList;
    }

    private static <L extends IAction> List<Term> getAnnotatedFormulasForPendingReturnPosition(NestedFormulas<L, Term, Term> nestedFormulas, int n) {
        Term term;
        Term term2;
        Term term3;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Term term4 = nestedFormulas.getFormulaFromNonCallPos(n);
        if (term4 != null) {
            arrayList.add(term4);
        }
        if ((term3 = nestedFormulas.getLocalVarAssignment(n)) != null) {
            arrayList.add(term3);
        }
        if ((term2 = nestedFormulas.getOldVarAssignment(n)) != null) {
            arrayList.add(term2);
        }
        if ((term = nestedFormulas.getPendingContext(n)) != null) {
            arrayList.add(term);
        }
        return arrayList;
    }

    private static int[] integerListToIntArray(List<Integer> list) {
        int[] nArray = new int[list.size()];
        int n = 0;
        while (n < list.size()) {
            nArray[n] = list.get(n);
            ++n;
        }
        return nArray;
    }

    public IPredicate[] getNestedInterpolants() {
        int n = 0;
        while (n < this.mInterpolants.length) {
            this.mLogger.debug((Object)new DebugMessage("Interpolant {0}: {1}", new Object[]{n, this.mInterpolants[n]}));
            ++n;
        }
        return this.mInterpolants;
    }

    private IPredicate[] buildPredicates() {
        IPredicate[] iPredicateArray = new IPredicate[this.mPositionMapping.length];
        HashMap<Term, UnknownState> hashMap = new HashMap<Term, UnknownState>();
        int n = 0;
        while (n < this.mPositionMapping.length) {
            Object object;
            int n2 = this.mPositionMapping[n];
            if (n2 == -47) {
                assert (this.mSkippedInnerProcedurePositions.contains(n));
                object = this.mPredicateFactory.newDontCarePredicate(null);
            } else if (n2 == -82) {
                if (this.mTrace.isCallPosition(n)) {
                    object = this.mTrace.isPendingCall(n) ? iPredicateArray[n - 1] : this.mPredicateUnifier.getTruePredicate();
                } else if (this.mTrace.isReturnPosition(n)) {
                    if (this.mTrace.isPendingReturn(n)) {
                        throw new AssertionError((Object)"Pending returns are unsupported");
                    }
                    int n3 = this.mTrace.getCallPosition(n);
                    var6_6 = n3 == 0 ? this.mPrecondition : iPredicateArray[n3 - 1];
                    var7_7 = iPredicateArray[n - 1];
                    object = this.mPredicateFactory.isDontCare(var7_7) ? var6_6 : this.mPredicateUnifier.getOrConstructPredicateForConjunction(Arrays.asList(var6_6, var7_7));
                } else {
                    object = n == 0 ? this.mPrecondition : (n2 == this.mCraigInterpolants.length ? this.mPostcondition : iPredicateArray[n - 1]);
                }
            } else {
                var6_6 = this.mCraigInterpolants[n2];
                var7_7 = (IPredicate)hashMap.get(var6_6);
                if (var7_7 != null) {
                    object = var7_7;
                } else {
                    Term term = this.postprocessInterpolant(var6_6);
                    object = this.mPredicateUnifier.getOrConstructPredicate(term);
                    hashMap.put(var6_6, (UnknownState)object);
                }
            }
            iPredicateArray[n] = object;
            ++n;
        }
        return iPredicateArray;
    }

    private int getLastInterpolantFromSameContext(int n, int[] nArray) {
        if (this.mTrace.isCallPosition(n)) {
            return n;
        }
        do {
            if (this.mTrace.isReturnPosition(n)) {
                if (this.mTrace.isPendingReturn(n)) {
                    throw new AssertionError((Object)"Pending returns not yet supported.");
                }
                n = this.mTrace.getCallPosition(n);
            }
            if (--n == -1) {
                return n;
            }
            if (!this.mTrace.isCallPosition(n)) continue;
            return n;
        } while (nArray[n] == -47 || nArray[n] == -82);
        return n;
    }

    private Term postprocessInterpolant(Term term) {
        Term term2 = new FormulaUnLet().transform(term);
        Term term3 = this.mConst2RepTvSubst.apply(term2);
        if (this.mInstantiateArrayExt) {
            term3 = this.instantiateArrayExt(term3);
        }
        Term term4 = new ConstantTermNormalizer().transform(term3);
        Term term5 = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScriptCfg, (Term)term4, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique);
        return term5;
    }

    private void checkTimeout() {
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            throw new ToolchainCanceledException(this.getClass(), "constructing predicates for " + (this.mPositionMapping.length - 1) + " interpolants");
        }
    }

    private Term instantiateArrayExt(Term term) {
        ApplicationTerm applicationTerm2;
        Term term2 = new NnfTransformer(this.mMgdScriptCfg, this.mServices, NnfTransformer.QuantifierHandling.PULL).transform(term);
        QuantifierSequence quantifierSequence = new QuantifierSequence(this.mMgdScriptCfg, term2);
        Term term3 = quantifierSequence.getInnerTerm();
        Set set = SmtUtils.extractApplicationTerms((String)"array-ext", (Term)term, (boolean)false);
        if (set.isEmpty()) {
            return term;
        }
        Term[] termArray = new Term[set.size()];
        TermVariable[] termVariableArray = new TermVariable[set.size()];
        HashMap<ApplicationTerm, TermVariable> hashMap = new HashMap<ApplicationTerm, TermVariable>();
        int n = 0;
        for (ApplicationTerm applicationTerm2 : set) {
            ArrayExtTerm arrayExtTerm = new ArrayExtTerm(applicationTerm2);
            termVariableArray[n] = arrayExtTerm.getReplacementTermVariable();
            termArray[n] = arrayExtTerm.getImplication();
            hashMap.put(arrayExtTerm.getArrayExtTerm(), arrayExtTerm.getReplacementTermVariable());
            ++n;
        }
        applicationTerm2 = Substitution.apply((ManagedScript)this.mMgdScriptCfg, hashMap, (Term)term3);
        applicationTerm2 = SmtUtils.and((Script)this.mMgdScriptCfg.getScript(), (Term[])new Term[]{applicationTerm2, SmtUtils.and((Script)this.mMgdScriptCfg.getScript(), (Term[])termArray)});
        applicationTerm2 = this.mMgdScriptCfg.getScript().quantifier(0, termVariableArray, (Term)applicationTerm2, (Term[][])new Term[0][]);
        applicationTerm2 = QuantifierSequence.prependQuantifierSequence((Script)this.mMgdScriptCfg.getScript(), (List)quantifierSequence.getQuantifierBlocks(), (Term)applicationTerm2);
        return applicationTerm2;
    }

    private static void dumpInterpolationInput(int n, Term[] termArray, List<Integer> list, NestedRun<?, IPredicate> nestedRun, Script script, PrintWriter printWriter, ILogger iLogger) {
        int n2 = 0;
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        try {
            String string = "==Interpolation Input";
            iLogger.debug((Object)string);
            printWriter.println(string);
            int n3 = 0;
            while (n3 < termArray.length) {
                int n4 = n3 == 0 ? n : list.get(n3 - 1);
                string = CoreUtil.addIndentation((int)n2, (String)("Location " + n4 + ": " + String.valueOf(((SPredicate)nestedRun.getStateAtPosition(n4)).getProgramPoint())));
                iLogger.debug((Object)string);
                printWriter.println(string);
                if (nestedRun.isCallPosition(n4)) {
                    ++n2;
                }
                string = CoreUtil.addIndentation((int)n2, (String)formulaUnLet.unlet(termArray[n3]).toString());
                iLogger.debug((Object)string);
                printWriter.println(string);
                if (nestedRun.isReturnPosition(n4)) {
                    --n2;
                }
                ++n3;
            }
            if (n != 0) {
                n3 = nestedRun.getWord().getReturnPosition(n) + 1;
                string = CoreUtil.addIndentation((int)n2, (String)("Location " + n3 + ": " + String.valueOf(((SPredicate)nestedRun.getStateAtPosition(n3)).getProgramPoint())));
                iLogger.debug((Object)string);
                printWriter.println(string);
            }
            printWriter.println("");
            printWriter.println("");
        }
        finally {
            printWriter.flush();
        }
    }

    private static void dumpInterpolationOutput(int n, Term[] termArray, List<Integer> list, Word<?> word, PrintWriter printWriter, ILogger iLogger) {
        NestedWord nestedWord = NestedWord.nestedWord(word);
        assert (termArray.length == list.size());
        int n2 = 0;
        try {
            String string = "==Interpolation Output";
            iLogger.debug((Object)string);
            printWriter.println(string);
            int n3 = 0;
            while (n3 < termArray.length) {
                int n4 = list.get(n3);
                if (n4 > 1 && nestedWord.isCallPosition(n4 - 1)) {
                    ++n2;
                }
                string = CoreUtil.addIndentation((int)n2, (String)("InterpolOutput" + n4 + ": " + String.valueOf(termArray[n3])));
                iLogger.debug((Object)string);
                printWriter.println(string);
                if (nestedWord.isReturnPosition(n4)) {
                    --n2;
                }
                ++n3;
            }
            printWriter.println("");
            printWriter.println("");
        }
        finally {
            printWriter.flush();
        }
    }

    private static void dumpNestedStateFormulas(IPredicate[] iPredicateArray, Word<?> word, PrintWriter printWriter, ILogger iLogger) {
        NestedWord nestedWord = NestedWord.nestedWord(word);
        assert (iPredicateArray.length == word.length() + 1);
        int n = 0;
        try {
            String string = "==NestedInterpolants";
            iLogger.debug((Object)string);
            printWriter.println(string);
            int n2 = 0;
            while (n2 < iPredicateArray.length) {
                string = CoreUtil.addIndentation((int)n, (String)(n2 + ": " + String.valueOf(iPredicateArray[n2])));
                iLogger.debug((Object)string);
                printWriter.println(string);
                if (n2 != iPredicateArray.length - 1) {
                    printWriter.println(word.getSymbol(n2));
                    if (nestedWord.isCallPosition(n2)) {
                        ++n;
                    }
                    if (nestedWord.isReturnPosition(n2)) {
                        --n;
                    }
                }
                ++n2;
            }
        }
        finally {
            printWriter.flush();
        }
    }

    private static boolean isAtDiffTerm(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getName().equals("@diff");
        }
        return false;
    }

    private class ArrayExtTerm {
        private final ApplicationTerm mArrayExtTerm;
        private final Term mFirstArray;
        private final Term mSecondArray;
        private final TermVariable mReplacementTermVariable;
        private final Term mImplication;

        public ArrayExtTerm(ApplicationTerm applicationTerm) {
            this.mArrayExtTerm = applicationTerm;
            if (!this.mArrayExtTerm.getFunction().getName().equals("array-ext")) {
                throw new IllegalArgumentException("no array-ext Term");
            }
            if (this.mArrayExtTerm.getParameters().length != 2) {
                throw new IllegalArgumentException("expected two params");
            }
            this.mFirstArray = this.mArrayExtTerm.getParameters()[0];
            this.mSecondArray = this.mArrayExtTerm.getParameters()[1];
            this.mReplacementTermVariable = applicationTerm.getTheory().createFreshTermVariable("arrExt", applicationTerm.getSort());
            this.mImplication = this.constructImplication();
        }

        private Term constructImplication() {
            Term term = NestedInterpolantsBuilder.this.mMgdScriptCfg.getScript().term("distinct", new Term[]{this.mFirstArray, this.mSecondArray});
            Term term2 = SmtUtils.select((Script)NestedInterpolantsBuilder.this.mMgdScriptCfg.getScript(), (Term)this.mFirstArray, (Term)this.mReplacementTermVariable);
            Term term3 = SmtUtils.select((Script)NestedInterpolantsBuilder.this.mMgdScriptCfg.getScript(), (Term)this.mSecondArray, (Term)this.mReplacementTermVariable);
            Term term4 = NestedInterpolantsBuilder.this.mMgdScriptCfg.getScript().term("distinct", new Term[]{term2, term3});
            Term term5 = Util.implies((Script)NestedInterpolantsBuilder.this.mMgdScriptCfg.getScript(), (Term[])new Term[]{term, term4});
            return term5;
        }

        public ApplicationTerm getArrayExtTerm() {
            return this.mArrayExtTerm;
        }

        public Term getFirstArray() {
            return this.mFirstArray;
        }

        public Term getSecondArray() {
            return this.mSecondArray;
        }

        public TermVariable getReplacementTermVariable() {
            return this.mReplacementTermVariable;
        }

        public Term getImplication() {
            return this.mImplication;
        }
    }
}

