/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctTerm;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonDetector;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctMatrix;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctTerm;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OctagonTransformer
extends NonRecursive {
    private final HashSet<Term> mCheckedTerms;
    private TermVariable mFirstVar;
    private TermVariable mSecondVar;
    private boolean mFirstNegative;
    private boolean mSecondNegative;
    private final OctagonDetector mOctagonDetector;
    private BigDecimal mValue;
    private InequalityType mType;
    private final Script mScript;
    private final HashSet<Term> mAdditionalTerms;
    private final FastUPRUtils mUtils;

    public OctagonTransformer(FastUPRUtils fastUPRUtils, Script script, OctagonDetector octagonDetector) {
        this.mOctagonDetector = octagonDetector;
        this.mUtils = fastUPRUtils;
        this.mCheckedTerms = new HashSet();
        this.mValue = new BigDecimal(0);
        this.mScript = script;
        this.mAdditionalTerms = new HashSet();
    }

    public OctConjunction transform(Term term) {
        return this.transform(this.mOctagonDetector.getConjunctSubTerms(term));
    }

    public OctConjunction transform(Set<Term> set) {
        this.mCheckedTerms.clear();
        this.mAdditionalTerms.clear();
        this.mUtils.debug("Starting Term to OctagonTransformation");
        OctConjunction octConjunction = new OctConjunction();
        for (Term term : set) {
            this.mUtils.debug("Getting Value from:" + term.toString());
            this.resetTerm();
            this.run(new OctagonTermWalker(term, InequalitySide.NONE));
            if (this.mType == InequalityType.LESSER) {
                this.mValue = this.mValue.subtract(new BigDecimal(1));
            }
            this.mUtils.debug("Value is:" + this.mValue.toString());
            if (this.mFirstVar == null) {
                this.mUtils.debug("ERROR");
                continue;
            }
            if (this.mSecondVar == null) {
                this.mValue = this.mValue.multiply(new BigDecimal(2));
                octConjunction.addTerm(OctagonFactory.createOneVarOctTerm(this.mValue, this.mFirstVar, this.mFirstNegative));
                continue;
            }
            octConjunction.addTerm(OctagonFactory.createTwoVarOctTerm(this.mValue, this.mFirstVar, this.mFirstNegative, this.mSecondVar, this.mSecondNegative));
        }
        for (Term term : this.mAdditionalTerms) {
            this.mUtils.debug("Getting Value from:" + term.toString());
            this.resetTerm();
            this.run(new OctagonTermWalker(term, InequalitySide.NONE));
            if (this.mType == InequalityType.LESSER) {
                this.mValue = this.mValue.subtract(new BigDecimal(1));
            }
            this.mUtils.debug("Value is:" + this.mValue.toString());
            if (this.mFirstVar == null) {
                this.mUtils.debug("ERROR");
                continue;
            }
            if (this.mSecondVar == null) {
                this.mValue = this.mValue.multiply(new BigDecimal(2));
                octConjunction.addTerm(OctagonFactory.createOneVarOctTerm(this.mValue, this.mFirstVar, this.mFirstNegative));
                continue;
            }
            octConjunction.addTerm(OctagonFactory.createTwoVarOctTerm(this.mValue, this.mFirstVar, this.mFirstNegative, this.mSecondVar, this.mSecondNegative));
        }
        this.mUtils.debug("Octagon:");
        this.mUtils.debug(octConjunction.toString());
        return octConjunction;
    }

    public ParametricOctMatrix getMatrix(OctConjunction octConjunction, List<TermVariable> list) {
        this.mUtils.debug(">> Converting OctagonConjunction to Matrix");
        this.mUtils.debug("> Conjunction: " + octConjunction.toString());
        List<OctTerm> list2 = octConjunction.getTerms();
        ParametricOctMatrix parametricOctMatrix = new ParametricOctMatrix(list.size());
        for (TermVariable object : list) {
            parametricOctMatrix.addVar(object);
        }
        this.mUtils.debug(parametricOctMatrix.getMapping().toString());
        this.mUtils.debug("Created ParametricOctMatrix of size " + list.size() * 2);
        for (OctTerm octTerm : list2) {
            if (octTerm instanceof ParametricOctTerm) {
                this.mUtils.getLogger().fatal((Object)"Parametric to Matrix Conversion not supported", (Throwable)new UnsupportedOperationException());
            }
            if (octTerm.isOneVar()) {
                parametricOctMatrix.setValue(octTerm.getValue(), octTerm.getFirstVar(), octTerm.isFirstNegative());
                continue;
            }
            parametricOctMatrix.setValue(octTerm.getValue(), octTerm.getFirstVar(), octTerm.isFirstNegative(), octTerm.getSecondVar(), octTerm.isSecondNegative());
        }
        return parametricOctMatrix;
    }

    private void addValue(ConstantTerm constantTerm, boolean bl) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        if (constantTerm.getValue() instanceof Rational) {
            if (((Rational)constantTerm.getValue()).denominator().equals(BigInteger.ONE)) {
                bigDecimal = new BigDecimal(((Rational)constantTerm.getValue()).numerator());
            }
        } else if (constantTerm.getValue() instanceof BigDecimal) {
            bigDecimal = (BigDecimal)constantTerm.getValue();
        } else if (constantTerm.getValue() instanceof BigInteger) {
            bigDecimal = new BigDecimal((BigInteger)constantTerm.getValue());
        }
        if (bl) {
            bigDecimal = bigDecimal.negate();
        }
        this.mValue = this.mValue.add(bigDecimal);
    }

    private void addVariable(TermVariable termVariable, boolean bl) {
        if (this.mFirstVar == null) {
            this.mFirstVar = termVariable;
            this.mFirstNegative = bl;
        } else if (this.mSecondVar == null) {
            this.mSecondVar = termVariable;
            this.mSecondNegative = bl;
        }
    }

    private void resetTerm() {
        this.mFirstVar = null;
        this.mSecondVar = null;
        this.mFirstNegative = false;
        this.mSecondNegative = false;
        this.mValue = new BigDecimal(0);
    }

    private void transformTerm(Term term, boolean bl) {
        this.mUtils.debug("> Walking over neutral Term: " + (String)(bl ? "not: " : " " + term.toString()));
        if (this.mCheckedTerms.contains(term)) {
            return;
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            String string = applicationTerm.getFunction().getName();
            this.mUtils.debug(">> Application of type: " + string);
            Term term2 = term;
            if (string.compareTo("<") == 0) {
                this.mType = InequalityType.LESSER;
                term2 = applicationTerm;
            } else if (string.compareTo(">") == 0) {
                this.mType = InequalityType.LESSER;
                term2 = this.mScript.term("<", new Term[]{applicationTerm.getParameters()[1], applicationTerm.getParameters()[0]});
            } else if (string.compareTo("<=") == 0) {
                this.mType = InequalityType.LESSER_EQUAL;
                term2 = applicationTerm;
            } else if (string.compareTo(">=") == 0) {
                this.mType = InequalityType.LESSER_EQUAL;
                term2 = this.mScript.term("<=", new Term[]{applicationTerm.getParameters()[1], applicationTerm.getParameters()[0]});
            } else {
                if (string.compareTo("not") == 0) {
                    this.enqueueWalker(new OctagonTermWalker(applicationTerm.getParameters()[0], true));
                    return;
                }
                if (string.compareTo("=") == 0) {
                    this.mUtils.debug(">> EQUALITY");
                    Term term3 = this.mScript.term("<=", new Term[]{applicationTerm.getParameters()[0], applicationTerm.getParameters()[1]});
                    Term term4 = this.mScript.term("<=", new Term[]{applicationTerm.getParameters()[1], applicationTerm.getParameters()[0]});
                    this.enqueueWalker(new OctagonTermWalker(term3, false));
                    this.mAdditionalTerms.add(term4);
                    return;
                }
            }
            ApplicationTerm applicationTerm2 = (ApplicationTerm)term2;
            if (bl) {
                if (this.mType == InequalityType.LESSER) {
                    applicationTerm2 = (ApplicationTerm)this.mScript.term("<=", new Term[]{applicationTerm2.getParameters()[1], applicationTerm2.getParameters()[0]});
                    this.mType = InequalityType.LESSER_EQUAL;
                } else {
                    applicationTerm2 = (ApplicationTerm)this.mScript.term("<", new Term[]{applicationTerm2.getParameters()[1], applicationTerm2.getParameters()[0]});
                    this.mType = InequalityType.LESSER;
                }
            }
            Term term5 = applicationTerm2.getParameters()[0];
            Term term6 = applicationTerm2.getParameters()[1];
            this.enqueueWalker(new OctagonTermWalker(term5, InequalitySide.LEFT));
            this.enqueueWalker(new OctagonTermWalker(term6, InequalitySide.RIGHT));
        } else if (term instanceof AnnotatedTerm) {
            this.enqueueWalker(new OctagonTermWalker(((AnnotatedTerm)term).getSubterm(), InequalitySide.NONE));
        }
    }

    private void transformTermSide(Term term, InequalitySide inequalitySide, boolean bl) {
        this.mUtils.debug("> Walking over " + String.valueOf((Object)inequalitySide) + " Term: " + term.toString());
        this.mUtils.debug("Type: " + term.getClass().toString());
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            String string = applicationTerm.getFunction().getName();
            this.mUtils.debug(">> Application of type: " + string);
            if (string.compareTo("-") == 0) {
                if (applicationTerm.getParameters().length == 1) {
                    this.enqueueWalker(new OctagonTermWalker(applicationTerm.getParameters()[0], inequalitySide, !bl));
                } else if (applicationTerm.getParameters().length == 2) {
                    this.enqueueWalker(new OctagonTermWalker(applicationTerm.getParameters()[0], inequalitySide, bl));
                    this.enqueueWalker(new OctagonTermWalker(applicationTerm.getParameters()[1], inequalitySide, !bl));
                }
            } else if (string.compareTo("+") == 0) {
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term2 = termArray[n2];
                    this.enqueueWalker(new OctagonTermWalker(term2, inequalitySide, bl));
                    ++n2;
                }
            } else {
                string.compareTo("*");
            }
        } else if (term instanceof TermVariable) {
            this.mUtils.debug(">> Variable");
            if (inequalitySide == InequalitySide.LEFT) {
                this.addVariable((TermVariable)term, bl);
            } else {
                this.addVariable((TermVariable)term, !bl);
            }
        } else if (term instanceof ConstantTerm) {
            this.mUtils.debug(">> Constant");
            if (inequalitySide == InequalitySide.RIGHT) {
                this.addValue((ConstantTerm)term, bl);
            } else {
                this.addValue((ConstantTerm)term, !bl);
            }
        } else if (term instanceof AnnotatedTerm) {
            this.enqueueWalker(new OctagonTermWalker(((AnnotatedTerm)term).getSubterm(), inequalitySide));
        }
    }

    private static enum InequalitySide {
        NONE,
        LEFT,
        RIGHT;

    }

    private static enum InequalityType {
        NONE,
        LESSER,
        LESSER_EQUAL;

    }

    private static class OctagonTermWalker
    implements NonRecursive.Walker {
        private final Term mTerm;
        private final InequalitySide mSide;
        private final boolean mNegate;

        OctagonTermWalker(Term term, InequalitySide inequalitySide) {
            this(term, inequalitySide, false);
        }

        OctagonTermWalker(Term term, InequalitySide inequalitySide, boolean bl) {
            this.mTerm = term;
            this.mSide = inequalitySide;
            this.mNegate = bl;
        }

        OctagonTermWalker(Term term, boolean bl) {
            this(term, InequalitySide.NONE, bl);
        }

        public void walk(NonRecursive nonRecursive) {
            if (this.mSide == InequalitySide.NONE) {
                ((OctagonTransformer)nonRecursive).transformTerm(this.mTerm, this.mNegate);
            } else {
                ((OctagonTransformer)nonRecursive).transformTermSide(this.mTerm, this.mSide, this.mNegate);
            }
        }
    }
}

