/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class DawgState<LETTER, VALUE> {
    final VALUE mFinal;
    final Map<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> mTransitions;

    public DawgState(VALUE VALUE) {
        this.mFinal = VALUE;
        this.mTransitions = null;
    }

    public DawgState(Map<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> map) {
        this.mFinal = null;
        this.mTransitions = map;
    }

    public boolean isFinal() {
        return this.mTransitions == null;
    }

    public VALUE getFinalValue() {
        return this.mFinal;
    }

    public String toString() {
        if (this.isFinal()) {
            return "RET(" + String.valueOf(this.mFinal) + ")";
        }
        StringBuilder stringBuilder = new StringBuilder();
        LinkedHashSet<DawgState<LETTER, VALUE>> linkedHashSet = new LinkedHashSet<DawgState<LETTER, VALUE>>();
        HashSet<DawgState> hashSet = new HashSet<DawgState>();
        linkedHashSet.add(this);
        while (!linkedHashSet.isEmpty()) {
            DawgState dawgState = (DawgState)linkedHashSet.iterator().next();
            linkedHashSet.remove(dawgState);
            if (!hashSet.add(dawgState)) continue;
            stringBuilder.append(String.format("Dawg#%04d", dawgState.hashCode() % 10000));
            String string = "";
            for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : dawgState.getTransitions().entrySet()) {
                stringBuilder.append(string).append("->");
                if (entry.getKey().isFinal()) {
                    stringBuilder.append("(").append(entry.getKey().getFinalValue()).append(") ");
                } else {
                    stringBuilder.append(String.format("#%04d ", entry.getKey().hashCode() % 10000));
                    linkedHashSet.add(entry.getKey());
                }
                stringBuilder.append(entry.getValue());
                stringBuilder.append("\n");
                string = "         ";
            }
        }
        return stringBuilder.toString();
    }

    public Map<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> getTransitions() {
        return this.mTransitions;
    }

    public VALUE getValue(List<LETTER> list) {
        DawgState dawgState = this;
        for (LETTER LETTER : list) {
            DawgState<LETTER, VALUE> dawgState2 = null;
            for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : dawgState.getTransitions().entrySet()) {
                if (!entry.getValue().matches(LETTER)) continue;
                dawgState2 = entry.getKey();
                break;
            }
            dawgState = dawgState2;
        }
        assert (dawgState.isFinal());
        return dawgState.getFinalValue();
    }

    public boolean isTotal() {
        int n = -1;
        boolean bl = true;
        HashSet<Pair> hashSet = new HashSet<Pair>();
        ArrayDeque<Pair<Integer, DawgState<LETTER, VALUE>>> arrayDeque = new ArrayDeque<Pair<Integer, DawgState<LETTER, VALUE>>>();
        arrayDeque.add(new Pair<Integer, DawgState>(0, this));
        while (!arrayDeque.isEmpty()) {
            Pair pair = (Pair)arrayDeque.removeFirst();
            if (!hashSet.add(pair)) continue;
            DawgState dawgState = (DawgState)pair.getSecond();
            if (dawgState.isFinal()) {
                assert (n == -1 || n == (Integer)pair.getFirst());
                n = (Integer)pair.getFirst();
                continue;
            }
            int n2 = (Integer)pair.getFirst() + 1;
            DawgLetter<LETTER> dawgLetter = dawgState.getTransitions().values().iterator().next();
            DawgLetter<LETTER> dawgLetter2 = dawgLetter.intersect(dawgLetter.complement());
            for (Map.Entry<DawgState<LETTER, VALUE>, DawgLetter<LETTER>> entry : dawgState.getTransitions().entrySet()) {
                arrayDeque.addLast(new Pair<Integer, DawgState<LETTER, VALUE>>(n2, entry.getKey()));
                assert (dawgLetter2.intersect(entry.getValue()).isEmpty());
                dawgLetter2 = dawgLetter2.union(entry.getValue());
            }
            bl &= dawgLetter2.isUniversal();
        }
        return bl;
    }
}

