/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.srparse.pattern;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.CounterTrace;
import de.uni_freiburg.informatik.ultimate.lib.srparse.SrParseScope;
import de.uni_freiburg.informatik.ultimate.lib.srparse.SrParseScopeGlobally;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import java.util.Collections;
import java.util.List;

public class DeclarationPattern
extends PatternType<DeclarationPattern> {
    private static final SrParseScopeGlobally INIT_SCOPE = new SrParseScopeGlobally();
    private final String mType;
    private final VariableCategory mVisibility;
    private final Expression mExpression;

    public DeclarationPattern(String string, String string2, VariableCategory variableCategory) {
        this(string, string2, variableCategory, null);
    }

    public DeclarationPattern(String string, String string2, VariableCategory variableCategory, Expression expression) {
        super(INIT_SCOPE, string, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        this.mType = string2;
        this.mVisibility = variableCategory;
        this.mExpression = expression;
    }

    @Override
    public DeclarationPattern create(SrParseScope<?> srParseScope, String string, List<CDD> list, List<Rational> list2, List<String> list3) {
        throw new UnsupportedOperationException();
    }

    public VariableCategory getCategory() {
        return this.mVisibility;
    }

    public String getType() {
        return this.mType;
    }

    public Expression getExpression() {
        return this.mExpression;
    }

    @Override
    public String toString() {
        String string = this.mVisibility.getKeyword() + " " + this.getId() + " IS ";
        if (this.mVisibility == VariableCategory.CONST) {
            return string + BoogiePrettyPrinter.print((Expression)this.getExpression());
        }
        return string + this.mType;
    }

    @Override
    protected List<CounterTrace> transform(CDD[] cDDArray, int[] nArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mExpression == null ? 0 : this.mExpression.hashCode());
        n = 31 * n + (this.mType == null ? 0 : this.mType.hashCode());
        n = 31 * n + (this.mVisibility == null ? 0 : this.mVisibility.hashCode());
        n = 31 * n + (this.getId() == null ? 0 : this.getId().hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DeclarationPattern declarationPattern = (DeclarationPattern)object;
        if (this.mVisibility != declarationPattern.mVisibility) {
            return false;
        }
        if (this.mType == null ? declarationPattern.mType != null : !this.mType.equals(declarationPattern.mType)) {
            return false;
        }
        if (this.getId() == null ? declarationPattern.getId() != null : !this.getId().equals(declarationPattern.getId())) {
            return false;
        }
        return !(this.mExpression == null ? declarationPattern.mExpression != null : !this.mExpression.equals(declarationPattern.mExpression));
    }

    public DeclarationPattern rename(String string) {
        return new DeclarationPattern(string, this.getType(), this.getCategory(), this.getExpression());
    }

    @Override
    public int getExpectedCddSize() {
        return 0;
    }

    @Override
    public int getExpectedDurationSize() {
        return 0;
    }

    public static enum VariableCategory {
        IN("Input"),
        OUT("Output"),
        HIDDEN("???"),
        CONST("CONST");

        private final String mKeyword;

        private VariableCategory(String string2) {
            this.mKeyword = string2;
        }

        public String getKeyword() {
            return this.mKeyword;
        }
    }
}

