/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.Function;

public final class BitvectorUtils {
    private static final String BITVEC_CONST_PATTERN = "bv\\d+";

    private BitvectorUtils() {
    }

    public static boolean isBitvectorConstant(FunctionSymbol functionSymbol) {
        return functionSymbol.isIntern() && functionSymbol.getName().matches(BITVEC_CONST_PATTERN);
    }

    public static boolean isBitvectorConstant(BigInteger bigInteger, Term term) {
        BitvectorConstant bitvectorConstant = BitvectorUtils.constructBitvectorConstant(term);
        if (bitvectorConstant == null) {
            return false;
        }
        return bitvectorConstant.getValue().equals(bigInteger);
    }

    public static BitvectorConstant constructBitvectorConstant(Term term) {
        if (!SmtSortUtils.isBitvecSort(term.getSort())) {
            return null;
        }
        if (term instanceof ApplicationTerm && term.getSort().getIndices().length == 1) {
            FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
            if (!BitvectorUtils.isBitvectorConstant(functionSymbol)) {
                return null;
            }
            assert (functionSymbol.getName().startsWith("bv"));
            String string = functionSymbol.getName().substring(2);
            return BitvectorUtils.constructBitvectorConstant(new BigInteger(string), term.getSort());
        }
        if (term instanceof ConstantTerm) {
            BigInteger bigInteger = BitvectorUtils.extractValueFromBitvectorConstant((ConstantTerm)term);
            return BitvectorUtils.constructBitvectorConstant(bigInteger, term.getSort());
        }
        return null;
    }

    public static BitvectorConstant constructBitvectorConstant(BigInteger bigInteger, Sort sort) {
        String string = sort.getIndices()[0];
        return new BitvectorConstant(bigInteger, string);
    }

    public static BigInteger extractValueFromBitvectorConstant(ConstantTerm constantTerm) {
        if (!SmtSortUtils.isBitvecSort(constantTerm.getSort())) {
            throw new AssertionError((Object)("Sort must be bitvector sort, got " + String.valueOf(constantTerm.getSort())));
        }
        Object object = constantTerm.getValue();
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object.toString().startsWith("#x")) {
            return new BigInteger(object.toString().substring(2), 16);
        }
        if (object.toString().startsWith("#b")) {
            return new BigInteger(object.toString().substring(2), 2);
        }
        throw new AssertionError((Object)"Value must be stored as BigInterger, hexadecimally endoded string or binarily encoded string");
    }

    public static Term constructTerm(Script script, BigInteger bigInteger, Sort sort) {
        String string = sort.getIndices()[0];
        return BitvectorUtils.constructTerm(script, new BitvectorConstant(bigInteger, string));
    }

    public static Term constructTerm(Script script, BitvectorConstant bitvectorConstant) {
        String string = "bv" + bitvectorConstant.getValue().toString();
        return script.term(string, new String[]{bitvectorConstant.getStringIndex()}, null, new Term[0]);
    }

    public static boolean allTermsAreBitvectorConstants(Term[] termArray) {
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            if (!SmtSortUtils.isBitvecSort(term.getSort())) {
                return false;
            }
            if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                if (!BitvectorUtils.isBitvectorConstant(applicationTerm.getFunction())) {
                    return false;
                }
            } else {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static Term unfTerm(Script script, String string, BigInteger[] bigIntegerArray, Term ... termArray) {
        BitvectorConstant.BvOp bvOp = BitvectorConstant.BvOp.valueOf((String)string);
        return switch (bvOp) {
            case BitvectorConstant.BvOp.zero_extend -> new Zero_extend().simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.sign_extend -> new Sign_extend().simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.extract -> new Extract().simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.concat -> new Concat().simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvadd -> SmtUtils.sum(script, string, termArray);
            case BitvectorConstant.BvOp.bvsub -> SmtUtils.minus(script, termArray);
            case BitvectorConstant.BvOp.bvudiv -> new RegularBitvectorOperation_BitvectorResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvudiv((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvurem -> new RegularBitvectorOperation_BitvectorResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvurem((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvsdiv -> new RegularBitvectorOperation_BitvectorResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvsdiv((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvsrem -> new RegularBitvectorOperation_BitvectorResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvsrem((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvsmod -> new RegularBitvectorOperation_BitvectorResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvsmod((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvmul -> SmtUtils.mul(script, string, termArray);
            case BitvectorConstant.BvOp.bvand -> new Bvand().simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvor -> new RegularBitvectorOperation_BitvectorResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvor((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvxor -> new RegularBitvectorOperation_BitvectorResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvxor((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvnot -> new Bvnot().simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvneg -> new Bvneg().simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvshl -> new RegularBitvectorOperation_BitvectorResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvshl((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvlshr -> new RegularBitvectorOperation_BitvectorResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvlshr((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvashr -> new RegularBitvectorOperation_BitvectorResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvashr((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvult -> new RegularBitvectorOperation_BooleanResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvult((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvule -> new RegularBitvectorOperation_BooleanResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvule((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvugt -> new RegularBitvectorOperation_BooleanResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvugt((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvuge -> new RegularBitvectorOperation_BooleanResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvuge((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvslt -> new RegularBitvectorOperation_BooleanResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvslt((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvsle -> new RegularBitvectorOperation_BooleanResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvsle((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvsgt -> new RegularBitvectorOperation_BooleanResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvsgt((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            case BitvectorConstant.BvOp.bvsge -> new RegularBitvectorOperation_BooleanResult(string, bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvsge((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2)).simplifiedResult(script, string, bigIntegerArray, termArray);
            default -> {
                if (BitvectorUtils.allTermsAreBitvectorConstants(termArray)) {
                    throw new AssertionError((Object)("wasted optimization " + string));
                }
                yield SmtUtils.oldAPITerm(script, string, bigIntegerArray, null, termArray);
            }
        };
    }

    private static abstract class BitvectorOperation {
        private BitvectorOperation() {
        }

        public final Term simplifiedResult(Script script, String string, BigInteger[] bigIntegerArray, Term ... termArray) {
            if (!this.getFunctionName().equals(string)) {
                throw new AssertionError((Object)("Wrong function name: " + string));
            }
            assert (this.getNumberOfIndices() == 0 && bigIntegerArray == null || this.getNumberOfIndices() == bigIntegerArray.length) : "Wrong number of indices:" + Arrays.toString(bigIntegerArray);
            if (this.getNumberOfParams() != termArray.length) {
                throw new AssertionError((Object)String.format("%s: params expected %s, params provided %s", string, this.getNumberOfParams(), termArray.length));
            }
            BitvectorConstant[] bitvectorConstantArray = new BitvectorConstant[termArray.length];
            boolean bl = true;
            int n = 0;
            while (n < termArray.length) {
                bitvectorConstantArray[n] = BitvectorUtils.constructBitvectorConstant(termArray[n]);
                bl &= bitvectorConstantArray[n] != null;
                ++n;
            }
            if (bl) {
                return this.simplify_ConstantCase(script, bigIntegerArray, bitvectorConstantArray);
            }
            return this.simplify_NonConstantCase(script, bigIntegerArray, termArray, bitvectorConstantArray);
        }

        protected Term simplify_NonConstantCase(Script script, BigInteger[] bigIntegerArray, Term[] termArray, BitvectorConstant[] bitvectorConstantArray) {
            return this.notSimplified(script, bigIntegerArray, termArray);
        }

        private final Term notSimplified(Script script, BigInteger[] bigIntegerArray, Term[] termArray) {
            Term[] termArray2 = this.isCommutative() ? CommuhashUtils.sortByHashCode(termArray) : termArray;
            return SmtUtils.oldAPITerm(script, this.getFunctionName(), bigIntegerArray, null, termArray2);
        }

        public abstract String getFunctionName();

        public abstract boolean isCommutative();

        public abstract int getNumberOfIndices();

        public abstract int getNumberOfParams();

        public abstract Term simplify_ConstantCase(Script var1, BigInteger[] var2, BitvectorConstant[] var3);
    }

    private static class Bvand
    extends RegularBitvectorOperation_BitvectorResult {
        public Bvand() {
            super("bvand", bitvectorConstant -> bitvectorConstant2 -> BitvectorConstant.bvand((BitvectorConstant)bitvectorConstant, (BitvectorConstant)bitvectorConstant2));
        }

        @Override
        protected Term simplify_NonConstantCase(Script script, BigInteger[] bigIntegerArray, Term[] termArray, BitvectorConstant[] bitvectorConstantArray) {
            BitvectorConstant[] bitvectorConstantArray2 = bitvectorConstantArray;
            int n = bitvectorConstantArray.length;
            int n2 = 0;
            while (n2 < n) {
                BitvectorConstant bitvectorConstant = bitvectorConstantArray2[n2];
                if (bitvectorConstant != null && bitvectorConstant.getValue().equals(BigInteger.ZERO)) {
                    return BitvectorUtils.constructTerm(script, bitvectorConstant);
                }
                ++n2;
            }
            return super.simplify_NonConstantCase(script, bigIntegerArray, termArray, bitvectorConstantArray);
        }
    }

    private static class Bvneg
    extends BitvectorOperation {
        private Bvneg() {
        }

        @Override
        public String getFunctionName() {
            return "bvneg";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 0;
        }

        @Override
        public int getNumberOfParams() {
            return 1;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] bigIntegerArray, BitvectorConstant[] bitvectorConstantArray) {
            return BitvectorUtils.constructTerm(script, BitvectorConstant.bvneg((BitvectorConstant)bitvectorConstantArray[0]));
        }
    }

    private static class Bvnot
    extends BitvectorOperation {
        private Bvnot() {
        }

        @Override
        public String getFunctionName() {
            return "bvnot";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 0;
        }

        @Override
        public int getNumberOfParams() {
            return 1;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] bigIntegerArray, BitvectorConstant[] bitvectorConstantArray) {
            return BitvectorUtils.constructTerm(script, BitvectorConstant.bvnot((BitvectorConstant)bitvectorConstantArray[0]));
        }
    }

    private static class Concat
    extends BitvectorOperation {
        private Concat() {
        }

        @Override
        public String getFunctionName() {
            return "concat";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 0;
        }

        @Override
        public int getNumberOfParams() {
            return 2;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] bigIntegerArray, BitvectorConstant[] bitvectorConstantArray) {
            BitvectorConstant bitvectorConstant = BitvectorConstant.concat((BitvectorConstant)bitvectorConstantArray[0], (BitvectorConstant)bitvectorConstantArray[1]);
            return BitvectorUtils.constructTerm(script, bitvectorConstant);
        }
    }

    private static class Extract
    extends BitvectorOperation {
        private Extract() {
        }

        @Override
        public String getFunctionName() {
            return "extract";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 2;
        }

        @Override
        public int getNumberOfParams() {
            return 1;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] bigIntegerArray, BitvectorConstant[] bitvectorConstantArray) {
            BitvectorConstant bitvectorConstant = BitvectorConstant.extract((BitvectorConstant)bitvectorConstantArray[0], (int)bigIntegerArray[0].intValueExact(), (int)bigIntegerArray[1].intValueExact());
            return BitvectorUtils.constructTerm(script, bitvectorConstant);
        }
    }

    private static abstract class RegularBitvectorOperation
    extends BitvectorOperation {
        private RegularBitvectorOperation() {
        }

        @Override
        public int getNumberOfIndices() {
            return 0;
        }

        @Override
        public int getNumberOfParams() {
            return 2;
        }
    }

    private static class RegularBitvectorOperation_BitvectorResult
    extends RegularBitvectorOperation {
        private final String mName;
        private final Function<BitvectorConstant, Function<BitvectorConstant, BitvectorConstant>> mConstantSimplification;

        public RegularBitvectorOperation_BitvectorResult(String string, Function<BitvectorConstant, Function<BitvectorConstant, BitvectorConstant>> function) {
            this.mName = string;
            this.mConstantSimplification = function;
        }

        @Override
        public String getFunctionName() {
            return this.mName;
        }

        @Override
        public boolean isCommutative() {
            BitvectorConstant.BvOp bvOp = BitvectorConstant.BvOp.valueOf((String)this.getFunctionName());
            switch (bvOp) {
                case bvadd: 
                case bvmul: 
                case bvand: 
                case bvor: 
                case bvxor: {
                    return true;
                }
                case bvsub: 
                case bvudiv: 
                case bvurem: 
                case bvsdiv: 
                case bvsrem: 
                case bvsmod: 
                case bvshl: 
                case bvlshr: 
                case bvashr: {
                    return false;
                }
                case sign_extend: 
                case zero_extend: 
                case extract: 
                case concat: 
                case bvnot: 
                case bvneg: 
                case bvult: 
                case bvule: 
                case bvugt: 
                case bvuge: 
                case bvslt: 
                case bvsle: 
                case bvsgt: 
                case bvsge: {
                    throw new AssertionError((Object)("Not a regular bitvector operator with bitvector result: " + String.valueOf(bvOp)));
                }
            }
            throw new UnsupportedOperationException("Unknown bitvector operator: " + String.valueOf(bvOp));
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] bigIntegerArray, BitvectorConstant[] bitvectorConstantArray) {
            if (bitvectorConstantArray.length != this.getNumberOfParams()) {
                throw new AssertionError((Object)"supported and provided parameters differ - feature not yet implemented");
            }
            return BitvectorUtils.constructTerm(script, this.mConstantSimplification.apply(bitvectorConstantArray[0]).apply(bitvectorConstantArray[1]));
        }
    }

    private static class RegularBitvectorOperation_BooleanResult
    extends RegularBitvectorOperation {
        private final String mName;
        private final Function<BitvectorConstant, Function<BitvectorConstant, Boolean>> mFunction;

        public RegularBitvectorOperation_BooleanResult(String string, Function<BitvectorConstant, Function<BitvectorConstant, Boolean>> function) {
            this.mName = string;
            this.mFunction = function;
        }

        @Override
        public String getFunctionName() {
            return this.mName;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] bigIntegerArray, BitvectorConstant[] bitvectorConstantArray) {
            return script.term(String.valueOf(this.mFunction.apply(bitvectorConstantArray[0]).apply(bitvectorConstantArray[1])), new Term[0]);
        }
    }

    private static class Sign_extend
    extends BitvectorOperation {
        private Sign_extend() {
        }

        @Override
        public String getFunctionName() {
            return "sign_extend";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 1;
        }

        @Override
        public int getNumberOfParams() {
            return 1;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] bigIntegerArray, BitvectorConstant[] bitvectorConstantArray) {
            BitvectorConstant bitvectorConstant = BitvectorConstant.sign_extend((BitvectorConstant)bitvectorConstantArray[0], (BigInteger)bigIntegerArray[0]);
            return BitvectorUtils.constructTerm(script, bitvectorConstant);
        }
    }

    private static class Zero_extend
    extends BitvectorOperation {
        private Zero_extend() {
        }

        @Override
        public String getFunctionName() {
            return "zero_extend";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 1;
        }

        @Override
        public int getNumberOfParams() {
            return 1;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] bigIntegerArray, BitvectorConstant[] bitvectorConstantArray) {
            BitvectorConstant bitvectorConstant = BitvectorConstant.zero_extend((BitvectorConstant)bitvectorConstantArray[0], (BigInteger)bigIntegerArray[0]);
            return BitvectorUtils.constructTerm(script, bitvectorConstant);
        }
    }
}

