/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.RelationCheckUtil;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class StateBasedDomain<STATE extends IAbstractState<STATE>>
implements IDomain {
    private final SymbolicTools mTools;
    private final int mMaxDisjuncts;
    private final ILogger mLogger;
    private final Supplier<IProgressAwareTimer> mTimeout;
    private final IStateProvider<STATE> mStateProvider;
    private final WeakHashMap<IPredicate, List<STATE>> mPredicateCache = new WeakHashMap();

    public StateBasedDomain(SymbolicTools symbolicTools, int n, ILogger iLogger, Supplier<IProgressAwareTimer> supplier, IStateProvider<STATE> iStateProvider) {
        this.mTools = symbolicTools;
        this.mMaxDisjuncts = n;
        this.mLogger = iLogger;
        this.mTimeout = supplier;
        this.mStateProvider = iStateProvider;
    }

    @Override
    public IPredicate join(IPredicate iPredicate, IPredicate iPredicate2) {
        List<STATE> list = new ArrayList<STATE>(this.toStates(iPredicate));
        list.addAll(this.toStates(iPredicate2));
        if (list.size() > this.mMaxDisjuncts) {
            list = List.of(this.joinToSingleState(list));
        }
        return this.toPredicate(list);
    }

    private STATE joinToSingleState(List<STATE> list) {
        return (STATE)((IAbstractState)list.stream().reduce(IAbstractState::join).orElseThrow());
    }

    @Override
    public IPredicate widen(IPredicate iPredicate, IPredicate iPredicate2) {
        List<Object> list;
        List<STATE> list2 = this.toStates(iPredicate);
        List<STATE> list3 = this.toStates(iPredicate2);
        int n = list2.size() * list3.size();
        if (n > this.mMaxDisjuncts) {
            STATE STATE = this.joinToSingleState(list2);
            STATE STATE2 = this.joinToSingleState(list3);
            list = List.of(STATE.widen(STATE2));
        } else {
            list = new ArrayList(n);
            for (IAbstractState iAbstractState : list2) {
                for (IAbstractState iAbstractState2 : list3) {
                    list.add(iAbstractState.widen(iAbstractState2));
                }
            }
        }
        return this.toPredicate(list);
    }

    @Override
    public IDomain.ResultForAlteredInputs isEqBottom(IPredicate iPredicate) {
        return RelationCheckUtil.isEqBottom_SolverAlphaSolver(this.mTools, this, iPredicate);
    }

    @Override
    public IDomain.ResultForAlteredInputs isSubsetEq(IPredicate iPredicate, IPredicate iPredicate2) {
        return RelationCheckUtil.isSubsetEq_SolverAlphaSolver(this.mTools, this, iPredicate, iPredicate2);
    }

    @Override
    public IPredicate alpha(IPredicate iPredicate) {
        return this.toPredicate(this.toStates(iPredicate));
    }

    private List<STATE> toStates(IPredicate iPredicate) {
        return this.mPredicateCache.computeIfAbsent(iPredicate, this::computeStates);
    }

    private List<STATE> computeStates(IPredicate iPredicate) {
        IProgressAwareTimer iProgressAwareTimer = this.mTimeout.get();
        Term[] termArray = this.mTools.dnfDisjuncts(iPredicate, this.mStateProvider::preprocessTerm);
        ArrayList<STATE> arrayList = new ArrayList<STATE>(termArray.length);
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            STATE STATE;
            Term term = termArray2[n2];
            if (!iProgressAwareTimer.continueProcessing()) {
                this.mLogger.warn((Object)(this.getClass().getSimpleName() + " alpha timed out before all disjuncts were processed. Continuing with top."));
                return List.of(this.mStateProvider.getTopState());
            }
            if (!SmtUtils.isFalseLiteral((Term)term) && !(STATE = this.mStateProvider.toState(SmtUtils.getConjuncts((Term)term))).isBottom()) {
                arrayList.add(STATE);
            }
            ++n2;
        }
        return arrayList;
    }

    private IPredicate toPredicate(List<STATE> list) {
        return this.mTools.orT(list.stream().map(iAbstractState -> iAbstractState.toTerm(this.mTools.getScript())).collect(Collectors.toList()));
    }

    public static interface IStateProvider<STATE extends IAbstractState<STATE>> {
        public STATE toState(Term[] var1);

        public STATE getTopState();

        public Term preprocessTerm(Term var1);
    }
}

