/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.TypeErrorReporter;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.TypeCheckHelper;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class StatementFactory {
    public static AssignmentStatement constructSingleAssignmentStatement(ILocation iLocation, LeftHandSide leftHandSide, Expression expression) {
        return StatementFactory.constructAssignmentStatement(iLocation, new LeftHandSide[]{leftHandSide}, new Expression[]{expression});
    }

    public static AssignmentStatement constructAssignmentStatement(ILocation iLocation, LeftHandSide[] leftHandSideArray, Expression[] expressionArray) {
        assert (leftHandSideArray.length == expressionArray.length);
        assert (leftHandSideArray.length > 0);
        String[] stringArray = new String[leftHandSideArray.length];
        BoogieType[] boogieTypeArray = new BoogieType[leftHandSideArray.length];
        BoogieType[] boogieTypeArray2 = new BoogieType[expressionArray.length];
        int n = 0;
        while (n < leftHandSideArray.length) {
            stringArray[n] = TypeCheckHelper.getLeftHandSideIdentifier(leftHandSideArray[n]);
            boogieTypeArray[n] = (BoogieType)leftHandSideArray[n].getType();
            boogieTypeArray2[n] = (BoogieType)expressionArray[n].getType();
            assert (boogieTypeArray[n] != null);
            assert (boogieTypeArray2[n] != null);
            ++n;
        }
        TypeCheckHelper.typeCheckAssignStatement(stringArray, boogieTypeArray, boogieTypeArray2, new TypeErrorReporter(iLocation));
        return new AssignmentStatement(iLocation, leftHandSideArray, expressionArray);
    }

    public static CallStatement constructCallStatement(ILocation iLocation, boolean bl, VariableLHS[] variableLHSArray, String string, Expression[] expressionArray) {
        return new CallStatement(iLocation, bl, variableLHSArray, string, expressionArray);
    }

    public static Statement constructIfStatement(ILocation iLocation, Expression expression, Statement[] statementArray, Statement[] statementArray2) {
        return new IfStatement(iLocation, expression, statementArray, statementArray2);
    }

    public static Statement constructIfStatement(ILocation iLocation, Expression expression, List<Statement> list, List<Statement> list2) {
        return StatementFactory.constructIfStatement(iLocation, expression, (Statement[])list.toArray(Statement[]::new), (Statement[])list2.toArray(Statement[]::new));
    }

    public static Statement constructIfStatement(ILocation iLocation, Expression expression, List<Statement> list) {
        return StatementFactory.constructIfStatement(iLocation, expression, (Statement[])list.toArray(Statement[]::new), new Statement[0]);
    }

    public static AtomicStatement constructAtomicStatement(ILocation iLocation, List<Statement> list) {
        return StatementFactory.constructAtomicStatement(iLocation, list.stream());
    }

    public static AtomicStatement constructAtomicStatement(ILocation iLocation, Stream<Statement> stream) {
        return new AtomicStatement(iLocation, (Statement[])stream.flatMap(StatementFactory::getFlattenedStatements).toArray(Statement[]::new));
    }

    private static Stream<Statement> getFlattenedStatements(Statement statement) {
        if (statement instanceof AtomicStatement) {
            return Arrays.stream(((AtomicStatement)statement).getBody()).flatMap(StatementFactory::getFlattenedStatements);
        }
        return Stream.of(statement);
    }
}

