/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ArrayEqualityExplicator {
    private static final String AUX_VAR_PREFIX = "antiDerIndex";
    private final List<TermVariable> mNewAuxVars;
    private final Term mResultTerm;

    public ArrayEqualityExplicator(ManagedScript managedScript, int n, TermVariable termVariable, Term term, List<BinaryEqualityRelation> list) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (BinaryEqualityRelation binaryEqualityRelation : list) {
            if (binaryEqualityRelation.getRelationSymbol() != ArrayEqualityExplicator.getDerRelationSymbol(n).negate()) {
                throw new IllegalArgumentException("incompatible relation");
            }
            Term term2 = this.constructElementwiseEquality(managedScript, n, binaryEqualityRelation.getLhs(), binaryEqualityRelation.getRhs(), arrayList);
            hashMap.put(binaryEqualityRelation.toTerm(managedScript.getScript()), term2);
        }
        this.mResultTerm = Substitution.apply(managedScript, hashMap, term);
        assert (CommuhashUtils.isInCommuhashNormalForm(term, CommuhashUtils.COMMUTATIVE_OPERATORS)) : "input not in commuhash normal form";
        if (this.mResultTerm.equals(term)) {
            throw new AssertionError((Object)("Substitution failed: " + String.valueOf(hashMap)));
        }
        this.mNewAuxVars = arrayList;
    }

    private static RelationSymbol getDerRelationSymbol(int n) {
        if (n == 0) {
            return RelationSymbol.EQ;
        }
        if (n == 1) {
            return RelationSymbol.DISTINCT;
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public Term getResultTerm() {
        return this.mResultTerm;
    }

    public List<TermVariable> getNewAuxVars() {
        return this.mNewAuxVars;
    }

    private Term constructElementwiseEquality(ManagedScript managedScript, int n, Term term, Term term2, List<TermVariable> list) {
        Term term3;
        MultiDimensionalSort multiDimensionalSort = new MultiDimensionalSort(term.getSort());
        ArrayIndex arrayIndex = ArrayEqualityExplicator.constructAuxIndex(managedScript, multiDimensionalSort, list);
        Term term4 = SmtUtils.multiDimensionalSelect(managedScript.getScript(), term, arrayIndex);
        Term term5 = SmtUtils.multiDimensionalSelect(managedScript.getScript(), term2, arrayIndex);
        if (n == 0) {
            term3 = SmtSortUtils.isBoolSort(term4.getSort()) ? SmtUtils.binaryBooleanNotEquals(managedScript.getScript(), term4, term5) : managedScript.getScript().term("not", new Term[]{SmtUtils.equality(managedScript.getScript(), term4, term5)});
        } else if (n == 1) {
            term3 = SmtSortUtils.isBoolSort(term4.getSort()) ? SmtUtils.binaryBooleanEquality(managedScript.getScript(), term4, term5) : SmtUtils.equality(managedScript.getScript(), term4, term5);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return term3;
    }

    private static ArrayIndex constructAuxIndex(ManagedScript managedScript, MultiDimensionalSort multiDimensionalSort, List<TermVariable> list) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        int n = 0;
        for (Sort sort : multiDimensionalSort.getIndexSorts()) {
            TermVariable termVariable = managedScript.constructFreshTermVariable("antiDerIndex_entry" + n, sort);
            arrayList.add(termVariable);
            list.add(termVariable);
            ++n;
        }
        return new ArrayIndex(arrayList);
    }
}

