/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.compound;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CompoundDomainState
implements IAbstractState<CompoundDomainState> {
    private static int sId;
    private static final Map<Class<?>, String> mSanitizedShortNames;
    private final IUltimateServiceProvider mServices;
    private final List<IAbstractState<?>> mAbstractStates;
    private final List<IAbstractDomain> mDomainList;
    private final int mId = ++sId;
    private final String[] mCachedShortNames;

    static {
        mSanitizedShortNames = new HashMap();
    }

    public CompoundDomainState(IUltimateServiceProvider iUltimateServiceProvider, List<IAbstractDomain> list, List<IAbstractState<?>> list2) {
        if (list.size() != list2.size()) {
            throw new UnsupportedOperationException("The domain list size and the abstract state list size must be identical.");
        }
        this.mServices = iUltimateServiceProvider;
        this.mDomainList = list;
        this.mAbstractStates = list2;
        this.mCachedShortNames = this.initializeShortNames();
    }

    public CompoundDomainState(IUltimateServiceProvider iUltimateServiceProvider, List<IAbstractDomain> list, boolean bl) {
        this.mServices = iUltimateServiceProvider;
        this.mDomainList = list;
        this.mAbstractStates = new ArrayList();
        if (bl) {
            this.mDomainList.forEach(iAbstractDomain -> {
                boolean bl = this.mAbstractStates.add(iAbstractDomain.createBottomState());
            });
        } else {
            this.mDomainList.forEach(iAbstractDomain -> {
                boolean bl = this.mAbstractStates.add(iAbstractDomain.createTopState());
            });
        }
        this.mCachedShortNames = this.initializeShortNames();
    }

    public CompoundDomainState addVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.performStateOperation(iAbstractState -> iAbstractState.addVariable(iProgramVarOrConst));
    }

    public CompoundDomainState removeVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.performStateOperation(iAbstractState -> iAbstractState.removeVariable(iProgramVarOrConst));
    }

    public CompoundDomainState addVariables(Collection<IProgramVarOrConst> collection) {
        return this.performStateOperation(iAbstractState -> iAbstractState.addVariables(collection));
    }

    public CompoundDomainState removeVariables(Collection<IProgramVarOrConst> collection) {
        return this.performStateOperation(iAbstractState -> iAbstractState.removeVariables(collection));
    }

    public boolean containsVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.mAbstractStates.get(0).containsVariable(iProgramVarOrConst);
    }

    public ImmutableSet<IProgramVarOrConst> getVariables() {
        return this.mAbstractStates.get(0).getVariables();
    }

    public CompoundDomainState renameVariable(IProgramVarOrConst iProgramVarOrConst, IProgramVarOrConst iProgramVarOrConst2) {
        return this.performStateOperation(iAbstractState -> iAbstractState.renameVariable(iProgramVarOrConst, iProgramVarOrConst2));
    }

    public CompoundDomainState renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> map) {
        return this.performStateOperation(iAbstractState -> iAbstractState.renameVariables(map));
    }

    public CompoundDomainState patch(CompoundDomainState compoundDomainState) {
        assert (this.mAbstractStates.size() == compoundDomainState.mAbstractStates.size());
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.mAbstractStates.size()) {
            arrayList.add(CompoundDomainState.patchInternally(this.mAbstractStates.get(n), compoundDomainState.mAbstractStates.get(n)));
            ++n;
        }
        return new CompoundDomainState(this.mServices, this.mDomainList, arrayList);
    }

    private static <T extends IAbstractState> T patchInternally(T t, T t2) {
        return (T)t.patch(t2);
    }

    public boolean isEmpty() {
        return this.mAbstractStates.get(0).isEmpty();
    }

    public boolean isBottom() {
        for (IAbstractState<?> iAbstractState : this.mAbstractStates) {
            if (!iAbstractState.isBottom()) continue;
            return true;
        }
        return false;
    }

    public boolean isEqualTo(CompoundDomainState compoundDomainState) {
        assert (this.mAbstractStates.size() == compoundDomainState.mAbstractStates.size());
        int n = 0;
        while (n < this.mAbstractStates.size()) {
            if (!CompoundDomainState.isEqualToInternally(this.mAbstractStates.get(n), compoundDomainState.mAbstractStates.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static <T extends IAbstractState> boolean isEqualToInternally(T t, T t2) {
        return t.isEqualTo(t2);
    }

    private static <T extends IAbstractState> IAbstractState.SubsetResult isSubsetOfInternally(T t, T t2) {
        return t.isSubsetOf(t2);
    }

    public Term getTerm(Script script) {
        if (this.mAbstractStates.isEmpty() || this.isBottom()) {
            return script.term("false", new Term[0]);
        }
        if (this.mAbstractStates.size() == 1) {
            return this.mAbstractStates.iterator().next().getTerm(script);
        }
        return SmtUtils.and((Script)script, (Collection)this.mAbstractStates.stream().map(iAbstractState -> iAbstractState.getTerm(script)).collect(Collectors.toSet()));
    }

    public String toLogString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.mAbstractStates.size()) {
            stringBuilder.append(this.mCachedShortNames[n]).append(this.mAbstractStates.get(n).toLogString()).append(", ");
            ++n;
        }
        return stringBuilder.toString();
    }

    private String[] initializeShortNames() {
        String[] stringArray = new String[this.mAbstractStates.size()];
        int n = 0;
        while (n < this.mAbstractStates.size()) {
            stringArray[n] = CompoundDomainState.getShortName(this.mAbstractStates.get(n).getClass()) + ": ";
            ++n;
        }
        return stringArray;
    }

    private static String getShortName(Class<?> clazz) {
        if (mSanitizedShortNames.containsKey(clazz)) {
            return mSanitizedShortNames.get(clazz);
        }
        String string = clazz.getSimpleName();
        if (string.length() >= 4) {
            string = string.substring(0, 3);
        }
        mSanitizedShortNames.put(clazz, string);
        return string;
    }

    private CompoundDomainState performStateOperation(Function<IAbstractState<?>, IAbstractState<?>> function) {
        return new CompoundDomainState(this.mServices, this.mDomainList, this.mAbstractStates.stream().map(function).collect(Collectors.toList()));
    }

    protected List<IAbstractDomain> getDomainList() {
        return this.mDomainList;
    }

    protected List<IAbstractState<?>> getAbstractStatesList() {
        return this.mAbstractStates;
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompoundDomainState compoundDomainState = (CompoundDomainState)object;
        return Objects.equals(this.mAbstractStates, compoundDomainState.mAbstractStates);
    }

    public IAbstractState.SubsetResult isSubsetOf(CompoundDomainState compoundDomainState) {
        IAbstractState.SubsetResult subsetResult = IAbstractState.SubsetResult.EQUAL;
        int n = 0;
        while (n < this.mAbstractStates.size()) {
            if ((subsetResult = CompoundDomainState.isStrictSubsetOf(subsetResult, this.mAbstractStates.get(n), compoundDomainState.mAbstractStates.get(n))) == IAbstractState.SubsetResult.NONE) {
                return subsetResult;
            }
            ++n;
        }
        return subsetResult;
    }

    private static IAbstractState.SubsetResult isStrictSubsetOf(IAbstractState.SubsetResult subsetResult, IAbstractState<?> iAbstractState, IAbstractState<?> iAbstractState2) {
        IAbstractState.SubsetResult subsetResult2 = CompoundDomainState.isSubsetOfInternally(iAbstractState, iAbstractState2);
        return subsetResult.min(subsetResult2);
    }

    public String toString() {
        return this.toLogString();
    }

    public CompoundDomainState intersect(CompoundDomainState compoundDomainState) {
        List<IAbstractState<?>> list = this.getAbstractStatesList();
        List<IAbstractState<?>> list2 = compoundDomainState.getAbstractStatesList();
        List<IAbstractDomain> list3 = this.getDomainList();
        assert (list.size() == list2.size());
        assert (list3.size() == compoundDomainState.getDomainList().size());
        assert (list3.size() == list.size());
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            IAbstractState<?> iAbstractState3 = list.get(n);
            IAbstractState<?> iAbstractState4 = list2.get(n);
            arrayList.add((IAbstractState<?>)CompoundDomainState.applyCasted(iAbstractState3, iAbstractState4, (iAbstractState, iAbstractState2) -> iAbstractState.intersect(iAbstractState2)));
            ++n;
        }
        return new CompoundDomainState(this.mServices, list3, arrayList);
    }

    public CompoundDomainState union(CompoundDomainState compoundDomainState) {
        List<IAbstractState<?>> list = this.getAbstractStatesList();
        List<IAbstractState<?>> list2 = compoundDomainState.getAbstractStatesList();
        List<IAbstractDomain> list3 = this.getDomainList();
        assert (list.size() == list2.size());
        assert (list3.size() == compoundDomainState.getDomainList().size());
        assert (list3.size() == list.size());
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            IAbstractState<?> iAbstractState3 = list.get(n);
            IAbstractState<?> iAbstractState4 = list2.get(n);
            arrayList.add((IAbstractState<?>)CompoundDomainState.applyCasted(iAbstractState3, iAbstractState4, (iAbstractState, iAbstractState2) -> iAbstractState.union(iAbstractState2)));
            ++n;
        }
        return new CompoundDomainState(this.mServices, list3, arrayList);
    }

    public CompoundDomainState compact() {
        List<IAbstractState<?>> list = this.getAbstractStatesList();
        int n = list.size();
        List<IAbstractDomain> list2 = this.getDomainList();
        assert (list2.size() == list.size());
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        HashSet hashSet = new HashSet();
        for (IAbstractState<?> iAbstractState : list) {
            IAbstractState iAbstractState2 = iAbstractState.compact();
            hashSet.addAll(iAbstractState2.getVariables());
            arrayList.add(iAbstractState2);
        }
        ArrayList arrayList2 = new ArrayList(n);
        for (IAbstractState iAbstractState : arrayList) {
            Set set = DataStructureUtils.difference(hashSet, (Set)iAbstractState.getVariables());
            if (set.isEmpty()) {
                arrayList2.add(iAbstractState);
                continue;
            }
            arrayList2.add(iAbstractState.addVariables((Collection)set));
        }
        return new CompoundDomainState(this.mServices, list2, arrayList2);
    }

    private static <T extends IAbstractState<T>> T applyCasted(IAbstractState<?> iAbstractState, IAbstractState<?> iAbstractState2, IAbstractStateBinaryOperator<T> iAbstractStateBinaryOperator) {
        IAbstractState<?> iAbstractState3 = iAbstractState;
        IAbstractState<?> iAbstractState4 = iAbstractState2;
        return (T)((IAbstractState)iAbstractStateBinaryOperator.apply(iAbstractState3, iAbstractState4));
    }
}

