/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness;

import de.uni_freiburg.informatik.ultimate.acsl.parser.ACSLSyntaxErrorException;
import de.uni_freiburg.informatik.ultimate.acsl.parser.Parser;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.witness.IExtractedWitnessEntry;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public abstract class ExtractedWitnessInvariant
implements IExtractedWitnessEntry {
    private final String mInvariant;
    private final IASTNode mMatchedAstNode;

    public ExtractedWitnessInvariant(String string, IASTNode iASTNode) {
        this.mInvariant = string;
        this.mMatchedAstNode = iASTNode;
    }

    public String getInvariant() {
        return this.mInvariant;
    }

    private int getStartline() {
        return this.mMatchedAstNode.getFileLocation().getStartingLineNumber();
    }

    private int getEndline() {
        return this.mMatchedAstNode.getFileLocation().getEndingLineNumber();
    }

    public IASTNode getRelatedAstNode() {
        return this.mMatchedAstNode;
    }

    public String toString() {
        return this.getLocationDescription() + " [L" + this.getStartline() + "-L" + this.getEndline() + "] " + this.mInvariant;
    }

    protected abstract String getLocationDescription();

    protected ExpressionResult instrument(ILocation iLocation, IDispatcher iDispatcher) {
        ACSLNode aCSLNode = null;
        try {
            ExtractedWitnessInvariant.checkForQuantifiers(this.mInvariant);
            aCSLNode = Parser.parseComment((String)("lstart\n assert " + this.mInvariant + ";"), (int)this.getStartline(), (int)1);
        }
        catch (ACSLSyntaxErrorException aCSLSyntaxErrorException) {
            throw new UnsupportedSyntaxException(iLocation, String.format("Unable to instrument \"%s\" at %s (%s)", this.mInvariant, iLocation, aCSLSyntaxErrorException.getMessageText()));
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
        return (ExpressionResult)iDispatcher.dispatch(aCSLNode, this.mMatchedAstNode);
    }

    private static void checkForQuantifiers(String string) {
        if (string.contains("exists") || string.contains("forall")) {
            throw new UnsupportedSyntaxException(LocationFactory.createIgnoreCLocation(), "invariant contains quantifiers");
        }
    }
}

