/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.Diet;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.FloydWarshall;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceEdgeLabel;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCcManager;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PartialOrderCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class WeakEquivalenceGraph<NODE extends IEqNodeIdentifier<NODE>> {
    private final WeqCcManager<NODE> mWeqCcManager;
    private final Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> mWeakEquivalenceEdges;
    private final Queue<ConstraintFromWeqGraph> mConstraintsToReport;
    final WeqCongruenceClosure<NODE> mWeqCc;
    private boolean mIsFrozen;
    final CongruenceClosure<NODE> mEmptyDisjunct;

    public WeakEquivalenceGraph(WeqCongruenceClosure<NODE> weqCongruenceClosure, WeqCcManager<NODE> weqCcManager, CongruenceClosure<NODE> congruenceClosure) {
        this.mWeqCc = weqCongruenceClosure;
        this.mWeakEquivalenceEdges = new HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>();
        this.mConstraintsToReport = new ArrayDeque<ConstraintFromWeqGraph>();
        this.mWeqCcManager = weqCcManager;
        this.mEmptyDisjunct = congruenceClosure;
        assert (this.sanityCheck());
    }

    private WeakEquivalenceGraph(Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> map, Queue<ConstraintFromWeqGraph> queue, WeqCcManager<NODE> weqCcManager, CongruenceClosure<NODE> congruenceClosure) {
        this.mWeqCc = null;
        this.mWeakEquivalenceEdges = map;
        this.mConstraintsToReport = queue;
        this.mWeqCcManager = weqCcManager;
        this.mEmptyDisjunct = congruenceClosure;
        assert (this.sanityCheck());
    }

    public WeakEquivalenceGraph(WeqCongruenceClosure<NODE> weqCongruenceClosure, WeakEquivalenceGraph<NODE> weakEquivalenceGraph) {
        this.mWeqCc = weqCongruenceClosure;
        this.mConstraintsToReport = new ArrayDeque<ConstraintFromWeqGraph>(weakEquivalenceGraph.mConstraintsToReport);
        this.mWeakEquivalenceEdges = new HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>();
        this.mWeqCcManager = weakEquivalenceGraph.getWeqCcManager();
        this.mEmptyDisjunct = weakEquivalenceGraph.mEmptyDisjunct;
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : weakEquivalenceGraph.mWeakEquivalenceEdges.entrySet()) {
            Doubleton doubleton = new Doubleton((Object)weqCongruenceClosure.getRepresentativeElement((IEqNodeIdentifier)entry.getKey().getOneElement()), (Object)weqCongruenceClosure.getRepresentativeElement((IEqNodeIdentifier)entry.getKey().getOtherElement()));
            this.putEdgeLabel(doubleton, this.mWeqCcManager.copy(entry.getValue(), this, true));
        }
        assert (this.sanityCheck());
    }

    public ConstraintFromWeqGraph pollStoredConstraintAndRemoveRelatedWeqEdge() {
        if (!this.hasConstraintsToReport()) {
            throw new IllegalStateException("check hasArrayEqualities before calling this method");
        }
        ConstraintFromWeqGraph constraintFromWeqGraph = this.mConstraintsToReport.poll();
        this.mWeakEquivalenceEdges.remove(constraintFromWeqGraph.getRelatedWeqEdge());
        return constraintFromWeqGraph;
    }

    @Deprecated
    public boolean reportChangeInGroundPartialArrangement(Predicate<CongruenceClosure<NODE>> predicate) {
        assert (!this.mIsFrozen);
        boolean bl = false;
        HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> hashMap = new HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>(this.mWeakEquivalenceEdges);
        for (Map.Entry entry : hashMap.entrySet()) {
            WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel = ((WeakEquivalenceEdgeLabel)entry.getValue()).reportChangeInGroundPartialArrangement(predicate);
            this.updateConstraintsToBePropagated((Doubleton)entry.getKey(), (WeakEquivalenceEdgeLabel)entry.getValue());
            bl = true;
            this.putEdgeLabel((Doubleton)entry.getKey(), weakEquivalenceEdgeLabel);
            bl |= !this.mWeqCcManager.isEquivalentCc((WeakEquivalenceEdgeLabel)entry.getValue(), weakEquivalenceEdgeLabel);
        }
        return bl;
    }

    public void replaceVertex(NODE NODE, NODE NODE2) {
        HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> hashMap = new HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>(this.mWeakEquivalenceEdges);
        for (Map.Entry entry : hashMap.entrySet()) {
            WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel;
            IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)((Doubleton)entry.getKey()).getOneElement();
            IEqNodeIdentifier iEqNodeIdentifier2 = (IEqNodeIdentifier)((Doubleton)entry.getKey()).getOtherElement();
            if (iEqNodeIdentifier.equals(NODE)) {
                weakEquivalenceEdgeLabel = this.mWeakEquivalenceEdges.remove(entry.getKey());
                if (NODE2 == null) continue;
                this.putEdgeLabelDuringRemove(new Doubleton(NODE2, (Object)iEqNodeIdentifier2), weakEquivalenceEdgeLabel, NODE2);
                continue;
            }
            if (!iEqNodeIdentifier2.equals(NODE)) continue;
            weakEquivalenceEdgeLabel = this.mWeakEquivalenceEdges.remove(entry.getKey());
            if (NODE2 == null) continue;
            this.putEdgeLabelDuringRemove(new Doubleton((Object)iEqNodeIdentifier, NODE2), weakEquivalenceEdgeLabel, NODE2);
        }
    }

    public WeakEquivalenceGraph<NODE> thinLabels(WeqCongruenceClosure<NODE> weqCongruenceClosure) {
        assert (this.mWeqCc.mDiet != Diet.THIN);
        WeakEquivalenceGraph<IEqNodeIdentifier> weakEquivalenceGraph = new WeakEquivalenceGraph<IEqNodeIdentifier>(weqCongruenceClosure, this.mWeqCcManager, this.mWeqCcManager.getEmptyCc(false));
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            weakEquivalenceGraph.reportWeakEquivalence((IEqNodeIdentifier)entry.getKey().getOneElement(), (IEqNodeIdentifier)entry.getKey().getOtherElement(), entry.getValue().thin(weakEquivalenceGraph), true);
        }
        return weakEquivalenceGraph;
    }

    public Set<NODE> projectAwaySimpleElementInEdgeLabels(NODE NODE) {
        assert (!this.mIsFrozen);
        HashSet<NODE> hashSet = new HashSet<NODE>();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            assert (!NODE.equals(entry.getKey().getOneElement()));
            assert (!NODE.equals(entry.getKey().getOtherElement()));
            hashSet.addAll(entry.getValue().projectAwaySimpleElement(NODE));
        }
        assert (this.assertElementIsFullyRemoved(NODE));
        return hashSet;
    }

    public void transformElementsAndFunctions(Function<NODE, NODE> function) {
        HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> hashMap = new HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>(this.mWeakEquivalenceEdges);
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : hashMap.entrySet()) {
            this.mWeakEquivalenceEdges.remove(entry.getKey());
            Doubleton doubleton = new Doubleton((Object)((IEqNodeIdentifier)function.apply((IEqNodeIdentifier)entry.getKey().getOneElement())), (Object)((IEqNodeIdentifier)function.apply((IEqNodeIdentifier)entry.getKey().getOtherElement())));
            if (entry.getValue().isFrozen()) {
                WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel = this.mWeqCcManager.unfreeze(entry.getValue());
                weakEquivalenceEdgeLabel.transformElements(function);
                this.putEdgeLabel(doubleton, weakEquivalenceEdgeLabel);
                continue;
            }
            entry.getValue().transformElements(function);
            this.putEdgeLabel(doubleton, entry.getValue());
        }
        assert (this.sanityCheck());
    }

    WeakEquivalenceGraph<NODE> join(WeakEquivalenceGraph<NODE> weakEquivalenceGraph) {
        Object object;
        IEqNodeIdentifier iEqNodeIdentifier;
        Object object2;
        assert (this.mWeqCc != null && weakEquivalenceGraph.mWeqCc != null) : "we need the base weqCc for the joinof the weq graphs, because strong equalities influence the weak ones..";
        assert (this.isFrozen() && weakEquivalenceGraph.isFrozen()) : "frozen <-> fully closed/reduced";
        WeakEquivalenceGraph<NODE> weakEquivalenceGraph2 = new WeakEquivalenceGraph<NODE>(null, this.mWeqCcManager, this.mEmptyDisjunct);
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel;
            object2 = weakEquivalenceGraph.getEdgeLabel(entry.getKey());
            iEqNodeIdentifier = (IEqNodeIdentifier)entry.getKey().getOneElement();
            if (weakEquivalenceGraph.mWeqCc.hasElements(new IEqNodeIdentifier[]{iEqNodeIdentifier, object = (IEqNodeIdentifier)entry.getKey().getOtherElement()}) && weakEquivalenceGraph.mWeqCc.getEqualityStatus(iEqNodeIdentifier, (IEqNodeIdentifier)object) == EqualityStatus.EQUAL) {
                weakEquivalenceEdgeLabel = this.mWeqCcManager.copy(entry.getValue(), weakEquivalenceGraph2, true);
                weakEquivalenceGraph2.putEdgeLabel(entry.getKey(), weakEquivalenceEdgeLabel);
                assert (object2 == null);
                continue;
            }
            if (object2 == null) continue;
            weakEquivalenceEdgeLabel = this.mWeqCcManager.copy(entry.getValue(), weakEquivalenceGraph2, true);
            WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2 = this.mWeqCcManager.copy((WeakEquivalenceEdgeLabel<NODE>)object2, weakEquivalenceGraph2, true);
            weakEquivalenceGraph2.putEdgeLabel(entry.getKey(), weakEquivalenceEdgeLabel.union(weakEquivalenceEdgeLabel2));
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : weakEquivalenceGraph.getWeqEdgesEntrySet()) {
            object2 = (IEqNodeIdentifier)entry.getKey().getOneElement();
            if (!this.mWeqCc.hasElements(new IEqNodeIdentifier[]{object2, iEqNodeIdentifier = (IEqNodeIdentifier)entry.getKey().getOtherElement()}) || this.mWeqCc.getEqualityStatus((IEqNodeIdentifier)object2, iEqNodeIdentifier) != EqualityStatus.EQUAL) continue;
            object = this.mWeqCcManager.copy(entry.getValue(), weakEquivalenceGraph2, true);
            weakEquivalenceGraph2.putEdgeLabel((Doubleton<NODE>)new Doubleton(object2, (Object)iEqNodeIdentifier), (WeakEquivalenceEdgeLabel<NODE>)object);
        }
        assert (weakEquivalenceGraph2.sanityCheck());
        return weakEquivalenceGraph2;
    }

    boolean hasConstraintsToReport() {
        return !this.mConstraintsToReport.isEmpty();
    }

    WeakEquivalenceEdgeLabel<NODE> otherPlus(Pair<WeakEquivalenceEdgeLabel<NODE>, WeakEquivalenceEdgeLabel<NODE>> pair, Triple<NODE, NODE, NODE> triple) {
        WeakEquivalenceEdgeLabel weakEquivalenceEdgeLabel = (WeakEquivalenceEdgeLabel)pair.getFirst();
        WeakEquivalenceEdgeLabel weakEquivalenceEdgeLabel2 = (WeakEquivalenceEdgeLabel)pair.getSecond();
        assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || weakEquivalenceEdgeLabel.sanityCheck());
        assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || weakEquivalenceEdgeLabel2.sanityCheck());
        IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)triple.getFirst();
        IEqNodeIdentifier iEqNodeIdentifier2 = (IEqNodeIdentifier)triple.getSecond();
        IEqNodeIdentifier iEqNodeIdentifier3 = (IEqNodeIdentifier)triple.getThird();
        if (iEqNodeIdentifier.getSort() != iEqNodeIdentifier2.getSort()) {
            assert (weakEquivalenceEdgeLabel.isTautological());
            return weakEquivalenceEdgeLabel;
        }
        if (iEqNodeIdentifier2.getSort() != iEqNodeIdentifier3.getSort()) {
            assert (weakEquivalenceEdgeLabel2.isTautological());
            return weakEquivalenceEdgeLabel2;
        }
        boolean bl = this.mayVanishOnProjectOfArray(weakEquivalenceEdgeLabel, iEqNodeIdentifier2);
        boolean bl2 = this.mayVanishOnProjectOfArray(weakEquivalenceEdgeLabel2, iEqNodeIdentifier2);
        if (bl) {
            IEqNodeIdentifier iEqNodeIdentifier4 = this.constructAOfQ(new MultiDimensionalSort(iEqNodeIdentifier.getSort()), iEqNodeIdentifier);
            IEqNodeIdentifier iEqNodeIdentifier5 = this.constructAOfQ(new MultiDimensionalSort(iEqNodeIdentifier.getSort()), iEqNodeIdentifier2);
            WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel3 = this.mWeqCcManager.reportEquality(weakEquivalenceEdgeLabel, iEqNodeIdentifier4, iEqNodeIdentifier5, false);
            assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || weakEquivalenceEdgeLabel3.sanityCheck());
            return weakEquivalenceEdgeLabel3.union(weakEquivalenceEdgeLabel2, null);
        }
        if (bl2) {
            IEqNodeIdentifier iEqNodeIdentifier6 = this.constructAOfQ(new MultiDimensionalSort(iEqNodeIdentifier3.getSort()), iEqNodeIdentifier3);
            IEqNodeIdentifier iEqNodeIdentifier7 = this.constructAOfQ(new MultiDimensionalSort(iEqNodeIdentifier.getSort()), iEqNodeIdentifier2);
            WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel4 = this.mWeqCcManager.reportEquality(weakEquivalenceEdgeLabel2, iEqNodeIdentifier6, iEqNodeIdentifier7, false);
            assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || weakEquivalenceEdgeLabel4.sanityCheck());
            return weakEquivalenceEdgeLabel.union(weakEquivalenceEdgeLabel4, null);
        }
        return weakEquivalenceEdgeLabel.union(weakEquivalenceEdgeLabel2, null);
    }

    private NODE constructAOfQ(MultiDimensionalSort multiDimensionalSort, NODE object) {
        int n = multiDimensionalSort.getDimension();
        int n2 = n - 1;
        while (n2 >= 0) {
            NODE NODE = this.mWeqCcManager.getWeqVariableNodeForDimension(n2, (Sort)multiDimensionalSort.getIndexSorts().get(n2));
            object = (IEqNodeIdentifier)this.mWeqCcManager.getEqNodeAndFunctionFactory().getOrConstructFuncAppElement((ICongruenceClosureElement)object, (ICongruenceClosureElement)NODE);
            --n2;
        }
        return object;
    }

    private boolean mayVanishOnProjectOfArray(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, NODE NODE) {
        if (weakEquivalenceEdgeLabel.isTautological() || weakEquivalenceEdgeLabel.isInconsistent()) {
            return false;
        }
        return weakEquivalenceEdgeLabel.getDisjuncts().stream().anyMatch(congruenceClosure -> this.mayVanishOnProjectOfArray((CongruenceClosure<NODE>)congruenceClosure, NODE));
    }

    private boolean mayVanishOnProjectOfArray(CongruenceClosure<NODE> congruenceClosure, NODE NODE) {
        return !this.mWeqCcManager.getAllWeqNodes().stream().anyMatch(iEqNodeIdentifier -> congruenceClosure.isConstrainedDirectly((ICongruenceClosureElement)iEqNodeIdentifier));
    }

    Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> propagateViaTriangleRule() {
        if (this.mWeakEquivalenceEdges.isEmpty()) {
            return Collections.emptyMap();
        }
        assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || this.sanityCheck());
        BiPredicate<WeakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel> biPredicate = (weakEquivalenceEdgeLabel, weakEquivalenceEdgeLabel2) -> this.mWeqCcManager.isStrongerThan(weakEquivalenceEdgeLabel, weakEquivalenceEdgeLabel2, this.mWeqCcManager::isStrongerThan);
        BiFunction<Pair, Triple, WeakEquivalenceEdgeLabel> biFunction = this::otherPlus;
        BiFunction<WeakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel> biFunction2 = (weakEquivalenceEdgeLabel, weakEquivalenceEdgeLabel2) -> this.mWeqCcManager.meetEdgeLabels((WeakEquivalenceEdgeLabel<NODE>)weakEquivalenceEdgeLabel, (WeakEquivalenceEdgeLabel<NODE>)weakEquivalenceEdgeLabel2, false);
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel3 = new WeakEquivalenceEdgeLabel<NODE>(this, this.mEmptyDisjunct);
        Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> map = this.mWeakEquivalenceEdges;
        Function<WeakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel> function = weakEquivalenceEdgeLabel -> this.mWeqCcManager.copy((WeakEquivalenceEdgeLabel<NODE>)weakEquivalenceEdgeLabel, true);
        FloydWarshall<NODE, WeakEquivalenceEdgeLabel> floydWarshall = new FloydWarshall<NODE, WeakEquivalenceEdgeLabel>(biPredicate, biFunction, biFunction2, weakEquivalenceEdgeLabel3, map, function, true);
        if (!floydWarshall.performedChanges()) {
            return Collections.emptyMap();
        }
        assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || floydWarshall.getResult().keySet().stream().allMatch(doubleton -> ((IEqNodeIdentifier)doubleton.getOneElement()).getSort().equals(((IEqNodeIdentifier)doubleton.getOtherElement()).getSort())));
        return floydWarshall.getResult();
    }

    public boolean isEmpty() {
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            if (entry.getValue().isTautological()) continue;
            return false;
        }
        return true;
    }

    boolean isStrongerThan(WeakEquivalenceGraph<NODE> weakEquivalenceGraph) {
        assert (this.isFrozen() && weakEquivalenceGraph.isFrozen());
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : weakEquivalenceGraph.getWeqEdgesEntrySet()) {
            WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel = this.getEdgeLabel(entry.getKey());
            if (weakEquivalenceEdgeLabel == null) {
                return false;
            }
            if (this.mWeqCcManager.isStrongerThan(weakEquivalenceEdgeLabel, entry.getValue())) continue;
            return false;
        }
        return true;
    }

    boolean isFrozen() {
        return this.mIsFrozen;
    }

    public List<Term> getWeakEquivalenceConstraintsAsTerms(Script script) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            ArrayList<Term> arrayList2 = new ArrayList<Term>(entry.getValue().toDnf(script));
            IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)entry.getKey().getOneElement();
            IEqNodeIdentifier iEqNodeIdentifier2 = (IEqNodeIdentifier)entry.getKey().getOtherElement();
            assert (iEqNodeIdentifier.hasSameTypeAs(iEqNodeIdentifier2));
            Term term = this.computeArrayEquation(script, iEqNodeIdentifier, iEqNodeIdentifier2);
            arrayList2.add(term);
            Term term2 = SmtUtils.quantifier((Script)script, (int)1, new HashSet<TermVariable>(this.computeWeqIndicesForArray((IEqNodeIdentifier)entry.getKey().getOneElement())), (Term)SmtUtils.or((Script)script, arrayList2));
            arrayList.add(term2);
            assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained2() || this.mWeqCcManager.getAllWeqVariables().stream().allMatch(termVariable -> !Arrays.asList(term2.getFreeVars()).contains(termVariable))) : "free weqvar in formula";
        }
        return arrayList;
    }

    private Term computeArrayEquation(Script script, NODE NODE, NODE NODE2) {
        assert (NODE.getTerm().getSort().equals(NODE2.getTerm().getSort()));
        List list = this.computeWeqIndicesForArray(NODE).stream().map(termVariable -> termVariable).collect(Collectors.toList());
        ArrayIndex arrayIndex = new ArrayIndex(list);
        Term term = NODE.getSort().isArraySort() ? SmtUtils.multiDimensionalSelect((Script)script, (Term)NODE.getTerm(), (ArrayIndex)arrayIndex) : NODE.getTerm();
        Term term2 = NODE2.getSort().isArraySort() ? SmtUtils.multiDimensionalSelect((Script)script, (Term)NODE2.getTerm(), (ArrayIndex)arrayIndex) : NODE2.getTerm();
        return SmtUtils.binaryEquality((Script)script, (Term)term, (Term)term2);
    }

    private List<TermVariable> computeWeqIndicesForArray(NODE NODE) {
        MultiDimensionalSort multiDimensionalSort = new MultiDimensionalSort(NODE.getTerm().getSort());
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        int n = 0;
        while (n < multiDimensionalSort.getDimension()) {
            arrayList.add(this.mWeqCcManager.getWeqVariableForDimension(n, (Sort)multiDimensionalSort.getIndexSorts().get(n)));
            ++n;
        }
        return arrayList;
    }

    public Map<NODE, WeakEquivalenceEdgeLabel<NODE>> getAdjacentWeqEdges(NODE NODE) {
        HashMap<IEqNodeIdentifier, WeakEquivalenceEdgeLabel<NODE>> hashMap = new HashMap<IEqNodeIdentifier, WeakEquivalenceEdgeLabel<NODE>>();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            if (((IEqNodeIdentifier)entry.getKey().getOneElement()).equals(NODE)) {
                hashMap.put((IEqNodeIdentifier)entry.getKey().getOtherElement(), entry.getValue());
            }
            if (!((IEqNodeIdentifier)entry.getKey().getOtherElement()).equals(NODE)) continue;
            hashMap.put((IEqNodeIdentifier)entry.getKey().getOneElement(), entry.getValue());
        }
        return hashMap;
    }

    public Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> getEdges() {
        return Collections.unmodifiableMap(this.mWeakEquivalenceEdges);
    }

    void putEdgeLabel(Doubleton<NODE> doubleton, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel) {
        assert (!this.isFrozen()) : "attempting to change a frozen weq graph";
        assert (this.mWeqCc == null || this.mWeqCc.isRepresentative((IEqNodeIdentifier)doubleton.getOneElement()));
        assert (this.mWeqCc == null || this.mWeqCc.isRepresentative((IEqNodeIdentifier)doubleton.getOtherElement()));
        assert (!this.mIsFrozen || weakEquivalenceEdgeLabel.assertDisjunctsAreFrozen());
        this.mWeakEquivalenceEdges.put(doubleton, weakEquivalenceEdgeLabel);
    }

    private void putEdgeLabelDuringRemove(Doubleton<NODE> doubleton, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, NODE NODE) {
        this.mWeakEquivalenceEdges.put(doubleton, weakEquivalenceEdgeLabel);
    }

    private WeakEquivalenceEdgeLabel<NODE> getEdgeLabel(Doubleton<NODE> doubleton) {
        return this.mWeakEquivalenceEdges.get(doubleton);
    }

    private boolean reportWeakEquivalence(Doubleton<NODE> doubleton, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, boolean bl) {
        assert (!weakEquivalenceEdgeLabel.isTautological()) : "catch this case before?";
        assert (!this.mIsFrozen);
        assert (this.mWeqCc.isRepresentative((IEqNodeIdentifier)doubleton.getOneElement()) && this.mWeqCc.isRepresentative((IEqNodeIdentifier)doubleton.getOtherElement()));
        assert (((IEqNodeIdentifier)doubleton.getOneElement()).getTerm().getSort().equals(((IEqNodeIdentifier)doubleton.getOtherElement()).getTerm().getSort()));
        assert (!this.mIsFrozen);
        assert (this.mWeqCc.isRepresentative((IEqNodeIdentifier)doubleton.getOneElement()) && this.mWeqCc.isRepresentative((IEqNodeIdentifier)doubleton.getOtherElement()));
        assert (!((IEqNodeIdentifier)doubleton.getOneElement()).equals(doubleton.getOtherElement()));
        assert (bl || this.sanityCheck());
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2 = this.getEdgeLabel(doubleton);
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel3 = this.mWeqCcManager.copy(weakEquivalenceEdgeLabel, this, true);
        if (weakEquivalenceEdgeLabel3.isInconsistent()) {
            this.putEdgeLabel(doubleton, weakEquivalenceEdgeLabel3);
            this.addSetConstraintToReport(new ConstraintFromWeqGraph(this, (IEqNodeIdentifier)doubleton.getOneElement(), (IEqNodeIdentifier)doubleton.getOtherElement()));
            return weakEquivalenceEdgeLabel2 == null || !weakEquivalenceEdgeLabel2.isInconsistent();
        }
        if (weakEquivalenceEdgeLabel2 == null || weakEquivalenceEdgeLabel2.isTautological()) {
            WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel4;
            this.updateConstraintsToBePropagated(doubleton, weakEquivalenceEdgeLabel3);
            if (this.mWeqCcManager.getSettings().isMeetWithGpaOnReportWeq()) {
                weakEquivalenceEdgeLabel3.meetWithCcGpa();
                weakEquivalenceEdgeLabel4 = weakEquivalenceEdgeLabel3.projectToElements(new HashSet<IEqNodeIdentifier>(this.mWeqCcManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)doubleton.getOneElement())), false);
            } else {
                weakEquivalenceEdgeLabel4 = this.mWeqCc.getDiet() == Diet.THIN ? weakEquivalenceEdgeLabel3.projectToElements(new HashSet<IEqNodeIdentifier>(this.mWeqCcManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)doubleton.getOneElement())), false) : weakEquivalenceEdgeLabel3;
            }
            this.putEdgeLabel(doubleton, weakEquivalenceEdgeLabel4);
            assert (bl || this.sanityCheck());
            return true;
        }
        assert (weakEquivalenceEdgeLabel2.getWeqGraph() == this);
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel5 = this.mWeqCcManager.copy(weakEquivalenceEdgeLabel2, true);
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel6 = weakEquivalenceEdgeLabel3;
        assert (weakEquivalenceEdgeLabel6.sanityCheck()) : "input label not normalized??";
        if (this.mWeqCcManager.getSettings().isMeetWithGpaOnReportWeq()) {
            weakEquivalenceEdgeLabel6.meetWithCcGpa();
            weakEquivalenceEdgeLabel5.meetWithCcGpa();
        }
        if (this.mWeqCcManager.isStrongerThan(weakEquivalenceEdgeLabel5, weakEquivalenceEdgeLabel6)) {
            return false;
        }
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel7 = this.mWeqCcManager.meetEdgeLabels(weakEquivalenceEdgeLabel5, weakEquivalenceEdgeLabel6, false);
        if (this.mWeqCcManager.isStrongerThan(weakEquivalenceEdgeLabel2, weakEquivalenceEdgeLabel7)) {
            return false;
        }
        this.updateConstraintsToBePropagated(doubleton, weakEquivalenceEdgeLabel7);
        if (this.mWeqCc.mDiet == Diet.THIN) {
            weakEquivalenceEdgeLabel7 = weakEquivalenceEdgeLabel7.projectToElements(new HashSet<IEqNodeIdentifier>(this.mWeqCcManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)doubleton.getOneElement())), false);
        }
        if (this.mWeqCcManager.isStrongerThan(weakEquivalenceEdgeLabel2, weakEquivalenceEdgeLabel7)) {
            return false;
        }
        assert (weakEquivalenceEdgeLabel7.sanityCheck());
        this.putEdgeLabel(doubleton, weakEquivalenceEdgeLabel7);
        assert (bl || this.sanityCheck());
        return true;
    }

    private void updateConstraintsToBePropagated(Doubleton<NODE> doubleton, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel) {
        if (weakEquivalenceEdgeLabel.isInconsistent()) {
            this.addSetConstraintToReport(new ConstraintFromWeqGraph(this, (IEqNodeIdentifier)doubleton.getOneElement(), (IEqNodeIdentifier)doubleton.getOtherElement()));
        }
        if (((IEqNodeIdentifier)doubleton.getOneElement()).getSort().isArraySort()) {
            return;
        }
        Collection<ConstraintFromWeqGraph> collection = this.checkEdgeForImpliedSetConstraints(doubleton, weakEquivalenceEdgeLabel);
        for (ConstraintFromWeqGraph constraintFromWeqGraph : collection) {
            this.addSetConstraintToReport(constraintFromWeqGraph);
        }
    }

    public boolean reportWeakEquivalence(NODE NODE, NODE NODE2, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, boolean bl) {
        assert (!this.mIsFrozen);
        assert (this.mWeqCc.isRepresentative(NODE) && this.mWeqCc.isRepresentative(NODE2));
        if (weakEquivalenceEdgeLabel.isTautological()) {
            return false;
        }
        boolean bl2 = this.reportWeakEquivalence(new Doubleton(NODE, NODE2), weakEquivalenceEdgeLabel, bl);
        assert (bl || this.sanityCheck());
        return bl2;
    }

    public boolean isConstrained(NODE NODE) {
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            if (!entry.getValue().isConstrained(NODE)) continue;
            return true;
        }
        return false;
    }

    public WeakEquivalenceEdgeLabel<NODE> getEdgeLabel(NODE NODE, NODE NODE2) {
        NODE NODE3;
        if (NODE.getSort() != NODE2.getSort()) {
            throw new IllegalArgumentException("asking for a weak equivalence between of different sorts make no sense");
        }
        NODE NODE4 = this.mWeqCc.getRepresentativeElement(NODE);
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel = this.getEdgeLabel(new Doubleton(NODE4, NODE3 = this.mWeqCc.getRepresentativeElement(NODE2)));
        if (weakEquivalenceEdgeLabel == null) {
            return new WeakEquivalenceEdgeLabel<NODE>(this, this.mEmptyDisjunct);
        }
        return weakEquivalenceEdgeLabel;
    }

    public WeakEquivalenceEdgeLabel<NODE> projectEdgeLabelToPoint(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, NODE NODE, List<NODE> list) {
        assert (!this.mIsFrozen);
        assert (this.assertFrozenInsideOut());
        assert (weakEquivalenceEdgeLabel.getWeqGraph() == this);
        IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)list.get(0);
        List list2 = list.size() > 1 ? list.subList(0, list.size() - 2) : Collections.emptyList();
        CongruenceClosure<IEqNodeIdentifier> congruenceClosure2 = this.mWeqCcManager.getSingleEqualityCc(iEqNodeIdentifier, (IEqNodeIdentifier)NODE, true, (CongruenceClosure<IEqNodeIdentifier>)this.mEmptyDisjunct);
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel2 = this.mWeqCcManager.getSingletonEdgeLabel(this, congruenceClosure2);
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel3 = this.mWeqCcManager.copy(weakEquivalenceEdgeLabel, true);
        assert (!weakEquivalenceEdgeLabel3.isFrozen());
        if (this.mWeqCcManager.getSettings().isMeetWithGpaProjectOrShiftLabel()) {
            weakEquivalenceEdgeLabel3.meetWithCcGpa();
        }
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel4 = this.mWeqCcManager.meetEdgeLabels(weakEquivalenceEdgeLabel3, weakEquivalenceEdgeLabel2, true);
        weakEquivalenceEdgeLabel4.setExternalRemInfo(this.mWeqCc.getElementCurrentlyBeingRemoved());
        weakEquivalenceEdgeLabel4.projectWeqVarNode(iEqNodeIdentifier);
        weakEquivalenceEdgeLabel4.inOrDecreaseWeqVarIndices(-1, list);
        assert (!weakEquivalenceEdgeLabel4.getAppearingNodes().contains(list.get(list.size() - 1))) : "double check the condition if this assertion fails, but as we decreased all weq vars, the last one should not be present in the result, right?..";
        assert (!weakEquivalenceEdgeLabel4.getDisjuncts().stream().anyMatch(congruenceClosure -> congruenceClosure.isInconsistent())) : "label not well-formed";
        assert (weakEquivalenceEdgeLabel4.sanityCheckDontEnforceProjectToWeqVars(this.mWeqCc));
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weakEquivalenceEdgeLabel5 = this.mWeqCc.mDiet == Diet.THIN ? weakEquivalenceEdgeLabel4.projectToElements(new HashSet(list2), false) : weakEquivalenceEdgeLabel4;
        assert (this.mWeqCc.mDiet != Diet.THIN || weakEquivalenceEdgeLabel5.assertHasOnlyWeqVarConstraints(new HashSet(list2)));
        assert (weakEquivalenceEdgeLabel5.sanityCheck());
        return weakEquivalenceEdgeLabel5;
    }

    public WeakEquivalenceEdgeLabel<NODE> shiftLabelAndAddException(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, NODE NODE, List<NODE> list) {
        assert (!list.isEmpty()) : "because the array in the resolvent must have a dimension >= 1";
        assert (weakEquivalenceEdgeLabel.getWeqGraph() == this);
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2 = this.mWeqCcManager.copy(weakEquivalenceEdgeLabel, true);
        if (this.mWeqCcManager.getSettings().isMeetWithGpaProjectOrShiftLabel()) {
            weakEquivalenceEdgeLabel2.meetWithCcGpa();
        }
        weakEquivalenceEdgeLabel2.setExternalRemInfo(this.mWeqCc.getElementCurrentlyBeingRemoved());
        weakEquivalenceEdgeLabel2.projectWeqVarNode((IEqNodeIdentifier)list.get(list.size() - 1));
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel3 = weakEquivalenceEdgeLabel2;
        if (this.mWeqCc.mDiet == Diet.THIN) {
            weakEquivalenceEdgeLabel3 = weakEquivalenceEdgeLabel3.projectToElements(new HashSet<NODE>(list), true);
        }
        weakEquivalenceEdgeLabel3.inOrDecreaseWeqVarIndices(1, list);
        IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)list.get(0);
        assert (weakEquivalenceEdgeLabel3.isTautological() || weakEquivalenceEdgeLabel3.isInconsistent() || !weakEquivalenceEdgeLabel3.getAppearingNodes().contains(iEqNodeIdentifier));
        HashSet<CongruenceClosure<NODE>> hashSet = new HashSet<CongruenceClosure<NODE>>(weakEquivalenceEdgeLabel3.getDisjuncts());
        CongruenceClosure<IEqNodeIdentifier> congruenceClosure2 = this.mWeqCcManager.getSingleDisequalityCc(iEqNodeIdentifier, (IEqNodeIdentifier)NODE, true, (CongruenceClosure<IEqNodeIdentifier>)this.mEmptyDisjunct);
        hashSet.add(congruenceClosure2);
        assert (hashSet.stream().allMatch(congruenceClosure -> congruenceClosure.sanityCheckOnlyCc()));
        WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel4 = this.mWeqCcManager.filterRedundantICcs(new WeakEquivalenceEdgeLabel<NODE>(this, hashSet));
        assert (weakEquivalenceEdgeLabel4.getDisjuncts().stream().allMatch(congruenceClosure -> congruenceClosure.sanityCheckOnlyCc()));
        return weakEquivalenceEdgeLabel4;
    }

    public void collapseEdgeAtMerge(NODE NODE, NODE NODE2) {
        this.mWeakEquivalenceEdges.remove(new Doubleton(NODE, NODE2));
    }

    public void updateForNewRep(NODE NODE, NODE NODE2, NODE NODE3) {
        assert (this.mWeqCc.getRepresentativeElement(NODE) == NODE3);
        assert (this.mWeqCc.getRepresentativeElement(NODE2) == NODE3);
        if (NODE == NODE3) {
            for (Map.Entry<NODE, WeakEquivalenceEdgeLabel<NODE>> arrayDeque : this.getAdjacentWeqEdges(NODE2).entrySet()) {
                this.mWeakEquivalenceEdges.remove(new Doubleton(NODE2, (Object)((IEqNodeIdentifier)arrayDeque.getKey())));
                this.putEdgeLabel(new Doubleton(NODE3, (Object)((IEqNodeIdentifier)arrayDeque.getKey())), arrayDeque.getValue());
            }
        } else {
            for (Map.Entry<NODE, WeakEquivalenceEdgeLabel<NODE>> entry : this.getAdjacentWeqEdges(NODE).entrySet()) {
                this.mWeakEquivalenceEdges.remove(new Doubleton(NODE, (Object)((IEqNodeIdentifier)entry.getKey())));
                this.putEdgeLabel(new Doubleton(NODE3, (Object)((IEqNodeIdentifier)entry.getKey())), entry.getValue());
            }
        }
        this.mConstraintsToReport.removeIf(constraintFromWeqGraph -> constraintFromWeqGraph.vanishesOnMergeOf(NODE, NODE2));
        if (NODE == NODE3) {
            ArrayDeque<ConstraintFromWeqGraph> arrayDeque = new ArrayDeque<ConstraintFromWeqGraph>(this.mConstraintsToReport);
            this.mConstraintsToReport.clear();
            while (!arrayDeque.isEmpty()) {
                var5_4 = arrayDeque.poll();
                this.mConstraintsToReport.add(((ConstraintFromWeqGraph)var5_4).replaceNode(NODE2, NODE3));
            }
        } else {
            assert (NODE2 == NODE3);
            ArrayDeque<ConstraintFromWeqGraph> arrayDeque = new ArrayDeque<ConstraintFromWeqGraph>(this.mConstraintsToReport);
            this.mConstraintsToReport.clear();
            while (!arrayDeque.isEmpty()) {
                var5_4 = arrayDeque.poll();
                this.mConstraintsToReport.add(((ConstraintFromWeqGraph)var5_4).replaceNode(NODE, NODE3));
            }
        }
    }

    public Integer getNumberOfEdgesStatistic() {
        return this.mWeakEquivalenceEdges.size();
    }

    public Integer getMaxSizeOfEdgeLabelStatistic() {
        Optional<Integer> optional = this.mWeakEquivalenceEdges.values().stream().map(weakEquivalenceEdgeLabel -> weakEquivalenceEdgeLabel.getDisjuncts().size()).reduce(Math::max);
        if (optional.isPresent()) {
            return optional.get();
        }
        return 0;
    }

    private Set<Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>> getWeqEdgesEntrySet() {
        return this.mWeakEquivalenceEdges.entrySet();
    }

    public WeakEquivalenceGraph<NODE> ccFattenEdgeLabels() {
        assert (!this.mWeqCc.isInconsistent(false));
        assert (this.mWeqCc.getDiet() == Diet.TRANSITORY_THIN_TO_CCFAT || this.mWeqCc.getDiet() == Diet.TRANSITORY_CCREFATTEN);
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            entry.getValue().meetWithCcGpa();
            this.updateConstraintsToBePropagated(entry.getKey(), entry.getValue());
        }
        return this;
    }

    private void addSetConstraintToReport(ConstraintFromWeqGraph constraintFromWeqGraph) {
        this.mConstraintsToReport.add(constraintFromWeqGraph);
    }

    public boolean assertElementIsFullyRemoved(NODE NODE) {
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            if (((IEqNodeIdentifier)entry.getKey().getOneElement()).equals(NODE)) {
                assert (false);
                return false;
            }
            if (((IEqNodeIdentifier)entry.getKey().getOtherElement()).equals(NODE)) {
                assert (false);
                return false;
            }
            if (entry.getValue().assertElementIsFullyRemoved(NODE)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public ILogger getLogger() {
        return this.mWeqCc.getLogger();
    }

    public WeqCcManager<NODE> getWeqCcManager() {
        return this.mWeqCcManager;
    }

    public void freeze() {
        assert (!this.hasConstraintsToReport()) : "report array equalities before freezing";
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            entry.getValue().freezeIfNecessary();
        }
        this.mIsFrozen = true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty";
        }
        if (this.mWeakEquivalenceEdges.size() < this.mWeqCcManager.getSettings().getMaxNoWeqEdgesForVerboseToString()) {
            return this.toLogString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("summary:\n");
        for (Map.Entry<String, Integer> entry : this.summarize().entrySet()) {
            stringBuilder.append(String.format("%s : %d\n", entry.getKey(), entry.getValue()));
        }
        stringBuilder.append("graph shape:\n");
        for (Map.Entry<String, Object> entry : this.getWeqEdgesEntrySet()) {
            stringBuilder.append((Object)entry.getKey());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String toLogString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("\n");
            stringBuilder.append(entry.getValue().toLogString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    Map<String, Integer> summarize() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("#Edges", this.mWeakEquivalenceEdges.size());
        int n3 = this.mWeakEquivalenceEdges.values().stream().map(weakEquivalenceEdgeLabel -> weakEquivalenceEdgeLabel.getDisjuncts().size()).reduce((n, n2) -> n + n2).get();
        hashMap.put("#EdgeLabelDisjuncts", n3);
        hashMap.put("Average#EdgeLabelDisjuncts", n3 == 0 ? -1 : this.mWeakEquivalenceEdges.size() / n3);
        return hashMap;
    }

    public boolean assertLabelsAreUnfrozen() {
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            if (entry.getValue().isFrozen()) {
                assert (false);
                return false;
            }
            if (entry.getValue().assertDisjunctsAreUnfrozen()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    boolean sanityCheck() {
        assert (this.mWeqCcManager != null);
        if (this.mWeqCc != null && this.mWeqCc.isInconsistent(false)) {
            return true;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            if (((IEqNodeIdentifier)entry.getKey().getOneElement()).getSort().equals(((IEqNodeIdentifier)entry.getKey().getOtherElement()).getSort())) continue;
            assert (false) : "weq graph has edge between arrays of different sorts";
            return false;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            if (entry.getValue().getWeqGraph() == this) continue;
            assert (false) : "weq graph has edge label with incorrect getWeqGraph()";
            return false;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            assert (entry.getValue().sanityCheck());
        }
        assert (this.assertFrozenInsideOut());
        assert (this.sanityAllNodesOnWeqLabelsAreKnownToGpa(null));
        return this.sanityCheckWithoutNodesComparison();
    }

    private boolean assertFrozenInsideOut() {
        if (this.mWeqCc != null && this.mWeqCc.isFrozen() && !this.mIsFrozen) {
            assert (false);
            return false;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            if (!this.mIsFrozen || entry.getValue().assertDisjunctsAreFrozen()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    boolean sanityCheckWithoutNodesComparison() {
        IEqNodeIdentifier iEqNodeIdentifier;
        IEqNodeIdentifier iEqNodeIdentifier2;
        assert (this.mWeqCcManager != null) : "factory is needed for the sanity check..";
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> object : this.getWeqEdgesEntrySet()) {
            iEqNodeIdentifier2 = (IEqNodeIdentifier)object.getKey().getOneElement();
            if (iEqNodeIdentifier2.hasSameTypeAs(iEqNodeIdentifier = (IEqNodeIdentifier)object.getKey().getOtherElement())) continue;
            assert (false);
            return false;
        }
        if (this.mWeqCc != null) {
            for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
                iEqNodeIdentifier2 = (IEqNodeIdentifier)entry.getKey().getOneElement();
                iEqNodeIdentifier = (IEqNodeIdentifier)entry.getKey().getOtherElement();
                if (!this.mWeqCc.hasElement(iEqNodeIdentifier2)) {
                    assert (false) : "weq edge source is not known to partial arrangement";
                    return false;
                }
                if (!this.mWeqCc.hasElement(iEqNodeIdentifier)) {
                    assert (false) : "weq edge target is not known to partial arrangement";
                    return false;
                }
                if (!this.mWeqCc.isRepresentative(iEqNodeIdentifier2)) {
                    assert (false) : "weq edge source is not a representative";
                    return false;
                }
                if (this.mWeqCc.isRepresentative(iEqNodeIdentifier)) continue;
                assert (false) : "weq edge target is not a representative";
                return false;
            }
        }
        for (Doubleton doubleton : this.mWeakEquivalenceEdges.keySet()) {
            if (!((IEqNodeIdentifier)doubleton.getOneElement()).equals(doubleton.getOtherElement())) continue;
            assert (false) : "self loop in weq graph";
            return false;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            iEqNodeIdentifier2 = (IEqNodeIdentifier)entry.getKey().getOneElement();
            iEqNodeIdentifier = (IEqNodeIdentifier)entry.getKey().getOtherElement();
            if (!entry.getValue().isInconsistent() || this.mConstraintsToReport.stream().anyMatch(constraintFromWeqGraph -> constraintFromWeqGraph.isIsArrayEquality() && constraintFromWeqGraph.isEqualityBetween(iEqNodeIdentifier2, iEqNodeIdentifier))) continue;
            assert (false) : "lost track of an inconsistent weq edge";
            return false;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            int n = new MultiDimensionalSort(((IEqNodeIdentifier)entry.getKey().getOneElement()).getSort()).getDimension();
            if (entry.getValue().assertWeqVarSelectsHaveCorrectVarForDimension(n)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    protected boolean sanityAllNodesOnWeqLabelsAreKnownToGpa(Set<NODE> set) {
        if (this.mWeqCc != null) {
            for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
                WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel = entry.getValue();
                Set set2 = weakEquivalenceEdgeLabel.getAppearingNodes().stream().filter(iEqNodeIdentifier -> !CongruenceClosure.dependsOnAny((ICongruenceClosureElement)iEqNodeIdentifier, this.mWeqCcManager.getAllWeqNodes())).filter(iEqNodeIdentifier -> !CongruenceClosure.dependsOnAny((ICongruenceClosureElement)iEqNodeIdentifier, this.mWeqCcManager.getAllWeqPrimedNodes())).filter(iEqNodeIdentifier -> set == null || !set.contains(iEqNodeIdentifier)).collect(Collectors.toSet());
                if (this.mWeqCc.getAllElements().containsAll(set2)) continue;
                Set set3 = DataStructureUtils.difference(set2, this.mWeqCc.getAllElements());
                assert (false) : "weq edge contains node(s) that has been removed: " + String.valueOf(set3);
                return false;
            }
        }
        return true;
    }

    public void freezeIfNecessary() {
        if (!this.isFrozen()) {
            this.freeze();
        }
    }

    public Set<NODE> getAppearingNodes() {
        HashSet hashSet = new HashSet();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            hashSet.add((IEqNodeIdentifier)entry.getKey().getOneElement());
            hashSet.add((IEqNodeIdentifier)entry.getKey().getOtherElement());
            hashSet.addAll(entry.getValue().getAppearingNodes());
        }
        return hashSet;
    }

    public WeqCongruenceClosure<NODE> getBaseWeqCc() {
        return this.mWeqCc;
    }

    public CongruenceClosure<NODE> getEmptyDisjunct() {
        return this.mEmptyDisjunct;
    }

    public Set<NODE> getAppearingNonWeqVarNodes() {
        HashSet<IEqNodeIdentifier> hashSet = new HashSet<IEqNodeIdentifier>();
        for (IEqNodeIdentifier iEqNodeIdentifier : this.getAppearingNodes()) {
            if (CongruenceClosure.dependsOnAny((ICongruenceClosureElement)iEqNodeIdentifier, this.mWeqCcManager.getAllWeqNodes())) continue;
            hashSet.add(iEqNodeIdentifier);
        }
        return hashSet;
    }

    private Collection<ConstraintFromWeqGraph> checkEdgeForImpliedSetConstraints(Doubleton<NODE> doubleton, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel) {
        if (!((IEqNodeIdentifier)doubleton.getOneElement()).isFunctionApplication() && !((IEqNodeIdentifier)doubleton.getOtherElement()).isFunctionApplication()) {
            return Collections.emptyList();
        }
        if (weakEquivalenceEdgeLabel.isTautological()) {
            return Collections.emptyList();
        }
        ArrayList<ConstraintFromWeqGraph> arrayList = new ArrayList<ConstraintFromWeqGraph>();
        IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)doubleton.getOneElement();
        IEqNodeIdentifier iEqNodeIdentifier2 = (IEqNodeIdentifier)doubleton.getOtherElement();
        SetConstraintManager setConstraintManager = this.mWeqCcManager.getCcManager().getSetConstraintManager();
        IEqNodeIdentifier iEqNodeIdentifier3 = iEqNodeIdentifier;
        IEqNodeIdentifier iEqNodeIdentifier4 = iEqNodeIdentifier2;
        this.collectImpliedSetconstraints(setConstraintManager, arrayList, weakEquivalenceEdgeLabel, iEqNodeIdentifier3, iEqNodeIdentifier4);
        this.collectImpliedSetconstraints(setConstraintManager, arrayList, weakEquivalenceEdgeLabel, iEqNodeIdentifier4, iEqNodeIdentifier3);
        return arrayList;
    }

    private void collectImpliedSetconstraints(SetConstraintManager<NODE> setConstraintManager, Collection<ConstraintFromWeqGraph> collection, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, NODE NODE, NODE NODE2) {
        if (!NODE.isFunctionApplication()) {
            return;
        }
        Set<SetConstraint<NODE>> set = weakEquivalenceEdgeLabel.getContainsConstraintForElement(NODE);
        if (set == null || set.isEmpty()) {
            collection.add(new ConstraintFromWeqGraph(this, NODE, NODE2, true));
            return;
        }
        for (SetConstraint<NODE> setConstraint : set) {
            HashSet<NODE> hashSet = new HashSet<NODE>(setConstraint.getLiterals());
            HashSet<NODE> hashSet2 = new HashSet<NODE>(setConstraint.getNonLiterals());
            if (NODE2.isLiteral()) {
                hashSet.add(NODE2);
            } else {
                hashSet2.add(NODE2);
            }
            SetConstraint setConstraint2 = setConstraintManager.buildSetConstraint(hashSet, hashSet2);
            collection.add(new ConstraintFromWeqGraph(this, NODE, setConstraint2, NODE, NODE2));
        }
    }

    class CachingWeqEdgeLabelPoComparator {
        private final PartialOrderCache<CongruenceClosure<NODE>> mCcPoCache;

        public CachingWeqEdgeLabelPoComparator() {
            this.mCcPoCache = new PartialOrderCache(WeakEquivalenceGraph.this.mWeqCcManager.getCcComparator());
        }

        boolean isStrongerOrEqual(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2) {
            return WeakEquivalenceGraph.this.mWeqCcManager.isStrongerThan(weakEquivalenceEdgeLabel, weakEquivalenceEdgeLabel2, (arg_0, arg_1) -> this.mCcPoCache.isSmallerOrEqual(arg_0, arg_1));
        }

        WeakEquivalenceEdgeLabel<NODE> union(WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel<NODE> weakEquivalenceEdgeLabel2) {
            WeakEquivalenceEdgeLabel weakEquivalenceEdgeLabel3 = weakEquivalenceEdgeLabel.union(weakEquivalenceEdgeLabel2, this.mCcPoCache);
            assert (WeakEquivalenceGraph.this.mWeqCcManager.getSettings().omitSanitycheckFineGrained2() || DataStructureUtils.union(weakEquivalenceEdgeLabel.getAppearingNodes(), weakEquivalenceEdgeLabel2.getAppearingNodes()).containsAll(weakEquivalenceEdgeLabel3.getAppearingNodes())) : "union of two labels may not introduce any new nodes";
            return weakEquivalenceEdgeLabel3;
        }
    }

    class ConstraintFromWeqGraph {
        private final boolean mIsArrayEquality;
        private final boolean mIsSetConstraint;
        private final boolean mIsDummyConstraint;
        private final Pair<NODE, SetConstraint<NODE>> mSetConstraint;
        private final Pair<NODE, NODE> mEquality;
        private final Doubleton<NODE> mRelatedEdge;
        final /* synthetic */ WeakEquivalenceGraph this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ConstraintFromWeqGraph(NODE NODE, NODE NODE2, boolean bl) {
            this.this$0 = (WeakEquivalenceGraph)n;
            assert (bl);
            this.mIsArrayEquality = false;
            this.mIsSetConstraint = false;
            this.mIsDummyConstraint = true;
            this.mSetConstraint = null;
            this.mEquality = null;
            this.mRelatedEdge = new Doubleton(NODE, NODE2);
        }

        ConstraintFromWeqGraph(NODE NODE, SetConstraint<NODE> setConstraint, NODE NODE2, NODE NODE3) {
            this.this$0 = var1_1;
            this.mIsArrayEquality = false;
            this.mIsSetConstraint = true;
            this.mIsDummyConstraint = false;
            this.mSetConstraint = new Pair(NODE, setConstraint);
            this.mEquality = null;
            this.mRelatedEdge = new Doubleton(NODE2, NODE3);
        }

        ConstraintFromWeqGraph(NODE NODE, NODE NODE2) {
            this.this$0 = var1_1;
            this.mIsArrayEquality = true;
            this.mIsSetConstraint = false;
            this.mIsDummyConstraint = false;
            this.mSetConstraint = null;
            this.mEquality = new Pair(NODE, NODE2);
            this.mRelatedEdge = new Doubleton(NODE, NODE2);
        }

        public ConstraintFromWeqGraph replaceNode(NODE NODE, NODE NODE2) {
            if (this.isIsArrayEquality()) {
                IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)this.mEquality.getFirst();
                IEqNodeIdentifier iEqNodeIdentifier2 = (IEqNodeIdentifier)this.mEquality.getSecond();
                return new ConstraintFromWeqGraph(this.this$0, iEqNodeIdentifier.equals(NODE) ? NODE2 : iEqNodeIdentifier, iEqNodeIdentifier2.equals(NODE) ? NODE2 : iEqNodeIdentifier2);
            }
            if (this.isSetConstraint()) {
                IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)this.mSetConstraint.getFirst();
                SetConstraint setConstraint = (SetConstraint)this.mSetConstraint.getSecond();
                SetConstraintManager setConstraintManager = this.this$0.mWeqCcManager.getCcManager().getSetConstraintManager();
                IEqNodeIdentifier iEqNodeIdentifier4 = (IEqNodeIdentifier)this.mRelatedEdge.getOneElement();
                IEqNodeIdentifier iEqNodeIdentifier5 = (IEqNodeIdentifier)this.mRelatedEdge.getOtherElement();
                return new ConstraintFromWeqGraph(this.this$0, iEqNodeIdentifier.equals(NODE) ? NODE2 : iEqNodeIdentifier, setConstraintManager.transformElements(setConstraint, iEqNodeIdentifier3 -> iEqNodeIdentifier3.equals(NODE) ? NODE2 : iEqNodeIdentifier3), iEqNodeIdentifier4.equals(NODE) ? NODE2 : iEqNodeIdentifier4, iEqNodeIdentifier5.equals(NODE) ? NODE2 : iEqNodeIdentifier5);
            }
            if (this.isDummyConstraint()) {
                IEqNodeIdentifier iEqNodeIdentifier = (IEqNodeIdentifier)this.mRelatedEdge.getOneElement();
                IEqNodeIdentifier iEqNodeIdentifier6 = (IEqNodeIdentifier)this.mRelatedEdge.getOtherElement();
                return new ConstraintFromWeqGraph(this.this$0, iEqNodeIdentifier.equals(NODE) ? NODE2 : iEqNodeIdentifier, iEqNodeIdentifier6.equals(NODE) ? NODE2 : iEqNodeIdentifier6, true);
            }
            throw new AssertionError();
        }

        public Doubleton<NODE> getRelatedWeqEdge() {
            return this.mRelatedEdge;
        }

        public boolean isIsArrayEquality() {
            return this.mIsArrayEquality;
        }

        public boolean isSetConstraint() {
            return this.mIsSetConstraint;
        }

        public boolean isDummyConstraint() {
            return this.mIsDummyConstraint;
        }

        public Pair<NODE, SetConstraint<NODE>> getSetConstraint() {
            return this.mSetConstraint;
        }

        public Pair<NODE, NODE> getEquality() {
            return this.mEquality;
        }

        public boolean isEqualityBetween(NODE NODE, NODE NODE2) {
            if (!this.isIsArrayEquality()) {
                return false;
            }
            if (((IEqNodeIdentifier)this.mEquality.getFirst()).equals(NODE) && ((IEqNodeIdentifier)this.mEquality.getSecond()).equals(NODE2)) {
                return true;
            }
            return ((IEqNodeIdentifier)this.mEquality.getSecond()).equals(NODE) && ((IEqNodeIdentifier)this.mEquality.getFirst()).equals(NODE2);
        }

        public boolean vanishesOnMergeOf(NODE NODE, NODE NODE2) {
            if (((IEqNodeIdentifier)this.mRelatedEdge.getOneElement()).equals(NODE) && ((IEqNodeIdentifier)this.mRelatedEdge.getOtherElement()).equals(NODE2) || ((IEqNodeIdentifier)this.mRelatedEdge.getOneElement()).equals(NODE2) && ((IEqNodeIdentifier)this.mRelatedEdge.getOtherElement()).equals(NODE)) {
                return true;
            }
            if (this.isSetConstraint()) {
                if (((IEqNodeIdentifier)this.mSetConstraint.getFirst()).equals(NODE) && ((SetConstraint)this.mSetConstraint.getSecond()).containsElement(NODE2)) {
                    return true;
                }
                if (((IEqNodeIdentifier)this.mSetConstraint.getFirst()).equals(NODE2) && ((SetConstraint)this.mSetConstraint.getSecond()).containsElement(NODE)) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.mIsArrayEquality) {
                stringBuilder.append("equality: ");
                stringBuilder.append(this.mEquality);
            } else if (this.mIsSetConstraint) {
                stringBuilder.append("set constraint: ");
                stringBuilder.append(this.mSetConstraint.getFirst());
                stringBuilder.append(" in ");
                stringBuilder.append(this.mSetConstraint.getSecond());
            } else if (this.mIsDummyConstraint) {
                stringBuilder.append("DummyConstraint");
            } else {
                throw new AssertionError();
            }
            return stringBuilder.toString();
        }
    }
}

