/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.muses;

import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.Translator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import java.util.BitSet;

public class ConstraintAdministrationSolver {
    final Script mScript;
    boolean mUnknownConstraintsAreSet;
    boolean mLastOpWasReset;
    int mLevels;
    Translator mTranslator;

    public ConstraintAdministrationSolver(Script script, Translator translator) {
        this.mScript = script;
        this.mUnknownConstraintsAreSet = false;
        this.mLastOpWasReset = false;
        this.mLevels = 0;
        this.mTranslator = translator;
        this.push(1);
    }

    public void pushRecLevel() {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        if (this.mUnknownConstraintsAreSet) {
            throw new SMTLIBException("You may not push a new recursion level, when unknown constraints are set.");
        }
        this.push(1);
    }

    public void popRecLevel() {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        this.clearUnknownConstraints();
        this.pop(1);
    }

    private void push(int n) {
        ++this.mLevels;
        this.mScript.push(n);
    }

    private void pop(int n) {
        this.mLevels -= n;
        assert (this.mLevels >= 1) : "This class should not be able to modify lower levels of the script than the level at which it was created";
        this.mScript.pop(n);
    }

    public void clearUnknownConstraints() {
        if (this.mUnknownConstraintsAreSet) {
            this.pop(1);
            this.mUnknownConstraintsAreSet = false;
        }
    }

    public void assertCriticalConstraint(int n) throws SMTLIBException {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        if (this.mUnknownConstraintsAreSet) {
            throw new SMTLIBException("Modifying crits without clearing unknowns is prohibited.");
        }
        this.mScript.assertTerm(this.mTranslator.translate2Constraint(n));
    }

    public void assertCriticalConstraints(BitSet bitSet) throws SMTLIBException {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        if (this.mUnknownConstraintsAreSet) {
            throw new SMTLIBException("Modifying crits without clearing unknowns is prohibited.");
        }
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            this.mScript.assertTerm(this.mTranslator.translate2Constraint(n));
            n = bitSet.nextSetBit(n + 1);
        }
    }

    public void assertUnknownConstraint(int n) {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        if (!this.mUnknownConstraintsAreSet) {
            this.push(1);
            this.mUnknownConstraintsAreSet = true;
        }
        this.mScript.assertTerm(this.mTranslator.translate2Constraint(n));
    }

    public void assertUnknownConstraints(BitSet bitSet) {
        if (this.mLastOpWasReset) {
            this.push(1);
            this.mLastOpWasReset = false;
        }
        if (!this.mUnknownConstraintsAreSet) {
            this.push(1);
            this.mUnknownConstraintsAreSet = true;
        }
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            this.mScript.assertTerm(this.mTranslator.translate2Constraint(n));
            n = bitSet.nextSetBit(n + 1);
        }
    }

    public Script.LBool checkSat() throws SMTLIBException {
        return this.mScript.checkSat();
    }

    public BitSet getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        Term[] termArray = this.mScript.getUnsatCore();
        return this.mTranslator.translateToBitSet(termArray);
    }

    public BitSet getSatExtension(TerminationRequest terminationRequest) throws SMTLIBException, UnsupportedOperationException {
        Script.LBool lBool = this.mScript.checkSat();
        if (Script.LBool.SAT != lBool) {
            if (Script.LBool.UNKNOWN == lBool && terminationRequest != null && terminationRequest.isTerminationRequested()) {
                return null;
            }
            throw new SMTLIBException("The current assertions are not satisfiable.");
        }
        Model model = this.mScript.getModel();
        Term[] termArray = this.mScript.getAssertions();
        BitSet bitSet = this.mTranslator.translateToBitSet(termArray);
        BitSet bitSet2 = (BitSet)bitSet.clone();
        bitSet2.flip(0, this.mTranslator.getNumberOfConstraints());
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            Term term = model.evaluate(this.mTranslator.translate2Constraint(n));
            if (term == term.getTheory().mTrue) {
                bitSet.set(n);
            } else if (term != term.getTheory().mFalse) {
                throw new SMTLIBException("Term evaluated by model is neither True nor False.");
            }
            n = bitSet2.nextSetBit(n + 1);
        }
        return bitSet;
    }

    public BitSet getSatExtensionMoreDemanding() throws SMTLIBException {
        if (Script.LBool.SAT != this.mScript.checkSat()) {
            throw new SMTLIBException("The current assertions are not satisfiable.");
        }
        this.push(1);
        Term[] termArray = this.mScript.getAssertions();
        BitSet bitSet = this.mTranslator.translateToBitSet(termArray);
        BitSet bitSet2 = (BitSet)bitSet.clone();
        bitSet2.flip(0, this.mTranslator.getNumberOfConstraints());
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            this.mScript.assertTerm(this.mTranslator.translate2Constraint(n));
            bitSet.set(n);
            switch (this.mScript.checkSat()) {
                case UNSAT: {
                    bitSet.clear(n);
                    this.pop(1);
                    return bitSet;
                }
                case SAT: {
                    break;
                }
                case UNKNOWN: {
                    throw new SMTLIBException("Solver returns UNKNOWN in Extension process.");
                }
                default: {
                    throw new SMTLIBException("Unknown LBool value in Extension process.");
                }
            }
            n = bitSet2.nextSetBit(n + 1);
        }
        this.pop(1);
        throw new SMTLIBException("This means, that the set of all constraints is satisfiable. Something is not right!");
    }

    public BitSet getSatExtensionMaximalDemanding() {
        if (Script.LBool.SAT != this.mScript.checkSat()) {
            throw new SMTLIBException("The current assertions are not satisfiable.");
        }
        this.push(1);
        int n = 1;
        Term[] termArray = this.mScript.getAssertions();
        BitSet bitSet = this.mTranslator.translateToBitSet(termArray);
        BitSet bitSet2 = (BitSet)bitSet.clone();
        bitSet2.flip(0, this.mTranslator.getNumberOfConstraints());
        int n2 = bitSet2.nextSetBit(0);
        while (n2 >= 0) {
            this.push(1);
            this.mScript.assertTerm(this.mTranslator.translate2Constraint(n2));
            ++n;
            bitSet.set(n2);
            switch (this.mScript.checkSat()) {
                case UNSAT: {
                    bitSet.clear(n2);
                    this.pop(1);
                    --n;
                    break;
                }
                case SAT: {
                    break;
                }
                case UNKNOWN: {
                    throw new SMTLIBException("Solver returns LBool.UNKNOWN in extension process.");
                }
                default: {
                    throw new SMTLIBException("Unknown LBool value in extension process.");
                }
            }
            n2 = bitSet2.nextSetBit(n2 + 1);
        }
        this.pop(n);
        return bitSet;
    }

    public BitSet getCrits() throws SMTLIBException {
        if (this.mUnknownConstraintsAreSet) {
            throw new SMTLIBException("Reading crits without clearing unknowns is prohibited.");
        }
        Term[] termArray = this.mScript.getAssertions();
        return this.mTranslator.translateToBitSet(termArray);
    }

    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        return this.mScript.getProof();
    }

    public int getNumberOfConstraints() {
        return this.mTranslator.getNumberOfConstraints();
    }

    public void reset() {
        this.mUnknownConstraintsAreSet = false;
        this.mLastOpWasReset = true;
        this.mScript.pop(this.mLevels);
    }

    public Object getInfo(String string) {
        return this.mScript.getInfo(string);
    }
}

