/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.BPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.IImplicationGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.ImplicationVertex;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.TransitiveClosureIG;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ImplicationGraph<T extends IPredicate>
implements IImplicationGraph<T> {
    private final ManagedScript mMgdScript;
    private final BPredicateUnifier mUnifier;
    private final Set<ImplicationVertex<T>> mVertices;
    private final Map<T, ImplicationVertex<T>> mPredicateMap;
    private final ImplicationVertex<T> mTrueVertex;
    private final ImplicationVertex<T> mFalseVertex;

    protected ImplicationGraph(ManagedScript managedScript, BPredicateUnifier bPredicateUnifier, T t, T t2) {
        this.mMgdScript = managedScript;
        this.mUnifier = bPredicateUnifier;
        this.mVertices = new HashSet<ImplicationVertex<T>>();
        this.mPredicateMap = new HashMap<T, ImplicationVertex<T>>();
        this.mFalseVertex = new ImplicationVertex<T>(t, new HashSet(), new HashSet());
        HashSet hashSet = new HashSet();
        hashSet.add(this.mFalseVertex);
        this.mTrueVertex = new ImplicationVertex<T>(t2, new HashSet(), hashSet);
        this.mFalseVertex.addChild(this.mTrueVertex);
        this.mVertices.add(this.mTrueVertex);
        this.mVertices.add(this.mFalseVertex);
        this.mPredicateMap.put(t2, this.mTrueVertex);
        this.mPredicateMap.put(t, this.mFalseVertex);
    }

    public Set<ImplicationVertex<T>> getVertices() {
        return this.mVertices;
    }

    public ImplicationVertex<T> getFalseVertex() {
        return this.mFalseVertex;
    }

    public ImplicationVertex<T> getTrueVertex() {
        return this.mTrueVertex;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ImplicationVertex<T> implicationVertex : this.mVertices) {
            stringBuilder.append("\n " + implicationVertex.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public Set<IPredicate> getCoveredPredicates(IPredicate iPredicate) {
        Set<ImplicationVertex<ImplicationVertex>> set = this.mPredicateMap.get(iPredicate).getAncestors();
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        set.forEach(implicationVertex -> {
            boolean bl = hashSet.add((IPredicate)implicationVertex.getPredicate());
        });
        hashSet.add(iPredicate);
        return hashSet;
    }

    @Override
    public Set<IPredicate> getCoveringPredicates(IPredicate iPredicate) {
        Set<ImplicationVertex<ImplicationVertex>> set = this.mPredicateMap.get(iPredicate).getDescendants();
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        set.forEach(implicationVertex -> {
            boolean bl = hashSet.add((IPredicate)implicationVertex.getPredicate());
        });
        hashSet.add(iPredicate);
        return hashSet;
    }

    @Override
    public IPartialComparator<IPredicate> getPartialComparator() {
        return (iPredicate, iPredicate2) -> {
            if (!this.mUnifier.isRepresentative((IPredicate)iPredicate) || !this.mUnifier.isRepresentative((IPredicate)iPredicate2)) {
                throw new AssertionError((Object)"predicates unknown to predicate unifier");
            }
            if (iPredicate.equals(iPredicate2)) {
                return IPartialComparator.ComparisonResult.EQUAL;
            }
            if (this.getCoveringPredicates((IPredicate)iPredicate).contains(iPredicate2)) {
                return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
            }
            if (this.getCoveringPredicates((IPredicate)iPredicate2).contains(iPredicate)) {
                return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
            }
            return IPartialComparator.ComparisonResult.INCOMPARABLE;
        };
    }

    @Override
    public HashRelation<IPredicate, IPredicate> getCopyOfImplicationRelation() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean unifyPredicate(T t) {
        ImplicationVertex implicationVertex;
        ImplicationVertex implicationVertex2;
        TransitiveClosureIG transitiveClosureIG = new TransitiveClosureIG(this);
        HashSet hashSet = new HashSet();
        while (!hashSet.containsAll(transitiveClosureIG.getVertices())) {
            implicationVertex2 = transitiveClosureIG.getMaxTransitiveClosureCount(hashSet, true);
            if (this.internImplication((IPredicate)implicationVertex2.getPredicate(), (IPredicate)t)) {
                hashSet.add(implicationVertex2);
                transitiveClosureIG.removeAncestorsFromTC(implicationVertex2);
                continue;
            }
            transitiveClosureIG.removeDescendantsFromTC(implicationVertex2, null);
            transitiveClosureIG.removeVertex(implicationVertex2);
        }
        implicationVertex2 = new HashSet(transitiveClosureIG.getVertices());
        transitiveClosureIG = new TransitiveClosureIG(this, implicationVertex2);
        hashSet.clear();
        while (!hashSet.containsAll(transitiveClosureIG.getVertices())) {
            implicationVertex = transitiveClosureIG.getMaxTransitiveClosureCount(hashSet, false);
            if (this.internImplication((IPredicate)t, (IPredicate)implicationVertex.getPredicate())) {
                hashSet.add(implicationVertex);
                transitiveClosureIG.removeDescendantsFromTC(implicationVertex, null);
                continue;
            }
            transitiveClosureIG.removeAncestorsFromTC(implicationVertex);
            transitiveClosureIG.removeVertex(implicationVertex);
        }
        implicationVertex = new HashSet(transitiveClosureIG.getVertices());
        ImplicationVertex<T> implicationVertex3 = new ImplicationVertex<T>(t, implicationVertex, implicationVertex2);
        this.mVertices.add(implicationVertex3);
        this.mPredicateMap.put(t, implicationVertex3);
        return true;
    }

    @Override
    public Collection<T> removeImpliedVerticesFromCollection(Collection<T> collection) {
        HashSet hashSet = new HashSet();
        collection.forEach(iPredicate -> {
            boolean bl = hashSet.add(this.mPredicateMap.get(iPredicate));
        });
        HashSet<T> hashSet2 = new HashSet<T>(collection);
        block0: for (ImplicationVertex implicationVertex : hashSet) {
            for (ImplicationVertex implicationVertex2 : hashSet) {
                if (!implicationVertex.getAncestors().contains(implicationVertex2)) continue;
                hashSet2.remove(implicationVertex.getPredicate());
                continue block0;
            }
        }
        return hashSet2;
    }

    @Override
    public Collection<T> removeImplyingVerticesFromCollection(Collection<T> collection) {
        HashSet hashSet = new HashSet();
        collection.forEach(iPredicate -> {
            boolean bl = hashSet.add(this.mPredicateMap.get(iPredicate));
        });
        HashSet<T> hashSet2 = new HashSet<T>(collection);
        block0: for (ImplicationVertex implicationVertex : hashSet) {
            for (ImplicationVertex implicationVertex2 : hashSet) {
                if (!implicationVertex.getDescendants().contains(implicationVertex2)) continue;
                hashSet2.remove(implicationVertex.getPredicate());
                continue block0;
            }
        }
        return hashSet2;
    }

    @Override
    public IncrementalPlicationChecker.Validity isCovered(IPredicate iPredicate, IPredicate iPredicate2) {
        if (this.getCoveringPredicates(iPredicate).contains(iPredicate2)) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        return IncrementalPlicationChecker.Validity.INVALID;
    }

    public boolean internImplication(IPredicate iPredicate, IPredicate iPredicate2) {
        if (iPredicate.equals(iPredicate2)) {
            return true;
        }
        if (this.mPredicateMap.containsKey(iPredicate) && this.mPredicateMap.containsKey(iPredicate2)) {
            return this.getCoveringPredicates(iPredicate).contains(iPredicate2);
        }
        Term term = iPredicate.getClosedFormula();
        Term term2 = iPredicate2.getClosedFormula();
        if (this.mMgdScript.isLocked()) {
            this.mMgdScript.requestLockRelease();
        }
        this.mMgdScript.lock((Object)this);
        Term term3 = this.mMgdScript.term((Object)this, "and", new Term[]{term, this.mMgdScript.term((Object)this, "not", new Term[]{term2})});
        this.mMgdScript.push((Object)this, 1);
        try {
            this.mMgdScript.assertTerm((Object)this, term3);
            Script.LBool lBool = this.mMgdScript.checkSat((Object)this);
            if (lBool == Script.LBool.UNSAT) {
                return true;
            }
            if (lBool == Script.LBool.SAT) {
                return false;
            }
            throw new UnsupportedOperationException("Cannot handle case were solver cannot decide implication of predicates");
        }
        finally {
            this.mMgdScript.pop((Object)this, 1);
            this.mMgdScript.unlock((Object)this);
        }
    }
}

