/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.translator;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieLocation;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.pea2boogie.Activator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.LinkedHashRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ReqSymboltableBuilder {
    private static final BoogieLocation DUMMY_LOC = new BoogieLocation("", -1, -1, -1, -1);
    private final IUltimateServiceProvider mServices;
    private final boolean mBuildHistoryVars;
    private final ILogger mLogger;
    private final LinkedHashRelation<String, ErrorInfo> mId2Errors;
    private final Map<String, BoogieType> mId2Type;
    private final Map<String, IdentifierExpression> mId2IdExpr;
    private final Map<String, VariableLHS> mId2VarLHS;
    private final Set<String> mStateVars;
    private final Set<String> mConstVars;
    private final Set<String> mPrimedVars;
    private final Set<String> mHistoryVars;
    private final Set<String> mEventVars;
    private final Set<String> mPcVars;
    private final Set<String> mClockVars;
    private final Map<String, Expression> mConst2Value;
    private final Map<PatternType<?>, BoogieLocation> mReq2Loc;
    private final Set<String> mInputVars;
    private final Set<String> mOutputVars;
    private final Map<String, FunctionDeclaration> mBuiltinFunctions;
    private final UnionFind<String> mEquivalences;

    public ReqSymboltableBuilder(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mBuildHistoryVars = iPreferenceProvider.getBoolean("Generate history vars ('v) in Encoding");
        this.mId2Errors = new LinkedHashRelation();
        this.mId2Type = new LinkedHashMap<String, BoogieType>();
        this.mId2IdExpr = new LinkedHashMap<String, IdentifierExpression>();
        this.mId2VarLHS = new LinkedHashMap<String, VariableLHS>();
        this.mStateVars = new LinkedHashSet<String>();
        this.mConstVars = new LinkedHashSet<String>();
        this.mPrimedVars = new LinkedHashSet<String>();
        this.mHistoryVars = new LinkedHashSet<String>();
        this.mEventVars = new LinkedHashSet<String>();
        this.mPcVars = new LinkedHashSet<String>();
        this.mClockVars = new LinkedHashSet<String>();
        this.mReq2Loc = new LinkedHashMap();
        this.mConst2Value = new LinkedHashMap<String, Expression>();
        this.mInputVars = new LinkedHashSet<String>();
        this.mOutputVars = new LinkedHashSet<String>();
        this.mEquivalences = new UnionFind();
        this.mBuiltinFunctions = ReqSymboltableBuilder.generateBuildinFuntions();
    }

    public void addInitPattern(DeclarationPattern declarationPattern) {
        BoogiePrimitiveType boogiePrimitiveType = BoogiePrimitiveType.toPrimitiveType((String)declarationPattern.getType());
        String string = declarationPattern.getId();
        if (boogiePrimitiveType == BoogieType.TYPE_ERROR) {
            this.addError(string, new ErrorInfo(ErrorType.NONE_TYPE, (PatternType<?>)declarationPattern));
            return;
        }
        switch (declarationPattern.getCategory()) {
            case CONST: {
                this.addVar(string, (BoogieType)boogiePrimitiveType, (PatternType<?>)declarationPattern, this.mConstVars);
                this.mConst2Value.put(string, declarationPattern.getExpression());
                break;
            }
            case IN: {
                this.mInputVars.add(string);
                this.addVar(string, (BoogieType)boogiePrimitiveType, (PatternType<?>)declarationPattern, this.mStateVars);
                break;
            }
            case OUT: {
                this.mOutputVars.add(string);
                this.addVar(string, (BoogieType)boogiePrimitiveType, (PatternType<?>)declarationPattern, this.mStateVars);
                break;
            }
            case HIDDEN: {
                this.addVar(string, (BoogieType)boogiePrimitiveType, (PatternType<?>)declarationPattern, this.mStateVars);
            }
        }
    }

    public void addPea(PatternType<?> patternType, PhaseEventAutomata phaseEventAutomata) {
        this.addVar(ReqSymboltableBuilder.getPcName(phaseEventAutomata), (BoogieType)BoogieType.TYPE_INT, patternType, this.mPcVars);
        phaseEventAutomata.getClocks().forEach(string -> this.addVar((String)string, (BoogieType)BoogieType.TYPE_REAL, patternType, this.mClockVars));
        this.updateEquivalences(phaseEventAutomata);
        for (Map.Entry entry : phaseEventAutomata.getVariables().entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (string3 == null) {
                this.checkVar(string2, patternType);
                continue;
            }
            switch (string3.toLowerCase()) {
                case "int": 
                case "bool": 
                case "real": {
                    this.addVar(string2, (BoogieType)BoogiePrimitiveType.toPrimitiveType((String)string3), patternType, this.mStateVars);
                    break;
                }
                case "event": {
                    this.addVar(string2, (BoogieType)BoogieType.TYPE_BOOL, patternType, this.mEventVars);
                    break;
                }
                default: {
                    this.addError(string2, new ErrorInfo(ErrorType.UNKNOWN_TYPE, patternType));
                }
            }
        }
    }

    private void updateEquivalences(PhaseEventAutomata phaseEventAutomata) {
        HashSet hashSet = new HashSet(phaseEventAutomata.getVariables().keySet());
        hashSet.addAll(phaseEventAutomata.getClocks());
        hashSet.add(ReqSymboltableBuilder.getPcName(phaseEventAutomata));
        hashSet.forEach(arg_0 -> this.mEquivalences.findAndConstructEquivalenceClassIfNeeded(arg_0));
        this.mEquivalences.union(hashSet);
    }

    public void addAuxvar(String string, String string2, PatternType<?> patternType) {
        this.addVar(string, (BoogieType)BoogiePrimitiveType.toPrimitiveType((String)string2), patternType, this.mStateVars);
    }

    public IReqSymbolTable constructSymbolTable() {
        String string = this.declareDeltaVar();
        return new ReqSymbolTable(string, this.mId2Type, this.mId2IdExpr, this.mId2VarLHS, this.mStateVars, this.mPrimedVars, this.mHistoryVars, this.mConstVars, this.mEventVars, this.mPcVars, this.mClockVars, this.mReq2Loc, this.mConst2Value, this.mInputVars, this.mOutputVars, this.mBuiltinFunctions, this.mEquivalences);
    }

    public Set<String> getConstIds() {
        return this.mConstVars;
    }

    public Set<Map.Entry<String, ErrorInfo>> getErrors() {
        return Collections.unmodifiableSet(this.mId2Errors.getSetOfPairs());
    }

    private static Map<String, FunctionDeclaration> generateBuildinFuntions() {
        LinkedHashMap<String, FunctionDeclaration> linkedHashMap = new LinkedHashMap<String, FunctionDeclaration>();
        ASTType aSTType = BoogieType.TYPE_INT.toASTType((ILocation)DUMMY_LOC);
        NamedAttribute namedAttribute = new NamedAttribute((ILocation)DUMMY_LOC, "builtin", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)DUMMY_LOC, (String)"abs")});
        VarList[] varListArray = new VarList[]{new VarList((ILocation)DUMMY_LOC, new String[]{"in"}, aSTType)};
        VarList varList = new VarList((ILocation)DUMMY_LOC, new String[]{"res"}, aSTType);
        linkedHashMap.put("abs", new FunctionDeclaration((ILocation)DUMMY_LOC, new Attribute[]{namedAttribute}, "abs", new String[0], varListArray, varList));
        return linkedHashMap;
    }

    private void addError(String string, ErrorInfo errorInfo) {
        if (this.mId2Errors.addPair((Object)string, (Object)errorInfo)) {
            this.mLogger.error((Object)(String.valueOf((Object)errorInfo.mType) + " for " + string));
        }
    }

    private void addVar(String string, BoogieType boogieType, PatternType<?> patternType, Set<String> set) {
        this.addVarOneKind(string, boogieType, patternType, set);
        if (patternType instanceof DeclarationPattern && ((DeclarationPattern)patternType).getCategory() == DeclarationPattern.VariableCategory.CONST) {
            return;
        }
        if (this.mBuildHistoryVars) {
            this.addVarOneKind(ReqSymboltableBuilder.getHistoryVarId(string), boogieType, patternType, this.mHistoryVars);
        }
        this.addVarOneKind(ReqSymboltableBuilder.getPrimedVarId(string), boogieType, patternType, this.mPrimedVars);
    }

    private void addVarOneKind(String string, BoogieType boogieType, PatternType<?> patternType, Set<String> set) {
        BoogieType boogieType2;
        if (!(boogieType != null || set.contains(string) && this.mId2Type.containsKey(string))) {
            throw new AssertionError();
        }
        if (set != null) {
            set.add(string);
        }
        if ((boogieType2 = this.mId2Type.put(string, boogieType)) != null && boogieType2 != boogieType) {
            this.addError(string, new ErrorInfo(ErrorType.DUPLICATE_DECLARATION, patternType));
            this.mId2Type.put(string, (BoogieType)BoogieType.TYPE_ERROR);
            return;
        }
        ILocation iLocation = this.getLocation(patternType);
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)boogieType, (String)string, (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
        this.mId2IdExpr.put(string, identifierExpression);
        this.mId2VarLHS.put(string, new VariableLHS(iLocation, string));
    }

    private void checkVar(String string, PatternType<?> patternType) {
        if (this.mId2Type.containsKey(string)) {
            return;
        }
        this.addError(string, new ErrorInfo(ErrorType.MISSING_DECLARATION, patternType));
    }

    private ILocation getLocation(PatternType<?> patternType) {
        ILocation iLocation = (ILocation)this.mReq2Loc.get(patternType);
        if (iLocation != null) {
            return iLocation;
        }
        this.mReq2Loc.put(patternType, DUMMY_LOC);
        return DUMMY_LOC;
    }

    private String declareDeltaVar() {
        Object object = "delta";
        while (this.mId2Type.containsKey(object)) {
            object = "_" + (String)object;
        }
        this.addVar((String)object, (BoogieType)BoogieType.TYPE_REAL, null, null);
        return object;
    }

    private static String getPrimedVarId(String string) {
        return string + "'";
    }

    private static String getHistoryVarId(String string) {
        return "'" + string;
    }

    private static String getPcName(PhaseEventAutomata phaseEventAutomata) {
        return ReqSymboltableBuilder.getPcName(phaseEventAutomata.getName());
    }

    public static String getPcName(String string) {
        return string + "_pc";
    }

    public static final class ErrorInfo {
        private final ErrorType mType;
        private final PatternType<?> mSource;
        private final String mMessage;

        public ErrorInfo(ErrorType errorType, PatternType<?> patternType) {
            this.mType = errorType;
            this.mSource = patternType;
            this.mMessage = null;
        }

        public ErrorInfo(ErrorType errorType, PatternType<?> patternType, String string) {
            this.mType = errorType;
            this.mSource = patternType;
            this.mMessage = string;
        }

        public PatternType<?> getSource() {
            return this.mSource;
        }

        public ErrorType getType() {
            return this.mType;
        }

        public String getMessage() {
            return this.mMessage;
        }
    }

    public static enum ErrorType {
        DUPLICATE_DECLARATION,
        UNKNOWN_TYPE,
        NO_DURATION_EXPRESSION,
        NO_DURATION_VALUE,
        NONE_TYPE,
        MISSING_DECLARATION,
        SYNTAX_ERROR;

    }

    private static final class ReqSymbolTable
    implements IReqSymbolTable {
        private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
        private final Map<String, BoogieType> mId2Type;
        private final Map<String, IdentifierExpression> mId2IdExpr;
        private final Map<String, VariableLHS> mId2VarLHS;
        private final Map<String, Expression> mConst2Value;
        private final Map<PatternType<?>, BoogieLocation> mReq2Loc;
        private final Set<String> mStateVars;
        private final Set<String> mConstVars;
        private final Set<String> mPrimedVars;
        private final Set<String> mHistoryVars;
        private final Set<String> mEventVars;
        private final Set<String> mPcVars;
        private final Set<String> mClockVars;
        private final String mDeltaVar;
        private final Set<String> mInputVars;
        private final Set<String> mOutputVars;
        private final Map<String, FunctionDeclaration> mBuildinFunctions;
        private final UnionFind<String> mEquivalences;

        private ReqSymbolTable(String string, Map<String, BoogieType> map, Map<String, IdentifierExpression> map2, Map<String, VariableLHS> map3, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, Set<String> set6, Set<String> set7, Map<PatternType<?>, BoogieLocation> map4, Map<String, Expression> map5, Set<String> set8, Set<String> set9, Map<String, FunctionDeclaration> map6, UnionFind<String> unionFind) {
            this.mId2Type = Collections.unmodifiableMap(map);
            this.mId2IdExpr = Collections.unmodifiableMap(map2);
            this.mId2VarLHS = Collections.unmodifiableMap(map3);
            this.mStateVars = Collections.unmodifiableSet(set);
            this.mConstVars = Collections.unmodifiableSet(set4);
            this.mPrimedVars = Collections.unmodifiableSet(set2);
            this.mHistoryVars = Collections.unmodifiableSet(set3);
            this.mEventVars = Collections.unmodifiableSet(set5);
            this.mPcVars = Collections.unmodifiableSet(set6);
            this.mClockVars = Collections.unmodifiableSet(set7);
            this.mReq2Loc = Collections.unmodifiableMap(map4);
            this.mConst2Value = Collections.unmodifiableMap(map5);
            this.mInputVars = Collections.unmodifiableSet(set8);
            this.mOutputVars = Collections.unmodifiableSet(set9);
            this.mBuildinFunctions = Collections.unmodifiableMap(map6);
            this.mDeltaVar = string;
            this.mEquivalences = unionFind;
        }

        @Override
        public IdentifierExpression getIdentifierExpression(String string) {
            IdentifierExpression identifierExpression = this.mId2IdExpr.get(string);
            if (identifierExpression == null || identifierExpression.getType() == null) {
                throw new AssertionError((Object)(string + " has no identifier expression or no type"));
            }
            assert (identifierExpression != null && identifierExpression.getType() != null);
            return identifierExpression;
        }

        @Override
        public Map<PatternType<?>, BoogieLocation> getLocations() {
            return Collections.unmodifiableMap(this.mReq2Loc);
        }

        @Override
        public String getDeltaVarName() {
            return this.mDeltaVar;
        }

        @Override
        public VariableLHS getVariableLhs(String string) {
            return this.mId2VarLHS.get(string);
        }

        @Override
        public Set<String> getStateVars() {
            return this.mStateVars;
        }

        @Override
        public Set<String> getHistoryVars() {
            return this.mHistoryVars;
        }

        @Override
        public Set<String> getPrimedVars() {
            return this.mPrimedVars;
        }

        @Override
        public Set<String> getEventVars() {
            return this.mEventVars;
        }

        @Override
        public Set<String> getClockVars() {
            return this.mClockVars;
        }

        @Override
        public Set<String> getPcVars() {
            return this.mPcVars;
        }

        @Override
        public Set<String> getConstVars() {
            return this.mConstVars;
        }

        @Override
        public Set<String> getInputVars() {
            return this.mInputVars;
        }

        @Override
        public Set<String> getOutputVars() {
            return this.mOutputVars;
        }

        @Override
        public Map<String, Expression> getConstToValue() {
            return this.mConst2Value;
        }

        @Override
        public String getPcName(PhaseEventAutomata phaseEventAutomata) {
            return ReqSymboltableBuilder.getPcName(phaseEventAutomata);
        }

        @Override
        public String getPrimedVarId(String string) {
            return ReqSymboltableBuilder.getPrimedVarId(string);
        }

        @Override
        public String getHistoryVarId(String string) {
            return ReqSymboltableBuilder.getHistoryVarId(string);
        }

        @Override
        public Collection<Declaration> getDeclarations() {
            ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
            arrayList.add(this.constructVariableDeclaration(this.getDeltaVarName()));
            arrayList.addAll(this.constructVariableDeclarations(this.mClockVars));
            arrayList.addAll(this.constructVariableDeclarations(this.mPcVars));
            arrayList.addAll(this.constructConstDeclarations(this.mConstVars));
            arrayList.addAll(this.constructVariableDeclarations(this.mStateVars));
            arrayList.addAll(this.constructVariableDeclarations(this.mPrimedVars));
            arrayList.addAll(this.constructVariableDeclarations(this.mHistoryVars));
            arrayList.addAll(this.constructVariableDeclarations(this.mEventVars));
            arrayList.addAll(this.mBuildinFunctions.values());
            return arrayList;
        }

        @Override
        public IBoogieType getFunctionReturnType(String string) {
            FunctionDeclaration functionDeclaration = this.mBuildinFunctions.get(string);
            if (functionDeclaration == null) {
                return BoogieType.TYPE_ERROR;
            }
            return functionDeclaration.getOutParam().getType().getBoogieType();
        }

        private List<Declaration> constructVariableDeclarations(Collection<String> collection) {
            List<? extends VarList> list = this.constructVarLists(collection);
            return list.stream().map(varList -> new VariableDeclaration(varList.getLocation(), EMPTY_ATTRIBUTES, new VarList[]{varList})).collect(Collectors.toList());
        }

        private List<Declaration> constructConstDeclarations(Collection<String> collection) {
            List<? extends VarList> list = this.constructVarLists(collection);
            ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
            list.stream().map(varList -> new ConstDeclaration(varList.getLocation(), EMPTY_ATTRIBUTES, false, varList, null, false)).forEachOrdered(arrayList::add);
            for (VarList varList2 : list) {
                String[] stringArray = varList2.getIdentifiers();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    Expression expression = this.mConst2Value.get(string);
                    IdentifierExpression identifierExpression = this.mId2IdExpr.get(string);
                    BinaryExpression binaryExpression = new BinaryExpression(expression.getLoc(), expression.getType(), BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, expression);
                    arrayList.add((Declaration)new Axiom(varList2.getLocation(), EMPTY_ATTRIBUTES, (Expression)binaryExpression));
                    ++n2;
                }
            }
            return arrayList;
        }

        private Declaration constructVariableDeclaration(String string) {
            VarList varList = this.constructVarlist(string);
            if (varList == null) {
                return null;
            }
            return new VariableDeclaration(varList.getLocation(), EMPTY_ATTRIBUTES, new VarList[]{varList});
        }

        private VarList constructVarlist(String string) {
            BoogieType boogieType = this.mId2Type.get(string);
            IdentifierExpression identifierExpression = this.mId2IdExpr.get(string);
            if (boogieType == null || identifierExpression == null) {
                return null;
            }
            return new VarList(identifierExpression.getLocation(), new String[]{string}, boogieType.toASTType(identifierExpression.getLocation()));
        }

        private List<? extends VarList> constructVarLists(Collection<String> collection) {
            if (collection.isEmpty()) {
                return Collections.emptyList();
            }
            return collection.stream().map(this::constructVarlist).filter(varList -> varList != null).collect(Collectors.toList());
        }

        @Override
        public UnionFind<String> getVariableEquivalenceClasses() {
            return this.mEquivalences;
        }
    }
}

