/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.referee;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.referee.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.InvariantChecker;

public class RefereeStarter {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private IElement mRootOfNewModel;

    public RefereeStarter(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<IcfgLocation> iIcfg) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
        boolean bl = iPreferenceProvider.getBoolean("Allow loops without annotation");
        InvariantChecker invariantChecker = new InvariantChecker(this.mServices, iIcfg, bl);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)invariantChecker.getResultForUltimateUser());
        this.mLogger.info((Object)invariantChecker.getResultForUltimateUser().getShortDescription());
    }

    public IElement getRootOfNewModel() {
        return this.mRootOfNewModel;
    }
}

