/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import java.util.Collection;
import java.util.stream.Stream;

public class PosetUtils {
    public static <T> boolean isMaximalElement(T t, Stream<T> stream, IPartialComparator<T> iPartialComparator) {
        boolean bl = stream.allMatch(object2 -> iPartialComparator.compare(object2, t) != IPartialComparator.ComparisonResult.STRICTLY_GREATER);
        return bl;
    }

    public static <T> boolean isMinimalElement(T t, Stream<T> stream, IPartialComparator<T> iPartialComparator) {
        boolean bl = stream.allMatch(object2 -> iPartialComparator.compare(object2, t) != IPartialComparator.ComparisonResult.STRICTLY_SMALLER);
        return bl;
    }

    public static <T> Stream<T> filterMaximalElements(Collection<T> collection, IPartialComparator<T> iPartialComparator) {
        return collection.stream().filter(object -> PosetUtils.isMaximalElement(object, collection.stream(), iPartialComparator));
    }

    public static <T> Stream<T> filterMinimalElements(Collection<T> collection, IPartialComparator<T> iPartialComparator) {
        return collection.stream().filter(object -> PosetUtils.isMinimalElement(object, collection.stream(), iPartialComparator));
    }
}

