/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DifferenceSynchronizationInformation<LETTER, PLACE> {
    private final Set<LETTER> mChangerLetters;
    private final HashRelation<Transition<LETTER, PLACE>, PLACE> mSelfloops;
    private final HashRelation<Transition<LETTER, PLACE>, PLACE> mStateChangers;
    private final HashRelation<Transition<LETTER, PLACE>, PLACE> mBlockingTransitions;
    private final Set<Transition<LETTER, PLACE>> mContributingTransitions;
    private final boolean mReachabilityPreserved;
    private final boolean mVitalityPreserved;

    public DifferenceSynchronizationInformation(Set<LETTER> set, HashRelation<Transition<LETTER, PLACE>, PLACE> hashRelation, HashRelation<Transition<LETTER, PLACE>, PLACE> hashRelation2, Set<Transition<LETTER, PLACE>> set2, HashRelation<Transition<LETTER, PLACE>, PLACE> hashRelation3, boolean bl, boolean bl2) {
        this.mChangerLetters = set;
        this.mSelfloops = hashRelation;
        this.mStateChangers = hashRelation2;
        this.mContributingTransitions = set2;
        this.mBlockingTransitions = hashRelation3;
        this.mReachabilityPreserved = bl;
        this.mVitalityPreserved = bl2;
    }

    public Set<LETTER> getChangerLetters() {
        return this.mChangerLetters;
    }

    public HashRelation<Transition<LETTER, PLACE>, PLACE> getSelfloops() {
        return this.mSelfloops;
    }

    public HashRelation<Transition<LETTER, PLACE>, PLACE> getStateChangers() {
        return this.mStateChangers;
    }

    public HashRelation<Transition<LETTER, PLACE>, PLACE> getBlockingTransitions() {
        return this.mBlockingTransitions;
    }

    public Set<Transition<LETTER, PLACE>> getContributingTransitions() {
        return this.mContributingTransitions;
    }

    public boolean isReachabilityPreserved() {
        return this.mReachabilityPreserved;
    }

    public boolean isVitalityPreserved() {
        return this.mVitalityPreserved;
    }

    public DifferenceSynchronizationInformation<LETTER, PLACE> transformThroughRemoveRedundantFlow(HashRelation<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> hashRelation, Map<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> map, HashRelation<Transition<LETTER, PLACE>, PLACE> hashRelation2, Set<PLACE> set) {
        Object object5;
        Set set22;
        Object object22;
        Object object32;
        HashRelation hashRelation3 = new HashRelation();
        for (Object object32 : this.mSelfloops.entrySet()) {
            for (Object object22 : (HashSet)object32.getValue()) {
                set22 = hashRelation.getImage((Object)((Transition)object32.getKey()));
                assert (!set22.isEmpty()) : "no corresponding transitions in difference";
                if (this.isRedundantForAll(hashRelation2, set22, object22)) continue;
                Object object4 = map.get(set22.iterator().next());
                hashRelation3.addPair(object4, object22);
            }
        }
        object32 = new HashRelation();
        for (Object object5 : this.mStateChangers.entrySet()) {
            Set set3 = hashRelation.getImage((Object)((Transition)object5.getKey()));
            for (Set set22 : (HashSet)object5.getValue()) {
                if (set.contains(set22)) continue;
                Transition<LETTER, PLACE> transition2 = map.get(set3.iterator().next());
                object32.addPair((Object)transition2, set22);
            }
        }
        object5 = new HashRelation();
        for (Object object22 : this.mBlockingTransitions.entrySet()) {
            set22 = hashRelation.getImage((Object)((Transition)object22.getKey()));
            if (set22.isEmpty()) continue;
            for (Object object4 : (HashSet)object22.getValue()) {
                Transition<LETTER, PLACE> transition3 = map.get(set22.iterator().next());
                if (set.contains(object4)) continue;
                object5.addPair(transition3, object4);
            }
        }
        object22 = this.mContributingTransitions.stream().map(transition -> (Transition)map.get(hashRelation.getImage(transition).iterator().next())).collect(Collectors.toSet());
        return new DifferenceSynchronizationInformation<LETTER, PLACE>(this.mChangerLetters, hashRelation3, object32, object22, object5, true, false);
    }

    private boolean isRedundantForAll(HashRelation<Transition<LETTER, PLACE>, PLACE> hashRelation, Set<Transition<LETTER, PLACE>> set, PLACE PLACE) {
        return set.stream().allMatch(transition -> hashRelation.containsPair(transition, PLACE));
    }

    public boolean isCompatible(IPetriNet<LETTER, PLACE> iPetriNet) {
        if (!iPetriNet.getAlphabet().containsAll(this.getChangerLetters())) {
            return false;
        }
        if (!iPetriNet.getTransitions().containsAll(this.getStateChangers().getDomain())) {
            return false;
        }
        if (!iPetriNet.getTransitions().containsAll(this.getSelfloops().getDomain())) {
            return false;
        }
        return iPetriNet.getTransitions().containsAll(this.getBlockingTransitions().getDomain());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DifferenceSynchronizationInformation [mChangerLetters=");
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(this.mChangerLetters);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(", mSelfloops=");
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(this.mSelfloops);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(", mStateChangers=");
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(this.mStateChangers);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(", mBlockingTransitions=");
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(this.mBlockingTransitions);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(", mContributingTransitions=");
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(this.mContributingTransitions);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

