/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISemanticReducerFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.Tree;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeRun;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.difference.LazyDifference;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.Minimize;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.hopcroft.MinimizeNftaHopcroft;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornAnnot;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.chc.results.ChcSatResult;
import de.uni_freiburg.informatik.ultimate.lib.chc.results.ChcUnsatResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.TaMinimization;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.CandidateRuleProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HCHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HCPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HCPredicateFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HCStateFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HcSsaTreeFlattener;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.TreeChecker;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TreeAutomizerCEGAR {
    private TreeAutomatonBU<HornClause, IPredicate> mAbstraction;
    private final HCStateFactory mStateFactory;
    private final ManagedScript mBackendSmtSolverScript;
    private int mIteration;
    private final ILogger mLogger;
    private final HornAnnot mHornAnnot;
    private final HCPredicate mInitialPredicate;
    private final HCPredicate mFinalPredicate;
    private TreeChecker mChecker;
    protected ITreeAutomatonBU<HornClause, IPredicate> mInterpolAutomaton;
    private final HcSymbolTable mSymbolTable;
    private final HCHoareTripleChecker mHoareTripleChecker;
    private final PredicateUnifier mPredicateUnifier;
    private final HCPredicateFactory mPredicateFactory;
    private final AutomataLibraryServices mAutomataLibraryServices;
    private final List<HornClause> mAlphabet;
    private TreeRun<HornClause, IPredicate> mCounterExample;
    private final IUltimateServiceProvider mServices;
    private final IPreferenceProvider mPreferences;

    public TreeAutomizerCEGAR(IUltimateServiceProvider iUltimateServiceProvider, HornAnnot hornAnnot, TAPreferences tAPreferences, ILogger iLogger) {
        this.mBackendSmtSolverScript = hornAnnot.getScript();
        this.mSymbolTable = hornAnnot.getSymbolTable();
        this.mLogger = iLogger;
        this.mHornAnnot = hornAnnot;
        this.mAlphabet = this.mHornAnnot.getHornClauses();
        this.mIteration = 0;
        this.mAutomataLibraryServices = new AutomataLibraryServices(iUltimateServiceProvider);
        this.mServices = iUltimateServiceProvider;
        this.mPredicateFactory = new HCPredicateFactory(iUltimateServiceProvider, this.mBackendSmtSolverScript, this.mSymbolTable, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        this.mInitialPredicate = this.mPredicateFactory.getTrueLocationPredicate();
        this.mFinalPredicate = this.mPredicateFactory.getFalseLocationPredicate();
        this.mPredicateUnifier = new PredicateUnifier(this.mLogger, iUltimateServiceProvider, this.mBackendSmtSolverScript, (BasicPredicateFactory)this.mPredicateFactory, (IIcfgSymbolTable)this.mSymbolTable, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, new IPredicate[]{this.mInitialPredicate});
        this.mHoareTripleChecker = new HCHoareTripleChecker(this.mPredicateUnifier, this.mBackendSmtSolverScript, this.mSymbolTable);
        this.mStateFactory = new HCStateFactory(this.mBackendSmtSolverScript, this.mPredicateFactory, this.mServices, this.mLogger, this.mPredicateUnifier, this.mHoareTripleChecker, false);
        this.mPredicateUnifier.getOrConstructPredicate(this.mInitialPredicate.getFormula());
        this.mPredicateUnifier.getOrConstructPredicate(this.mFinalPredicate.getFormula());
        this.mPreferences = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
    }

    public IResult iterate() throws AutomataLibraryException {
        this.getInitialAbstraction();
        this.mLogger.debug((Object)("Abstraction tree automaton before iteration #" + (this.mIteration + 1)));
        this.mLogger.debug(this.mAbstraction);
        while (this.mServices.getProgressMonitorService().continueProcessing()) {
            Object object2;
            this.mLogger.debug((Object)("Iteration #" + (this.mIteration + 1)));
            TreeRun<HornClause, IPredicate> treeRun = this.isAbstractionCorrect();
            if (treeRun == null) {
                this.mLogger.info((Object)"The horn clause set is SAT!!");
                this.mLogger.info((Object)"states of the final abstraction: (i.e., the model for the uninterpreted predicates)");
                for (Object object2 : this.mAbstraction.getStates()) {
                    this.mLogger.info((Object)object2.toString());
                }
                return new ChcSatResult(Activator.PLUGIN_ID, "The given horn clause set is SAT", null);
            }
            this.mBackendSmtSolverScript.lock((Object)this);
            this.mBackendSmtSolverScript.push((Object)this, 1);
            if (this.getCounterexampleFeasibility(treeRun, this) == Script.LBool.SAT) {
                this.mLogger.info((Object)"The program is unsafe, feasible counterexample.");
                this.mLogger.info((Object)treeRun.getTree());
                this.mBackendSmtSolverScript.pop((Object)this, 1);
                this.mBackendSmtSolverScript.unlock((Object)this);
                return new ChcUnsatResult(Activator.PLUGIN_ID, "The given horn clause set is UNSAT", null, TreeAutomizerCEGAR.extractUnsatCore((Tree<HornClause>)treeRun.getTree()));
            }
            this.mLogger.debug((Object)"Getting Interpolants...");
            object2 = this.retrieveInterpolantsMap(this.mChecker.getSSA(), treeRun);
            this.mBackendSmtSolverScript.pop((Object)this, 1);
            this.mBackendSmtSolverScript.unlock((Object)this);
            this.constructInterpolantAutomaton(treeRun, (Map<TreeRun<HornClause, IPredicate>, Term>)object2);
            this.mLogger.debug((Object)"Interpolant automaton:");
            this.mLogger.debug(this.mInterpolAutomaton);
            this.mLogger.debug((Object)"Refining abstract model...");
            this.refineAbstraction();
            this.mLogger.debug((Object)("Abstraction tree automaton before iteration #" + (this.mIteration + 1)));
            this.mLogger.debug(this.mAbstraction);
        }
        this.mLogger.info((Object)"The program is not decieded...");
        return new TimeoutResult(Activator.PLUGIN_ID, "TreeAutomizer says UNKNOWN/TIMEOUT");
    }

    private static Set<HornClause> extractUnsatCore(Tree<HornClause> tree) {
        HashSet<HornClause> hashSet = new HashSet<HornClause>();
        ArrayDeque<Tree<HornClause>> arrayDeque = new ArrayDeque<Tree<HornClause>>();
        arrayDeque.push(tree);
        while (!arrayDeque.isEmpty()) {
            Tree tree2 = (Tree)arrayDeque.pop();
            hashSet.add((HornClause)tree2.getSymbol());
            arrayDeque.addAll(tree2.getChildren());
        }
        return hashSet;
    }

    protected void getInitialAbstraction() throws AutomataLibraryException {
        this.mAbstraction = new TreeAutomatonBU();
        for (HornClause hornClause : this.mAlphabet) {
            ArrayList<HCPredicate> arrayList = new ArrayList<HCPredicate>();
            for (HcPredicateSymbol hcPredicateSymbol : hornClause.getBodyPredicates()) {
                arrayList.add(this.mPredicateFactory.getTruePredicateWithLocation(hcPredicateSymbol));
            }
            if (hornClause.isHeadFalse()) {
                this.mAbstraction.addRule(new TreeAutomatonRule((IRankedLetter)hornClause, arrayList, (Object)this.mFinalPredicate));
                continue;
            }
            this.mAbstraction.addRule(new TreeAutomatonRule((IRankedLetter)hornClause, arrayList, (Object)this.mPredicateFactory.getTruePredicateWithLocation(hornClause.getHeadPredicate())));
        }
        this.mAbstraction.addFinalState((Object)this.mFinalPredicate);
        for (HornClause hornClause : this.mAbstraction.getStates()) {
            this.mPredicateUnifier.getOrConstructPredicate(hornClause.getFormula());
        }
        this.mLogger.debug((Object)"Initial abstraction tree Automaton:");
        this.mLogger.debug(this.mAbstraction);
    }

    private TreeRun<HornClause, IPredicate> isAbstractionCorrect() throws AutomataOperationCanceledException {
        IsEmpty isEmpty = new IsEmpty(this.mAutomataLibraryServices, this.mAbstraction);
        TreeRun treeRun = isEmpty.getTreeRun();
        if (this.mLogger.isDebugEnabled()) {
            if (treeRun != null) {
                this.mLogger.debug((Object)"Error trace found.");
                this.mLogger.debug((Object)treeRun.toString());
            } else {
                this.mLogger.debug((Object)"No (further) counterexample found in abstraction.");
            }
        }
        this.mCounterExample = treeRun;
        return treeRun;
    }

    private Script.LBool getCounterexampleFeasibility(TreeRun<HornClause, IPredicate> treeRun, Object object) {
        this.mChecker = new TreeChecker(treeRun, this.mBackendSmtSolverScript, this.mInitialPredicate, this.mFinalPredicate, this.mLogger, this.mPredicateUnifier, this.mSymbolTable);
        return this.mChecker.checkTrace(object);
    }

    protected void constructInterpolantAutomaton(TreeRun<HornClause, IPredicate> treeRun, Map<TreeRun<HornClause, IPredicate>, Term> map) throws AutomataOperationCanceledException {
        Object object2;
        TreeRun<HornClause, IPredicate> treeRun2 = this.mChecker.annotateTreeRunWithInterpolants(map);
        this.mInterpolAutomaton = treeRun2.getInterpolantAutomaton((ISemanticReducerFactory)this.mStateFactory);
        for (Object object2 : this.mInterpolAutomaton.getStates()) {
            this.mPredicateUnifier.getOrConstructPredicate(object2.getFormula());
        }
        ((TreeAutomatonBU)this.mInterpolAutomaton).extendAlphabet((Collection)this.mAbstraction.getAlphabet());
        assert (this.assertAllRulesAreInductive(this.mInterpolAutomaton));
        object2 = this.mPreferences.getString("Dump automata to");
        if (!((String)object2).isEmpty()) {
            String string = this.mHornAnnot.getFileName() + "_interpolant_automaton_nr_" + this.mIteration;
            TreeAutomizerCEGAR.writeAutomatonToFile(this.mServices, this.mInterpolAutomaton, (String)object2, string, AutomatonDefinitionPrinter.Format.ATS_NUMERATE, "");
        }
        assert (this.assertAllRulesAreInductive(this.mInterpolAutomaton));
    }

    private boolean assertAllRulesAreInductive(ITreeAutomatonBU<HornClause, IPredicate> iTreeAutomatonBU) {
        for (List list : iTreeAutomatonBU.getSourceCombinations()) {
            for (TreeAutomatonRule treeAutomatonRule : iTreeAutomatonBU.getSuccessors(list)) {
                IncrementalPlicationChecker.Validity validity = this.mHoareTripleChecker.check(treeAutomatonRule.getSource(), (HornClause)treeAutomatonRule.getLetter(), (IPredicate)treeAutomatonRule.getDest());
                if (validity == IncrementalPlicationChecker.Validity.VALID) continue;
                assert (false) : "Rule is not inductive: " + String.valueOf(treeAutomatonRule);
                return false;
            }
        }
        return true;
    }

    private void generalizeCounterExample(ITreeAutomatonBU<HornClause, IPredicate> iTreeAutomatonBU) {
        HashSet<TreeAutomatonRule<HornClause, IPredicate>> hashSet = new HashSet<TreeAutomatonRule<HornClause, IPredicate>>();
        for (TreeAutomatonRule<HornClause, IPredicate> treeAutomatonRule : new CandidateRuleProvider(iTreeAutomatonBU, this.mHoareTripleChecker).getCandidateRules()) {
            if (this.mHoareTripleChecker.check(treeAutomatonRule) != IncrementalPlicationChecker.Validity.VALID) continue;
            this.mLogger.debug((Object)("Adding Rule: " + String.valueOf(treeAutomatonRule.getLetter()) + "(" + String.valueOf(treeAutomatonRule.getSource()) + ") --> " + String.valueOf(treeAutomatonRule.getDest())));
            hashSet.add(treeAutomatonRule);
        }
        this.mLogger.debug((Object)"Generalizing counterExample:");
        for (TreeAutomatonRule treeAutomatonRule : hashSet) {
            this.mInterpolAutomaton.addRule(treeAutomatonRule);
        }
    }

    private ITreeAutomatonBU<HornClause, IPredicate> getCounterExample() {
        return this.mInterpolAutomaton;
    }

    protected boolean refineAbstraction() throws AutomataLibraryException {
        this.dumpAbstraction("r0_abstraction_before_refine");
        this.mAbstraction = (TreeAutomatonBU)new LazyDifference(this.mAutomataLibraryServices, (IMergeStateFactory)this.mStateFactory, this.mAbstraction, this.getCounterExample()).getResult();
        this.mLogger.debug((Object)String.format("Abstraction ffter difference has %d states, %d rules.", this.mAbstraction.getStates().size(), ((Set)this.mAbstraction.getRules()).size()));
        this.dumpAbstraction("r1_abstraction_after_difference");
        assert (!new Accepts(this.mAutomataLibraryServices, this.mAbstraction, this.mCounterExample).getResult().booleanValue()) : "refined abstraction still contains error tree -- no progress";
        this.removeFalseStatesFromAbstraction();
        this.dumpAbstraction("r2_abstraction_after_removeFalse");
        assert (!new Accepts(this.mAutomataLibraryServices, this.mAbstraction, this.mCounterExample).getResult().booleanValue()) : "refined abstraction still contains error tree -- no progress";
        if (this.mPreferences.getEnum("Type of minimization to use", TaMinimization.class) == TaMinimization.NAIVE) {
            try {
                this.mAbstraction = (TreeAutomatonBU)new Minimize(this.mAutomataLibraryServices, (IMergeStateFactory)this.mStateFactory, this.mAbstraction).getResult();
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                throw new ToolchainCanceledException((IRunningTaskStackProvider)automataOperationCanceledException, new RunningTaskInfo(this.getClass(), "refining abstraction"));
            }
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)String.format("Abstraction after naive minimization has  %d states, %d rules.", this.mAbstraction.getStates().size(), ((Set)this.mAbstraction.getRules()).size()));
            }
        } else if (this.mPreferences.getEnum("Type of minimization to use", TaMinimization.class) == TaMinimization.HOPCROFT) {
            this.mAbstraction = (TreeAutomatonBU)new MinimizeNftaHopcroft(this.mAutomataLibraryServices, (IMergeStateFactory)this.mStateFactory, this.mAbstraction).getResult();
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)String.format("Abstraction after hopcroft minimization has %d states, %d rules.", this.mAbstraction.getStates().size(), ((Set)this.mAbstraction.getRules()).size()));
            }
        }
        this.mLogger.debug((Object)"Refine ends...");
        this.dumpAbstraction("r3_abstraction_after_minimize");
        assert (!new Accepts(this.mAutomataLibraryServices, this.mAbstraction, this.mCounterExample).getResult().booleanValue()) : "refined abstraction still contains error tree -- no progress";
        ++this.mIteration;
        return false;
    }

    public void removeFalseStatesFromAbstraction() {
        HashSet hashSet = new HashSet(this.mAbstraction.getStates());
        for (IPredicate iPredicate : hashSet) {
            if (!SmtUtils.isFalseLiteral((Term)iPredicate.getFormula())) continue;
            this.mAbstraction.removeState((Object)iPredicate);
        }
    }

    public void dumpAbstraction(String string) {
        String string2 = this.mPreferences.getString("Dump automata to");
        if (!string2.isEmpty()) {
            String string3 = this.mHornAnnot.getFileName() + string + this.mIteration;
            TreeAutomizerCEGAR.writeAutomatonToFile(this.mServices, this.mAbstraction, string2, string3, AutomatonDefinitionPrinter.Format.ATS_NUMERATE, "");
        }
    }

    private Map<TreeRun<HornClause, IPredicate>, Term> retrieveInterpolantsMap(HcSsaTreeFlattener hcSsaTreeFlattener, TreeRun<HornClause, IPredicate> treeRun) {
        Term[] termArray = this.mBackendSmtSolverScript.getInterpolants((Object)this, hcSsaTreeFlattener.getNamedTermList(this.mBackendSmtSolverScript, this), hcSsaTreeFlattener.getStartsOfSubTrees());
        List<TreeRun<HornClause, IPredicate>> list = TreeAutomizerCEGAR.computeSubtreesInPostOrder(treeRun);
        HashMap<TreeRun<HornClause, IPredicate>, Term> hashMap = new HashMap<TreeRun<HornClause, IPredicate>, Term>();
        int n = 0;
        while (n < termArray.length) {
            TreeRun<HornClause, IPredicate> treeRun2 = list.get(n);
            hashMap.put(treeRun2, termArray[n]);
            ++n;
        }
        hashMap.put(treeRun, this.mBackendSmtSolverScript.term((Object)this, "false", new Term[0]));
        return hashMap;
    }

    private static List<TreeRun<HornClause, IPredicate>> computeSubtreesInPostOrder(TreeRun<HornClause, IPredicate> treeRun) {
        ArrayList<TreeRun<HornClause, IPredicate>> arrayList = new ArrayList<TreeRun<HornClause, IPredicate>>();
        for (TreeRun treeRun2 : treeRun.getChildren()) {
            arrayList.addAll(TreeAutomizerCEGAR.computeSubtreesInPostOrder((TreeRun<HornClause, IPredicate>)treeRun2));
        }
        if (treeRun.getRootSymbol() != null) {
            arrayList.add(treeRun);
        }
        return arrayList;
    }

    protected void computeCFGHoareAnnotation() {
    }

    public IElement getArtifact() {
        return null;
    }

    protected static void writeAutomatonToFile(IUltimateServiceProvider iUltimateServiceProvider, IAutomaton<?, IPredicate> iAutomaton, String string, String string2, AutomatonDefinitionPrinter.Format format, String string3) {
        new AutomatonDefinitionPrinter(new AutomataLibraryServices(iUltimateServiceProvider), "ta", string + "/" + string2, format, string3, new IAutomaton[]{iAutomaton});
    }
}

