/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation;

import de.uni_freiburg.informatik.ultimate.boogie.BitvectorFactory;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieTypeConstructor;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TypeHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.FloatFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.ISOIEC9899TC3;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class BitvectorTranslation
extends ExpressionTranslation {
    public static final String ROUNDING_MODE_BOOGIE_TYPE_IDENTIFIER = "FloatRoundingMode";
    public static final String ROUNDING_MODE_SMT_TYPE_IDENTIFIER = "RoundingMode";
    public static final BoogieType ROUNDING_MODE_BOOGIE_TYPE = BoogieType.createConstructedType((BoogieTypeConstructor)new BoogieTypeConstructor("FloatRoundingMode", false, 0, new int[0]));
    public static final ASTType ROUNDING_MODE_BOOGIE_AST_TYPE = ROUNDING_MODE_BOOGIE_TYPE.toASTType((ILocation)LocationFactory.createIgnoreCLocation());
    public static final String ULTIMATE_VAR_CURRENT_ROUNDING_MODE = "currentRoundingMode";
    public static final String ULTIMATE_PROC_SET_CURRENT_ROUNDING_MODE = "ULTIMATE.setCurrentRoundingMode";
    public static final String SMT_LIB_NAN = "NaN";
    public static final String SMT_LIB_PLUS_INF = "+oo";
    public static final String SMT_LIB_MINUS_INF = "-oo";
    public static final String SMT_LIB_PLUS_ZERO = "+zero";
    public static final String SMT_LIB_MINUS_ZERO = "-zero";
    private final Expression mCurrentRoundingModeMacroValue;
    private final IdentifierExpression mCurrentRoundingMode;

    public BitvectorTranslation(TypeSizes typeSizes, TranslationSettings translationSettings, FlatSymbolTable flatSymbolTable, ITypeHandler iTypeHandler) {
        super(typeSizes, translationSettings, iTypeHandler, flatSymbolTable);
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        CACSLPreferenceInitializer.FloatingPointRoundingMode floatingPointRoundingMode = this.mSettings.getInitialRoundingMode();
        this.mCurrentRoundingMode = this.mSettings.getInitialRoundingMode().getSmtRoundingMode().getBoogieIdentifierExpression();
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        this.mCurrentRoundingModeMacroValue = floatingPointRoundingMode == CACSLPreferenceInitializer.FloatingPointRoundingMode.FE_TOWARDZERO ? this.mTypeSizes.constructLiteralForIntegerType(cACSLLocation, cPrimitive, BigInteger.valueOf(0L)) : (floatingPointRoundingMode == CACSLPreferenceInitializer.FloatingPointRoundingMode.FE_TONEAREST ? this.mTypeSizes.constructLiteralForIntegerType(cACSLLocation, cPrimitive, BigInteger.valueOf(1L)) : (floatingPointRoundingMode == CACSLPreferenceInitializer.FloatingPointRoundingMode.FE_UPWARD ? this.mTypeSizes.constructLiteralForIntegerType(cACSLLocation, cPrimitive, BigInteger.valueOf(2L)) : this.mTypeSizes.constructLiteralForIntegerType(cACSLLocation, cPrimitive, BigInteger.valueOf(3L))));
    }

    private int computeBitsize(CPrimitive cPrimitive) {
        Integer n = this.mTypeSizes.getSize(cPrimitive.getType());
        return n * 8;
    }

    @Override
    public RValue translateIntegerLiteral(ILocation iLocation, String string) {
        RValue rValue = ISOIEC9899TC3.handleIntegerConstant(string, iLocation, true, this.mTypeSizes);
        return rValue;
    }

    @Override
    public Expression constructLiteralForIntegerType(ILocation iLocation, CPrimitive cPrimitive, BigInteger bigInteger) {
        return ISOIEC9899TC3.constructLiteralForCIntegerLiteral(iLocation, true, this.mTypeSizes, cPrimitive, bigInteger);
    }

    @Override
    public Expression constructLiteralForFloatingType(ILocation iLocation, CPrimitive cPrimitive, BigDecimal bigDecimal) {
        Object object;
        Expression[] expressionArray;
        String string;
        if (this.mSettings.overapproximateFloatingPointOperations()) {
            return super.constructOverapproximationFloatLiteral(iLocation, bigDecimal.toPlainString(), cPrimitive);
        }
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            string = SMT_LIB_PLUS_ZERO;
            expressionArray = new Expression[]{};
        } else {
            string = "to_fp";
            object = ExpressionFactory.createRealLiteral((ILocation)iLocation, (String)bigDecimal.toString());
            expressionArray = new Expression[]{this.getCurrentRoundingMode(), object};
        }
        object = this.getBoogieFunctionName(string, cPrimitive);
        return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)object, (Expression[])expressionArray, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
    }

    private String getBoogieFunctionName(String string, CPrimitive cPrimitive) {
        return SFO.getBoogieFunctionName(string, this.computeBitsize(cPrimitive));
    }

    @Override
    public Expression constructBinaryComparisonIntegerExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        if (!this.mFunctionDeclarations.checkParameters(cPrimitive, cPrimitive2)) {
            throw new IllegalArgumentException("incompatible types " + String.valueOf(cPrimitive) + " " + String.valueOf(cPrimitive2));
        }
        return switch (n) {
            case 28, 29 -> this.constructBinaryEqualityExpression(iLocation, n, expression, cPrimitive, expression2, cPrimitive2);
            case 8, 9, 10, 11 -> this.constructBinaryInequalityExpression(iLocation, n, expression, cPrimitive, expression2, cPrimitive2);
            default -> throw new AssertionError((Object)("unknown operation " + n));
        };
    }

    public Expression constructBinaryInequalityExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        if (!this.mFunctionDeclarations.checkParameters(cPrimitive, cPrimitive2)) {
            throw new IllegalArgumentException("incompatible types " + String.valueOf(cPrimitive) + " " + String.valueOf(cPrimitive2));
        }
        BitvectorConstant.BvOp bvOp = switch (n) {
            case 11 -> {
                if (this.mTypeSizes.isUnsigned(cPrimitive) && this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvuge;
                }
                if (!this.mTypeSizes.isUnsigned(cPrimitive) && !this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvsge;
                }
                throw new IllegalArgumentException("Mixed signed and unsigned arguments");
            }
            case 9 -> {
                if (this.mTypeSizes.isUnsigned(cPrimitive) && this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvugt;
                }
                if (!this.mTypeSizes.isUnsigned(cPrimitive) && !this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvsgt;
                }
                throw new IllegalArgumentException("Mixed signed and unsigned arguments");
            }
            case 10 -> {
                if (this.mTypeSizes.isUnsigned(cPrimitive) && this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvule;
                }
                if (!this.mTypeSizes.isUnsigned(cPrimitive) && !this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvsle;
                }
                throw new IllegalArgumentException("Mixed signed and unsigned arguments");
            }
            case 8 -> {
                if (this.mTypeSizes.isUnsigned(cPrimitive) && this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvult;
                }
                if (!this.mTypeSizes.isUnsigned(cPrimitive) && !this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvslt;
                }
                throw new IllegalArgumentException("Mixed signed and unsigned arguments");
            }
            default -> throw new AssertionError((Object)("unknown operation " + n));
        };
        assert (cPrimitive.getType() == cPrimitive2.getType()) : "Probably incompatible types! Did you forget a conversion?";
        int n2 = this.computeBitsize(cPrimitive);
        this.declareBitvectorFunction(iLocation, bvOp, SFO.getBoogieFunctionName(bvOp.toString(), n2), true, new CPrimitive(CPrimitive.CPrimitives.BOOL), null, cPrimitive, cPrimitive2);
        Expression expression3 = BitvectorFactory.constructBinaryBitvectorOperation((ILocation)iLocation, (BitvectorConstant.BvOp)bvOp, (Expression[])new Expression[]{expression, expression2});
        return expression3;
    }

    private Expression constructBinaryBitwiseIntegerExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        if (!this.mFunctionDeclarations.checkParameters(cPrimitive, cPrimitive2)) {
            throw new IllegalArgumentException("incompatible types " + String.valueOf(cPrimitive) + " " + String.valueOf(cPrimitive2));
        }
        BitvectorConstant.BvOp bvOp = switch (n) {
            case 12, 25 -> BitvectorConstant.BvOp.bvand;
            case 14, 27 -> BitvectorConstant.BvOp.bvor;
            case 13, 26 -> BitvectorConstant.BvOp.bvxor;
            case 6, 23 -> BitvectorConstant.BvOp.bvshl;
            case 7, 24 -> this.mTypeSizes.isUnsigned(cPrimitive) ? BitvectorConstant.BvOp.bvlshr : BitvectorConstant.BvOp.bvashr;
            default -> throw new UnsupportedSyntaxException(iLocation, "Unknown or unsupported bitwise expression");
        };
        String string = this.getBoogieFunctionName(bvOp.toString(), cPrimitive);
        this.declareBitvectorFunction(iLocation, bvOp, string, false, cPrimitive, null, cPrimitive, cPrimitive2);
        return BitvectorFactory.constructBinaryBitvectorOperation((ILocation)iLocation, (BitvectorConstant.BvOp)bvOp, (Expression[])new Expression[]{expression, expression2});
    }

    @Override
    protected ExpressionResult handleBinaryBitwiseIntegerExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2, AuxVarInfoBuilder auxVarInfoBuilder) {
        ExpressionResult expressionResult = this.convertIntToInt(iLocation, new ExpressionResult(new RValue(expression2, cPrimitive2)), cPrimitive);
        Expression expression3 = this.constructBinaryBitwiseIntegerExpression(iLocation, n, expression, cPrimitive, expressionResult.getLrValue().getValue(), cPrimitive);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(expression3, cPrimitive, false, false)).build();
    }

    @Override
    protected Expression constructUnaryIntegerExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive) {
        BitvectorConstant.BvOp bvOp = switch (n) {
            case 6 -> BitvectorConstant.BvOp.bvnot;
            case 3 -> BitvectorConstant.BvOp.bvneg;
            default -> throw new UnsupportedSyntaxException(iLocation, "Unknown or unsupported unary expression");
        };
        String string = this.getBoogieFunctionName(bvOp.toString(), cPrimitive);
        this.declareBitvectorFunction(iLocation, bvOp, string, false, cPrimitive, null, cPrimitive);
        return BitvectorFactory.constructUnaryOperation((ILocation)iLocation, (BitvectorConstant.BvOp)bvOp, (Expression)expression);
    }

    @Override
    public Expression constructArithmeticIntegerExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        if (!this.mFunctionDeclarations.checkParameters(cPrimitive, cPrimitive2)) {
            throw new IllegalArgumentException("incompatible types " + String.valueOf(cPrimitive) + " " + String.valueOf(cPrimitive2));
        }
        BitvectorConstant.BvOp bvOp = switch (n) {
            case 5, 22 -> BitvectorConstant.BvOp.bvsub;
            case 1, 18 -> BitvectorConstant.BvOp.bvmul;
            case 2, 19 -> {
                if (this.mTypeSizes.isUnsigned(cPrimitive) && this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvudiv;
                }
                if (!this.mTypeSizes.isUnsigned(cPrimitive) && !this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvsdiv;
                }
                throw new IllegalArgumentException("Mixed signed and unsigned");
            }
            case 3, 20 -> {
                if (this.mTypeSizes.isUnsigned(cPrimitive) && this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvurem;
                }
                if (!this.mTypeSizes.isUnsigned(cPrimitive) && !this.mTypeSizes.isUnsigned(cPrimitive2)) {
                    yield BitvectorConstant.BvOp.bvsrem;
                }
                throw new IllegalArgumentException("Mixed signed and unsigned");
            }
            case 4, 21 -> BitvectorConstant.BvOp.bvadd;
            default -> throw new UnsupportedSyntaxException(iLocation, "Unknown or unsupported arithmetic expression");
        };
        int n2 = this.computeBitsize(cPrimitive);
        String string = SFO.getBoogieFunctionName(bvOp.toString(), n2);
        this.declareBitvectorFunction(iLocation, bvOp, string, false, cPrimitive, null, cPrimitive, cPrimitive2);
        return BitvectorFactory.constructBinaryBitvectorOperation((ILocation)iLocation, (BitvectorConstant.BvOp)bvOp, (Expression[])new Expression[]{expression, expression2});
    }

    @Override
    public Pair<Expression, ASTType> constructInfinitePrecisionOperation(ILocation iLocation, int n, Expression expression, Expression expression2, CPrimitive cPrimitive) {
        BitvectorConstant.BvOp bvOp;
        int n2;
        int n3 = this.computeBitsize(cPrimitive);
        if (n == 4) {
            n2 = n3 + 1;
            bvOp = BitvectorConstant.BvOp.bvadd;
        } else if (n == 5) {
            n2 = n3 + 1;
            bvOp = BitvectorConstant.BvOp.bvsub;
        } else if (n == 2) {
            n2 = n3 + 1;
            bvOp = BitvectorConstant.BvOp.bvsdiv;
        } else if (n == 1) {
            n2 = 2 * n3;
            bvOp = BitvectorConstant.BvOp.bvmul;
        } else {
            throw new AssertionError((Object)("Unsupported operator for infinite precision operation: " + n));
        }
        BitvectorConstant.ExtendOperation extendOperation = this.mTypeSizes.isUnsigned(cPrimitive) ? BitvectorConstant.ExtendOperation.zero_extend : BitvectorConstant.ExtendOperation.sign_extend;
        Expression expression3 = this.extend(iLocation, expression, extendOperation, n3, n2);
        Expression expression4 = this.extend(iLocation, expression2, extendOperation, n3, n2);
        this.declareBitvectorFunctionForArithmeticOperation(iLocation, bvOp, n2);
        Expression expression5 = BitvectorFactory.constructBinaryBitvectorOperation((ILocation)iLocation, (BitvectorConstant.BvOp)bvOp, (Expression[])new Expression[]{expression3, expression4});
        PrimitiveType primitiveType = new PrimitiveType(iLocation, (IBoogieType)BoogieType.createBitvectorType((int)n2), "bv" + n2);
        return new Pair((Object)expression5, (Object)primitiveType);
    }

    public void declareBitvectorFunction(ILocation iLocation, BitvectorConstant.BvOp bvOp, String string, boolean bl, CPrimitive cPrimitive, int[] nArray, CPrimitive ... cPrimitiveArray) {
        if (this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string)) {
            return;
        }
        Attribute[] attributeArray = this.generateAttributes(iLocation, false, bvOp.toString(), nArray);
        this.mFunctionDeclarations.declareFunction(iLocation, string, attributeArray, bl, cPrimitive, cPrimitiveArray);
    }

    private void declareBitvectorFunctionForArithmeticOperation(ILocation iLocation, BitvectorConstant.BvOp bvOp, int n) {
        assert (bvOp == BitvectorConstant.BvOp.bvadd || bvOp == BitvectorConstant.BvOp.bvand || bvOp == BitvectorConstant.BvOp.bvmul || bvOp == BitvectorConstant.BvOp.bvor || bvOp == BitvectorConstant.BvOp.bvsdiv || bvOp == BitvectorConstant.BvOp.bvsmod || bvOp == BitvectorConstant.BvOp.bvsrem || bvOp == BitvectorConstant.BvOp.bvxor || bvOp == BitvectorConstant.BvOp.bvsub || bvOp == BitvectorConstant.BvOp.bvshl);
        String string = SFO.getBoogieFunctionName(bvOp.toString(), n);
        if (this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string)) {
            return;
        }
        int[] nArray = null;
        Attribute[] attributeArray = this.generateAttributes(iLocation, false, bvOp.toString(), nArray);
        this.mFunctionDeclarations.declareFunction(iLocation, string, attributeArray, BitvectorTranslation.constructBitvectorAstType(iLocation, n), BitvectorTranslation.constructBitvectorAstType(iLocation, n), BitvectorTranslation.constructBitvectorAstType(iLocation, n));
    }

    private void declareBitvectorFunctionForComparisonOperation(ILocation iLocation, BitvectorConstant.BvOp bvOp, int n) {
        assert (bvOp == BitvectorConstant.BvOp.bvule || bvOp == BitvectorConstant.BvOp.bvult || bvOp == BitvectorConstant.BvOp.bvuge || bvOp == BitvectorConstant.BvOp.bvugt || bvOp == BitvectorConstant.BvOp.bvsle || bvOp == BitvectorConstant.BvOp.bvslt || bvOp == BitvectorConstant.BvOp.bvsge || bvOp == BitvectorConstant.BvOp.bvsgt);
        String string = SFO.getBoogieFunctionName(bvOp.toString(), n);
        if (this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string)) {
            return;
        }
        int[] nArray = null;
        Attribute[] attributeArray = this.generateAttributes(iLocation, false, bvOp.toString(), nArray);
        this.mFunctionDeclarations.declareFunction(iLocation, string, attributeArray, (ASTType)new PrimitiveType(iLocation, "bool"), BitvectorTranslation.constructBitvectorAstType(iLocation, n), BitvectorTranslation.constructBitvectorAstType(iLocation, n));
    }

    private void declareBitvectorFunctionBvNeg(ILocation iLocation, int n) {
        BitvectorConstant.BvOp bvOp = BitvectorConstant.BvOp.bvneg;
        String string = SFO.getBoogieFunctionName(bvOp.toString(), n);
        if (this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string)) {
            return;
        }
        int[] nArray = null;
        Attribute[] attributeArray = this.generateAttributes(iLocation, false, bvOp.toString(), nArray);
        this.mFunctionDeclarations.declareFunction(iLocation, string, attributeArray, BitvectorTranslation.constructBitvectorAstType(iLocation, n), BitvectorTranslation.constructBitvectorAstType(iLocation, n));
    }

    private void declareExtendFunction(ILocation iLocation, BitvectorConstant.ExtendOperation extendOperation, int n, int n2) {
        String string = BitvectorFactory.generateBoogieFunctionNameForExtend((BitvectorConstant.ExtendOperation)extendOperation, (int)n, (int)n2);
        if (this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string)) {
            return;
        }
        int[] nArray = new int[]{n2 - n};
        String string2 = extendOperation.toString();
        Attribute[] attributeArray = this.generateAttributes(iLocation, false, string2.toString(), nArray);
        ASTType aSTType = BitvectorTranslation.constructBitvectorAstType(iLocation, n);
        PrimitiveType primitiveType = new PrimitiveType(iLocation, "bv" + n2);
        this.mFunctionDeclarations.declareFunction(iLocation, string, attributeArray, (ASTType)primitiveType, aSTType);
    }

    private static ASTType constructBitvectorAstType(ILocation iLocation, int n) {
        return new PrimitiveType(iLocation, "bv" + n);
    }

    private void declareFloatingPointFunction(ILocation iLocation, String string, boolean bl, boolean bl2, CPrimitive cPrimitive, CPrimitive ... cPrimitiveArray) {
        this.declareFloatingPointFunction(iLocation, string, bl, bl2, cPrimitive, (int[])null, cPrimitiveArray);
    }

    private void declareFloatingPointFunction(ILocation iLocation, String string, boolean bl, boolean bl2, CPrimitive cPrimitive, int[] nArray, CPrimitive ... cPrimitiveArray) {
        String string2 = this.getBoogieFunctionName(string, cPrimitiveArray[0]);
        if (this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string2)) {
            return;
        }
        Attribute[] attributeArray = this.generateAttributes(iLocation, this.mSettings.overapproximateFloatingPointOperations(), string, nArray);
        if (bl2) {
            ASTType[] aSTTypeArray = new ASTType[cPrimitiveArray.length + 1];
            ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
            int n = 1;
            aSTTypeArray[0] = ROUNDING_MODE_BOOGIE_AST_TYPE;
            CPrimitive[] cPrimitiveArray2 = cPrimitiveArray;
            int n2 = cPrimitiveArray.length;
            int n3 = 0;
            while (n3 < n2) {
                CPrimitive cPrimitive2 = cPrimitiveArray2[n3];
                aSTTypeArray[n] = this.mTypeHandler.cType2AstType(iLocation, cPrimitive2);
                ++n;
                ++n3;
            }
            this.mFunctionDeclarations.declareFunction(iLocation, string2, attributeArray, aSTType, aSTTypeArray);
        } else {
            this.mFunctionDeclarations.declareFunction(iLocation, string2, attributeArray, bl, cPrimitive, cPrimitiveArray);
        }
    }

    @Override
    public void declareFloatingPointConstructors(ILocation iLocation, CPrimitive cPrimitive) {
        this.declareFloatingPointConstructorFromBitvec(iLocation, cPrimitive);
        this.declareFloatingPointConstructorFromReal(iLocation, cPrimitive);
    }

    private void declareFloatingPointConstructorFromReal(ILocation iLocation, CPrimitive cPrimitive) {
        ASTType[] aSTTypeArray = new ASTType[]{ROUNDING_MODE_BOOGIE_AST_TYPE, new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_REAL, "real")};
        TypeSizes.FloatingPointSize floatingPointSize = this.mTypeSizes.getFloatingPointSize(cPrimitive.getType());
        Attribute[] attributeArray = this.generateAttributes(iLocation, this.mSettings.overapproximateFloatingPointOperations(), "to_fp", new int[]{floatingPointSize.getExponent(), floatingPointSize.getSignificant()});
        ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
        this.mFunctionDeclarations.declareFunction(iLocation, this.getBoogieFunctionName("to_fp", cPrimitive), attributeArray, aSTType, aSTTypeArray);
    }

    private void declareFloatingPointConstructorFromBitvec(ILocation iLocation, CPrimitive cPrimitive) {
        TypeSizes.FloatingPointSize floatingPointSize = this.mTypeSizes.getFloatingPointSize(cPrimitive.getType());
        ASTType[] aSTTypeArray = new ASTType[]{new PrimitiveType(iLocation, (IBoogieType)BoogieType.createBitvectorType((int)1), "bv1"), new PrimitiveType(iLocation, (IBoogieType)BoogieType.createBitvectorType((int)floatingPointSize.getExponent()), "bv" + floatingPointSize.getExponent()), new PrimitiveType(iLocation, (IBoogieType)BoogieType.createBitvectorType((int)(floatingPointSize.getSignificant() - 1)), "bv" + (floatingPointSize.getSignificant() - 1))};
        Attribute[] attributeArray = this.generateAttributes(iLocation, this.mSettings.overapproximateFloatingPointOperations(), "fp", null);
        ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
        this.mFunctionDeclarations.declareFunction(iLocation, this.getBoogieFunctionName("fp", cPrimitive), attributeArray, aSTType, aSTTypeArray);
    }

    @Override
    protected ExpressionResult convertIntToIntNonBool(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        int n;
        if (cPrimitive == null) {
            throw new UnsupportedOperationException("non-primitive types not supported yet " + String.valueOf(cPrimitive));
        }
        if (cPrimitive.getGeneralType() != CPrimitive.CPrimitiveCategory.INTTYPE) {
            throw new UnsupportedOperationException("non-integer types not supported yet " + String.valueOf(cPrimitive));
        }
        int n2 = this.mTypeSizes.getSize(cPrimitive.getType()) * 8;
        if (n2 == (n = this.mTypeSizes.getSize(((CPrimitive)expressionResult.getLrValue().getCType().getUnderlyingType()).getType()) * 8)) {
            RValue rValue = (RValue)expressionResult.getLrValue();
            RValue rValue2 = new RValue(rValue.getValue(), cPrimitive, rValue.isBoogieBool(), rValue.isIntFromPointer());
            return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue2).build();
        }
        if (n2 > n) {
            return this.extend(iLocation, expressionResult, cPrimitive, n2, n);
        }
        Expression expression = this.extractBits(iLocation, expressionResult.getLrValue().getValue(), n2, 0);
        RValue rValue = new RValue(expression, cPrimitive);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue).build();
    }

    @Override
    public Expression convertInfinitePrecisionExpression(ILocation iLocation, Expression expression, CPrimitive cPrimitive) {
        return this.extractBits(iLocation, expression, this.computeBitsize(cPrimitive), 0);
    }

    @Override
    protected ExpressionResult convertFloatToIntNonBool(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        String string = this.declareConversionFunction(iLocation, (CPrimitive)expressionResult.getLrValue().getCType().getUnderlyingType(), cPrimitive);
        Expression expression = expressionResult.getLrValue().getValue();
        IdentifierExpression identifierExpression = SmtRoundingMode.RTZ.getBoogieIdentifierExpression();
        Expression expression2 = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{identifierExpression, expression}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
        RValue rValue = new RValue(expression2, cPrimitive, false, false);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue).build();
    }

    @Override
    public ExpressionResult convertIntToFloat(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        String string = this.declareConversionFunction(iLocation, (CPrimitive)expressionResult.getLrValue().getCType().getUnderlyingType(), cPrimitive);
        Expression expression = expressionResult.getLrValue().getValue();
        Expression expression2 = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{this.getCurrentRoundingMode(), expression}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
        RValue rValue = new RValue(expression2, cPrimitive, false, false);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue).build();
    }

    @Override
    public ExpressionResult convertFloatToFloat(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        String string = this.declareConversionFunction(iLocation, (CPrimitive)expressionResult.getLrValue().getCType().getUnderlyingType(), cPrimitive);
        Expression expression = expressionResult.getLrValue().getValue();
        Expression expression2 = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{this.getCurrentRoundingMode(), expression}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
        RValue rValue = new RValue(expression2, cPrimitive, false, false);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue).build();
    }

    @Override
    public Expression extractBits(ILocation iLocation, Expression expression, int n, int n2) {
        return ExpressionFactory.constructBitvectorAccessExpression((ILocation)iLocation, (Expression)expression, (int)n, (int)n2);
    }

    private ExpressionResult extend(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive, int n, int n2) {
        CPrimitive cPrimitive2 = (CPrimitive)expressionResult.getLrValue().getCType().getUnderlyingType();
        BitvectorConstant.ExtendOperation extendOperation = this.mTypeSizes.isUnsigned(cPrimitive2) ? BitvectorConstant.ExtendOperation.zero_extend : BitvectorConstant.ExtendOperation.sign_extend;
        String string = BitvectorFactory.generateBoogieFunctionNameForExtend((BitvectorConstant.ExtendOperation)extendOperation, (int)n2, (int)n);
        int[] nArray = new int[]{n - n2};
        this.declareBitvectorFunction(iLocation, extendOperation.getBvOp(), string, false, cPrimitive, nArray, cPrimitive2);
        Expression expression = expressionResult.getLrValue().getValue();
        Expression expression2 = BitvectorFactory.constructExtendOperation((ILocation)iLocation, (BitvectorConstant.ExtendOperation)extendOperation, (BigInteger)BigInteger.valueOf(nArray[0]), (Expression)expression);
        RValue rValue = new RValue(expression2, cPrimitive);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue).build();
    }

    private Expression extend(ILocation iLocation, Expression expression, BitvectorConstant.ExtendOperation extendOperation, int n, int n2) {
        this.declareExtendFunction(iLocation, extendOperation, n, n2);
        return BitvectorFactory.constructExtendOperation((ILocation)iLocation, (BitvectorConstant.ExtendOperation)extendOperation, (BigInteger)BigInteger.valueOf(n2 - n), (Expression)expression);
    }

    @Override
    public CPrimitive getCTypeOfPointerComponents() {
        return new CPrimitive(CPrimitive.CPrimitives.ULONG);
    }

    @Override
    public Optional<Expression> getTypeConstraint(ILocation iLocation, Expression expression, ICType iCType) {
        return Optional.empty();
    }

    @Override
    public Expression concatBits(ILocation iLocation, List<Expression> list, int n) {
        Iterator<Expression> iterator = list.iterator();
        Expression expression = iterator.next();
        while (iterator.hasNext()) {
            Expression expression2 = iterator.next();
            expression = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.BITVECCONCAT, (Expression)expression, (Expression)expression2);
        }
        return expression;
    }

    @Override
    public Expression signExtend(ILocation iLocation, Expression expression, int n, int n2) {
        ASTType aSTType = ((TypeHandler)this.mTypeHandler).byteSize2AstType(iLocation, CPrimitive.CPrimitiveCategory.INTTYPE, n2 / 8);
        ASTType aSTType2 = ((TypeHandler)this.mTypeHandler).byteSize2AstType(iLocation, CPrimitive.CPrimitiveCategory.INTTYPE, n / 8);
        String string = BitvectorFactory.generateBoogieFunctionNameForExtend((BitvectorConstant.ExtendOperation)BitvectorConstant.ExtendOperation.sign_extend, (int)n, (int)n2);
        if (!this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string)) {
            int[] nArray = new int[]{n2 - n};
            Attribute[] attributeArray = this.generateAttributes(iLocation, false, "sign_extend", nArray);
            this.mFunctionDeclarations.declareFunction(iLocation, string, attributeArray, aSTType, aSTType2);
        }
        return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{expression}, (BoogieType)BoogieType.createBitvectorType((int)n2));
    }

    @Override
    public Expression eraseBits(ILocation iLocation, Expression expression, CPrimitive cPrimitive, int n) {
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(n).subtract(BigInteger.ONE);
        Expression expression2 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, bigInteger);
        return this.constructBinaryBitwiseIntegerExpression(iLocation, 12, expression, cPrimitive, expression2, cPrimitive);
    }

    @Override
    public Expression constructBinaryComparisonFloatingPointExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        String string;
        if (!this.mFunctionDeclarations.checkParameters(cPrimitive, cPrimitive2)) {
            throw new IllegalArgumentException("incompatible types " + String.valueOf(cPrimitive) + " " + String.valueOf(cPrimitive2));
        }
        boolean bl = false;
        switch (n) {
            case 28: {
                string = "fp.eq";
                break;
            }
            case 29: {
                string = "fp.eq";
                bl = true;
                break;
            }
            case 11: {
                string = "fp.geq";
                break;
            }
            case 9: {
                string = "fp.gt";
                break;
            }
            case 10: {
                string = "fp.leq";
                break;
            }
            case 8: {
                string = "fp.lt";
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown operation " + n));
            }
        }
        this.declareFloatingPointFunction(iLocation, string, true, false, new CPrimitive(CPrimitive.CPrimitives.BOOL), cPrimitive, cPrimitive2);
        String string2 = this.getBoogieFunctionName(string, cPrimitive);
        Expression expression3 = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string2, (Expression[])new Expression[]{expression, expression2}, (BoogieType)BoogieType.TYPE_BOOL);
        if (bl) {
            expression3 = ExpressionFactory.constructUnaryExpression((ILocation)iLocation, (UnaryExpression.Operator)UnaryExpression.Operator.LOGICNEG, (Expression)expression3);
        }
        return expression3;
    }

    @Override
    protected Expression constructUnaryFloatingPointExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive) {
        String string = switch (n) {
            case 3 -> "fp.neg";
            default -> throw new UnsupportedSyntaxException(iLocation, "Unknown or unsupported unary expression");
        };
        this.declareFloatingPointFunction(iLocation, string, false, false, cPrimitive, cPrimitive);
        String string2 = this.getBoogieFunctionName(string, cPrimitive);
        return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string2, (Expression[])new Expression[]{expression}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
    }

    @Override
    protected Expression constructArithmeticFloatingPointExpression(ILocation iLocation, int n, Expression expression, CPrimitive cPrimitive, Expression expression2, CPrimitive cPrimitive2) {
        String string;
        if (!this.mFunctionDeclarations.checkParameters(cPrimitive, cPrimitive2)) {
            throw new IllegalArgumentException("incompatible types " + String.valueOf(cPrimitive) + " " + String.valueOf(cPrimitive2));
        }
        boolean bl = true;
        switch (n) {
            case 5: 
            case 22: {
                string = "fp.sub";
                break;
            }
            case 1: 
            case 18: {
                string = "fp.mul";
                break;
            }
            case 2: 
            case 19: {
                string = "fp.div";
                break;
            }
            case 3: 
            case 20: {
                string = "fp.rem";
                bl = false;
                break;
            }
            case 4: 
            case 21: {
                string = "fp.add";
                break;
            }
            default: {
                throw new UnsupportedSyntaxException(iLocation, "Unknown or unsupported arithmetic expression");
            }
        }
        if (bl) {
            this.declareFloatingPointFunction(iLocation, string, false, bl, cPrimitive, cPrimitive, cPrimitive2);
            String string2 = this.getBoogieFunctionName(string, cPrimitive);
            return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string2, (Expression[])new Expression[]{this.getCurrentRoundingMode(), expression, expression2}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
        }
        this.declareFloatingPointFunction(iLocation, string, false, bl, cPrimitive, cPrimitive, cPrimitive2);
        String string3 = this.getBoogieFunctionName(string, cPrimitive);
        return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string3, (Expression[])new Expression[]{expression, expression2}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
    }

    @Override
    protected Expression constructBinaryEqualityExpressionFloating(ILocation iLocation, int n, Expression expression, ICType iCType, Expression expression2, ICType iCType2) {
        return this.constructBinaryComparisonFloatingPointExpression(iLocation, n, expression, (CPrimitive)iCType, expression2, (CPrimitive)iCType2);
    }

    @Override
    protected Expression constructBinaryEqualityExpressionInteger(ILocation iLocation, int n, Expression expression, ICType iCType, Expression expression2, ICType iCType2) {
        if (n == 28) {
            return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression, (Expression)expression2);
        }
        if (n == 29) {
            return ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPNEQ, (Expression)expression, (Expression)expression2);
        }
        throw new IllegalArgumentException("operator is neither equals nor not equals");
    }

    private String declareConversionFunction(ILocation iLocation, CPrimitive cPrimitive, CPrimitive cPrimitive2) {
        String string = "convert" + cPrimitive.toString() + "To" + cPrimitive2.toString();
        String string2 = "~" + string;
        if (!this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string2)) {
            Attribute[] attributeArray;
            Object object;
            Object object2;
            ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
            ASTType aSTType2 = ROUNDING_MODE_BOOGIE_AST_TYPE;
            if (cPrimitive2.isFloatingType()) {
                object2 = new int[2];
                object = this.mTypeSizes.getFloatingPointSize(cPrimitive2.getType());
                object2[0] = ((TypeSizes.FloatingPointSize)object).getExponent();
                object2[1] = ((TypeSizes.FloatingPointSize)object).getSignificant();
                attributeArray = cPrimitive.isIntegerType() && this.mTypeSizes.isUnsigned(cPrimitive) ? this.generateAttributes(iLocation, this.mSettings.overapproximateFloatingPointOperations(), "to_fp_unsigned", (int[])object2) : this.generateAttributes(iLocation, this.mSettings.overapproximateFloatingPointOperations(), "to_fp", (int[])object2);
            } else if (cPrimitive2.isIntegerType()) {
                object2 = this.mTypeSizes.isUnsigned(cPrimitive2) ? (Object)"fp.to_ubv" : (Object)"fp.to_sbv";
                object = this.mTypeSizes.getSize(cPrimitive2.getType());
                int n = (Integer)object * 8;
                attributeArray = this.generateAttributes(iLocation, this.mSettings.overapproximateFloatingPointOperations(), (String)object2, new int[]{n});
            } else {
                throw new AssertionError((Object)"unhandled case");
            }
            object2 = new ASTType[]{aSTType2, aSTType};
            object = this.mTypeHandler.cType2AstType(iLocation, cPrimitive2);
            this.mFunctionDeclarations.declareFunction(iLocation, string2, attributeArray, (ASTType)object, (ASTType[])object2);
        }
        return string2;
    }

    @Override
    public ExpressionResult createNanOrInfinity(ILocation iLocation, String string) {
        CPrimitive cPrimitive;
        String string2;
        if (string.equals("INFINITY") || string.equals("inf") || string.equals("inff")) {
            string2 = SMT_LIB_PLUS_INF;
            cPrimitive = new CPrimitive(CPrimitive.CPrimitives.DOUBLE);
        } else if (string.equals("NAN") || string.equals("nan")) {
            string2 = SMT_LIB_NAN;
            cPrimitive = new CPrimitive(CPrimitive.CPrimitives.DOUBLE);
        } else if (string.equals("nanl")) {
            string2 = SMT_LIB_NAN;
            cPrimitive = new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE);
        } else if (string.equals("nanf")) {
            string2 = SMT_LIB_NAN;
            cPrimitive = new CPrimitive(CPrimitive.CPrimitives.FLOAT);
        } else {
            throw new IllegalArgumentException("not a nan or infinity type");
        }
        this.declareFloatConstant(iLocation, string2, cPrimitive);
        String string3 = this.getBoogieFunctionName(string2, cPrimitive);
        Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string3, (Expression[])new Expression[0], (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
        return new ExpressionResult(new RValue(expression, cPrimitive));
    }

    public ExpressionResult createRoundingMode(ILocation iLocation, String string) {
        CPrimitive cPrimitive;
        String string2;
        if (string.equals("INFINITY") || string.equals("inf") || string.equals("inff")) {
            string2 = SMT_LIB_PLUS_INF;
            cPrimitive = new CPrimitive(CPrimitive.CPrimitives.DOUBLE);
        } else if (string.equals("NAN") || string.equals("nan")) {
            string2 = SMT_LIB_NAN;
            cPrimitive = new CPrimitive(CPrimitive.CPrimitives.DOUBLE);
        } else if (string.equals("nanl")) {
            string2 = SMT_LIB_NAN;
            cPrimitive = new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE);
        } else if (string.equals("nanf")) {
            string2 = SMT_LIB_NAN;
            cPrimitive = new CPrimitive(CPrimitive.CPrimitives.FLOAT);
        } else {
            throw new IllegalArgumentException("not a nan or infinity type");
        }
        this.declareFloatConstant(iLocation, string2, cPrimitive);
        String string3 = this.getBoogieFunctionName(string2, cPrimitive);
        Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string3, (Expression[])new Expression[0], (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive));
        return new ExpressionResult(new RValue(expression, cPrimitive));
    }

    @Override
    public void declareFloatConstant(ILocation iLocation, String string, CPrimitive cPrimitive) {
        TypeSizes.FloatingPointSize floatingPointSize = this.mTypeSizes.getFloatingPointSize(cPrimitive.getType());
        Attribute[] attributeArray = this.generateAttributes(iLocation, this.mSettings.overapproximateFloatingPointOperations(), string, new int[]{floatingPointSize.getExponent(), floatingPointSize.getSignificant()});
        ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
        this.getFunctionDeclarations().declareFunction(iLocation, this.getBoogieFunctionName(string, cPrimitive), attributeArray, aSTType, new ASTType[0]);
    }

    @Override
    public Expression getCurrentRoundingMode() {
        if (this.mSettings.isFesetroundEnabled()) {
            return ExpressionFactory.constructIdentifierExpression((ILocation)LocationFactory.createIgnoreCLocation(), (BoogieType)ROUNDING_MODE_BOOGIE_TYPE, (String)ULTIMATE_VAR_CURRENT_ROUNDING_MODE, (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
        }
        return this.mCurrentRoundingMode;
    }

    @Override
    public RValue constructOtherUnaryFloatOperation(ILocation iLocation, FloatFunction floatFunction, RValue rValue) {
        if ("sqrt".equals(floatFunction.getFunctionName())) {
            BitvectorTranslation.checkIsFloatPrimitive(rValue);
            CPrimitive cPrimitive = (CPrimitive)rValue.getCType().getUnderlyingType();
            this.declareFloatingPointFunction(iLocation, "fp.sqrt", false, true, cPrimitive, cPrimitive);
            String string = this.getBoogieFunctionName("fp.sqrt", cPrimitive);
            CPrimitive cPrimitive2 = (CPrimitive)rValue.getCType().getUnderlyingType();
            Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{this.getCurrentRoundingMode(), rValue.getValue()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive2));
            return new RValue(expression, cPrimitive2);
        }
        if ("trunc".equals(floatFunction.getFunctionName())) {
            BitvectorTranslation.checkIsFloatPrimitive(rValue);
            CPrimitive cPrimitive = (CPrimitive)rValue.getCType().getUnderlyingType();
            this.declareFloatingPointFunction(iLocation, "fp.roundToIntegral", false, true, cPrimitive, cPrimitive);
            String string = this.getBoogieFunctionName("fp.roundToIntegral", cPrimitive);
            CPrimitive cPrimitive3 = (CPrimitive)rValue.getCType().getUnderlyingType();
            Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{SmtRoundingMode.RTZ.getBoogieIdentifierExpression(), rValue.getValue()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive3));
            return new RValue(expression, cPrimitive3);
        }
        if ("round".equals(floatFunction.getFunctionName())) {
            BitvectorTranslation.checkIsFloatPrimitive(rValue);
            CPrimitive cPrimitive = (CPrimitive)rValue.getCType().getUnderlyingType();
            this.declareFloatingPointFunction(iLocation, "fp.roundToIntegral", false, true, cPrimitive, cPrimitive);
            String string = this.getBoogieFunctionName("fp.roundToIntegral", cPrimitive);
            CPrimitive cPrimitive4 = (CPrimitive)rValue.getCType().getUnderlyingType();
            Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{SmtRoundingMode.RNA.getBoogieIdentifierExpression(), rValue.getValue()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive4));
            return new RValue(expression, cPrimitive4);
        }
        if ("lround".equals(floatFunction.getFunctionName())) {
            BitvectorTranslation.checkIsFloatPrimitive(rValue);
            CPrimitive cPrimitive = (CPrimitive)rValue.getCType().getUnderlyingType();
            this.declareFloatingPointFunction(iLocation, "fp.roundToIntegral", false, true, cPrimitive, cPrimitive);
            String string = this.getBoogieFunctionName("fp.roundToIntegral", cPrimitive);
            CPrimitive cPrimitive5 = (CPrimitive)rValue.getCType().getUnderlyingType();
            Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{SmtRoundingMode.RNA.getBoogieIdentifierExpression(), rValue.getValue()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive5));
            RValue rValue2 = new RValue(expression, cPrimitive5);
            ExpressionResult expressionResult = new ExpressionResultBuilder().setLrValue(rValue2).build();
            return (RValue)this.convertFloatToIntNonBool(iLocation, expressionResult, new CPrimitive(CPrimitive.CPrimitives.LONG)).getLrValue();
        }
        if ("llround".equals(floatFunction.getFunctionName())) {
            BitvectorTranslation.checkIsFloatPrimitive(rValue);
            CPrimitive cPrimitive = (CPrimitive)rValue.getCType().getUnderlyingType();
            this.declareFloatingPointFunction(iLocation, "fp.roundToIntegral", false, true, cPrimitive, cPrimitive);
            String string = this.getBoogieFunctionName("fp.roundToIntegral", cPrimitive);
            CPrimitive cPrimitive6 = (CPrimitive)rValue.getCType().getUnderlyingType();
            Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{SmtRoundingMode.RNA.getBoogieIdentifierExpression(), rValue.getValue()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive6));
            RValue rValue3 = new RValue(expression, cPrimitive6);
            ExpressionResult expressionResult = new ExpressionResultBuilder().setLrValue(rValue3).build();
            return (RValue)this.convertFloatToIntNonBool(iLocation, expressionResult, new CPrimitive(CPrimitive.CPrimitives.LONGLONG)).getLrValue();
        }
        if ("floor".equals(floatFunction.getFunctionName())) {
            BitvectorTranslation.checkIsFloatPrimitive(rValue);
            CPrimitive cPrimitive = (CPrimitive)rValue.getCType().getUnderlyingType();
            this.declareFloatingPointFunction(iLocation, "fp.roundToIntegral", false, true, cPrimitive, cPrimitive);
            String string = this.getBoogieFunctionName("fp.roundToIntegral", cPrimitive);
            CPrimitive cPrimitive7 = (CPrimitive)rValue.getCType().getUnderlyingType();
            Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{SmtRoundingMode.RTN.getBoogieIdentifierExpression(), rValue.getValue()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive7));
            return new RValue(expression, cPrimitive7);
        }
        if ("ceil".equals(floatFunction.getFunctionName())) {
            BitvectorTranslation.checkIsFloatPrimitive(rValue);
            CPrimitive cPrimitive = (CPrimitive)rValue.getCType().getUnderlyingType();
            this.declareFloatingPointFunction(iLocation, "fp.roundToIntegral", false, true, cPrimitive, cPrimitive);
            String string = this.getBoogieFunctionName("fp.roundToIntegral", cPrimitive);
            CPrimitive cPrimitive8 = (CPrimitive)rValue.getCType().getUnderlyingType();
            Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{SmtRoundingMode.RTP.getBoogieIdentifierExpression(), rValue.getValue()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive8));
            return new RValue(expression, cPrimitive8);
        }
        if ("sin".equals(floatFunction.getFunctionName())) {
            throw new UnsupportedOperationException("not yet supported float operation " + floatFunction.getFunctionName());
        }
        if ("fabs".equals(floatFunction.getFunctionName())) {
            BitvectorTranslation.checkIsFloatPrimitive(rValue);
            CPrimitive cPrimitive = (CPrimitive)rValue.getCType().getUnderlyingType();
            this.declareFloatingPointFunction(iLocation, "fp.abs", false, false, cPrimitive, cPrimitive);
            String string = this.getBoogieFunctionName("fp.abs", cPrimitive);
            CPrimitive cPrimitive9 = (CPrimitive)rValue.getCType().getUnderlyingType();
            Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{rValue.getValue()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive9));
            return new RValue(expression, cPrimitive9);
        }
        if ("isnan".equals(floatFunction.getFunctionName())) {
            return this.constructSmtFloatClassificationFunction(iLocation, "fp.isNaN", rValue);
        }
        if ("isinf".equals(floatFunction.getFunctionName())) {
            return this.constructSmtFloatClassificationFunction(iLocation, "fp.isInfinite", rValue);
        }
        if ("isnormal".equals(floatFunction.getFunctionName())) {
            return this.constructSmtFloatClassificationFunction(iLocation, "fp.isNormal", rValue);
        }
        if ("isfinite".equals(floatFunction.getFunctionName()) || "finite".equals(floatFunction.getFunctionName())) {
            RValue rValue4 = this.constructSmtFloatClassificationFunction(iLocation, "fp.isNormal", rValue);
            Expression expression = rValue4.getValue();
            RValue rValue5 = this.constructSmtFloatClassificationFunction(iLocation, "fp.isSubnormal", rValue);
            rValue4 = rValue5.getValue();
            RValue rValue6 = this.constructSmtFloatClassificationFunction(iLocation, "fp.isZero", rValue);
            rValue5 = rValue6.getValue();
            rValue6 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression, (Expression)rValue4), (Expression)rValue5);
            return new RValue((Expression)rValue6, new CPrimitive(CPrimitive.CPrimitives.INT), true);
        }
        if ("fpclassify".equals(floatFunction.getFunctionName())) {
            RValue rValue7 = this.constructSmtFloatClassificationFunction(iLocation, "fp.isInfinite", rValue);
            Expression expression = rValue7.getValue();
            RValue rValue8 = this.constructSmtFloatClassificationFunction(iLocation, "fp.isNaN", rValue);
            rValue7 = rValue8.getValue();
            RValue rValue9 = this.constructSmtFloatClassificationFunction(iLocation, "fp.isNormal", rValue);
            rValue8 = rValue9.getValue();
            RValue rValue10 = this.constructSmtFloatClassificationFunction(iLocation, "fp.isSubnormal", rValue);
            rValue9 = rValue10.getValue();
            rValue10 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression, (Expression)this.handleNumberClassificationMacro(iLocation, "FP_INFINITE").getValue(), (Expression)ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)rValue7, (Expression)this.handleNumberClassificationMacro(iLocation, "FP_NAN").getValue(), (Expression)ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)rValue8, (Expression)this.handleNumberClassificationMacro(iLocation, "FP_NORMAL").getValue(), (Expression)ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)rValue9, (Expression)this.handleNumberClassificationMacro(iLocation, "FP_SUBNORMAL").getValue(), (Expression)this.handleNumberClassificationMacro(iLocation, "FP_ZERO").getValue()))));
            return new RValue((Expression)rValue10, new CPrimitive(CPrimitive.CPrimitives.INT));
        }
        "signbit".equals(floatFunction.getFunctionName());
        throw new UnsupportedOperationException("not yet supported float operation " + floatFunction.getFunctionName());
    }

    private static void checkIsFloatPrimitive(RValue rValue) {
        CPrimitive cPrimitive;
        ICType iCType = rValue.getCType().getUnderlyingType();
        if (!(iCType instanceof CPrimitive) || !(cPrimitive = (CPrimitive)iCType).getType().isFloatingtype()) {
            throw new IllegalArgumentException("can apply float operation only to floating type, but saw " + String.valueOf(rValue.getCType()));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public RValue constructOtherBinaryFloatOperation(ILocation var1_1, FloatFunction var2_2, RValue var3_3, RValue var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[8] lbl61 : CaseStatement: default:\u000a, @NONE, blocks:[8] lbl61 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RValue delegateOtherBinaryFloatOperationToSmt(ILocation iLocation, RValue rValue, RValue rValue2, String string) {
        BitvectorTranslation.checkIsFloatPrimitive(rValue);
        BitvectorTranslation.checkIsFloatPrimitive(rValue2);
        CPrimitive cPrimitive = (CPrimitive)rValue.getCType().getUnderlyingType();
        CPrimitive cPrimitive2 = (CPrimitive)rValue.getCType().getUnderlyingType();
        if (!cPrimitive.equals(cPrimitive2)) {
            throw new IllegalArgumentException("No mixed type arguments allowed");
        }
        this.declareFloatingPointFunction(iLocation, string, false, false, cPrimitive, cPrimitive, cPrimitive2);
        String string2 = this.getBoogieFunctionName(string, cPrimitive);
        CPrimitive cPrimitive3 = cPrimitive;
        Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string2, (Expression[])new Expression[]{rValue.getValue(), rValue2.getValue()}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(cPrimitive3));
        return new RValue(expression, cPrimitive3);
    }

    private RValue constructSmtFloatClassificationFunction(ILocation iLocation, String string, RValue rValue) {
        CPrimitive cPrimitive = (CPrimitive)rValue.getCType().getUnderlyingType();
        String string2 = this.getBoogieFunctionName(string, cPrimitive);
        CPrimitive cPrimitive2 = new CPrimitive(CPrimitive.CPrimitives.INT);
        PrimitiveType primitiveType = new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, "bool");
        Attribute[] attributeArray = this.generateAttributes(iLocation, this.mSettings.overapproximateFloatingPointOperations(), string, null);
        ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
        this.getFunctionDeclarations().declareFunction(iLocation, string2, attributeArray, (ASTType)primitiveType, aSTType);
        Expression expression = ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string2, (Expression[])new Expression[]{rValue.getValue()}, (BoogieType)BoogieType.TYPE_BOOL);
        return new RValue(expression, cPrimitive2, true);
    }

    @Override
    public Expression transformBitvectorToFloat(ILocation iLocation, Expression expression, CPrimitive.CPrimitives cPrimitives) {
        TypeSizes.FloatingPointSize floatingPointSize = this.mTypeSizes.getFloatingPointSize(cPrimitives);
        Expression expression2 = this.extractBits(iLocation, expression, floatingPointSize.getSignificant() - 1, 0);
        Expression expression3 = this.extractBits(iLocation, expression, floatingPointSize.getSignificant() - 1 + floatingPointSize.getExponent(), floatingPointSize.getSignificant() - 1);
        Expression expression4 = this.extractBits(iLocation, expression, floatingPointSize.getSignificant() - 1 + floatingPointSize.getExponent() + 1, floatingPointSize.getSignificant() - 1 + floatingPointSize.getExponent());
        String string = this.getBoogieFunctionName("fp", new CPrimitive(cPrimitives));
        return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{expression4, expression3, expression2}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(new CPrimitive(cPrimitives)));
    }

    @Override
    public Expression transformFloatToBitvector(ILocation iLocation, Expression expression, CPrimitive.CPrimitives cPrimitives) {
        String string = this.getBoogieFunctionName("fp.to_ieee_bv", new CPrimitive(cPrimitives));
        if (!this.mFunctionDeclarations.getDeclaredFunctions().containsKey(string)) {
            int n = this.mTypeSizes.getSize(cPrimitives);
            ASTType aSTType = ((TypeHandler)this.mTypeHandler).byteSize2AstType(iLocation, cPrimitives.getPrimitiveCategory(), n);
            ASTType aSTType2 = this.mTypeHandler.cType2AstType(iLocation, new CPrimitive(cPrimitives));
            ASTType[] aSTTypeArray = new ASTType[]{aSTType2};
            Attribute[] attributeArray = this.generateAttributes(iLocation, this.mSettings.overapproximateFloatingPointOperations(), "fp.to_ieee_bv", null);
            this.mFunctionDeclarations.declareFunction(iLocation, string, attributeArray, aSTType, aSTTypeArray);
        }
        return ExpressionFactory.constructFunctionApplication((ILocation)iLocation, (String)string, (Expression[])new Expression[]{expression}, (BoogieType)this.mTypeHandler.getBoogieTypeForCType(new CPrimitive(cPrimitives)));
    }

    @Override
    public void declareBinaryBitvectorFunctionsForAllIntegerDatatypes(ILocation iLocation, BitvectorConstant.BvOp[] bvOpArray) {
        BitvectorConstant.BvOp[] bvOpArray2 = bvOpArray;
        int n = bvOpArray.length;
        int n2 = 0;
        while (n2 < n) {
            BitvectorConstant.BvOp bvOp = bvOpArray2[n2];
            CPrimitive.CPrimitives[] cPrimitivesArray = CPrimitive.CPrimitives.values();
            int n3 = cPrimitivesArray.length;
            int n4 = 0;
            while (n4 < n3) {
                CPrimitive.CPrimitives cPrimitives = cPrimitivesArray[n4];
                CPrimitive cPrimitive = new CPrimitive(cPrimitives);
                if (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.INTTYPE) {
                    String string = this.getBoogieFunctionName(bvOp.toString(), cPrimitive);
                    this.declareBitvectorFunction(iLocation, bvOp, string, bvOp.isBoolean(), cPrimitive, null, cPrimitive, cPrimitive);
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public RValue constructBuiltinFegetround(ILocation iLocation) {
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        if (this.mSettings.isFesetroundEnabled()) {
            this.mTypeHandler.requestFloatingTypes();
            Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ONE);
            IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)ROUNDING_MODE_BOOGIE_TYPE, (String)ULTIMATE_VAR_CURRENT_ROUNDING_MODE, (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
            Expression expression2 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, (Expression)SmtRoundingMode.RTZ.getBoogieIdentifierExpression());
            Expression expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, (Expression)SmtRoundingMode.RTN.getBoogieIdentifierExpression());
            Expression expression4 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, (Expression)SmtRoundingMode.RTP.getBoogieIdentifierExpression());
            Expression expression5 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)identifierExpression, (Expression)SmtRoundingMode.RNE.getBoogieIdentifierExpression());
            Expression expression6 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.valueOf(-1L));
            Expression expression7 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO);
            Expression expression8 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.valueOf(2L));
            Expression expression9 = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.valueOf(3L));
            Expression expression10 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression3, (Expression)expression9, (Expression)expression6);
            Expression expression11 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression4, (Expression)expression8, (Expression)expression10);
            Expression expression12 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression5, (Expression)expression, (Expression)expression11);
            Expression expression13 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression2, (Expression)expression7, (Expression)expression12);
            return new RValue(expression13, cPrimitive);
        }
        return new RValue(this.mCurrentRoundingModeMacroValue, cPrimitive);
    }

    @Override
    public ExpressionResult constructBuiltinFesetround(ILocation iLocation, ExpressionResult expressionResult, AuxVarInfoBuilder auxVarInfoBuilder) {
        if (this.mSettings.isFesetroundEnabled()) {
            this.mTypeHandler.requestFloatingTypes();
            CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
            ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
            Expression[] expressionArray = new Expression[]{expressionResult.getLrValue().getValue()};
            AuxVarInfo auxVarInfo = auxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, aSTType, SFO.AUXVAR.RETURNED);
            HashSet<AuxVarInfo> hashSet = new HashSet<AuxVarInfo>();
            hashSet.add(auxVarInfo);
            LocalLValue localLValue = new LocalLValue((LeftHandSide)auxVarInfo.getLhs(), (ICType)cPrimitive, null);
            CallStatement callStatement = StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[]{auxVarInfo.getLhs()}, (String)ULTIMATE_PROC_SET_CURRENT_ROUNDING_MODE, (Expression[])expressionArray);
            ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult);
            expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
            expressionResultBuilder.addStatement((Statement)callStatement);
            expressionResultBuilder.setLrValue(localLValue);
            return expressionResultBuilder.build();
        }
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.valueOf(-1L));
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(expression, cPrimitive)).build();
    }

    @Override
    public Expression applyWraparound(ILocation iLocation, CPrimitive cPrimitive, Expression expression) {
        return expression;
    }

    @Override
    public Pair<Expression, Expression> constructOverflowCheckForArithmeticExpression(ILocation iLocation, int n, CPrimitive cPrimitive, Expression expression, Expression expression2) {
        BitvectorConstant.BvOp bvOp;
        int n2;
        int n3 = this.computeBitsize(cPrimitive);
        if (n == 4 || n == 21) {
            n2 = n3 + 1;
            bvOp = BitvectorConstant.BvOp.bvadd;
        } else if (n == 5 || n == 22) {
            n2 = n3 + 1;
            bvOp = BitvectorConstant.BvOp.bvsub;
        } else if (n == 2 || n == 19) {
            n2 = n3 + 1;
            bvOp = BitvectorConstant.BvOp.bvsdiv;
        } else if (n == 1 || n == 18) {
            n2 = n3 * 2 - 1;
            bvOp = BitvectorConstant.BvOp.bvmul;
        } else {
            throw new AssertionError((Object)("Not applicable to operation " + n));
        }
        Expression expression3 = this.extend(iLocation, expression, BitvectorConstant.ExtendOperation.sign_extend, n3, n2);
        Expression expression4 = this.extend(iLocation, expression2, BitvectorConstant.ExtendOperation.sign_extend, n3, n2);
        this.declareBitvectorFunctionForArithmeticOperation(iLocation, bvOp, n2);
        Expression expression5 = BitvectorFactory.constructBinaryBitvectorOperation((ILocation)iLocation, (BitvectorConstant.BvOp)bvOp, (Expression[])new Expression[]{expression3, expression4});
        Expression expression6 = this.constructBiggerMinIntConstraint(iLocation, cPrimitive, n2, expression5);
        Expression expression7 = this.constructSmallerMaxIntConstraint(iLocation, cPrimitive, n2, expression5);
        return new Pair((Object)expression6, (Object)expression7);
    }

    private Expression constructSmallerMaxIntConstraint(ILocation iLocation, CPrimitive cPrimitive, int n, Expression expression) {
        BitvectorConstant.BvOp bvOp = this.mTypeSizes.isUnsigned(cPrimitive) ? BitvectorConstant.BvOp.bvule : BitvectorConstant.BvOp.bvsle;
        BigInteger bigInteger = this.mTypeSizes.getMaxValueOfPrimitiveType(cPrimitive);
        Expression expression2 = ExpressionFactory.createBitvecLiteral((ILocation)iLocation, (BigInteger)bigInteger, (int)n);
        Expression expression3 = BitvectorFactory.constructBinaryBitvectorOperation((ILocation)iLocation, (BitvectorConstant.BvOp)bvOp, (Expression[])new Expression[]{expression, expression2});
        return expression3;
    }

    private Expression constructBiggerMinIntConstraint(ILocation iLocation, CPrimitive cPrimitive, int n, Expression expression) {
        BitvectorConstant.BvOp bvOp = this.mTypeSizes.isUnsigned(cPrimitive) ? BitvectorConstant.BvOp.bvule : BitvectorConstant.BvOp.bvsle;
        this.declareBitvectorFunctionForComparisonOperation(iLocation, bvOp, n);
        BigInteger bigInteger = this.mTypeSizes.getMinValueOfPrimitiveType(cPrimitive);
        Expression expression2 = ExpressionFactory.createBitvecLiteral((ILocation)iLocation, (BigInteger)bigInteger, (int)n);
        Expression expression3 = BitvectorFactory.constructBinaryBitvectorOperation((ILocation)iLocation, (BitvectorConstant.BvOp)bvOp, (Expression[])new Expression[]{expression2, expression});
        return expression3;
    }

    private static int computeBitsize(ASTType aSTType) {
        if (!(aSTType instanceof PrimitiveType)) {
            throw new AssertionError((Object)("Cannot extract bitsize from type " + String.valueOf(aSTType)));
        }
        String string = ((PrimitiveType)aSTType).getName();
        if (!string.startsWith("bv")) {
            throw new AssertionError((Object)("Cannot extract bitsize from type with name " + string));
        }
        return Integer.parseInt(string.substring(2));
    }

    @Override
    public Expression checkInRangeInfinitePrecision(ILocation iLocation, Expression expression, ASTType aSTType, CPrimitive cPrimitive) {
        int n = BitvectorTranslation.computeBitsize(aSTType);
        Expression expression2 = this.constructBiggerMinIntConstraint(iLocation, cPrimitive, n, expression);
        Expression expression3 = this.constructSmallerMaxIntConstraint(iLocation, cPrimitive, n, expression);
        return ExpressionFactory.and((ILocation)iLocation, List.of(expression2, expression3));
    }

    @Override
    public Pair<Expression, Expression> constructOverflowCheckForUnaryExpression(ILocation iLocation, int n, CPrimitive cPrimitive, Expression expression) {
        if (n == 3) {
            int n2 = this.computeBitsize(cPrimitive);
            int n3 = n2 + 1;
            Expression expression2 = this.extend(iLocation, expression, BitvectorConstant.ExtendOperation.sign_extend, n2, n3);
            this.declareBitvectorFunctionBvNeg(iLocation, n3);
            Expression expression3 = BitvectorFactory.constructUnaryOperation((ILocation)iLocation, (BitvectorConstant.BvOp)BitvectorConstant.BvOp.bvneg, (Expression)expression2);
            Expression expression4 = this.constructBiggerMinIntConstraint(iLocation, cPrimitive, n3, expression3);
            Expression expression5 = this.constructSmallerMaxIntConstraint(iLocation, cPrimitive, n3, expression3);
            return new Pair((Object)expression4, (Object)expression5);
        }
        throw new AssertionError((Object)("Not applicable to operation " + n));
    }

    @Override
    protected Pair<Expression, Expression> constructOverflowCheckForLeftShift(ILocation iLocation, CPrimitive cPrimitive, Expression expression, Expression expression2, ExpressionResult expressionResult) {
        int n = this.computeBitsize(cPrimitive);
        int n2 = 2 * n - 1;
        BitvectorConstant.BvOp bvOp = BitvectorConstant.BvOp.bvshl;
        Expression expression3 = this.extend(iLocation, expression, BitvectorConstant.ExtendOperation.sign_extend, n, n2);
        Expression expression4 = this.extend(iLocation, expression2, BitvectorConstant.ExtendOperation.sign_extend, n, n2);
        this.declareBitvectorFunctionForArithmeticOperation(iLocation, bvOp, n2);
        Expression expression5 = BitvectorFactory.constructBinaryBitvectorOperation((ILocation)iLocation, (BitvectorConstant.BvOp)bvOp, (Expression[])new Expression[]{expression3, expression4});
        Expression expression6 = this.constructBiggerMinIntConstraint(iLocation, cPrimitive, n2, expression5);
        Expression expression7 = this.constructSmallerMaxIntConstraint(iLocation, cPrimitive, n2, expression5);
        return new Pair((Object)expression6, (Object)expression7);
    }

    public static enum SmtRoundingMode {
        RNE("roundNearestTiesToEven"),
        RNA("roundNearestTiesToAway"),
        RTP("roundTowardPositive"),
        RTN("roundTowardNegative"),
        RTZ("roundTowardZero");

        private final String mSmtIdentifier;
        private final IdentifierExpression mBoogieExpr;
        private final VarList mVarlist;

        private SmtRoundingMode(String string2) {
            this.mSmtIdentifier = string2;
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            String string3 = "~" + string2;
            this.mBoogieExpr = ExpressionFactory.constructIdentifierExpression((ILocation)cACSLLocation, (BoogieType)ROUNDING_MODE_BOOGIE_TYPE, (String)string3, (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
            this.mVarlist = new VarList((ILocation)cACSLLocation, new String[]{string3}, ROUNDING_MODE_BOOGIE_TYPE.toASTType((ILocation)cACSLLocation));
        }

        public String getSmtIdentifier() {
            return this.mSmtIdentifier;
        }

        public String getBoogieIdentifier() {
            return this.mBoogieExpr.getIdentifier();
        }

        public IdentifierExpression getBoogieIdentifierExpression() {
            return this.mBoogieExpr;
        }

        public VarList getBoogieVarlist() {
            return this.mVarlist;
        }
    }
}

