/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.typechecker;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieTypeConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.TypeParameters;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Stack;
import java.util.stream.IntStream;

public class TypeManager {
    private final ILogger mLogger;
    private final HashMap<String, BoogieTypeConstructor> typeConstructors = new HashMap();
    private final HashMap<String, TypeDeclaration> declarations = new HashMap();
    private final Stack<String> visiting = new Stack();
    private final Stack<TypeParameters> typeParamScopes = new Stack();

    public TypeManager(Declaration[] declarationArray, ILogger iLogger) {
        this.mLogger = iLogger;
        Declaration[] declarationArray2 = declarationArray;
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Declaration declaration = declarationArray2[n2];
            if (declaration instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)declaration;
                this.declarations.put(typeDeclaration.getIdentifier(), typeDeclaration);
            }
            ++n2;
        }
    }

    public void pushTypeScope(TypeParameters typeParameters) {
        this.typeParamScopes.push(typeParameters);
    }

    public void popTypeScope() {
        this.typeParamScopes.pop();
    }

    public BoogieType getPrimitiveType(String string) {
        if (string.equals("int")) {
            return BoogieType.TYPE_INT;
        }
        if (string == "real") {
            return BoogieType.TYPE_REAL;
        }
        if (string == "bool") {
            return BoogieType.TYPE_BOOL;
        }
        if (string.startsWith("bv")) {
            int n = Integer.parseInt(string.substring(2));
            return BoogieType.createBitvectorType(n);
        }
        this.mLogger.fatal((Object)("getPrimitiveType called with unknown type " + string + "!"));
        return BoogieType.TYPE_ERROR;
    }

    public BoogieType resolveNamedType(NamedType namedType, boolean bl) {
        int n;
        BoogieType[] boogieTypeArray;
        Object object;
        String string = namedType.getName();
        int n2 = namedType.getTypeArgs().length;
        ListIterator listIterator = this.typeParamScopes.listIterator(this.typeParamScopes.size());
        int n3 = 0;
        while (listIterator.hasPrevious()) {
            object = (TypeParameters)listIterator.previous();
            boogieTypeArray = object.findType(string, n3, bl);
            if (boogieTypeArray != null) {
                if (n2 != 0) {
                    this.mLogger.error((Object)("Bounded type " + string + " used with arguments."));
                    return BoogieType.TYPE_ERROR;
                }
                return boogieTypeArray;
            }
            n3 += object.getCount();
        }
        if (!this.typeConstructors.containsKey(string)) {
            object = this.declarations.get(string);
            if (object == null) {
                this.mLogger.error((Object)("Type " + string + " is never defined."));
                return BoogieType.TYPE_ERROR;
            }
            this.resolve((TypeDeclaration)((Object)object));
        }
        if ((object = this.typeConstructors.get(string)) == null) {
            return BoogieType.TYPE_ERROR;
        }
        if (((BoogieTypeConstructor)object).getParamCount() != n2) {
            this.mLogger.error((Object)("Type " + string + " used with wrong number of arguments."));
            return BoogieType.TYPE_ERROR;
        }
        boogieTypeArray = new BoogieType[n2];
        int[] nArray = ((BoogieTypeConstructor)object).getParamOrder();
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            n = nArray[n5];
            boogieTypeArray[n] = this.resolveType(namedType.getTypeArgs()[n], bl);
            ++n5;
        }
        n = 0;
        while (n < n2) {
            if (boogieTypeArray[n] == null) {
                boogieTypeArray[n] = this.resolveType(namedType.getTypeArgs()[n], false);
            }
            ++n;
        }
        return BoogieType.createConstructedType((BoogieTypeConstructor)object, boogieTypeArray);
    }

    public BoogieType resolveArrayType(ArrayType arrayType, boolean bl) {
        TypeParameters typeParameters = new TypeParameters(arrayType.getTypeParams());
        this.pushTypeScope(typeParameters);
        int n = arrayType.getIndexTypes().length;
        BoogieType[] boogieTypeArray = new BoogieType[n];
        int n2 = 0;
        while (n2 < n) {
            boogieTypeArray[n2] = this.resolveType(arrayType.getIndexTypes()[n2], bl);
            ++n2;
        }
        if (!typeParameters.fullyUsed()) {
            this.mLogger.error((Object)("ArrayType generics not used in index types: " + String.valueOf((Object)arrayType)));
        }
        BoogieType boogieType = this.resolveType(arrayType.getValueType(), bl);
        this.popTypeScope();
        return BoogieType.createArrayType(arrayType.getTypeParams().length, boogieTypeArray, boogieType);
    }

    private BoogieType resolveStructType(StructType structType, boolean bl) {
        BoogieType[] boogieTypeArray;
        ArrayList<String> arrayList = new ArrayList<String>(structType.getFields().length);
        ArrayList<BoogieType[]> arrayList2 = new ArrayList<BoogieType[]>(structType.getFields().length);
        int n = 0;
        while (n < structType.getFields().length) {
            boogieTypeArray = this.resolveType(structType.getFields()[n].getType(), bl);
            String[] stringArray = structType.getFields()[n].getIdentifiers();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                arrayList.add(string);
                arrayList2.add(boogieTypeArray);
                ++n3;
            }
            ++n;
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        boogieTypeArray = arrayList2.toArray(new BoogieType[arrayList2.size()]);
        return BoogieType.createStructType(stringArray, boogieTypeArray);
    }

    public BoogieType resolveType(ASTType aSTType, boolean bl) {
        if (aSTType == null) {
            throw new IllegalArgumentException("ASTType is null - cannot resolve type.");
        }
        ASTType aSTType2 = aSTType;
        Objects.requireNonNull(aSTType2);
        ASTType aSTType3 = aSTType2;
        BoogieType boogieType = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveType.class, NamedType.class, ArrayType.class, StructType.class}, (Object)((Object)aSTType3), 0)) {
            case 0 -> {
                PrimitiveType var5_4 = (PrimitiveType)aSTType3;
                yield this.getPrimitiveType(var5_4.getName());
            }
            case 1 -> {
                NamedType var6_5 = (NamedType)aSTType3;
                yield this.resolveNamedType(var6_5, bl);
            }
            case 2 -> {
                ArrayType var7_6 = (ArrayType)aSTType3;
                yield this.resolveArrayType(var7_6, bl);
            }
            case 3 -> {
                StructType var8_7 = (StructType)aSTType3;
                yield this.resolveStructType(var8_7, bl);
            }
            default -> throw new MatchException(null, null);
        };
        aSTType.setBoogieType(boogieType);
        return boogieType;
    }

    public BoogieType resolveType(ASTType aSTType) {
        return this.resolveType(aSTType, true);
    }

    public void resolve(TypeDeclaration typeDeclaration) {
        int[] nArray;
        if (this.visiting.contains(typeDeclaration.getIdentifier())) {
            this.mLogger.fatal((Object)("Cyclic type definition: " + String.valueOf(this.visiting)));
            this.typeConstructors.put(typeDeclaration.getIdentifier(), null);
        }
        this.visiting.push(typeDeclaration.getIdentifier());
        String string = typeDeclaration.getIdentifier();
        String[] stringArray = typeDeclaration.getTypeParams();
        BoogieType boogieType = null;
        if (typeDeclaration.getSynonym() != null) {
            TypeParameters typeParameters = new TypeParameters(stringArray, true);
            this.pushTypeScope(typeParameters);
            boogieType = this.resolveType(typeDeclaration.getSynonym());
            nArray = new int[typeParameters.getNumUsed()];
            System.arraycopy(typeParameters.getOrder(), 0, nArray, 0, nArray.length);
            this.popTypeScope();
        } else {
            nArray = new int[stringArray.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = n;
                ++n;
            }
        }
        this.visiting.pop();
        this.typeConstructors.put(string, new BoogieTypeConstructor(string, typeDeclaration.isFinite(), stringArray.length, nArray, boogieType));
    }

    public void init() {
        for (TypeDeclaration typeDeclaration : this.declarations.values()) {
            if (this.typeConstructors.containsKey(typeDeclaration.getIdentifier())) continue;
            this.resolve(typeDeclaration);
        }
    }

    public static boolean isEquivalent(ASTType aSTType, ASTType aSTType2) {
        ASTType aSTType3 = aSTType;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveType.class, NamedType.class, ArrayType.class, StructType.class}, (Object)((Object)aSTType3), 0)) {
            case -1 -> {
                if (aSTType2 == null) {
                    yield true;
                }
                yield false;
            }
            case 0 -> {
                PrimitiveType var3_3 = (PrimitiveType)aSTType3;
                if (aSTType2 instanceof PrimitiveType) {
                    PrimitiveType var4_4 = (PrimitiveType)aSTType2;
                    if (Objects.equals(var3_3.getName(), var4_4.getName())) {
                        yield true;
                    }
                }
                yield false;
            }
            case 1 -> {
                NamedType var5_5 = (NamedType)aSTType3;
                if (aSTType2 instanceof NamedType) {
                    NamedType var6_6 = (NamedType)aSTType2;
                    if (Objects.equals(var5_5.getName(), var6_6.getName()) && TypeManager.areEquivalent(var5_5.getTypeArgs(), var6_6.getTypeArgs())) {
                        yield true;
                    }
                }
                yield false;
            }
            case 2 -> {
                ArrayType var7_7 = (ArrayType)aSTType3;
                if (aSTType2 instanceof ArrayType) {
                    ArrayType var8_8 = (ArrayType)aSTType2;
                    if (TypeManager.isEquivalent(var7_7.getValueType(), var8_8.getValueType()) && Arrays.equals(var7_7.getTypeParams(), var8_8.getTypeParams()) && TypeManager.areEquivalent(var7_7.getIndexTypes(), var8_8.getIndexTypes())) {
                        yield true;
                    }
                }
                yield false;
            }
            case 3 -> {
                StructType var9_9 = (StructType)aSTType3;
                if (aSTType2 instanceof StructType) {
                    StructType var10_10 = (StructType)aSTType2;
                    if (TypeManager.areEquivalent(var9_9.getFields(), var10_10.getFields())) {
                        yield true;
                    }
                }
                yield false;
            }
            default -> throw new MatchException(null, null);
        };
    }

    public static boolean areEquivalent(ASTType[] aSTTypeArray, ASTType[] aSTTypeArray2) {
        return TypeManager.areEquivalent(Arrays.asList(aSTTypeArray), Arrays.asList(aSTTypeArray2));
    }

    public static boolean areEquivalent(List<? extends ASTType> list, List<? extends ASTType> list2) {
        return list.size() == list2.size() && IntStream.range(0, list.size()).allMatch(n -> TypeManager.isEquivalent((ASTType)((Object)((Object)list.get(n))), (ASTType)((Object)((Object)list2.get(n)))));
    }

    private static boolean areEquivalent(VarList[] varListArray, VarList[] varListArray2) {
        return varListArray.length == varListArray2.length && IntStream.range(0, varListArray.length).allMatch(n -> {
            VarList varList = varListArray[n];
            VarList varList2 = varListArray2[n];
            assert (varList.getWhereClause() == null && varList2.getWhereClause() == null) : "'where' not supported in struct type declarations";
            return TypeManager.isEquivalent(varList.getType(), varList2.getType()) && Arrays.equals(varList.getIdentifiers(), varList2.getIdentifiers());
        });
    }
}

