/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class FunctionApplication
extends Expression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(FunctionApplication.class);
    String identifier;
    Expression[] arguments;

    public FunctionApplication(ILocation iLocation, String string, Expression[] expressionArray) {
        super(iLocation);
        this.identifier = string;
        this.arguments = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid FunctionApplication: " + String.valueOf((Object)this);
    }

    public FunctionApplication(ILocation iLocation, IBoogieType iBoogieType, String string, Expression[] expressionArray) {
        super(iLocation, iBoogieType);
        this.identifier = string;
        this.arguments = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid FunctionApplication: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FunctionApplication").append('[');
        stringBuffer.append(this.identifier);
        stringBuffer.append(',');
        if (this.arguments == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.arguments.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.arguments[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Expression[] getArguments() {
        return this.arguments;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.arguments != null) {
            list.addAll(Arrays.asList(this.arguments));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Expression)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.arguments != null) {
            Expression[] expressionArray = this.arguments;
            int n = this.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                expression.accept(generatedBoogieAstVisitor);
                ++n2;
            }
        }
    }

    @Override
    public Expression accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Expression expression = generatedBoogieAstTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        boolean bl = false;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (this.arguments != null) {
            Expression[] expressionArray = this.arguments;
            int n = this.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression2 = expressionArray[n2];
                Expression expression3 = expression2.accept(generatedBoogieAstTransformer);
                bl = bl || expression3 != expression2;
                arrayList.add(expression3);
                ++n2;
            }
        }
        if (bl) {
            return new FunctionApplication(this.loc, this.type, this.identifier, arrayList.toArray(new Expression[0]));
        }
        return this;
    }
}

