/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections;

import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;

public class VariableFactory<E> {
    public Doubleton<E> getDoubleton(E e, E e2, VariableType variableType) {
        switch (variableType) {
            case MERGE: {
                return new MergeDoubleton(e, e2);
            }
            case ORDINARY: {
                return new OrdinaryDoubleton(e, e2);
            }
            case DIRECT: {
                return new DirectDoubleton(e, e2);
            }
            case DELAYED_DUPLICATOR_ANSWERS: {
                return new DelayedDuplicatorAnswersDoubleton(e, e2);
            }
            case DELAYED_SPOILER_WINS: {
                return new DelayedSpoilerWinsDoubleton(e, e2);
            }
        }
        throw new IllegalArgumentException("Unknown variable type " + String.valueOf((Object)variableType));
    }

    public Pair<E, E> getPair(E e, E e2, VariableType variableType) {
        switch (variableType) {
            case MERGE: {
                return new MergePair(e, e2);
            }
            case ORDINARY: {
                return new OrdinaryPair(e, e2);
            }
            case DIRECT: {
                return new DirectPair(e, e2);
            }
            case DELAYED_DUPLICATOR_ANSWERS: {
                return new DelayedDuplicatorAnswersPair(e, e2);
            }
            case DELAYED_SPOILER_WINS: {
                return new DelayedSpoilerWinsPair(e, e2);
            }
        }
        throw new IllegalArgumentException("Unknown variable type " + String.valueOf((Object)variableType));
    }

    public class DelayedDuplicatorAnswersDoubleton
    extends Doubleton<E> {
        public DelayedDuplicatorAnswersDoubleton(E e, E e2) {
            super(e, e2);
        }
    }

    public class DelayedDuplicatorAnswersPair
    extends Pair<E, E> {
        public DelayedDuplicatorAnswersPair(E e, E e2) {
            super(e, e2);
        }
    }

    public class DelayedSpoilerWinsDoubleton
    extends Doubleton<E> {
        public DelayedSpoilerWinsDoubleton(E e, E e2) {
            super(e, e2);
        }
    }

    public class DelayedSpoilerWinsPair
    extends Pair<E, E> {
        public DelayedSpoilerWinsPair(E e, E e2) {
            super(e, e2);
        }
    }

    public class DirectDoubleton
    extends Doubleton<E> {
        public DirectDoubleton(E e, E e2) {
            super(e, e2);
        }
    }

    public class DirectPair
    extends Pair<E, E> {
        public DirectPair(E e, E e2) {
            super(e, e2);
        }
    }

    public class MergeDoubleton
    extends Doubleton<E> {
        public MergeDoubleton(E e, E e2) {
            super(e, e2);
        }
    }

    public class MergePair
    extends Pair<E, E> {
        public MergePair(E e, E e2) {
            super(e, e2);
        }
    }

    public class OrdinaryDoubleton
    extends Doubleton<E> {
        public OrdinaryDoubleton(E e, E e2) {
            super(e, e2);
        }
    }

    public class OrdinaryPair
    extends Pair<E, E> {
        public OrdinaryPair(E e, E e2) {
            super(e, e2);
        }
    }

    public static enum VariableType {
        MERGE,
        ORDINARY,
        DIRECT,
        DELAYED_DUPLICATOR_ANSWERS,
        DELAYED_SPOILER_WINS;

    }
}

