/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.HistoryRecordingScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationConstrainer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationManager;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Set;

public class IntBlastingWrapper
extends WrapperScript {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private Script.LBool mExpectedResult;
    private final Script mBvScript = new NoopScript();
    private final Script mIntScript;
    private final ManagedScript mMgdIntScript;
    private final ArrayDeque<Boolean> mOverapproximationTrackingStack = new ArrayDeque();
    private final TranslationManager mTm;
    private final String mBenchmarkFilename;
    private final IntBlastingMode mIntBlastingMode;
    private static final boolean WRITE_EVALUATION = false;
    private static final String EVALUATION_FILENAME = "IntBlastingWrapper.csv";
    private static final boolean DEBUG_ERROR_IF_UNKNOWN = false;

    public IntBlastingWrapper(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, Script script, IntBlastingMode intBlastingMode, TranslationConstrainer.ConstraintsForBitwiseOperations constraintsForBitwiseOperations, String string) {
        super(script);
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mIntScript = script;
        this.mMgdIntScript = new ManagedScript(iUltimateServiceProvider, this.mIntScript);
        this.mIntScript.setLogic(Logics.ALL);
        this.mOverapproximationTrackingStack.add(false);
        this.mTm = new TranslationManager(this.mMgdIntScript, constraintsForBitwiseOperations, intBlastingMode == IntBlastingMode.CongruenceBased);
        this.mBenchmarkFilename = string;
        this.mIntBlastingMode = intBlastingMode;
    }

    public void setLogic(String string) throws UnsupportedOperationException, SMTLIBException {
        try {
            this.setLogic(Logics.valueOf((String)string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException("Logic " + string + " not supported");
        }
    }

    public void setLogic(Logics logics) throws UnsupportedOperationException, SMTLIBException {
        this.mBvScript.setLogic(logics);
    }

    public void setOption(String string, Object object) throws UnsupportedOperationException, SMTLIBException {
        this.mIntScript.setOption(string, object);
    }

    public void setInfo(String string, Object object) {
        if (string.equals(":status")) {
            String string2 = (String)object;
            this.mExpectedResult = Script.LBool.valueOf((String)string2.toUpperCase());
        } else {
            this.mIntScript.setInfo(string, object);
        }
    }

    public FunctionSymbol getFunctionSymbol(String string) {
        return this.mBvScript.getFunctionSymbol(string);
    }

    public DataType.Constructor constructor(String string, String[] stringArray, Sort[] sortArray) throws SMTLIBException {
        return this.mBvScript.constructor(string, stringArray, sortArray);
    }

    public DataType datatype(String string, int n) throws SMTLIBException {
        return this.mBvScript.datatype(string, n);
    }

    public void declareDatatype(DataType dataType, DataType.Constructor[] constructorArray) throws SMTLIBException {
        this.mBvScript.declareDatatype(dataType, constructorArray);
        throw new UnsupportedOperationException("Cannot yet translate algebraic datatypes");
    }

    public void declareDatatypes(DataType[] dataTypeArray, DataType.Constructor[][] constructorArray, Sort[][] sortArray) throws SMTLIBException {
        this.mBvScript.declareDatatypes(dataTypeArray, constructorArray, sortArray);
        throw new UnsupportedOperationException("Cannot yet translate algebraic datatypes");
    }

    public void declareSort(String string, int n) throws SMTLIBException {
        this.mBvScript.declareSort(string, n);
        this.mIntScript.declareSort(string, n);
    }

    public void defineSort(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        this.mBvScript.defineSort(string, sortArray, sort);
        Sort[] sortArray2 = new Sort[sortArray.length];
        int n = 0;
        while (n < sortArray.length) {
            sortArray2[n] = IntBlastingWrapper.translateSort(this.mIntScript, sortArray[n]);
            ++n;
        }
        Sort sort2 = IntBlastingWrapper.translateSort(this.mIntScript, sort);
        this.mIntScript.defineSort(string, sortArray2, sort2);
    }

    public void defineFun(String string, TermVariable[] termVariableArray, Sort sort, Term term) throws SMTLIBException {
        Triple<Term, Set<Term>, Boolean> triple;
        Sort sort2;
        this.mBvScript.defineFun(string, termVariableArray, sort, term);
        TermVariable[] termVariableArray2 = new TermVariable[termVariableArray.length];
        int n = 0;
        while (n < termVariableArray.length) {
            sort2 = IntBlastingWrapper.translateSort(this.mIntScript, termVariableArray[n].getSort());
            triple = this.mIntScript.variable(termVariableArray[n].getName(), sort2);
            termVariableArray2[n] = triple;
            ++n;
        }
        Sort sort3 = IntBlastingWrapper.translateSort(this.mIntScript, sort);
        sort2 = new FormulaUnLet().unlet(term);
        try {
            triple = this.mTm.translateBvtoIntTransferrer((Term)sort2, (Script)new HistoryRecordingScript(this.mBvScript), (Script)new HistoryRecordingScript(this.mIntScript));
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable);
        }
        Term term2 = SmtUtils.simplify(this.mMgdIntScript, (Term)triple.getFirst(), this.mServices, SmtUtils.SimplificationTechnique.POLY_PAC);
        if (((Boolean)triple.getThird()).booleanValue()) {
            throw new UnsupportedOperationException("We cannot overapproximate in definition of defineFun");
        }
        if (!((Set)triple.getSecond()).isEmpty()) {
            throw new AssertionError((Object)("Unknown additional auxiliary variables " + String.valueOf(triple.getSecond())));
        }
        this.mIntScript.defineFun(string, termVariableArray2, sort3, term2);
    }

    public void declareFun(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        Sort[] sortArray2 = new Sort[sortArray.length];
        int n = 0;
        while (n < sortArray.length) {
            sortArray2[n] = IntBlastingWrapper.translateSort(this.mIntScript, sortArray[n]);
            ++n;
        }
        Sort sort2 = IntBlastingWrapper.translateSort(this.mIntScript, sort);
        this.mIntScript.declareFun(string, sortArray2, sort2);
        this.mBvScript.declareFun(string, sortArray, sort);
    }

    public static Sort translateSort(Script script, Sort sort) {
        if (!sort.getName().equals("BitVec")) {
            Sort[] sortArray = sort.getArguments();
            Sort[] sortArray2 = new Sort[sortArray.length];
            int n = 0;
            while (n < sortArray.length) {
                sortArray2[n] = IntBlastingWrapper.translateSort(script, sortArray[n]);
                ++n;
            }
            return script.sort(sort.getName(), sort.getIndices(), sortArray2);
        }
        Sort sort2 = SmtSortUtils.getIntSort(script);
        return sort2;
    }

    public void push(int n) throws SMTLIBException {
        this.mBvScript.push(n);
        this.mIntScript.push(n);
        int n2 = 0;
        while (n2 < n) {
            this.mOverapproximationTrackingStack.add(false);
            ++n2;
        }
    }

    public void pop(int n) throws SMTLIBException {
        this.mBvScript.pop(n);
        this.mIntScript.pop(n);
        int n2 = 0;
        while (n2 < n) {
            this.mOverapproximationTrackingStack.removeLast();
            ++n2;
        }
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        Triple<Term, Set<Term>, Boolean> triple;
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            this.writeEvalRow(0L, "Timeout at beginning of assertTerm");
            throw new ToolchainCanceledException(IntBlastingWrapper.class, String.format("assertTerm", new Object[0]));
        }
        Term term2 = new FormulaUnLet().unlet(term);
        try {
            triple = this.mTm.translateBvtoIntTransferrer(term2, (Script)new HistoryRecordingScript(this.mBvScript), (Script)new HistoryRecordingScript(this.mIntScript));
        }
        catch (Throwable throwable) {
            this.writeEvalRow(0L, throwable.toString());
            throw new AssertionError((Object)throwable);
        }
        Term term3 = (Term)triple.getFirst();
        boolean bl = (Boolean)triple.getThird();
        if (bl) {
            this.mOverapproximationTrackingStack.removeLast();
            this.mOverapproximationTrackingStack.add(true);
        }
        try {
            Term term4 = SmtUtils.simplify(this.mMgdIntScript, term3, this.mServices, SmtUtils.SimplificationTechnique.POLY_PAC);
            return this.mIntScript.assertTerm(term4);
        }
        catch (Throwable throwable) {
            this.writeEvalRow(0L, throwable.toString());
            throw new AssertionError((Object)throwable);
        }
    }

    public Script.LBool checkSat() throws SMTLIBException {
        long l = System.nanoTime();
        Script.LBool lBool = this.mIntScript.checkSat();
        long l2 = System.nanoTime() - l;
        long l3 = l2 / 1000000L;
        Script.LBool lBool2 = lBool == Script.LBool.SAT && this.mOverapproximationTrackingStack.contains(true) ? Script.LBool.UNKNOWN : lBool;
        if (this.mExpectedResult != null && lBool2 != Script.LBool.UNKNOWN && lBool2 != this.mExpectedResult) {
            throw new AssertionError((Object)("Result incorrect: expected " + String.valueOf(this.mExpectedResult) + " obtained " + String.valueOf(lBool2)));
        }
        this.writeEvalRow(l3, lBool2.toString());
        return lBool2;
    }

    private void writeEvalRow(long l, String string) {
    }

    public Script.LBool checkSatAssuming(Term ... termArray) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public Term[] getAssertions() throws SMTLIBException {
        return this.mBvScript.getAssertions();
    }

    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        return this.mBvScript.getProof();
    }

    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Term[] getUnsatAssumptions() throws SMTLIBException, UnsupportedOperationException {
        return this.mBvScript.getUnsatAssumptions();
    }

    public Map<Term, Term> getValue(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        return this.mBvScript.getAssignment();
    }

    public Object getOption(String string) throws UnsupportedOperationException {
        return this.mIntScript.getOption(string);
    }

    public Object getInfo(String string) throws UnsupportedOperationException, SMTLIBException {
        return this.mIntScript.getInfo(string);
    }

    public void exit() {
        this.mBvScript.exit();
        this.mIntScript.exit();
    }

    public Theory getTheory() {
        return this.mBvScript.getTheory();
    }

    public Sort sort(String string, Sort ... sortArray) throws SMTLIBException {
        return this.mBvScript.sort(string, sortArray);
    }

    public Sort sort(String string, String[] stringArray, Sort ... sortArray) throws SMTLIBException {
        return this.mBvScript.sort(string, stringArray, sortArray);
    }

    public Sort[] sortVariables(String ... stringArray) throws SMTLIBException {
        return this.mBvScript.sortVariables(stringArray);
    }

    public Term term(String string, Term ... termArray) throws SMTLIBException {
        return this.mBvScript.term(string, termArray);
    }

    public Term term(String string, String[] stringArray, Sort sort, Term ... termArray) throws SMTLIBException {
        return this.mBvScript.term(string, stringArray, sort, termArray);
    }

    public TermVariable variable(String string, Sort sort) throws SMTLIBException {
        return this.mBvScript.variable(string, sort);
    }

    public Term quantifier(int n, TermVariable[] termVariableArray, Term term, Term[] ... termArray) throws SMTLIBException {
        return this.mBvScript.quantifier(n, termVariableArray, term, termArray);
    }

    public Term let(TermVariable[] termVariableArray, Term[] termArray, Term term) throws SMTLIBException {
        return this.mBvScript.let(termVariableArray, termArray, term);
    }

    public Term match(Term term, TermVariable[][] termVariableArray, Term[] termArray, DataType.Constructor[] constructorArray) throws SMTLIBException {
        return this.mBvScript.match(term, termVariableArray, termArray, constructorArray);
    }

    public Term annotate(Term term, Annotation ... annotationArray) throws SMTLIBException {
        return this.mBvScript.annotate(term, annotationArray);
    }

    public Term numeral(String string) throws SMTLIBException {
        return this.mBvScript.numeral(string);
    }

    public Term numeral(BigInteger bigInteger) throws SMTLIBException {
        return this.mBvScript.numeral(bigInteger);
    }

    public Term decimal(String string) throws SMTLIBException {
        return this.mBvScript.decimal(string);
    }

    public Term decimal(BigDecimal bigDecimal) throws SMTLIBException {
        return this.mBvScript.decimal(bigDecimal);
    }

    public Term hexadecimal(String string) throws SMTLIBException {
        return this.mBvScript.hexadecimal(string);
    }

    public Term binary(String string) throws SMTLIBException {
        return this.mBvScript.binary(string);
    }

    public Term string(QuotedObject quotedObject) throws SMTLIBException {
        return this.mBvScript.string(quotedObject);
    }

    public Term simplify(Term term) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.mBvScript.reset();
        this.mIntScript.reset();
    }

    public void resetAssertions() {
        this.mBvScript.resetAssertions();
    }

    public Term[] getInterpolants(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Term[] getInterpolants(Term[] termArray, int[] nArray) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Term[] getInterpolants(Term[] termArray, int[] nArray, Term term) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Iterable<Term[]> checkAllsat(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Term[] findImpliedEquality(Term[] termArray, Term[] termArray2) {
        throw new UnsupportedOperationException();
    }

    public QuotedObject echo(QuotedObject quotedObject) {
        return this.mIntScript.echo(quotedObject);
    }

    public static enum IntBlastingMode {
        RangeBased,
        CongruenceBased;

    }
}

