/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.scc;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;

public class SccComputationNonRecursive<NODE, COMP extends StronglyConnectedComponent<NODE>>
extends SccComputation<NODE, COMP> {
    public SccComputationNonRecursive(ILogger iLogger, SccComputation.ISuccessorProvider<NODE> iSuccessorProvider, SccComputation.IStronglyConnectedComponentFactory<NODE, COMP> iStronglyConnectedComponentFactory, int n, Set<NODE> set) {
        super(iLogger, iSuccessorProvider, iStronglyConnectedComponentFactory, n, set);
    }

    @Override
    protected void strongconnect(NODE NODE) {
        ArrayDeque<TodoStackElement> arrayDeque = new ArrayDeque<TodoStackElement>();
        arrayDeque.push(new TodoStackElement(NODE, null));
        block5: while (!arrayDeque.isEmpty()) {
            TodoStackElement todoStackElement = (TodoStackElement)arrayDeque.pop();
            switch (todoStackElement.getTask()) {
                case INDEX: {
                    if (this.mIndices.containsKey(todoStackElement.getNode())) continue block5;
                    this.doIndex(todoStackElement.getNode());
                    todoStackElement.reportTaskAccomplished();
                    arrayDeque.push(todoStackElement);
                    break;
                }
                case GET_SUCCESSORS: {
                    todoStackElement.reportTaskAccomplished();
                    arrayDeque.push(todoStackElement);
                    this.doGetSuccessors(todoStackElement.getNode(), arrayDeque);
                    break;
                }
                case SET_LOWLINK: {
                    this.doSetLowlink(todoStackElement.getNode(), todoStackElement.getPredecessor());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private void doSetLowlink(NODE NODE, NODE NODE2) {
        if (((Integer)this.mLowLinks.get(NODE)).equals(this.mIndices.get(NODE))) {
            this.establishNewComponent(NODE);
        }
        if (NODE2 != null) {
            this.updateLowlink(NODE2, (Integer)this.mLowLinks.get(NODE));
        }
    }

    private void doGetSuccessors(NODE NODE, Deque<TodoStackElement> deque) {
        Iterator<NODE> iterator = this.mSuccessorProvider.getSuccessors(NODE);
        while (iterator.hasNext()) {
            NODE NODE2 = iterator.next();
            if (this.mIndices.containsKey(NODE2)) {
                if (!this.mNoScc.contains(NODE2)) continue;
                this.updateLowlink(NODE, (Integer)this.mIndices.get(NODE2));
                continue;
            }
            deque.push(new TodoStackElement(NODE2, NODE));
        }
    }

    private void doIndex(NODE NODE) {
        assert (!this.mIndices.containsKey(NODE));
        assert (!this.mLowLinks.containsKey(NODE));
        this.mIndices.put(NODE, this.mIndex);
        this.mLowLinks.put(NODE, this.mIndex);
        ++this.mIndex;
        this.mNoScc.push(NODE);
    }

    static enum NextTask {
        INDEX,
        GET_SUCCESSORS,
        SET_LOWLINK;

    }

    private class TodoStackElement {
        private final NODE mNode;
        private NextTask mTask;
        private final NODE mPredecessor;

        public TodoStackElement(NODE NODE, NODE NODE2) {
            this.mNode = NODE;
            this.mTask = NextTask.INDEX;
            this.mPredecessor = NODE2;
        }

        public void reportTaskAccomplished() {
            switch (this.mTask) {
                case INDEX: {
                    this.mTask = NextTask.GET_SUCCESSORS;
                    break;
                }
                case GET_SUCCESSORS: {
                    this.mTask = NextTask.SET_LOWLINK;
                    break;
                }
                case SET_LOWLINK: {
                    throw new IllegalStateException("SET_LOWLINK is last task");
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public NODE getNode() {
            return this.mNode;
        }

        public NextTask getTask() {
            return this.mTask;
        }

        public NODE getPredecessor() {
            return this.mPredecessor;
        }

        public String toString() {
            return "TodoStackElement [mNode=" + String.valueOf(this.mNode) + ", mTask=" + String.valueOf((Object)this.mTask) + ", mPredecessor=" + String.valueOf(this.mPredecessor) + "]";
        }
    }
}

