/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SimplificationUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermContextTransformationEngine;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolyPoNeUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.CondisDepthCodeGenerator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class PolyPacSimplificationTermWalker
extends TermContextTransformationEngine.TermWalker<Term> {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private static final boolean APPLY_CONSTANT_FOLDING = true;
    private static final boolean APPLY_MODULO_SIMPLIFICATION = true;
    private static final boolean APPLY_ARRAY_SIMPLIFICATION = true;
    private static final boolean DEBUG_CHECK_RESULT = false;

    private PolyPacSimplificationTermWalker(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript = managedScript;
    }

    @Override
    protected Term constructContextForApplicationTerm(Term term, FunctionSymbol functionSymbol, List<Term> list, int n) {
        return Context.buildCriticalConstraintForConDis(this.mServices, this.mMgdScript, term, functionSymbol, list, n, Context.CcTransformation.TO_NNF);
    }

    @Override
    protected Term constructContextForQuantifiedFormula(Term term, int n, List<TermVariable> list) {
        return Context.buildCriticalContraintForQuantifiedFormula(this.mMgdScript.getScript(), term, list, Context.CcTransformation.TO_NNF);
    }

    @Override
    protected TermContextTransformationEngine.DescendResult convert(Term term, Term term2) {
        ApplicationTerm applicationTerm;
        if (term2 instanceof ApplicationTerm) {
            applicationTerm = (ApplicationTerm)term2;
            if (applicationTerm.getFunction().getName().equals("and") || applicationTerm.getFunction().getName().equals("or")) {
                if (SmtUtils.isFalseLiteral(term)) {
                    Term term3;
                    if (applicationTerm.getFunction().getName().equals("and")) {
                        term3 = this.mMgdScript.getScript().term("true", new Term[0]);
                    } else if (applicationTerm.getFunction().getName().equals("or")) {
                        term3 = this.mMgdScript.getScript().term("false", new Term[0]);
                    } else {
                        throw new AssertionError();
                    }
                    return new TermContextTransformationEngine.FinalResultForAscend(term3);
                }
                return new TermContextTransformationEngine.IntermediateResultForDescend(term2);
            }
        } else if (term2 instanceof QuantifiedFormula) {
            return new TermContextTransformationEngine.IntermediateResultForDescend(term2);
        }
        applicationTerm = term2;
        applicationTerm = SimplificationUtils.applyConstantFolding(this.mMgdScript, term, (Term)applicationTerm);
        applicationTerm = SimplificationUtils.tryModSimplification(this.mMgdScript, termArray -> PolyPacSimplificationTermWalker.isValidInContext(this.mMgdScript.getScript(), term, termArray), (Term)applicationTerm);
        applicationTerm = SimplificationUtils.tryArraySimplification(this.mMgdScript, termArray -> PolyPacSimplificationTermWalker.isValidInContext(this.mMgdScript.getScript(), term, termArray), (Term)applicationTerm);
        return new TermContextTransformationEngine.FinalResultForAscend((Term)applicationTerm);
    }

    private static Script.LBool isValidInContext(Script script, Term term, Term ... termArray) {
        Term term2 = PolyPoNeUtils.and(script, term, Arrays.asList(termArray));
        if (SmtUtils.isTrueLiteral(term2)) {
            return Script.LBool.UNSAT;
        }
        return Script.LBool.UNKNOWN;
    }

    @Override
    protected Term constructResultForApplicationTerm(Term term, ApplicationTerm applicationTerm, Term[] termArray) {
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            CondisDepthCodeGenerator.CondisDepthCode condisDepthCode = CondisDepthCodeGenerator.CondisDepthCode.of(term);
            throw new ToolchainCanceledException(this.getClass(), String.format("simplifying %s xjuncts wrt. a %s context", termArray.length, condisDepthCode));
        }
        if (applicationTerm.getFunction().getName().equals("and")) {
            return PolyPoNeUtils.and(this.mMgdScript.getScript(), term, Arrays.asList(termArray));
        }
        if (applicationTerm.getFunction().getName().equals("or")) {
            return PolyPoNeUtils.or(this.mMgdScript.getScript(), term, Arrays.asList(termArray));
        }
        throw new AssertionError();
    }

    public static Term simplify(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term) {
        Term term2 = PolyPacSimplificationTermWalker.simplify(iUltimateServiceProvider, managedScript, managedScript.getScript().term("true", new Term[0]), term);
        return term2;
    }

    public static Term simplify(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term, Term term2) {
        Term term3;
        try {
            Comparator<Term> comparator = null;
            term3 = TermContextTransformationEngine.transform(new PolyPacSimplificationTermWalker(iUltimateServiceProvider, managedScript), comparator, term, term2);
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            CondisDepthCodeGenerator.CondisDepthCode condisDepthCode = CondisDepthCodeGenerator.CondisDepthCode.of(term2);
            String string = String.format("simplifying a %s term", condisDepthCode);
            toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(PolyPacSimplificationTermWalker.class, string));
            throw toolchainCanceledException;
        }
        return term3;
    }

    @Override
    protected Term constructResultForQuantifiedFormula(Term term, QuantifiedFormula quantifiedFormula, Term term2) {
        return SmtUtils.quantifier(this.mMgdScript.getScript(), quantifiedFormula.getQuantifier(), Arrays.asList(quantifiedFormula.getVariables()), term2);
    }

    @Override
    protected TermContextTransformationEngine.Repetition applyRepeatedly() {
        return TermContextTransformationEngine.Repetition.REPEAT_UNTIL_NO_CHANGE;
    }

    @Override
    protected void checkIntermediateResult(Term term, Term term2, Term term3) {
        Script.LBool lBool = SmtUtils.checkEquivalenceUnderAssumption(term2, term3, term, this.mMgdScript.getScript());
        switch (lBool) {
            case SAT: {
                throw new AssertionError((Object)String.format("Intermediate result not equivalent. Input: %s Output: %s Assumption: %s", term2, term3, term));
            }
            case UNKNOWN: {
                ILogger iLogger = this.mServices.getLoggingService().getLogger(this.getClass());
                iLogger.info((Object)String.format("Insufficient ressources to check equivalence of intermediate result. Input: %s Output: %s Assumption: %s", term2, term3, term));
                break;
            }
            case UNSAT: {
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + String.valueOf(lBool)));
            }
        }
    }
}

