/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public abstract class NwaApproximateXsimulation<LETTER, STATE, T> {
    protected final AutomataLibraryServices mServices;
    protected final ILogger mLogger;
    protected final INestedWordAutomaton<LETTER, STATE> mOperand;

    public NwaApproximateXsimulation(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mOperand = iNestedWordAutomaton;
    }

    public abstract ISetOfPairs<STATE, T> getResult();

    protected final void run(SimulationType simulationType, boolean bl) throws AutomataOperationCanceledException {
        this.initialize(simulationType);
        this.separateByDifferentSymbols();
        if (bl) {
            this.separateByTransitionConstraints();
        }
    }

    protected final void initialize(SimulationType simulationType) throws AutomataOperationCanceledException {
        switch (simulationType) {
            case ORDINARY: {
                this.initializeAllNonreflexivePairs();
                break;
            }
            case DIRECT: {
                this.initializeAllNonreflexivePairsRespectingAcceptance();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown simulation type: " + String.valueOf((Object)simulationType));
            }
        }
    }

    protected abstract void initializeAllNonreflexivePairs() throws AutomataOperationCanceledException;

    protected abstract void initializeAllNonreflexivePairsRespectingAcceptance() throws AutomataOperationCanceledException;

    protected abstract void separateByDifferentSymbols() throws AutomataOperationCanceledException;

    protected abstract void separateByTransitionConstraints() throws AutomataOperationCanceledException;

    protected final List<LETTER> getCommonIncomingLetters(STATE STATE, STATE STATE2, Function<STATE, Set<LETTER>> function) {
        Set<LETTER> set = function.apply(STATE);
        ArrayList<LETTER> arrayList = new ArrayList<LETTER>(set.size());
        for (LETTER LETTER : function.apply(STATE2)) {
            if (!set.contains(LETTER)) continue;
            arrayList.add(LETTER);
        }
        return arrayList;
    }

    public static enum SimulationType {
        ORDINARY,
        DIRECT;

    }
}

