/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsDeterministic;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DeterminizeSadd;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DeterminizedState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DoubleDeckerBuilder;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class DeterminizeDD<LETTER, STATE>
extends DoubleDeckerBuilder<LETTER, STATE>
implements IOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>> {
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    protected IStateDeterminizer<LETTER, STATE> mStateDeterminizer;
    protected Map<DeterminizedState<LETTER, STATE>, STATE> mDet2res = new HashMap<DeterminizedState<LETTER, STATE>, STATE>();
    protected final Map<STATE, DeterminizedState<LETTER, STATE>> mRes2det = new HashMap<STATE, DeterminizedState<LETTER, STATE>>();

    public DeterminizeDD(AutomataLibraryServices automataLibraryServices, IDeterminizeStateFactory<STATE> iDeterminizeStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iDeterminizeStateFactory, iNwaOutgoingLetterAndTransitionProvider, new PowersetDeterminizer<LETTER, STATE>(iNwaOutgoingLetterAndTransitionProvider, true, iDeterminizeStateFactory));
    }

    public DeterminizeDD(AutomataLibraryServices automataLibraryServices, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IStateDeterminizer<LETTER, STATE> iStateDeterminizer) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mStateDeterminizer = iStateDeterminizer;
        this.mTraversedNwa = new NestedWordAutomaton(this.mServices, iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet(), iEmptyStackStateFactory);
        this.mRemoveDeadEnds = false;
        this.traverseDoubleDeckerGraph();
        assert (new IsDeterministic(this.mServices, this.mTraversedNwa).getResult().booleanValue());
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.debug((Object)this.exitMessage());
        }
    }

    @Override
    public final String startMessage() {
        return "Start " + this.getOperationName() + ". Operand " + this.mOperand.sizeInformation();
    }

    @Override
    public final String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mTraversedNwa.sizeInformation();
    }

    @Override
    protected Collection<STATE> getInitialStates() {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        DeterminizedState<LETTER, STATE> determinizedState = this.mStateDeterminizer.initialState();
        STATE STATE = this.mStateDeterminizer.getState(determinizedState);
        ((NestedWordAutomaton)this.mTraversedNwa).addState(true, determinizedState.containsFinal(), STATE);
        this.mDet2res.put(determinizedState, STATE);
        this.mRes2det.put(STATE, determinizedState);
        arrayList.add(STATE);
        return arrayList;
    }

    @Override
    protected Collection<STATE> buildInternalSuccessors(DoubleDecker<STATE> doubleDecker) {
        LinkedList<STATE> linkedList = new LinkedList<STATE>();
        STATE STATE = doubleDecker.getUp();
        DeterminizedState<LETTER, STATE> determinizedState = this.mRes2det.get(STATE);
        for (Object LETTER : this.mOperand.getVpAlphabet().getInternalAlphabet()) {
            DeterminizedState<LETTER, STATE> determinizedState2 = this.mStateDeterminizer.internalSuccessor(determinizedState, LETTER);
            STATE STATE2 = this.getResState(determinizedState2);
            ((NestedWordAutomaton)this.mTraversedNwa).addInternalTransition(STATE, LETTER, STATE2);
            linkedList.add(STATE2);
        }
        return linkedList;
    }

    @Override
    protected Collection<STATE> buildCallSuccessors(DoubleDecker<STATE> doubleDecker) {
        LinkedList<STATE> linkedList = new LinkedList<STATE>();
        STATE STATE = doubleDecker.getUp();
        DeterminizedState<LETTER, STATE> determinizedState = this.mRes2det.get(STATE);
        for (Object LETTER : this.mOperand.getVpAlphabet().getCallAlphabet()) {
            DeterminizedState<LETTER, STATE> determinizedState2 = this.mStateDeterminizer.callSuccessor(determinizedState, LETTER);
            STATE STATE2 = this.getResState(determinizedState2);
            ((NestedWordAutomaton)this.mTraversedNwa).addCallTransition(STATE, LETTER, STATE2);
            linkedList.add(STATE2);
        }
        return linkedList;
    }

    @Override
    protected Collection<STATE> buildReturnSuccessors(DoubleDecker<STATE> doubleDecker) {
        LinkedList<STATE> linkedList = new LinkedList<STATE>();
        STATE STATE = doubleDecker.getDown();
        if (STATE == this.mTraversedNwa.getEmptyStackState()) {
            return linkedList;
        }
        STATE STATE2 = doubleDecker.getUp();
        DeterminizedState<LETTER, STATE> determinizedState = this.mRes2det.get(STATE);
        DeterminizedState<LETTER, STATE> determinizedState2 = this.mRes2det.get(STATE2);
        for (Object LETTER : this.mOperand.getVpAlphabet().getReturnAlphabet()) {
            DeterminizedState<LETTER, STATE> determinizedState3 = this.mStateDeterminizer.returnSuccessor(determinizedState2, determinizedState, LETTER);
            STATE STATE3 = this.getResState(determinizedState3);
            ((NestedWordAutomaton)this.mTraversedNwa).addReturnTransition(STATE2, STATE, LETTER, STATE3);
            linkedList.add(STATE3);
        }
        return linkedList;
    }

    protected STATE getResState(DeterminizedState<LETTER, STATE> determinizedState) {
        if (this.mDet2res.containsKey(determinizedState)) {
            return this.mDet2res.get(determinizedState);
        }
        STATE STATE = this.mStateDeterminizer.getState(determinizedState);
        ((NestedWordAutomaton)this.mTraversedNwa).addState(false, determinizedState.containsFinal(), STATE);
        this.mDet2res.put(determinizedState, STATE);
        this.mRes2det.put(STATE, determinizedState);
        return STATE;
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        boolean bl = true;
        if (this.mStateDeterminizer instanceof PowersetDeterminizer) {
            this.mLogger.info((Object)"Testing correctness of determinization");
            IDoubleDeckerAutomaton iDoubleDeckerAutomaton = new RemoveUnreachable<LETTER, STATE>(this.mServices, this.mOperand).getResult();
            Object object = new DeterminizeSadd(this.mServices, iNwaInclusionStateFactory, iDoubleDeckerAutomaton).getResult();
            bl &= new IsEquivalent(this.mServices, iNwaInclusionStateFactory, object, this.mTraversedNwa).getResult().booleanValue();
            this.mLogger.info((Object)"Finished testing correctness of determinization");
        }
        return bl;
    }
}

