/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Analyze;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CountingMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.TransitionType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.DuplicatorNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.INwaGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Supplier;

public final class NwaSimulationUtil {
    private NwaSimulationUtil() {
    }

    public static <LETTER, STATE> boolean areNwaSimulationResultsCorrect(AGameGraph<LETTER, STATE> aGameGraph, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, SimulationOrMinimizationType simulationOrMinimizationType, BiPredicate<STATE, STATE> biPredicate, ILogger iLogger) {
        Object object;
        Object object2;
        if (iLogger.isInfoEnabled()) {
            iLogger.info((Object)"Starting checking correctness of simulation results.");
        }
        HashRelation hashRelation = new HashRelation();
        for (SpoilerVertex object3 : aGameGraph.getSpoilerVertices()) {
            if (!(object3 instanceof SpoilerNwaVertex)) continue;
            object2 = object3.getQ0();
            object = object3.getQ1();
            if (object2 == null || object == null) continue;
            boolean bl = simulationOrMinimizationType == SimulationOrMinimizationType.DELAYED ? (object3.isB() ? iNwaOutgoingLetterAndTransitionProvider.isFinal(object2) && !iNwaOutgoingLetterAndTransitionProvider.isFinal(object) : !iNwaOutgoingLetterAndTransitionProvider.isFinal(object2) || iNwaOutgoingLetterAndTransitionProvider.isFinal(object)) : true;
            if (!bl || object3.getPM(null, aGameGraph.getGlobalInfinity()) >= aGameGraph.getGlobalInfinity()) continue;
            hashRelation.addPair(object3.getQ0(), object3.getQ1());
        }
        for (Map.Entry entry : hashRelation.getSetOfPairs()) {
            object2 = entry.getKey();
            if (!biPredicate.test(object2, object = entry.getValue())) continue;
            if (!NwaSimulationUtil.findSuccessorSimulationWitness(iLogger, hashRelation, object2, object, biPredicate, () -> iNwaOutgoingLetterAndTransitionProvider.internalSuccessors(object2), iNwaOutgoingLetterAndTransitionProvider::internalSuccessors)) {
                return false;
            }
            if (NwaSimulationUtil.findSuccessorSimulationWitness(iLogger, hashRelation, object2, object, biPredicate, () -> iNwaOutgoingLetterAndTransitionProvider.callSuccessors(object2), iNwaOutgoingLetterAndTransitionProvider::callSuccessors)) continue;
            return false;
        }
        if (iLogger.isInfoEnabled()) {
            iLogger.info((Object)"Finished checking correctness of simulation results, they are correct.");
        }
        return true;
    }

    private static <LETTER, STATE> boolean findSuccessorSimulationWitness(ILogger iLogger, HashRelation<STATE, STATE> hashRelation, STATE STATE, STATE STATE2, BiPredicate<STATE, STATE> biPredicate, Supplier<Iterable<? extends IOutgoingTransitionlet<LETTER, STATE>>> supplier, BiFunction<STATE, LETTER, Iterable<? extends IOutgoingTransitionlet<LETTER, STATE>>> biFunction) {
        for (IOutgoingTransitionlet<LETTER, STATE> iOutgoingTransitionlet : supplier.get()) {
            STATE STATE3 = iOutgoingTransitionlet.getSucc();
            Object LETTER = iOutgoingTransitionlet.getLetter();
            Set set = hashRelation.getImage(STATE3);
            boolean bl = false;
            for (IOutgoingTransitionlet<LETTER, STATE> iOutgoingTransitionlet2 : biFunction.apply(STATE2, LETTER)) {
                STATE STATE4 = iOutgoingTransitionlet2.getSucc();
                if (set.contains(STATE4)) {
                    bl = true;
                    break;
                }
                if (biPredicate.test(STATE3, STATE4)) continue;
                return true;
            }
            if (bl) continue;
            if (iLogger.isDebugEnabled()) {
                iLogger.debug((Object)("Supposedly " + String.valueOf(STATE2) + " simulates " + String.valueOf(STATE) + ". But there is no matching partner for " + String.valueOf(iOutgoingTransitionlet)));
            }
            return false;
        }
        return true;
    }

    public static <LETTER, STATE> void doInnerNwaSimulation(AGameGraph<LETTER, STATE> aGameGraph, ILogger iLogger, IProgressAwareTimer iProgressAwareTimer) throws AutomataOperationCanceledException {
        if (iLogger.isDebugEnabled()) {
            iLogger.debug((Object)"Starting innerSimulation.");
        }
        if (!(aGameGraph instanceof INwaGameGraph)) {
            throw new IllegalArgumentException("The given gameGraph must be an instance of INwaGameGraph.");
        }
        ((INwaGameGraph)((Object)aGameGraph)).undoRemovedReturnBridgesChanges();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n = aGameGraph.getGlobalInfinity();
        Set<SpoilerVertex<LETTER, STATE>> set = aGameGraph.getSpoilerVertices();
        if (set != null) {
            for (SpoilerVertex spoilerVertex : aGameGraph.getSpoilerVertices()) {
                if (spoilerVertex.getPM(null, n) >= n) {
                    linkedList.add(spoilerVertex);
                }
                if (iProgressAwareTimer == null || iProgressAwareTimer.continueProcessing()) continue;
                iLogger.debug((Object)"Stopped in doInnerNwaSimulation/collecting non simulating vertices");
                throw new AutomataOperationCanceledException(NwaSimulationUtil.class);
            }
        }
        while (!linkedList.isEmpty()) {
            SpoilerVertex spoilerVertex;
            spoilerVertex = (SpoilerVertex)linkedList.poll();
            if (!aGameGraph.hasPredecessors(spoilerVertex)) continue;
            for (Vertex<LETTER, STATE> vertex : aGameGraph.getPredecessors(spoilerVertex)) {
                DuplicatorNwaVertex duplicatorNwaVertex;
                if (vertex.getPM(null, n) >= n || vertex instanceof DuplicatorNwaVertex && (duplicatorNwaVertex = (DuplicatorNwaVertex)vertex).getTransitionType() == TransitionType.CALL) continue;
                boolean bl = true;
                if (vertex instanceof DuplicatorVertex) {
                    boolean bl2 = false;
                    if (aGameGraph.hasSuccessors(vertex)) {
                        for (Vertex vertex2 : aGameGraph.getSuccessors(vertex)) {
                            if (vertex2.getPM(null, n) >= n) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    boolean bl3 = bl = !bl2;
                }
                if (bl) {
                    vertex.setPM(n);
                    linkedList.add(vertex);
                    if (iLogger.isDebugEnabled()) {
                        iLogger.debug((Object)("\tImposed infinity for: " + String.valueOf(vertex)));
                    }
                }
                if (iProgressAwareTimer == null || iProgressAwareTimer.continueProcessing()) continue;
                iLogger.debug((Object)"Stopped in doInnerNwaSimulation/processing predecessors");
                throw new AutomataOperationCanceledException(NwaSimulationUtil.class);
            }
        }
    }

    public static <LETTER, STATE> void retrieveGeneralNwaAutomataPerformance(SimulationPerformance simulationPerformance, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton2, AutomataLibraryServices automataLibraryServices) {
        Analyze<LETTER, STATE> analyze = new Analyze<LETTER, STATE>(automataLibraryServices, iNestedWordAutomaton, true);
        simulationPerformance.setCountingMeasure(CountingMeasure.BUCHI_ALPHABET_SIZE_INTERNAL, analyze.getNumberOfSymbols(Analyze.SymbolType.INTERNAL));
        simulationPerformance.setCountingMeasure(CountingMeasure.BUCHI_ALPHABET_SIZE_CALL, analyze.getNumberOfSymbols(Analyze.SymbolType.CALL));
        simulationPerformance.setCountingMeasure(CountingMeasure.BUCHI_ALPHABET_SIZE_RETURN, analyze.getNumberOfSymbols(Analyze.SymbolType.RETURN));
        simulationPerformance.setCountingMeasure(CountingMeasure.BUCHI_TRANSITIONS_INTERNAL, analyze.getNumberOfTransitions(Analyze.SymbolType.INTERNAL));
        simulationPerformance.setCountingMeasure(CountingMeasure.BUCHI_TRANSITIONS_CALL, analyze.getNumberOfTransitions(Analyze.SymbolType.CALL));
        simulationPerformance.setCountingMeasure(CountingMeasure.BUCHI_TRANSITIONS_RETURN, analyze.getNumberOfTransitions(Analyze.SymbolType.RETURN));
        simulationPerformance.setCountingMeasure(CountingMeasure.BUCHI_TRANSITION_INTERNAL_DENSITY_MILLION, (int)Math.round(analyze.getTransitionDensity(Analyze.SymbolType.INTERNAL) * 1000000.0));
        simulationPerformance.setCountingMeasure(CountingMeasure.BUCHI_TRANSITION_CALL_DENSITY_MILLION, (int)Math.round(analyze.getTransitionDensity(Analyze.SymbolType.CALL) * 1000000.0));
        simulationPerformance.setCountingMeasure(CountingMeasure.BUCHI_TRANSITION_RETURN_DENSITY_MILLION, (int)Math.round(analyze.getTransitionDensity(Analyze.SymbolType.RETURN) * 1000000.0));
        Analyze<LETTER, STATE> analyze2 = new Analyze<LETTER, STATE>(automataLibraryServices, iNestedWordAutomaton2, true);
        simulationPerformance.setCountingMeasure(CountingMeasure.RESULT_ALPHABET_SIZE_INTERNAL, analyze2.getNumberOfSymbols(Analyze.SymbolType.INTERNAL));
        simulationPerformance.setCountingMeasure(CountingMeasure.RESULT_ALPHABET_SIZE_CALL, analyze2.getNumberOfSymbols(Analyze.SymbolType.CALL));
        simulationPerformance.setCountingMeasure(CountingMeasure.RESULT_ALPHABET_SIZE_RETURN, analyze2.getNumberOfSymbols(Analyze.SymbolType.RETURN));
        simulationPerformance.setCountingMeasure(CountingMeasure.RESULT_TRANSITIONS_INTERNAL, analyze2.getNumberOfTransitions(Analyze.SymbolType.INTERNAL));
        simulationPerformance.setCountingMeasure(CountingMeasure.RESULT_TRANSITIONS_CALL, analyze2.getNumberOfTransitions(Analyze.SymbolType.CALL));
        simulationPerformance.setCountingMeasure(CountingMeasure.RESULT_TRANSITIONS_RETURN, analyze2.getNumberOfTransitions(Analyze.SymbolType.RETURN));
        simulationPerformance.setCountingMeasure(CountingMeasure.RESULT_TRANSITION_INTERNAL_DENSITY_MILLION, (int)Math.round(analyze2.getTransitionDensity(Analyze.SymbolType.INTERNAL) * 1000000.0));
        simulationPerformance.setCountingMeasure(CountingMeasure.RESULT_TRANSITION_CALL_DENSITY_MILLION, (int)Math.round(analyze2.getTransitionDensity(Analyze.SymbolType.CALL) * 1000000.0));
        simulationPerformance.setCountingMeasure(CountingMeasure.RESULT_TRANSITION_RETURN_DENSITY_MILLION, (int)Math.round(analyze2.getTransitionDensity(Analyze.SymbolType.RETURN) * 1000000.0));
    }

    public static class BinaryRelationPredicateFromPartition<STATE>
    implements BiPredicate<STATE, STATE> {
        private final Map<STATE, Set<STATE>> mState2states = new HashMap<STATE, Set<STATE>>();

        public BinaryRelationPredicateFromPartition(Iterable<Set<STATE>> iterable) {
            for (Set<STATE> set : iterable) {
                for (STATE STATE : set) {
                    this.mState2states.put(STATE, set);
                }
            }
        }

        @Override
        public boolean test(STATE STATE, STATE STATE2) {
            return this.mState2states.get(STATE) == this.mState2states.get(STATE2);
        }
    }
}

