/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.rabin;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IRabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

public class Accepts<LETTER, STATE, CRSF extends IStateFactory<STATE>>
extends GeneralOperation<LETTER, STATE, CRSF> {
    private final boolean mResult;

    public Accepts(AutomataLibraryServices automataLibraryServices, IRabinAutomaton<LETTER, STATE> iRabinAutomaton, NestedLassoWord<LETTER> nestedLassoWord) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        if (!nestedLassoWord.getStem().hasEmptyNestingRelation() || !nestedLassoWord.getLoop().hasEmptyNestingRelation()) {
            throw new AssertionError((Object)"Rabin automata cannot handle calls/returns.");
        }
        this.mResult = this.computeResult(iRabinAutomaton, nestedLassoWord.getStem().asList(), nestedLassoWord.getLoop().asList());
    }

    public Accepts(AutomataLibraryServices automataLibraryServices, IRabinAutomaton<LETTER, STATE> iRabinAutomaton, List<LETTER> list, List<LETTER> list2) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mResult = this.computeResult(iRabinAutomaton, list, list2);
    }

    private boolean computeResult(IRabinAutomaton<LETTER, STATE> iRabinAutomaton, List<LETTER> list, List<LETTER> list2) throws AutomataOperationCanceledException {
        ArrayList<STATE> arrayList = this.stemEvaluation(iRabinAutomaton, list);
        int n = 0;
        HashSet<Pair> hashSet = new HashSet<Pair>();
        HashSet<Pair> hashSet2 = new HashSet<Pair>();
        arrayList.forEach((Consumer<STATE>)((Consumer<Object>)object -> {
            boolean bl = hashSet.add(new Pair((Object)0, object));
        }));
        do {
            if (this.isCancellationRequested()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            if (arrayList.isEmpty()) {
                return false;
            }
            ArrayList<STATE> arrayList2 = new ArrayList<STATE>();
            for (STATE STATE : arrayList) {
                if (iRabinAutomaton.isAccepting(STATE) && !iRabinAutomaton.isFinite(STATE) && !hashSet2.contains(new Pair((Object)n, STATE)) && this.hasLoop(iRabinAutomaton, STATE, list2, n)) {
                    return true;
                }
                hashSet2.add(new Pair((Object)n, STATE));
                for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iRabinAutomaton.getSuccessors(STATE, list2.get(n))) {
                    STATE STATE2 = outgoingInternalTransition.getSucc();
                    if (hashSet2.contains(new Pair((Object)((n + 1) % list2.size()), STATE2))) continue;
                    arrayList2.add(STATE2);
                }
            }
            arrayList.clear();
            arrayList.addAll(arrayList2);
            n = (n + 1) % list2.size();
            for (STATE STATE : arrayList) {
                hashSet.add(new Pair((Object)n, STATE));
            }
        } while (!hashSet.equals(hashSet2));
        return false;
    }

    private ArrayList<STATE> stemEvaluation(IRabinAutomaton<LETTER, STATE> iRabinAutomaton, List<LETTER> list) {
        ArrayList<STATE> arrayList = new ArrayList<STATE>(iRabinAutomaton.getInitialStates());
        for (LETTER LETTER : list) {
            if (arrayList.isEmpty()) break;
            ArrayList<STATE> arrayList2 = new ArrayList<STATE>();
            for (STATE STATE : arrayList) {
                for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iRabinAutomaton.getSuccessors(STATE, LETTER)) {
                    arrayList2.add(outgoingInternalTransition.getSucc());
                }
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    private boolean hasLoop(IRabinAutomaton<LETTER, STATE> iRabinAutomaton, STATE STATE, List<LETTER> list, int n) throws AutomataOperationCanceledException {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        int n2 = n;
        HashSet<Pair> hashSet = new HashSet<Pair>();
        HashSet<Pair> hashSet2 = new HashSet<Pair>();
        arrayList.add(STATE);
        hashSet.add(new Pair((Object)n, STATE));
        do {
            if (this.isCancellationRequested()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            if (arrayList.isEmpty()) {
                return false;
            }
            ArrayList<STATE> arrayList2 = new ArrayList<STATE>();
            for (Object e : arrayList) {
                for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iRabinAutomaton.getSuccessors(e, list.get(n2))) {
                    STATE STATE2 = outgoingInternalTransition.getSucc();
                    if (iRabinAutomaton.isFinite(STATE2)) continue;
                    if (n == (n2 + 1) % list.size() && STATE2.equals(STATE)) {
                        return true;
                    }
                    if (hashSet2.contains(new Pair((Object)((n2 + 1) % list.size()), STATE2))) continue;
                    arrayList2.add(STATE2);
                }
                hashSet2.add(new Pair((Object)n2, e));
            }
            arrayList = arrayList2;
            n2 = (n2 + 1) % list.size();
            for (Object e : arrayList) {
                hashSet.add(new Pair((Object)n2, e));
            }
        } while (!hashSet.equals(hashSet2));
        return false;
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }
}

