/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter;

import de.uni_freiburg.informatik.ultimate.core.lib.results.ExternalWitnessValidationResult;
import de.uni_freiburg.informatik.ultimate.core.lib.util.MonitoredProcess;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.witnessprinter.Activator;
import de.uni_freiburg.informatik.ultimate.witnessprinter.WitnessPrinter;
import de.uni_freiburg.informatik.ultimate.witnessprinter.preferences.PreferenceInitializer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class WitnessManager {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;

    public WitnessManager(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
    }

    public void run(Collection<WitnessPrinter.ResultWitness> collection) throws IOException, InterruptedException {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        HashMap<CallSite, Integer> hashMap = new HashMap<CallSite, Integer>();
        for (WitnessPrinter.ResultWitness resultWitness : collection) {
            String string;
            IResult iResult = resultWitness.getResult();
            String string2 = resultWitness.getSourceFile();
            String string3 = resultWitness.getWitnessString();
            String string4 = resultWitness.getWitnessEnding();
            String string5 = iPreferenceProvider.getString("Witness directory");
            String string6 = iPreferenceProvider.getString("Witness filename") + string4;
            boolean bl = iPreferenceProvider.getBoolean("Write witness besides input file");
            Integer n = (Integer)hashMap.get(string6);
            if (n == null) {
                string = null;
                hashMap.put((CallSite)((Object)string6), 1);
            } else {
                string = n.toString();
                hashMap.put((CallSite)((Object)string6), n + 1);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string7 = null;
            if (string3 != null) {
                string7 = bl ? this.createWitnessFilenameWriteBeside(string2, string, string4) : this.createWitnessFilename(string5, string6, string);
                this.writeWitness(string3, string7);
                arrayList.add(string7);
            }
            if (iPreferenceProvider.getBoolean("Verify the witness and generate results")) {
                if (string3 == null) {
                    this.reportWitnessResult(null, iResult, ExternalWitnessValidationResult.WitnessVerificationStatus.INTERNAL_ERROR, ExternalWitnessValidationResult.WitnessVerificationStatus.VERIFIED);
                } else {
                    this.checkWitness(string7, iResult, string2, string3);
                }
            } else if (iPreferenceProvider.getBoolean("Log witness to console")) {
                this.reportWitnessResult(string3, iResult, ExternalWitnessValidationResult.WitnessVerificationStatus.UNVERIFIED, ExternalWitnessValidationResult.WitnessVerificationStatus.UNVERIFIED);
            }
            if (!iPreferenceProvider.getBoolean("Delete the .graphml file after verification")) continue;
            for (String string8 : arrayList) {
                this.deleteFile(string8);
            }
        }
    }

    private void deleteFile(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.delete()) {
            this.mLogger.warn((Object)("File " + string + " could not be deleted"));
        }
    }

    private void writeWitness(String string, String string2) {
        try {
            File file = CoreUtil.writeFile((String)string2, (String)string);
            this.mLogger.info((Object)("Wrote witness to " + file.getCanonicalFile().getAbsolutePath()));
        }
        catch (IOException iOException) {
            this.mLogger.fatal((Object)"Something went wrong during writing of a witness", (Throwable)iOException);
        }
    }

    private String createWitnessFilenameWriteBeside(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        File file = new File(string);
        return this.createWitnessFilename(file.getParent(), stringBuilder.append(file.getName()).append("-").append("witness").append(string3).toString(), string2);
    }

    private String createWitnessFilename(String string, String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("You did not specify a filename for the witness");
        }
        if (string == null) {
            throw new IllegalArgumentException("You did not specify a directory for the witness");
        }
        File file = new File(string2);
        File file2 = new File(string);
        if (string3 == null) {
            return Paths.get(file2.getAbsolutePath(), file.getName()).toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        return Paths.get(file2.getAbsolutePath(), stringBuilder.append(string3).append("-").append(file.getName()).toString()).toString();
    }

    private void reportWitnessResult(String string, IResult iResult, ExternalWitnessValidationResult.WitnessVerificationStatus witnessVerificationStatus, ExternalWitnessValidationResult.WitnessVerificationStatus witnessVerificationStatus2) {
        this.mServices.getResultService().reportResult(iResult.getPlugin(), (IResult)new ExternalWitnessValidationResult(Activator.PLUGIN_ID, iResult, string, witnessVerificationStatus, witnessVerificationStatus2));
    }

    private boolean checkWitness(String string, IResult iResult, String string2, String string3) throws IOException, InterruptedException {
        this.mLogger.info((Object)("Verifying witness for CEX: " + iResult.getShortDescription()));
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        PreferenceInitializer.WitnessVerifierType witnessVerifierType = (PreferenceInitializer.WitnessVerifierType)iPreferenceProvider.getEnum("Use the following witness verifier", PreferenceInitializer.WitnessVerifierType.class);
        String string4 = iPreferenceProvider.getString("Command to execute witness verifier");
        switch (witnessVerifierType) {
            case CPACHECKER: {
                return this.checkWitnessWithCPAChecker(string, iResult, string2, string4, string3);
            }
        }
        throw new UnsupportedOperationException("Witness verifier " + String.valueOf((Object)witnessVerifierType) + " unknown");
    }

    private boolean checkWitnessWithCPAChecker(String string, IResult iResult, String string2, String string3, String string4) throws IOException, InterruptedException {
        String string5 = System.getenv().get("CPACHECKER_HOME");
        if (string5 == null) {
            this.mLogger.error((Object)"CPACHECKER_HOME not set, cannot use CPACHECKER as witness verifier");
            this.reportWitnessResult(string4, iResult, ExternalWitnessValidationResult.WitnessVerificationStatus.INTERNAL_ERROR, ExternalWitnessValidationResult.WitnessVerificationStatus.VERIFIED);
            return false;
        }
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        int n = iPreferenceProvider.getInt("Timeout in seconds for witness verifier");
        Object[] objectArray = WitnessManager.makeCPACheckerCommand(string3, string, iPreferenceProvider.getString("Path to .prp file"), string2, string5, n);
        ++n;
        this.mLogger.info((Object)StringUtils.join((Object[])objectArray, (String)" "));
        MonitoredProcess monitoredProcess = MonitoredProcess.exec((String[])objectArray, (String)string5, null, (IUltimateServiceProvider)this.mServices);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(monitoredProcess.getErrorStream());
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(monitoredProcess.getInputStream());
        String string6 = WitnessManager.convertStreamToString(bufferedInputStream);
        String string7 = WitnessManager.convertStreamToString(bufferedInputStream2);
        this.mLogger.info((Object)("Waiting for " + n + "s for CPA Checker..."));
        MonitoredProcess.MonitoredProcessState monitoredProcessState = monitoredProcess.impatientWaitUntilTime((long)n * 1000L);
        this.mLogger.info((Object)("Return code was " + monitoredProcessState.getReturnCode()));
        if (WitnessManager.checkOutputForSuccess(string7)) {
            this.mLogger.info((Object)"Witness for CEX was verified successfully");
            this.reportWitnessResult(string4, iResult, ExternalWitnessValidationResult.WitnessVerificationStatus.VERIFIED, ExternalWitnessValidationResult.WitnessVerificationStatus.VERIFIED);
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder().append("Witness for CEX did not verify");
        if (monitoredProcessState.isKilled()) {
            stringBuilder.append(" due to timeout of ").append(n).append("s");
        }
        stringBuilder.append("! CPAChecker said:").append(CoreUtil.getPlatformLineSeparator()).append("STDERR:").append(CoreUtil.getPlatformLineSeparator()).append(string6).append(CoreUtil.getPlatformLineSeparator()).append("STDOUT:").append(CoreUtil.getPlatformLineSeparator()).append(string7);
        this.mLogger.error((Object)stringBuilder.toString());
        this.reportWitnessResult(string4, iResult, ExternalWitnessValidationResult.WitnessVerificationStatus.VERIFICATION_FAILED, ExternalWitnessValidationResult.WitnessVerificationStatus.VERIFIED);
        return false;
    }

    private static boolean checkOutputForSuccess(String string) {
        String[] stringArray = string.split(CoreUtil.getPlatformLineSeparator());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string2.startsWith("Verification result: FALSE.")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String[] makeCPACheckerCommand(String string, String string2, String string3, String string4, String string5, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split(" ");
        File file = new File(string5 + File.separator + stringArray[0]);
        arrayList.add(file.getAbsolutePath());
        int n2 = 1;
        while (n2 < stringArray.length) {
            arrayList.add(stringArray[n2]);
            ++n2;
        }
        arrayList.add("-timelimit");
        arrayList.add(String.valueOf(n));
        arrayList.add("-spec");
        arrayList.add(WitnessManager.escape(string2));
        arrayList.add("-spec");
        arrayList.add(WitnessManager.escape(string3));
        arrayList.add(WitnessManager.escape(string4));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String escape(String string) {
        return string;
    }

    private static String convertStreamToString(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append(CoreUtil.getPlatformLineSeparator());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return stringBuilder.toString();
    }
}

