/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.BaseMemoryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.HeapDataArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.RequiredMemoryModelFeatures;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemoryModel_MultiBitprecise
extends BaseMemoryModel {
    private final Map<Integer, HeapDataArray> mSize2HeapIntegerArray = new HashMap<Integer, HeapDataArray>();
    private final Map<Integer, HeapDataArray> mSize2HeapFloatingArray = new HashMap<Integer, HeapDataArray>();

    public MemoryModel_MultiBitprecise(TypeSizes typeSizes, ITypeHandler iTypeHandler, ExpressionTranslation expressionTranslation) {
        super(typeSizes, iTypeHandler, expressionTranslation);
    }

    @Override
    public HeapDataArray getDataHeapArray(CPrimitive.CPrimitives cPrimitives) {
        switch (cPrimitives.getPrimitiveCategory()) {
            case FLOATTYPE: {
                return this.getDataHeapArrayForGivenGeneralType(cPrimitives, this.mSize2HeapFloatingArray);
            }
            case INTTYPE: {
                return this.getDataHeapArrayForGivenGeneralType(cPrimitives, this.mSize2HeapIntegerArray);
            }
            case VOID: {
                throw new AssertionError((Object)"void on the heap???");
            }
        }
        throw new AssertionError((Object)"unknown primitive category");
    }

    private HeapDataArray getDataHeapArrayForGivenGeneralType(CPrimitive.CPrimitives cPrimitives, Map<Integer, HeapDataArray> map) {
        int n = this.mTypeSizes.getSize(cPrimitives);
        HeapDataArray heapDataArray = map.get(n);
        if (heapDataArray == null) {
            String string = cPrimitives.getPrimitiveCategory().toString() + n;
            CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
            ASTType aSTType = this.mTypeHandler.cType2AstType(cACSLLocation, new CPrimitive(cPrimitives));
            BoogieType boogieType = this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType);
            heapDataArray = new HeapDataArray(string, aSTType, boogieType, this.mTypeHandler.getBoogiePointerType(), n);
            map.put(n, heapDataArray);
        }
        return heapDataArray;
    }

    @Override
    public String getProcedureSuffix(CPrimitive.CPrimitives cPrimitives) {
        return this.getDataHeapArray(cPrimitives).getName();
    }

    @Override
    public List<BaseMemoryModel.ReadWriteDefinition> getReadWriteDefinitionForNonPointerHeapDataArray(HeapDataArray heapDataArray, RequiredMemoryModelFeatures requiredMemoryModelFeatures) {
        HashRelation hashRelation = new HashRelation();
        for (CPrimitive.CPrimitives arrayList2 : requiredMemoryModelFeatures.getDataOnHeapRequired()) {
            int n = this.mTypeSizes.getSize(arrayList2);
            if (this.getDataHeapArray(arrayList2) != heapDataArray) continue;
            hashRelation.addPair((Object)n, (Object)arrayList2);
        }
        ArrayList<BaseMemoryModel.ReadWriteDefinition> arrayList = new ArrayList<BaseMemoryModel.ReadWriteDefinition>();
        for (Object object : hashRelation.getDomain()) {
            Set set = hashRelation.getImage(object);
            CPrimitive.CPrimitives cPrimitives = (CPrimitive.CPrimitives)((Object)set.iterator().next());
            String string = this.getProcedureSuffix(cPrimitives);
            ASTType aSTType = this.mTypeHandler.cType2AstType(LocationFactory.createIgnoreCLocation(), new CPrimitive(cPrimitives));
            boolean bl = DataStructureUtils.haveNonEmptyIntersection(requiredMemoryModelFeatures.getUncheckedWriteRequired(), (Set)set);
            boolean bl2 = DataStructureUtils.haveNonEmptyIntersection(requiredMemoryModelFeatures.getInitWriteRequired(), (Set)set);
            arrayList.add(new BaseMemoryModel.ReadWriteDefinition(string, (Integer)object, aSTType, new CPrimitive(cPrimitives), bl, bl2));
        }
        return arrayList;
    }

    @Override
    protected int bytesizeOfStoredPointerComponents() {
        return this.mTypeSizes.getSizeOfPointer();
    }
}

