/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CompatibleTypes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.DataRaceChecker;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.StructHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizeAndOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CNamed;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValueFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ResultWithSideEffects;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.StringLiteralResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;

public class ExpressionResultTransformer {
    private final CHandler mCHandler;
    private final MemoryHandler mMemoryHandler;
    private final StructHandler mStructHandler;
    private final ExpressionTranslation mExprTrans;
    private final TypeSizes mTypeSizes;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final ITypeHandler mTypeHandler;
    private final TypeSizeAndOffsetComputer mTypeSizeAndOffsetComputer;
    private final DataRaceChecker mDataRaceChecker;

    public ExpressionResultTransformer(CHandler cHandler, MemoryHandler memoryHandler, StructHandler structHandler, ExpressionTranslation expressionTranslation, TypeSizes typeSizes, AuxVarInfoBuilder auxVarInfoBuilder, ITypeHandler iTypeHandler, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer, DataRaceChecker dataRaceChecker) {
        this.mCHandler = cHandler;
        this.mMemoryHandler = memoryHandler;
        this.mStructHandler = structHandler;
        this.mExprTrans = expressionTranslation;
        this.mTypeSizes = typeSizes;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mTypeHandler = iTypeHandler;
        this.mTypeSizeAndOffsetComputer = typeSizeAndOffsetComputer;
        this.mDataRaceChecker = dataRaceChecker;
    }

    private ExpressionResult transform(ExpressionResult expressionResult, ICType iCType, ILocation iLocation, IASTNode iASTNode, Transformation ... transformationArray) {
        if (transformationArray == null || transformationArray.length == 0) {
            return expressionResult;
        }
        ExpressionResult expressionResult2 = expressionResult;
        Transformation[] transformationArray2 = transformationArray;
        int n = transformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Transformation transformation = transformationArray2[n2];
            if (transformation == null) {
                throw new IllegalArgumentException("transformation cannot be null");
            }
            expressionResult2 = transformation.mFun.apply(this, expressionResult2, iCType, iLocation, iASTNode);
            ++n2;
        }
        return expressionResult2;
    }

    public ExpressionResult transformDispatchDecaySwitchRexBoolToInt(IDispatcher iDispatcher, ILocation iLocation, IASTInitializerClause iASTInitializerClause) {
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClause);
        return this.transform(expressionResult, null, iLocation, (IASTNode)iASTInitializerClause, Transformation.DECAY_ARRAY_TO_POINTER, Transformation.SWITCH_TO_RVALUE, Transformation.REX_BOOL_TO_INT);
    }

    public ExpressionResult transformDispatchDecaySwitchImplicitConversion(IDispatcher iDispatcher, ILocation iLocation, IASTInitializerClause iASTInitializerClause, ICType iCType) {
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClause);
        return this.transform(expressionResult, iCType, iLocation, (IASTNode)iASTInitializerClause, Transformation.DECAY_ARRAY_TO_POINTER, Transformation.SWITCH_TO_RVALUE, Transformation.IMPLICIT_CONVERSION);
    }

    public ExpressionResult transformDispatchSwitchRexBoolToInt(IDispatcher iDispatcher, ILocation iLocation, IASTInitializerClause iASTInitializerClause) {
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClause);
        return this.transform(expressionResult, null, iLocation, (IASTNode)iASTInitializerClause, Transformation.SWITCH_TO_RVALUE, Transformation.REX_BOOL_TO_INT);
    }

    public ExpressionResult transformDecaySwitchRexBoolToInt(ExpressionResult expressionResult, ILocation iLocation, IASTNode iASTNode) {
        return this.transform(expressionResult, null, iLocation, iASTNode, Transformation.DECAY_ARRAY_TO_POINTER, Transformation.SWITCH_TO_RVALUE, Transformation.REX_BOOL_TO_INT);
    }

    public ExpressionResult transformDecaySwitch(ExpressionResult expressionResult, ILocation iLocation, IASTNode iASTNode) {
        return this.transform(expressionResult, null, iLocation, iASTNode, Transformation.DECAY_ARRAY_TO_POINTER, Transformation.SWITCH_TO_RVALUE);
    }

    public ExpressionResult transformSwitchRexBoolToInt(ExpressionResult expressionResult, ILocation iLocation, IASTNode iASTNode) {
        return this.transform(expressionResult, null, iLocation, iASTNode, Transformation.SWITCH_TO_RVALUE, Transformation.REX_BOOL_TO_INT);
    }

    public ExpressionResult transformSwitchRexIntToBool(ExpressionResult expressionResult, ILocation iLocation, IASTNode iASTNode) {
        return this.transform(expressionResult, null, iLocation, iASTNode, Transformation.SWITCH_TO_RVALUE, Transformation.REX_INT_TO_BOOL);
    }

    private ExpressionResult switchToRValue(ExpressionResult expressionResult, ILocation iLocation, IASTNode iASTNode, boolean bl) {
        LRValue lRValue = expressionResult.getLrValue();
        if (lRValue == null) {
            return expressionResult;
        }
        if (lRValue instanceof RValue) {
            return ExpressionResultTransformer.replaceEnumByInt(ExpressionResultTransformer.replaceCFunctionByCPointer(expressionResult));
        }
        if (lRValue instanceof LocalLValue) {
            ICType iCType = lRValue.getCType().getUnderlyingType();
            this.mCHandler.moveArrayAndStructIdsOnHeap(iCType, lRValue.getValue(), iASTNode);
            ICType iCType2 = iCType instanceof CArray ? new CPointer(((CArray)iCType).getValueType()) : (iCType instanceof CFunction ? new CPointer(iCType) : (iCType instanceof CEnum ? new CPrimitive(CPrimitive.CPrimitives.INT) : iCType));
            RValue rValue = new RValue(lRValue.getValue(), iCType2, lRValue.isBoogieBool());
            ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder(expressionResult).setOrResetLrValue(rValue);
            if (this.mDataRaceChecker != null) {
                this.mDataRaceChecker.checkOnRead(expressionResultBuilder, iLocation, lRValue);
            }
            return expressionResultBuilder.build();
        }
        if (lRValue instanceof HeapLValue) {
            RValue rValue;
            HeapLValue heapLValue = (HeapLValue)lRValue;
            ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
            if (iCType instanceof CEnum) {
                iCType = new CPrimitive(CPrimitive.CPrimitives.INT);
            }
            ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult);
            if (iCType instanceof CPrimitive || iCType instanceof CPointer) {
                ExpressionResult expressionResult2 = bl ? this.mMemoryHandler.getReadUnchecked(heapLValue.getAddress(), iCType) : this.mMemoryHandler.getReadCall(heapLValue.getAddress(), iCType);
                rValue = (RValue)expressionResult2.getLrValue();
                expressionResultBuilder.addAllExceptLrValue(expressionResult2);
            } else if (iCType instanceof CArray) {
                CArray cArray = (CArray)iCType;
                rValue = new RValue(heapLValue.getAddress(), new CPointer(cArray.getValueType()), false, false);
            } else {
                if (iCType instanceof CEnum) {
                    throw new AssertionError((Object)"handled above");
                }
                if (iCType instanceof CStructOrUnion) {
                    CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType;
                    ExpressionResult expressionResult3 = this.readStructFromHeap(expressionResult, iLocation, heapLValue.getAddress(), cStructOrUnion, iASTNode, bl);
                    rValue = (RValue)expressionResult3.getLrValue();
                    expressionResultBuilder.addAllExceptLrValue(expressionResult3);
                } else {
                    if (iCType instanceof CNamed) {
                        throw new AssertionError((Object)"This should not be the case as we took the underlying type.");
                    }
                    if (iCType instanceof CFunction) {
                        rValue = new RValue(heapLValue.getAddress(), new CPointer(iCType), false, false);
                    } else {
                        throw new UnsupportedSyntaxException(iLocation, "..");
                    }
                }
            }
            if (this.mDataRaceChecker != null) {
                this.mDataRaceChecker.checkOnRead(expressionResultBuilder, iLocation, lRValue);
            }
            return expressionResultBuilder.setLrValue(rValue).build();
        }
        throw new AssertionError((Object)"an LRValue that is not null, and no LocalLValue, RValue or HeapLValue???");
    }

    public ExpressionResult switchToRValue(ExpressionResult expressionResult, ILocation iLocation, IASTNode iASTNode) {
        return this.switchToRValue(expressionResult, iLocation, iASTNode, false);
    }

    public ExpressionResult switchToRValueUnchecked(ExpressionResult expressionResult, ILocation iLocation, IASTNode iASTNode) {
        return this.switchToRValue(expressionResult, iLocation, iASTNode, true);
    }

    private ExpressionResult readStructFromHeap(ExpressionResult expressionResult, ILocation iLocation, Expression expression, CStructOrUnion cStructOrUnion, IASTNode iASTNode, boolean bl) {
        Object object;
        Expression expression2 = expression;
        Expression expression3 = MemoryHandler.getPointerBaseAddress(expression2, iLocation);
        Expression expression4 = MemoryHandler.getPointerOffset(expression2, iLocation);
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        ArrayList<Declaration> arrayList2 = new ArrayList<Declaration>();
        LinkedHashSet<AuxVarInfo> linkedHashSet = new LinkedHashSet<AuxVarInfo>();
        String[] stringArray = cStructOrUnion.getFieldIds();
        ICType[] iCTypeArray = cStructOrUnion.getFieldTypes();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<Expression> arrayList4 = new ArrayList<Expression>();
        int n = 0;
        while (n < stringArray.length) {
            LRValue lRValue;
            arrayList3.add(stringArray[n]);
            ICType iCType = iCTypeArray[n];
            if (iCType instanceof CNamed) {
                CNamed cNamed = (CNamed)iCType;
                object = cNamed.getUnderlyingType();
            } else {
                object = iCTypeArray[n];
            }
            if (object instanceof CPrimitive) {
                var22_23 = (ExpressionResult)this.mStructHandler.readFieldInTheStructAtAddress(iLocation, n, expression, cStructOrUnion, bl);
                lRValue = ((ExpressionResult)var22_23).getLrValue();
                arrayList.addAll(((ResultWithSideEffects)var22_23).getStatements());
                arrayList2.addAll(((ResultWithSideEffects)var22_23).getDeclarations());
                linkedHashSet.addAll(((ResultWithSideEffects)var22_23).getAuxVars());
            } else if (object instanceof CPointer) {
                var22_23 = (ExpressionResult)this.mStructHandler.readFieldInTheStructAtAddress(iLocation, n, expression, cStructOrUnion, bl);
                lRValue = ((ExpressionResult)var22_23).getLrValue();
                arrayList.addAll(((ResultWithSideEffects)var22_23).getStatements());
                arrayList2.addAll(((ResultWithSideEffects)var22_23).getDeclarations());
                linkedHashSet.addAll(((ResultWithSideEffects)var22_23).getAuxVars());
            } else if (object instanceof CArray) {
                var22_23 = (CArray)object;
                var23_24 = this.mStructHandler.computeStructFieldAddress(iLocation, n, expression, cStructOrUnion);
                var25_26 = var24_25 = this.readArrayFromHeap(expressionResult, iLocation, (Expression)var23_24, (CArray)var22_23, iASTNode, bl);
                lRValue = ((ExpressionResult)var25_26).getLrValue();
                arrayList.addAll(((ResultWithSideEffects)var25_26).getStatements());
                arrayList2.addAll(((ResultWithSideEffects)var25_26).getDeclarations());
                linkedHashSet.addAll(((ResultWithSideEffects)var25_26).getAuxVars());
            } else if (object instanceof CEnum) {
                var23_24 = (ExpressionResult)this.mStructHandler.readFieldInTheStructAtAddress(iLocation, n, expression, cStructOrUnion, bl);
                lRValue = ((ExpressionResult)var23_24).getLrValue();
                arrayList.addAll(((ResultWithSideEffects)var23_24).getStatements());
                arrayList2.addAll(((ResultWithSideEffects)var23_24).getDeclarations());
                linkedHashSet.addAll(((ResultWithSideEffects)var23_24).getAuxVars());
            } else if (object instanceof CStructOrUnion) {
                var23_24 = (CStructOrUnion)object;
                var24_25 = this.mTypeSizeAndOffsetComputer.constructOffsetForField(iLocation, cStructOrUnion, n);
                if (((TypeSizeAndOffsetComputer.Offset)var24_25).isBitfieldOffset()) {
                    throw new UnsupportedOperationException("Bitfield read struct from heap");
                }
                var25_26 = this.mExprTrans.constructArithmeticExpression(iLocation, 4, expression4, this.mExprTrans.getCTypeOfPointerComponents(), ((TypeSizeAndOffsetComputer.Offset)var24_25).getAddressOffsetAsExpression(iLocation), this.mExprTrans.getCTypeOfPointerComponents());
                StructConstructor structConstructor = MemoryHandler.constructPointerFromBaseAndOffset(expression3, (Expression)var25_26, iLocation);
                ExpressionResult expressionResult2 = this.readStructFromHeap(expressionResult, iLocation, (Expression)structConstructor, (CStructOrUnion)var23_24, iASTNode, bl);
                lRValue = expressionResult2.getLrValue();
                arrayList.addAll(expressionResult2.getStatements());
                arrayList2.addAll(expressionResult2.getDeclarations());
                linkedHashSet.addAll(expressionResult2.getAuxVars());
            } else {
                if (object instanceof CNamed) {
                    throw new AssertionError((Object)"This should not be the case as we took the underlying type.");
                }
                throw new UnsupportedSyntaxException(iLocation, "..");
            }
            if (lRValue instanceof RValue) {
                arrayList4.add(lRValue.getValue());
            } else if (lRValue instanceof HeapLValue) {
                arrayList4.add(((HeapLValue)lRValue).getAddress());
            } else {
                throw new UnsupportedOperationException();
            }
            ++n;
        }
        StructConstructor structConstructor = ExpressionFactory.constructStructConstructor((ILocation)iLocation, (String[])arrayList3.toArray(new String[arrayList3.size()]), (Expression[])arrayList4.toArray(new Expression[arrayList4.size()]));
        object = new ExpressionResult(arrayList, new RValue((Expression)structConstructor, cStructOrUnion), arrayList2, linkedHashSet, expressionResult.getOverapprs(), expressionResult.getNeighbourUnionFields());
        return object;
    }

    private ExpressionResult readArrayFromHeap(ExpressionResult expressionResult, ILocation iLocation, Expression expression, CArray cArray, IASTNode iASTNode, boolean bl) {
        ICType iCType = cArray.getValueType().getUnderlyingType();
        if (iCType instanceof CArray) {
            throw new UnsupportedSyntaxException(iLocation, "we need to generalize this to nested and/or variable length arrays");
        }
        BigInteger bigInteger = this.mTypeSizes.extractIntegerValue(cArray.getBound());
        if (bigInteger == null) {
            throw new UnsupportedSyntaxException(iLocation, "variable length arrays not yet supported by this method");
        }
        int n = bigInteger.intValue();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cArray, SFO.AUXVAR.ARRAYCOPY);
        RValue rValue = new RValue((Expression)auxVarInfo.getExp(), cArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        Expression expression2 = MemoryHandler.getPointerBaseAddress(expression, iLocation);
        Expression expression3 = MemoryHandler.getPointerOffset(expression, iLocation);
        Expression expression4 = this.mMemoryHandler.calculateSizeOf(iLocation, iCType);
        Expression expression5 = expression3;
        int n2 = 0;
        while (n2 < n) {
            ExpressionResult expressionResult2;
            StructConstructor structConstructor = MemoryHandler.constructPointerFromBaseAndOffset(expression2, expression5, iLocation);
            if (iCType instanceof CStructOrUnion) {
                CStructOrUnion cStructOrUnion = (CStructOrUnion)iCType;
                expressionResult2 = this.readStructFromHeap(expressionResult, iLocation, (Expression)structConstructor, cStructOrUnion, iASTNode, bl);
            } else {
                expressionResult2 = bl ? this.mMemoryHandler.getReadUnchecked((Expression)structConstructor, cArray.getValueType()) : this.mMemoryHandler.getReadCall((Expression)structConstructor, cArray.getValueType());
            }
            expressionResultBuilder.addAllExceptLrValue(expressionResult2);
            expressionResultBuilder.setOrResetLrValue(expressionResult2.getLrValue());
            ArrayLHS arrayLHS = ExpressionFactory.constructNestedArrayLHS((ILocation)iLocation, (LeftHandSide)auxVarInfo.getLhs(), (Expression[])new Expression[]{this.mTypeSizes.constructLiteralForIntegerType(iLocation, this.mExprTrans.getCTypeOfPointerComponents(), BigInteger.valueOf(n2))});
            ExpressionResult expressionResult3 = this.mCHandler.makeAssignment(iLocation, new LocalLValue((LeftHandSide)arrayLHS, cArray.getValueType(), null), Collections.emptyList(), expressionResultBuilder.build(), iASTNode);
            expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult3).setLrValue(expressionResult3.getLrValue());
            expression5 = this.mExprTrans.constructArithmeticExpression(iLocation, 4, expression5, this.mExprTrans.getCTypeOfPointerComponents(), expression4, this.mExprTrans.getCTypeOfPointerComponents());
            ++n2;
        }
        expressionResultBuilder.setOrResetLrValue(rValue);
        return expressionResultBuilder.build();
    }

    private RValue toBoolean(ILocation iLocation, RValue rValue) {
        assert (!rValue.isBoogieBool());
        Expression expression = this.mExprTrans.toBool(iLocation, rValue.getValue(), rValue.getCType());
        return new RValue(expression, new CPrimitive(CPrimitive.CPrimitives.INT), true);
    }

    public ExpressionResult rexIntToBool(ExpressionResult expressionResult, ILocation iLocation) {
        if (!(expressionResult.getLrValue() instanceof RValue)) {
            throw new UnsupportedOperationException("only RValue can switch");
        }
        if (expressionResult.getLrValue().isBoogieBool()) {
            return expressionResult;
        }
        return new ExpressionResultBuilder(expressionResult).setOrResetLrValue(this.toBoolean(iLocation, (RValue)expressionResult.getLrValue())).build();
    }

    private RValue toInteger(ILocation iLocation, RValue rValue) {
        assert (rValue.isBoogieBool());
        return new RValue(this.mExprTrans.boolToInt(iLocation, rValue.getValue()), rValue.getCType(), false);
    }

    public ExpressionResult rexBoolToInt(ExpressionResult expressionResult, ILocation iLocation) {
        if (expressionResult.getLrValue() == null || !expressionResult.getLrValue().isBoogieBool()) {
            return expressionResult;
        }
        if (!(expressionResult.getLrValue() instanceof RValue)) {
            throw new UnsupportedOperationException("only RValue can switch");
        }
        return new ExpressionResultBuilder(expressionResult).setOrResetLrValue(this.toInteger(iLocation, (RValue)expressionResult.getLrValue())).build();
    }

    public ExpressionResult makeRepresentationReadyForConversionAndRexBoolToInt(ExpressionResult expressionResult, ILocation iLocation, ICType iCType, IASTNode iASTNode) {
        ExpressionResult expressionResult2 = this.makeRepresentationReadyForConversion(expressionResult, iLocation, iCType, iASTNode);
        return this.rexBoolToInt(expressionResult2, iLocation);
    }

    public ExpressionResult makeRepresentationReadyForConversion(ExpressionResult expressionResult, ILocation iLocation, ICType iCType, IASTNode iASTNode) {
        if (expressionResult.getLrValue() == null) {
            throw new AssertionError((Object)("Missing value " + String.valueOf(iLocation)));
        }
        if (expressionResult.getLrValue().getCType().getUnderlyingType() instanceof CArray && (iCType.getUnderlyingType() instanceof CPointer || iCType.getUnderlyingType() instanceof CPrimitive)) {
            ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult);
            RValue rValue = this.mCHandler.decayArrayLrValToPointer(expressionResult.getLrValue(), iASTNode);
            return expressionResultBuilder.setLrValue(rValue).build();
        }
        return this.switchToRValue(expressionResult, iLocation, iASTNode);
    }

    private static ExpressionResult replaceEnumByInt(ExpressionResult expressionResult) {
        if (expressionResult.getLrValue() instanceof RValue) {
            RValue rValue = (RValue)expressionResult.getLrValue();
            if (rValue.getCType().getUnderlyingType() instanceof CEnum) {
                CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
                return new ExpressionResultBuilder(expressionResult).setOrResetLrValue(new RValue(rValue.getValue(), cPrimitive, rValue.isBoogieBool(), rValue.isIntFromPointer())).build();
            }
            return expressionResult;
        }
        throw new UnsupportedOperationException("replaceEnumByInt only applicable for RValues");
    }

    private static ExpressionResult replaceCFunctionByCPointer(ExpressionResult expressionResult) {
        if (expressionResult.getLrValue() instanceof RValue) {
            RValue rValue = (RValue)expressionResult.getLrValue();
            if (rValue.getCType() instanceof CFunction) {
                CPointer cPointer = new CPointer(rValue.getCType());
                RValue rValue2 = new RValue(rValue.getValue(), cPointer, rValue.isBoogieBool(), rValue.isIntFromPointer());
                return new ExpressionResultBuilder(expressionResult).setOrResetLrValue(rValue2).build();
            }
            return expressionResult;
        }
        throw new UnsupportedOperationException("replaceEnumByInt only applicable for RValues");
    }

    public ExpressionResult decayArrayToPointer(ExpressionResult expressionResult, ILocation iLocation, IASTNode iASTNode) {
        if (expressionResult.getLrValue().getCType().getUnderlyingType() instanceof CArray) {
            ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
            expressionResultBuilder.addAllExceptLrValue(expressionResult);
            expressionResultBuilder.setLrValue(this.mCHandler.decayArrayLrValToPointer(expressionResult.getLrValue(), iASTNode));
            return expressionResultBuilder.build();
        }
        return expressionResult;
    }

    public ExpressionResult performImplicitConversion(ExpressionResult expressionResult, ICType iCType, ILocation iLocation) {
        RValue rValue = (RValue)expressionResult.getLrValue();
        ICType iCType2 = iCType.getUnderlyingType();
        ICType iCType3 = rValue.getCType().getUnderlyingType();
        BoogieType boogieType = (BoogieType)expressionResult.getLrValue().getValue().getType();
        BoogieType boogieType2 = this.mTypeHandler.getBoogieTypeForCType(iCType);
        if (CompatibleTypes.areCompatible(iCType2, iCType3) && !iCType2.equals(new CPrimitive(CPrimitive.CPrimitives.BOOL)) && boogieType.equals((Object)boogieType2)) {
            return expressionResult;
        }
        if (iCType2 instanceof CPrimitive) {
            CPrimitive cPrimitive = (CPrimitive)iCType2;
            if (cPrimitive.isIntegerType()) {
                return this.convertToIntegerType(iLocation, expressionResult, (CPrimitive)iCType2);
            }
            if (cPrimitive.isRealFloatingType()) {
                return this.convertToFloatingType(iLocation, expressionResult, (CPrimitive)iCType2);
            }
            if (cPrimitive.isVoidType()) {
                return ExpressionResultTransformer.convertToVoid(iLocation, expressionResult, (CPrimitive)iCType2);
            }
            throw new AssertionError((Object)("unknown type " + String.valueOf(iCType2)));
        }
        if (iCType2 instanceof CPointer) {
            return this.convertToPointer(iLocation, expressionResult, (CPointer)iCType2);
        }
        if (iCType2 instanceof CEnum) {
            return this.convertToIntegerType(iLocation, expressionResult, new CPrimitive(CPrimitive.CPrimitives.INT));
        }
        if (iCType2 instanceof CArray) {
            throw new AssertionError((Object)"cannot convert to CArray");
        }
        if (iCType2 instanceof CFunction) {
            throw new AssertionError((Object)"cannot convert to CFunction");
        }
        if (iCType2 instanceof CStructOrUnion) {
            throw new UnsupportedSyntaxException(iLocation, "conversion to CStructOrUnion not implemented.");
        }
        throw new AssertionError((Object)("unknown type " + String.valueOf(iCType2)));
    }

    private ExpressionResult convertToIntegerType(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        assert (expressionResult.getLrValue() instanceof RValue) : "has to be converted to RValue";
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        if (iCType instanceof CPrimitive) {
            CPrimitive cPrimitive2 = (CPrimitive)iCType;
            if (cPrimitive2.isIntegerType()) {
                return this.mExprTrans.convertIntToInt(iLocation, expressionResult, cPrimitive);
            }
            if (cPrimitive2.isRealFloatingType()) {
                return this.mExprTrans.convertFloatToInt(iLocation, expressionResult, cPrimitive);
            }
            if (cPrimitive2.isVoidType()) {
                throw new IncorrectSyntaxException(iLocation, "cannot convert from void");
            }
            throw new AssertionError((Object)("unknown type " + String.valueOf(cPrimitive)));
        }
        if (iCType instanceof CPointer) {
            return this.mExprTrans.convertPointerToInt(iLocation, expressionResult, cPrimitive);
        }
        if (iCType instanceof CEnum) {
            return this.mExprTrans.convertIntToInt(iLocation, expressionResult, cPrimitive);
        }
        if (iCType instanceof CArray) {
            throw new AssertionError((Object)"cannot convert from CArray");
        }
        if (iCType instanceof CFunction) {
            throw new AssertionError((Object)"cannot convert from CFunction");
        }
        if (iCType instanceof CStructOrUnion) {
            throw new UnsupportedSyntaxException(iLocation, "conversion from CStructOrUnion not implemented.");
        }
        throw new AssertionError((Object)("unknown type " + String.valueOf(cPrimitive)));
    }

    private ExpressionResult convertToPointer(ILocation iLocation, ExpressionResult expressionResult, CPointer cPointer) {
        assert (expressionResult.getLrValue() instanceof RValue) : "has to be converted to RValue";
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        if (iCType instanceof CPrimitive) {
            CPrimitive cPrimitive = (CPrimitive)iCType;
            if (cPrimitive.isIntegerType()) {
                return this.mExprTrans.convertIntToPointer(iLocation, expressionResult, cPointer);
            }
            if (cPrimitive.isRealFloatingType()) {
                throw new IncorrectSyntaxException(iLocation, "cannot convert float to pointer");
            }
            if (cPrimitive.isVoidType()) {
                throw new IncorrectSyntaxException(iLocation, "cannot convert from void");
            }
            throw new AssertionError((Object)("unknown type " + String.valueOf(cPointer)));
        }
        if (iCType instanceof CPointer) {
            return ExpressionResultTransformer.convertPointerToPointer(iLocation, expressionResult, cPointer);
        }
        if (iCType instanceof CEnum) {
            return this.mExprTrans.convertIntToPointer(iLocation, expressionResult, cPointer);
        }
        if (iCType instanceof CArray) {
            if (expressionResult instanceof StringLiteralResult) {
                RValue rValue = new RValue(expressionResult.getLrValue().getValue(), new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR)));
                return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue).build();
            }
            throw new AssertionError((Object)"cannot convert from CArray");
        }
        if (iCType instanceof CFunction) {
            throw new AssertionError((Object)"cannot convert from CFunction");
        }
        if (iCType instanceof CStructOrUnion) {
            throw new UnsupportedSyntaxException(iLocation, "conversion from CStruct not implemented.");
        }
        throw new AssertionError((Object)("unknown type " + String.valueOf(cPointer)));
    }

    private static ExpressionResult convertPointerToPointer(ILocation iLocation, ExpressionResult expressionResult, CPointer cPointer) {
        assert (expressionResult.getLrValue() instanceof RValue) : "has to be converted to RValue";
        RValue rValue = (RValue)expressionResult.getLrValue();
        assert (rValue.getCType() instanceof CPointer) : "has to be pointer";
        RValue rValue2 = new RValue(rValue.getValue(), cPointer);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue2).build();
    }

    private static ExpressionResult convertToVoid(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        assert (expressionResult.getLrValue() instanceof RValue) : "has to be converted to RValue";
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        if (!(iCType instanceof CPrimitive || iCType instanceof CPointer || iCType instanceof CEnum)) {
            if (iCType instanceof CArray) {
                throw new AssertionError((Object)"cannot convert from CArray");
            }
            if (iCType instanceof CFunction) {
                throw new AssertionError((Object)"cannot convert from CFunction");
            }
            if (iCType instanceof CStructOrUnion) {
                if (!cPrimitive.isVoidType()) {
                    throw new UnsupportedSyntaxException(iLocation, "cannot convert from CStructOrUnion to " + String.valueOf(cPrimitive));
                }
            } else {
                throw new AssertionError((Object)("unknown type " + String.valueOf(cPrimitive)));
            }
        }
        RValue rValue = (RValue)expressionResult.getLrValue();
        RValue rValue2 = new RValue(rValue.getValue(), cPrimitive, rValue.isBoogieBool(), rValue.isIntFromPointer());
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue2).build();
    }

    private ExpressionResult convertToFloatingType(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        assert (expressionResult.getLrValue() instanceof RValue) : "has to be converted to RValue";
        ICType iCType = expressionResult.getLrValue().getCType().getUnderlyingType();
        if (iCType instanceof CPrimitive) {
            CPrimitive cPrimitive2 = (CPrimitive)iCType;
            if (cPrimitive2.isIntegerType()) {
                return this.convertIfNecessary(iLocation, expressionResult, cPrimitive);
            }
            if (cPrimitive2.isRealFloatingType()) {
                return this.convertIfNecessary(iLocation, expressionResult, cPrimitive);
            }
            if (cPrimitive2.isVoidType()) {
                throw new IncorrectSyntaxException(iLocation, "cannot convert from void");
            }
            throw new AssertionError((Object)("unknown type " + String.valueOf(cPrimitive)));
        }
        if (iCType instanceof CPointer) {
            throw new IncorrectSyntaxException(iLocation, "cannot convert pointer to float");
        }
        if (iCType instanceof CEnum) {
            return this.convertIfNecessary(iLocation, expressionResult, cPrimitive);
        }
        if (iCType instanceof CArray) {
            throw new AssertionError((Object)"cannot convert from CArray");
        }
        if (iCType instanceof CFunction) {
            throw new AssertionError((Object)"cannot convert from CFunction");
        }
        if (iCType instanceof CStructOrUnion) {
            throw new UnsupportedSyntaxException(iLocation, "conversion from CStructOrUnion not implemented.");
        }
        throw new AssertionError((Object)("unknown type " + String.valueOf(cPrimitive)));
    }

    public Pair<ExpressionResult, ExpressionResult> usualArithmeticConversions(ILocation iLocation, ExpressionResult expressionResult, ExpressionResult expressionResult2) {
        ExpressionResult expressionResult3 = this.promoteToIntegerIfNecessary(iLocation, expressionResult);
        ExpressionResult expressionResult4 = this.promoteToIntegerIfNecessary(iLocation, expressionResult2);
        CPrimitive cPrimitive = this.determineResultOfUsualArithmeticConversions((CPrimitive)expressionResult3.getLrValue().getCType().getUnderlyingType(), (CPrimitive)expressionResult4.getLrValue().getCType().getUnderlyingType());
        ExpressionResult expressionResult5 = this.convertIfNecessary(iLocation, expressionResult3, cPrimitive);
        ExpressionResult expressionResult6 = this.convertIfNecessary(iLocation, expressionResult4, cPrimitive);
        if (!expressionResult5.getLrValue().getCType().getUnderlyingType().equals(cPrimitive)) {
            throw new AssertionError((Object)"conversion failed");
        }
        if (!expressionResult6.getLrValue().getCType().getUnderlyingType().equals(cPrimitive)) {
            throw new AssertionError((Object)"conversion failed");
        }
        return new Pair((Object)expressionResult5, (Object)expressionResult6);
    }

    private CPrimitive determineResultOfUsualArithmeticConversions(CPrimitive cPrimitive, CPrimitive cPrimitive2) {
        if (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.FLOATTYPE || cPrimitive2.getGeneralType() == CPrimitive.CPrimitiveCategory.FLOATTYPE) {
            if (cPrimitive.isComplexType() || cPrimitive2.isComplexType()) {
                throw new UnsupportedOperationException("complex types not yet supported");
            }
            if (cPrimitive.getType() == CPrimitive.CPrimitives.LONGDOUBLE || cPrimitive2.getType() == CPrimitive.CPrimitives.LONGDOUBLE) {
                return new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE);
            }
            if (cPrimitive.getType() == CPrimitive.CPrimitives.DOUBLE || cPrimitive2.getType() == CPrimitive.CPrimitives.DOUBLE) {
                return new CPrimitive(CPrimitive.CPrimitives.DOUBLE);
            }
            if (cPrimitive.getType() == CPrimitive.CPrimitives.FLOAT || cPrimitive2.getType() == CPrimitive.CPrimitives.FLOAT) {
                return new CPrimitive(CPrimitive.CPrimitives.FLOAT);
            }
            throw new AssertionError((Object)("unknown FLOATTYPE " + String.valueOf(cPrimitive) + ", " + String.valueOf(cPrimitive2)));
        }
        if (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.INTTYPE && cPrimitive2.getGeneralType() == CPrimitive.CPrimitiveCategory.INTTYPE) {
            return this.determineResultOfUsualArithmeticConversionsForInteger(cPrimitive, cPrimitive2);
        }
        throw new AssertionError((Object)("unsupported combination of CPrimitives: " + String.valueOf(cPrimitive) + " and " + String.valueOf(cPrimitive2)));
    }

    public final ExpressionResult promoteToIntegerIfNecessary(ILocation iLocation, ExpressionResult expressionResult) {
        CPrimitive cPrimitive;
        ICType iCType = CEnum.replaceEnumWithInt(expressionResult.getLrValue().getCType().getUnderlyingType());
        if (iCType instanceof CPrimitive && ExpressionResultTransformer.integerPromotionNeeded(cPrimitive = (CPrimitive)iCType)) {
            CPrimitive cPrimitive2 = this.determineResultOfIntegerPromotion(cPrimitive);
            return this.mExprTrans.convertIntToInt(iLocation, expressionResult, cPrimitive2);
        }
        return expressionResult;
    }

    private static boolean integerPromotionNeeded(CPrimitive cPrimitive) {
        return List.of(CPrimitive.CPrimitives.CHAR, CPrimitive.CPrimitives.SCHAR, CPrimitive.CPrimitives.UCHAR, CPrimitive.CPrimitives.SHORT, CPrimitive.CPrimitives.USHORT).contains((Object)cPrimitive.getType());
    }

    private CPrimitive determineResultOfUsualArithmeticConversionsForInteger(CPrimitive cPrimitive, CPrimitive cPrimitive2) {
        CPrimitive cPrimitive3;
        CPrimitive cPrimitive4;
        if (cPrimitive.equals(cPrimitive2)) {
            return cPrimitive;
        }
        if (this.mTypeSizes.isUnsigned(cPrimitive) == this.mTypeSizes.isUnsigned(cPrimitive2)) {
            return this.getMaximalType(cPrimitive, cPrimitive2);
        }
        if (this.mTypeSizes.isUnsigned(cPrimitive)) {
            cPrimitive4 = cPrimitive;
            cPrimitive3 = cPrimitive2;
        } else {
            cPrimitive4 = cPrimitive2;
            cPrimitive3 = cPrimitive;
        }
        return this.getMaximalType(cPrimitive4, cPrimitive3);
    }

    private CPrimitive getMaximalType(CPrimitive cPrimitive, CPrimitive cPrimitive2) {
        return this.mTypeSizes.getSize(cPrimitive.getType()) >= this.mTypeSizes.getSize(cPrimitive2.getType()) ? cPrimitive : cPrimitive2;
    }

    private CPrimitive determineResultOfIntegerPromotion(CPrimitive cPrimitive) {
        int n;
        int n2 = this.mTypeSizes.getSize(cPrimitive.getType());
        if (n2 < (n = this.mTypeSizes.getSize(CPrimitive.CPrimitives.INT).intValue()) || !this.mTypeSizes.isUnsigned(cPrimitive)) {
            return new CPrimitive(CPrimitive.CPrimitives.INT);
        }
        return new CPrimitive(CPrimitive.CPrimitives.UINT);
    }

    public ExpressionResult convertIfNecessary(ILocation iLocation, ExpressionResult expressionResult, CPrimitive cPrimitive) {
        if (expressionResult.getLrValue().getCType().getUnderlyingType().equals(cPrimitive)) {
            return expressionResult;
        }
        if (expressionResult.getLrValue().getCType().getUnderlyingType().isIntegerType()) {
            if (cPrimitive.isIntegerType()) {
                return this.mExprTrans.convertIntToInt(iLocation, expressionResult, cPrimitive);
            }
            if (cPrimitive.isRealFloatingType()) {
                return this.mExprTrans.convertIntToFloat(iLocation, expressionResult, cPrimitive);
            }
            throw new UnsupportedSyntaxException(iLocation, "conversion from " + String.valueOf(expressionResult.getLrValue().getCType().getUnderlyingType()) + " to " + String.valueOf(cPrimitive));
        }
        if (expressionResult.getLrValue().getCType().getUnderlyingType().isRealFloatingType()) {
            if (cPrimitive.isIntegerType()) {
                return this.mExprTrans.convertFloatToInt(iLocation, expressionResult, cPrimitive);
            }
            if (cPrimitive.isRealFloatingType()) {
                return this.mExprTrans.convertFloatToFloat(iLocation, expressionResult, cPrimitive);
            }
            throw new UnsupportedSyntaxException(iLocation, "conversion from " + String.valueOf(expressionResult.getLrValue().getCType().getUnderlyingType()) + " to " + String.valueOf(cPrimitive));
        }
        throw new UnsupportedSyntaxException(iLocation, "conversion from " + String.valueOf(expressionResult.getLrValue().getCType().getUnderlyingType()) + " to " + String.valueOf(cPrimitive));
    }

    public ExpressionResult convertNullPointerConstantToPointer(ExpressionResult expressionResult, ICType iCType, ILocation iLocation) {
        if (expressionResult.getLrValue().getCType().getUnderlyingType().isIntegerType()) {
            return this.mExprTrans.convertIntToPointer(iLocation, expressionResult, (CPointer)iCType);
        }
        assert (expressionResult.getLrValue().getCType().getUnderlyingType() instanceof CPointer);
        return expressionResult;
    }

    public ExpressionResult dispatchPointerLValue(IDispatcher iDispatcher, ILocation iLocation, IASTNode iASTNode) {
        ExpressionResult expressionResult;
        if (ExpressionResultTransformer.isAdressofOperator(iASTNode) && (expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)((IASTUnaryExpression)iASTNode).getOperand())).getLrValue() instanceof LocalLValue) {
            LocalLValue localLValue = (LocalLValue)expressionResult.getLrValue();
            LocalLValue localLValue2 = new LocalLValue(localLValue.getLhs(), new CPointer(expressionResult.getCType()), localLValue.isBoogieBool(), localLValue.isIntFromPointer(), localLValue.getBitfieldInformation());
            return new ExpressionResultBuilder(expressionResult).resetLrValue(localLValue2).build();
        }
        expressionResult = this.decayArrayToPointer((ExpressionResult)iDispatcher.dispatch(iASTNode), iLocation, iASTNode);
        if (expressionResult.getLrValue() instanceof HeapLValue) {
            return expressionResult;
        }
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder(expressionResult);
        expressionResultBuilder.resetLrValue(LRValueFactory.constructHeapLValue(this.mTypeHandler, expressionResult.getLrValue().getValue(), expressionResult.getCType(), null));
        return expressionResultBuilder.build();
    }

    private static boolean isAdressofOperator(IASTNode iASTNode) {
        return iASTNode instanceof IASTUnaryExpression && ((IASTUnaryExpression)iASTNode).getOperator() == 5;
    }

    public ExpressionResult makePointerAssignment(ILocation iLocation, LRValue lRValue, Expression expression) {
        if (lRValue instanceof RValue) {
            return this.makePointerAssignment(iLocation, new HeapLValue(lRValue.getValue(), lRValue.getCType(), null), expression);
        }
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        if (lRValue instanceof LocalLValue) {
            expressionResultBuilder.addStatement((Statement)StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)((LocalLValue)lRValue).getLhs(), (Expression)expression));
        } else if (lRValue instanceof HeapLValue) {
            ICType iCType = ((CPointer)lRValue.getCType()).getPointsToType();
            expressionResultBuilder.addStatements(this.mMemoryHandler.getWriteCall(iLocation, (HeapLValue)lRValue, expression, iCType, false));
        }
        if (this.mDataRaceChecker != null) {
            this.mDataRaceChecker.checkOnWrite(expressionResultBuilder, iLocation, lRValue);
        }
        return expressionResultBuilder.build();
    }

    public ExpressionResult readPointerValue(ILocation iLocation, LRValue lRValue) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ICType iCType = ((CPointer)lRValue.getCType()).getPointsToType();
        if (this.mDataRaceChecker != null) {
            this.mDataRaceChecker.checkOnRead(expressionResultBuilder, iLocation, lRValue);
        }
        if (lRValue instanceof HeapLValue) {
            HeapLValue heapLValue = (HeapLValue)lRValue;
            expressionResultBuilder.addAllIncludingLrValue(this.mMemoryHandler.getReadCall(heapLValue.getAddress(), iCType));
        } else {
            AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType, SFO.AUXVAR.RETURNED);
            expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo).setLrValue(new RValue((Expression)auxVarInfo.getExp(), iCType));
            expressionResultBuilder.addStatement((Statement)StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)auxVarInfo.getLhs(), (Expression)lRValue.getValue()));
        }
        return expressionResultBuilder.build();
    }

    @FunctionalInterface
    private static interface ITransformationFunction {
        public ExpressionResult apply(ExpressionResultTransformer var1, ExpressionResult var2, ICType var3, ILocation var4, IASTNode var5);
    }

    public static enum Transformation {
        SWITCH_TO_RVALUE((expressionResultTransformer, expressionResult, iCType, iLocation, iASTNode) -> expressionResultTransformer.switchToRValue(expressionResult, iLocation, iASTNode)),
        REX_BOOL_TO_INT((expressionResultTransformer, expressionResult, iCType, iLocation, iASTNode) -> expressionResultTransformer.rexBoolToInt(expressionResult, iLocation)),
        REX_INT_TO_BOOL((expressionResultTransformer, expressionResult, iCType, iLocation, iASTNode) -> expressionResultTransformer.rexIntToBool(expressionResult, iLocation)),
        DECAY_ARRAY_TO_POINTER((expressionResultTransformer, expressionResult, iCType, iLocation, iASTNode) -> expressionResultTransformer.decayArrayToPointer(expressionResult, iLocation, iASTNode)),
        IMPLICIT_CONVERSION((expressionResultTransformer, expressionResult, iCType, iLocation, iASTNode) -> expressionResultTransformer.performImplicitConversion(expressionResult, iCType, iLocation)),
        CONVERT_NULL_POINTER_TO_CONSTANT((expressionResultTransformer, expressionResult, iCType, iLocation, iASTNode) -> expressionResultTransformer.convertNullPointerConstantToPointer(expressionResult, iCType, iLocation));

        private final ITransformationFunction mFun;

        private Transformation(ITransformationFunction iTransformationFunction) {
            this.mFun = Objects.requireNonNull(iTransformationFunction);
        }
    }
}

