/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ArrayIndex
implements List<Term> {
    private final List<Term> mIndexEntries;

    public ArrayIndex() {
        this.mIndexEntries = Collections.emptyList();
    }

    public ArrayIndex(Term ... termArray) {
        this.mIndexEntries = Arrays.asList(termArray);
    }

    public ArrayIndex(List<? extends Term> list) {
        this.mIndexEntries = list;
    }

    @Override
    public boolean add(Term term) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public void add(int n, Term term) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public boolean addAll(Collection<? extends Term> collection) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public boolean addAll(int n, Collection<? extends Term> collection) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public boolean contains(Object object) {
        return this.mIndexEntries.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.mIndexEntries.containsAll(collection);
    }

    @Override
    public Term get(int n) {
        return this.mIndexEntries.get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.mIndexEntries.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.mIndexEntries.isEmpty();
    }

    @Override
    public Iterator<Term> iterator() {
        return this.mIndexEntries.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.mIndexEntries.lastIndexOf(object);
    }

    @Override
    public ListIterator<Term> listIterator() {
        return this.mIndexEntries.listIterator();
    }

    @Override
    public ListIterator<Term> listIterator(int n) {
        return this.mIndexEntries.listIterator(n);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public Term remove(int n) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public Term set(int n, Term term) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public int size() {
        return this.mIndexEntries.size();
    }

    @Override
    public List<Term> subList(int n, int n2) {
        return this.mIndexEntries.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.mIndexEntries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.mIndexEntries.toArray(TArray);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mIndexEntries);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ArrayIndex arrayIndex = (ArrayIndex)object;
        return !(this.mIndexEntries == null ? arrayIndex.mIndexEntries != null : !this.mIndexEntries.equals(arrayIndex.mIndexEntries));
    }

    public String toString() {
        return this.mIndexEntries.toString();
    }

    public ArrayIndex append(Term term) {
        ArrayList<Term> arrayList = new ArrayList<Term>(this.size() + 1);
        arrayList.addAll(this.mIndexEntries);
        arrayList.add(term);
        return new ArrayIndex(arrayList);
    }

    public ArrayIndex getFirst(int n) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.mIndexEntries.get(n2));
            ++n2;
        }
        return new ArrayIndex(arrayList);
    }

    public ArrayIndex getLast(int n) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n2 = this.mIndexEntries.size() - n;
        while (n2 < this.mIndexEntries.size()) {
            arrayList.add(this.mIndexEntries.get(n2));
            ++n2;
        }
        return new ArrayIndex(arrayList);
    }

    public Set<TermVariable> getFreeVars() {
        return SmtUtils.getFreeVars(this.mIndexEntries);
    }

    public boolean freeVarsAreSubset(Set<TermVariable> set) {
        for (Term term : this.mIndexEntries) {
            TermVariable[] termVariableArray = term.getFreeVars();
            int n = termVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable termVariable = termVariableArray[n2];
                if (!set.contains(termVariable)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public ArrayIndex appendEntriesAtBeginning(List<Term> list) {
        ArrayList<Term> arrayList = new ArrayList<Term>(list);
        arrayList.addAll(this);
        return new ArrayIndex(arrayList);
    }

    public ArrayIndex applySubstitution(ManagedScript managedScript, Map<? extends Term, ? extends Term> map) {
        ArrayIndex arrayIndex = new ArrayIndex(this.stream().map(term -> Substitution.apply(managedScript, map, term)).collect(Collectors.toList()));
        return arrayIndex;
    }

    public static List<ArrayIndex> appendEntriesAtBeginning(List<ArrayIndex> list, List<Term> list2) {
        ArrayList<ArrayIndex> arrayList = new ArrayList<ArrayIndex>(list.size());
        for (ArrayIndex arrayIndex : list) {
            arrayList.add(arrayIndex.appendEntriesAtBeginning(list2));
        }
        return arrayList;
    }

    public static Term constructIndexEquality(Script script, ArrayIndex arrayIndex, ArrayIndex arrayIndex2) {
        assert (arrayIndex.size() == arrayIndex2.size());
        ArrayList<Term> arrayList = new ArrayList<Term>(arrayIndex.size());
        int n = 0;
        while (n < arrayIndex.size()) {
            arrayList.add(SmtUtils.binaryEquality(script, arrayIndex.get(n), arrayIndex2.get(n)));
            ++n;
        }
        return SmtUtils.and(script, arrayList);
    }

    public static Term constructIndexNotEquals(Script script, ArrayIndex arrayIndex, ArrayIndex arrayIndex2) {
        assert (arrayIndex.size() == arrayIndex2.size());
        ArrayList<Term> arrayList = new ArrayList<Term>(arrayIndex.size());
        int n = 0;
        while (n < arrayIndex.size()) {
            arrayList.add(SmtUtils.distinct(script, arrayIndex.get(n), arrayIndex2.get(n)));
            ++n;
        }
        return SmtUtils.or(script, arrayList);
    }

    public ArrayIndex minus(Script script, ArrayIndex arrayIndex) {
        Term[] termArray = new Term[this.size()];
        int n = 0;
        while (n < this.size()) {
            termArray[n] = SmtUtils.minus(script, this.get(n), arrayIndex.get(n));
            ++n;
        }
        return new ArrayIndex(termArray);
    }
}

