/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TTSubstitution;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.TermTuple;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class ApplyDestructiveEqualityReasoning {
    HashSet<Literal> mResult;
    boolean mIsResultGround = true;
    private final EprTheory mEprTheory;

    public ApplyDestructiveEqualityReasoning(EprTheory eprTheory, Literal[] literalArray) {
        assert (eprTheory != null);
        this.mEprTheory = eprTheory;
        this.applyDER(new HashSet<Literal>(Arrays.asList(literalArray)));
    }

    private void applyDER(HashSet<Literal> hashSet) {
        HashSet<Literal> hashSet2 = new HashSet<Literal>(hashSet);
        Literal literal = this.findDisequality(hashSet2);
        this.mResult = hashSet2;
        this.mIsResultGround = false;
        while (literal != null) {
            hashSet2.remove(literal);
            TTSubstitution tTSubstitution = this.extractSubstitutionFromEquality((EprQuantifiedEqualityAtom)literal.getAtom());
            this.mResult = new HashSet();
            this.mIsResultGround = true;
            for (Literal literal2 : hashSet2) {
                Literal literal3 = EprHelpers.applySubstitution(tTSubstitution, literal2, this.mEprTheory, true);
                if (literal3.getAtom() instanceof DPLLAtom.TrueAtom) {
                    if (literal3.getSign() != 1) {
                        continue;
                    }
                } else if (literal3.getAtom() instanceof EprQuantifiedEqualityAtom || literal3.getAtom() instanceof EprQuantifiedPredicateAtom) {
                    this.mIsResultGround = false;
                } else if (literal3.getAtom() instanceof EprGroundPredicateAtom || literal3.getAtom() instanceof CCEquality) {
                    this.mEprTheory.addAtomToDPLLEngine(literal3.getAtom());
                } else if (!(literal3.getAtom() instanceof NamedAtom)) assert (false) : "case not forseen..";
                this.mResult.add(literal3);
            }
            hashSet2 = this.mResult;
            literal = this.findDisequality(hashSet2);
        }
    }

    public TTSubstitution extractSubstitutionFromEquality(EprQuantifiedEqualityAtom eprQuantifiedEqualityAtom) {
        TermTuple termTuple = eprQuantifiedEqualityAtom.getArgumentsAsTermTuple();
        TermVariable termVariable = null;
        Term term = null;
        if (termTuple.terms[0] instanceof TermVariable) {
            termVariable = (TermVariable)termTuple.terms[0];
            term = termTuple.terms[1];
        } else {
            termVariable = (TermVariable)termTuple.terms[1];
            term = termTuple.terms[0];
        }
        return new TTSubstitution(termVariable, term);
    }

    private Literal findDisequality(HashSet<Literal> hashSet) {
        for (Literal literal : hashSet) {
            if (literal.getSign() == 1 || !(literal.getAtom() instanceof EprQuantifiedEqualityAtom)) continue;
            return literal;
        }
        return null;
    }

    public Literal getSubstitutedLiteral(TTSubstitution tTSubstitution, Literal literal) {
        if (literal.getAtom() instanceof EprQuantifiedPredicateAtom || literal.getAtom() instanceof EprQuantifiedEqualityAtom) {
            boolean bl = literal.getSign() == 1;
            TermTuple termTuple = ((EprAtom)literal.getAtom()).getArgumentsAsTermTuple();
            SourceAnnotation sourceAnnotation = ((EprAtom)literal.getAtom()).getSourceAnnotation();
            TermTuple termTuple2 = tTSubstitution.apply(termTuple);
            if (termTuple2.equals(termTuple)) {
                return literal;
            }
            if (literal.getAtom() instanceof EprQuantifiedEqualityAtom) {
                if (termTuple2.isGround()) {
                    if (termTuple2.terms[0] == termTuple2.terms[1] && bl) {
                        return new DPLLAtom.TrueAtom();
                    }
                    if (termTuple2.terms[0] == termTuple2.terms[1] && !bl) {
                        return new DPLLAtom.TrueAtom().negate();
                    }
                    throw new UnsupportedOperationException();
                }
                EprQuantifiedEqualityAtom eprQuantifiedEqualityAtom = new EprQuantifiedEqualityAtom((ApplicationTerm)this.mEprTheory.getTheory().term("=", termTuple2.terms), 0, literal.getAtom().getAssertionStackLevel(), this.mEprTheory.getEqualityEprPredicate(termTuple2.terms[0].getSort()), sourceAnnotation);
                return bl ? eprQuantifiedEqualityAtom : eprQuantifiedEqualityAtom.negate();
            }
            EprPredicate eprPredicate = ((EprQuantifiedPredicateAtom)literal.getAtom()).getEprPredicate();
            EprPredicateAtom eprPredicateAtom = null;
            eprPredicateAtom = termTuple2.isGround() ? eprPredicate.getAtomForTermTuple(termTuple2, this.mEprTheory.getTheory(), this.mEprTheory.getClausifier().getStackLevel(), sourceAnnotation) : eprPredicate.getAtomForTermTuple(termTuple2, this.mEprTheory.getTheory(), this.mEprTheory.getClausifier().getStackLevel(), sourceAnnotation);
            return bl ? eprPredicateAtom : eprPredicateAtom.negate();
        }
        return literal;
    }

    public Set<Literal> getResult() {
        return this.mResult;
    }

    public boolean isResultGround() {
        return this.mIsResultGround;
    }
}

