/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.nontermination;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.ArgumentSynthesizer;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.ModelExtractionUtils;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.GeometricNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.SMTPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class NonTerminationArgumentSynthesizer
extends ArgumentSynthesizer {
    private static final String PREFIX_INIT = "init_";
    private static final String PREFIX_HONDA = "honda_";
    private static final String PREFIX_GE_VECTOR = "gev_";
    private static final String PREFIX_AUX = "aux_";
    private static final String PREFIX_EVALUE = "lambda";
    private static final String PREFIX_NIL_POTENT = "nu";
    public static long sAuxCounter = 0L;
    private final boolean mIntegerMode;
    private final AnalysisType mAnalysisType;
    private final NonTerminationAnalysisSettings mSettings;
    private final Sort mSort;
    private GeometricNonTerminationArgument mArgument = null;
    private Script.LBool mIsSat;

    public NonTerminationArgumentSynthesizer(Lasso lasso, ILassoRankerPreferences iLassoRankerPreferences, NonTerminationAnalysisSettings nonTerminationAnalysisSettings, IUltimateServiceProvider iUltimateServiceProvider) throws IOException {
        super(lasso, iLassoRankerPreferences, "nonterminationTemplate", iUltimateServiceProvider);
        this.mSettings = new NonTerminationAnalysisSettings(nonTerminationAnalysisSettings);
        this.mLogger.info((Object)nonTerminationAnalysisSettings.toString());
        boolean bl = this.mIntegerMode = lasso.getStem().containsIntegers() || lasso.getLoop().containsIntegers();
        if (!this.mIntegerMode) {
            this.mAnalysisType = this.mSettings.getAnalysis();
            if (this.mAnalysisType.isLinear()) {
                this.mScript.setLogic(Logics.QF_LRA);
            } else {
                this.mScript.setLogic(Logics.QF_NRA);
            }
            this.mSort = SmtSortUtils.getRealSort((Script)this.mScript);
        } else {
            this.mLogger.info((Object)"Using integer mode.");
            this.mAnalysisType = this.mSettings.getAnalysis();
            if (this.mSettings.getAnalysis().isLinear()) {
                this.mScript.setLogic(Logics.QF_LIA);
            } else {
                this.mScript.setLogic(Logics.QF_NIA);
            }
            this.mSort = SmtSortUtils.getIntSort((Script)this.mScript);
        }
        assert (!this.mAnalysisType.isDisabled());
    }

    @Override
    protected Script constructScript(ILassoRankerPreferences iLassoRankerPreferences, String string) {
        SolverBuilder.SolverMode solverMode = iLassoRankerPreferences.isAnnotateTerms() ? SolverBuilder.SolverMode.External_ModelsAndUnsatCoreMode : SolverBuilder.SolverMode.External_ModelsMode;
        SolverBuilder.SolverSettings solverSettings = iLassoRankerPreferences.getSolverConstructionSettings(solverMode, iLassoRankerPreferences.getBaseNameOfDumpedScript() + "+" + string);
        return SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)this.mServices, (SolverBuilder.SolverSettings)solverSettings, (String)"NonTerminationArgumentSynthesis solver ");
    }

    @Override
    protected Script.LBool doSynthesis() {
        List<Term> list;
        assert (this.mSettings.getNumberOfGevs() >= 0);
        String string = this.mIntegerMode ? "Int" : "Real";
        LinkedHashMap<IProgramVar, Term> linkedHashMap = new LinkedHashMap<IProgramVar, Term>();
        LinkedHashMap<IProgramVar, Term> linkedHashMap2 = new LinkedHashMap<IProgramVar, Term>();
        ArrayList<Map<IProgramVar, Term>> arrayList = new ArrayList<Map<IProgramVar, Term>>(this.mSettings.getNumberOfGevs());
        ArrayList<Term> arrayList2 = new ArrayList<Term>(this.mSettings.getNumberOfGevs());
        for (IProgramVar iProgramVar : this.mLasso.getAllRankVars()) {
            String string2 = SmtUtils.removeSmtQuoteCharacters((String)iProgramVar.toString());
            linkedHashMap.put(iProgramVar, this.newConstant(PREFIX_INIT + string2, string));
            linkedHashMap2.put(iProgramVar, this.newConstant(PREFIX_HONDA + string2, string));
        }
        int n = 0;
        while (n < this.mSettings.getNumberOfGevs()) {
            LinkedHashMap linkedHashMap3 = new LinkedHashMap();
            for (IProgramVar iProgramVar : this.mLasso.getAllRankVars()) {
                String string2 = SmtUtils.removeSmtQuoteCharacters((String)iProgramVar.toString());
                linkedHashMap3.put(iProgramVar, this.newConstant(PREFIX_GE_VECTOR + string2 + n, string));
            }
            arrayList.add(linkedHashMap3);
            arrayList2.add(this.newConstant(PREFIX_EVALUE + n, string));
            ++n;
        }
        if (this.mSettings.getNumberOfGevs() > 0) {
            list = new ArrayList(this.mSettings.getNumberOfGevs() - 1);
            int n2 = 0;
            while (n2 < this.mSettings.getNumberOfGevs() - 1) {
                list.add(this.newConstant(PREFIX_NIL_POTENT + n2, string));
                ++n2;
            }
        } else {
            list = Collections.emptyList();
        }
        Term term = this.generateConstraints(linkedHashMap, linkedHashMap2, arrayList, arrayList2, list);
        this.mLogger.debug((Object)new DebugMessage("{0}", new Object[]{new SMTPrettyPrinter(term)}));
        this.mScript.assertTerm(term);
        this.mIsSat = this.mScript.checkSat();
        if (this.mIsSat == Script.LBool.SAT) {
            this.mArgument = this.extractArgument(linkedHashMap, linkedHashMap2, arrayList, arrayList2, list);
        } else if (this.mIsSat == Script.LBool.UNKNOWN) {
            this.mScript.echo(new QuotedObject("Warning solver responded UNKNOWN to the check-sat above"));
        }
        return this.mIsSat;
    }

    /*
     * WARNING - void declaration
     */
    public Term generateConstraints(Map<IProgramVar, Term> map, Map<IProgramVar, Term> map2, List<Map<IProgramVar, Term>> list, List<Term> list2, List<Term> list3) {
        int n;
        Term term;
        Object object;
        void var17_19;
        Object object2;
        Rational rational;
        Term term2;
        Term term3;
        List<Object> list4;
        List<Object> list5;
        Term term4;
        Term term5;
        this.mSettings.checkSanity();
        assert (this.mSettings.getNumberOfGevs() >= 0);
        assert (list.size() == this.mSettings.getNumberOfGevs());
        assert (list2.size() == this.mSettings.getNumberOfGevs());
        int n2 = list.isEmpty() ? 0 : list.get(0).size();
        assert (n2 >= 0);
        Collection<IProgramVar> collection = this.mLasso.getAllRankVars();
        if (!this.mIntegerMode) {
            term5 = this.mScript.decimal("0");
            term4 = this.mScript.decimal("1");
        } else {
            term5 = this.mScript.numeral("0");
            term4 = this.mScript.numeral("1");
        }
        if (this.mAnalysisType == AnalysisType.NONLINEAR) {
            list5 = Collections.singletonList(null);
            list4 = Collections.singletonList(null);
        } else {
            term3 = new ArrayList();
            term3.add(term5);
            term3.add(term4);
            list4 = Collections.unmodifiableList(term3);
            if (this.mAnalysisType == AnalysisType.LINEAR) {
                list5 = Collections.singletonList(term4);
            } else if (this.mAnalysisType == AnalysisType.LINEAR_WITH_GUESSES) {
                term2 = this.mLasso.guessEigenvalues(false);
                list5 = new ArrayList<Object>(((Rational[])term2).length);
                Term object3 = term2;
                int n3 = ((Rational[])object3).length;
                int n4 = 0;
                while (n4 < n3) {
                    rational = object3[n4];
                    assert (!rational.isNegative());
                    if (!this.mIntegerMode || rational.isIntegral()) {
                        list5.add(rational.toTerm(this.mSort));
                    }
                    ++n4;
                }
            } else {
                assert (false);
                list5 = Collections.emptyList();
            }
        }
        term3 = this.mScript.term("true", new Term[0]);
        if (!this.mLasso.getStem().isTrue()) {
            LinearTransition linearTransition = this.mLasso.getStem();
            ArrayList<Term> arrayList = new ArrayList<Term>(linearTransition.getNumPolyhedra());
            for (List<LinearInequality> serializable : linearTransition.getPolyhedra()) {
                arrayList.add(this.generateConstraint(linearTransition, serializable, map, map2, false));
            }
            term3 = SmtUtils.or((Script)this.mScript, (Term[])arrayList.toArray(new Term[arrayList.size()]));
        }
        LinkedHashMap<IProgramVar, Term> linkedHashMap = new LinkedHashMap<IProgramVar, Term>(map2);
        for (IProgramVar iProgramVar : collection) {
            object2 = new Term[this.mSettings.getNumberOfGevs() + 1];
            object2[0] = map2.get(iProgramVar);
            int n11 = 0;
            while (n11 < this.mSettings.getNumberOfGevs()) {
                object2[n11 + 1] = list.get(n11).get(iProgramVar);
                ++n11;
            }
            Term term11 = ((Term[])object2).length == 1 ? object2[0] : this.mScript.term("+", (Term[])object2);
            linkedHashMap.put(iProgramVar, term11);
        }
        ArrayList<Term[]> arrayList = new ArrayList<Term[]>(this.mSettings.getNumberOfGevs());
        boolean bl = false;
        while (var17_19 < this.mSettings.getNumberOfGevs()) {
            object2 = new ArrayList(list5.size());
            arrayList.add((Term[])object2);
            int n5 = 0;
            while (n5 < list5.size()) {
                int n6 = 0;
                while (n6 < list4.size()) {
                    object = (Term)list5.get(n5);
                    if (object == null) {
                        object = list2.get((int)var17_19);
                    }
                    if ((term = (Term)list4.get(n6)) == null && var17_19 < this.mSettings.getNumberOfGevs() - 1) {
                        term = list3.get((int)var17_19);
                    }
                    LinkedHashMap<IProgramVar, Term> linkedHashMap2 = new LinkedHashMap<IProgramVar, Term>();
                    object2.add(linkedHashMap2);
                    for (IProgramVar iProgramVar : collection) {
                        if (this.mSettings.isNilpotentComponents() && var17_19 < this.mSettings.getNumberOfGevs() - 1) {
                            linkedHashMap2.put(iProgramVar, this.mScript.term("+", new Term[]{this.mScript.term("*", new Term[]{list.get((int)var17_19).get(iProgramVar), object}), this.mScript.term("*", new Term[]{list.get((int)(var17_19 + true)).get(iProgramVar), term})}));
                            continue;
                        }
                        linkedHashMap2.put(iProgramVar, this.mScript.term("*", new Term[]{list.get((int)var17_19).get(iProgramVar), object}));
                    }
                    ++n6;
                }
                ++n5;
            }
            ++var17_19;
        }
        LinearTransition linearTransition = this.mLasso.getLoop();
        object2 = new ArrayList(linearTransition.getNumPolyhedra());
        for (List<LinearInequality> list6 : linearTransition.getPolyhedra()) {
            object = this.generateConstraint(linearTransition, list6, map2, linkedHashMap, false);
            term = new Term[this.mSettings.getNumberOfGevs() + 1];
            int n7 = 0;
            while (n7 < this.mSettings.getNumberOfGevs()) {
                IProgramVar iProgramVar;
                iProgramVar = new Term[list5.size()];
                int n8 = 0;
                while (n8 < list5.size()) {
                    Term term6 = (Term)list5.get(n8);
                    Term term7 = this.generateConstraint(linearTransition, list6, list.get(n7), (Map)((List)arrayList.get(n7)).get(n8), true);
                    Term term8 = term6 == null ? this.mScript.term("true", new Term[0]) : this.mScript.term("=", new Term[]{list2.get(n7), term6});
                    iProgramVar[n8] = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term7, term8});
                    ++n8;
                }
                term[n7] = SmtUtils.or((Script)this.mScript, (Term[])iProgramVar);
                ++n7;
            }
            term[this.mSettings.getNumberOfGevs()] = object;
            object2.add(SmtUtils.and((Script)this.mScript, (Term[])term));
        }
        term2 = SmtUtils.or((Script)this.mScript, (Term[])object2.toArray(new Term[object2.size()]));
        ArrayList<Term> arrayList2 = new ArrayList<Term>(2 * this.mSettings.getNumberOfGevs());
        if (this.mSettings.isNilpotentComponents()) {
            n = 0;
            while (n < this.mSettings.getNumberOfGevs() - 1) {
                Term term9 = list3.get(n);
                arrayList2.add(SmtUtils.or((Script)this.mScript, (Term[])new Term[]{this.mScript.term("=", new Term[]{term9, term5}), this.mScript.term("=", new Term[]{term9, term4})}));
                ++n;
            }
        } else {
            n = 0;
            while (n < this.mSettings.getNumberOfGevs() - 1) {
                Term term10 = list3.get(n);
                arrayList2.add(this.mScript.term("=", new Term[]{term10, term5}));
                ++n;
            }
        }
        if (this.mSettings.isAllowBounded()) {
            n = 0;
            while (n < this.mSettings.getNumberOfGevs()) {
                arrayList2.add(this.mScript.term(">=", new Term[]{list2.get(n), term5}));
                ++n;
            }
        } else {
            ArrayList<Term> arrayList3 = new ArrayList<Term>(this.mSettings.getNumberOfGevs() * n2);
            int n9 = 0;
            while (n9 < this.mSettings.getNumberOfGevs()) {
                for (Term term11 : list.get(n9).values()) {
                    arrayList3.add(this.mScript.term("<>", new Term[]{term11, term5}));
                }
                arrayList2.add(this.mScript.term(">=", new Term[]{list2.get(n9), term4}));
                ++n9;
            }
            arrayList2.add(SmtUtils.or((Script)this.mScript, (Term[])arrayList3.toArray(new Term[arrayList3.size()])));
        }
        rational = SmtUtils.and((Script)this.mScript, (Term[])arrayList2.toArray(new Term[arrayList2.size()]));
        this.mLogger.debug((Object)new DebugMessage("{0}", new Object[]{new SMTPrettyPrinter(term3)}));
        this.mLogger.debug((Object)new DebugMessage("{0}", new Object[]{new SMTPrettyPrinter(term2)}));
        this.mLogger.debug((Object)new DebugMessage("{0}", new Object[]{new SMTPrettyPrinter((Term)rational)}));
        return this.mScript.term("and", new Term[]{term3, term2, rational});
    }

    private Term generateConstraint(LinearTransition linearTransition, List<LinearInequality> list, Map<IProgramVar, Term> map, Map<IProgramVar, Term> map2, boolean bl) {
        LinkedHashMap<Object, Term> linkedHashMap = new LinkedHashMap<Object, Term>();
        ArrayList<Term> arrayList = new ArrayList<Term>(list.size());
        for (LinearInequality linearInequality : list) {
            Object object;
            Object object2;
            Map.Entry<IProgramVar, TermVariable> entry2;
            ArrayList<Term> arrayList2 = new ArrayList<Term>();
            LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
            for (Map.Entry<IProgramVar, TermVariable> entry2 : linearTransition.getOutVars().entrySet()) {
                if (!map2.containsKey(entry2.getKey())) continue;
                object2 = linearInequality.getCoefficient((Term)entry2.getValue());
                arrayList2.add(this.mScript.term("*", new Term[]{map2.get(entry2.getKey()), this.mIntegerMode ? ((AffineTerm)object2).asIntTerm(this.mScript) : ((AffineTerm)object2).asRealTerm(this.mScript)}));
                linkedHashSet.add((Term)entry2.getValue());
            }
            for (Map.Entry<IProgramVar, TermVariable> entry2 : linearTransition.getInVars().entrySet()) {
                if (linkedHashSet.contains(entry2.getValue())) {
                    arrayList.add(this.mScript.term("=", new Term[]{map.get(entry2.getKey()), map2.get(entry2.getKey())}));
                    continue;
                }
                object2 = linearInequality.getCoefficient((Term)entry2.getValue());
                arrayList2.add(this.mScript.term("*", new Term[]{map.get(entry2.getKey()), this.mIntegerMode ? ((AffineTerm)object2).asIntTerm(this.mScript) : ((AffineTerm)object2).asRealTerm(this.mScript)}));
                linkedHashSet.add((Term)entry2.getValue());
            }
            entry2 = new LinkedHashSet<Term>(linearInequality.getVariables());
            entry2.removeAll(linkedHashSet);
            object2 = entry2.iterator();
            while (object2.hasNext()) {
                Term term;
                object = (Term)object2.next();
                if (linkedHashMap.containsKey(object)) {
                    term = (Term)linkedHashMap.get(object);
                } else {
                    term = this.newConstant(PREFIX_AUX + sAuxCounter, this.mIntegerMode ? "Int" : "Real");
                    linkedHashMap.put(object, term);
                }
                AffineTerm affineTerm = linearInequality.getCoefficient((Term)object);
                arrayList2.add(this.mScript.term("*", new Term[]{term, this.mIntegerMode ? affineTerm.asIntTerm(this.mScript) : affineTerm.asRealTerm(this.mScript)}));
                ++sAuxCounter;
            }
            if (!bl) {
                object = linearInequality.getConstant();
                arrayList2.add(this.mIntegerMode ? ((AffineTerm)object).asIntTerm(this.mScript) : ((AffineTerm)object).asRealTerm(this.mScript));
            }
            arrayList.add(this.mScript.term(bl ? ">=" : linearInequality.getInequalitySymbol(), new Term[]{SmtUtils.sum((Script)this.mScript, (Sort)this.mSort, (Term[])arrayList2.toArray(new Term[arrayList2.size()])), this.mIntegerMode ? SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ZERO) : this.mScript.decimal("0")}));
        }
        return SmtUtils.and((Script)this.mScript, (Term[])arrayList.toArray(new Term[arrayList.size()]));
    }

    private Map<IProgramVar, Rational> extractState(Map<IProgramVar, Term> map) throws SMTLIBException, UnsupportedOperationException, TermException {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Term, Rational> map2 = ModelExtractionUtils.getValuation(this.mScript, map.values());
        LinkedHashMap<IProgramVar, Rational> linkedHashMap = new LinkedHashMap<IProgramVar, Rational>();
        for (Map.Entry<IProgramVar, Term> entry : map.entrySet()) {
            assert (map2.containsKey(entry.getValue()));
            linkedHashMap.put(entry.getKey(), map2.get(entry.getValue()));
        }
        return linkedHashMap;
    }

    private GeometricNonTerminationArgument extractArgument(Map<IProgramVar, Term> map, Map<IProgramVar, Term> map2, List<Map<IProgramVar, Term>> list, List<Term> list2, List<Term> list3) {
        try {
            Map<IProgramVar, Rational> map3 = this.extractState(map);
            Map<IProgramVar, Rational> map4 = this.extractState(map2);
            ArrayList<Map<IProgramVar, Rational>> arrayList = new ArrayList<Map<IProgramVar, Rational>>(this.mSettings.getNumberOfGevs());
            Map map5 = !list2.isEmpty() ? this.mScript.getValue(list2.toArray(new Term[list2.size()])) : Collections.emptyMap();
            Map map6 = !list3.isEmpty() ? this.mScript.getValue(list3.toArray(new Term[list3.size()])) : Collections.emptyMap();
            ArrayList<Rational> arrayList2 = new ArrayList<Rational>(this.mSettings.getNumberOfGevs());
            ArrayList<Rational> arrayList3 = new ArrayList<Rational>();
            int n = 0;
            while (n < this.mSettings.getNumberOfGevs()) {
                arrayList.add(this.extractState(list.get(n)));
                arrayList2.add(ModelExtractionUtils.const2Rational((Term)map5.get(list2.get(n))));
                if (n < this.mSettings.getNumberOfGevs() - 1) {
                    arrayList3.add(ModelExtractionUtils.const2Rational((Term)map6.get(list3.get(n))));
                }
                ++n;
            }
            n = this.mLasso.getStem().isTrue() ? 0 : 1;
            return new GeometricNonTerminationArgument(n != 0 ? map3 : map4, map4, arrayList, arrayList2, arrayList3);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (TermException termException) {}
        return null;
    }

    public GeometricNonTerminationArgument getArgument() {
        assert (this.synthesisSuccessful());
        return this.mArgument;
    }
}

