/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LTLStepAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopEntryAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopExitAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Statements2TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ConcurrencyInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.LoopEntryDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.OrdinaryDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureEntryDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureErrorDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureErrorWithCheckDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureExitDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureFinalDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.StringDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.RCFGBacktranslator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.WeakestPrecondition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.AtomicBlockAnalyzer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.AtomicBlockInfo;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ForkThreadCurrent;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.GotoEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.JoinThreadCurrent;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.LargeBlockEncoding;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.LiveIcfgUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.preferences.RcfgPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.TransFormulaAdder;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CfgBuilder {
    private static final String ULTIMATE_START = "ULTIMATE.start";
    private final ILogger mLogger;
    private final BoogieIcfgContainer mIcfg;
    private final Boogie2SMT mBoogie2Smt;
    private final BoogieDeclarations mBoogieDeclarations;
    private TransFormulaAdder mTransFormulaAdder;
    private final Collection<Summary> mImplementationSummarys = new LinkedHashSet<Summary>();
    private final Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> mForks = new HashMap<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>>();
    private final List<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> mJoins = new ArrayList<IIcfgJoinTransitionThreadCurrent<IcfgLocation>>();
    private final RCFGBacktranslator mRcfgBacktranslator;
    private final RcfgPreferenceInitializer.CodeBlockSize mCodeBlockSize;
    private final boolean mCtxSwitchOnlyAtAtomicBoundaries;
    private final IUltimateServiceProvider mServices;
    private final boolean mAddAssumeForEachAssert;
    private final CodeBlockFactory mCbf;
    private int mRemovedAssumeTrueStatements = 0;
    static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.POLY_PAC;
    private final Set<String> mAllGotoTargets;
    private final boolean mRemoveAssumeTrueStmt;
    private final boolean mFutureLiveOptimization;

    public CfgBuilder(Unit unit, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mAddAssumeForEachAssert = iPreferenceProvider.getBoolean("Add additional assume for each assert");
        this.mRemoveAssumeTrueStmt = iPreferenceProvider.getBoolean("Remove assume true statements");
        String string = ILocation.getAnnotation((IElement)unit).getFileName();
        String string2 = new File(string).getName();
        Script script = this.constructAndInitializeSolver(iUltimateServiceProvider, string2);
        ManagedScript managedScript = new ManagedScript(this.mServices, script);
        this.mBoogieDeclarations = new BoogieDeclarations(unit, this.mLogger);
        boolean bl = iPreferenceProvider.getBoolean("Skolemize terms");
        ForkAndGotoInformation forkAndGotoInformation = new ForkAndGotoInformation(this.mBoogieDeclarations);
        this.mAllGotoTargets = forkAndGotoInformation.getAllGotoTargets();
        RcfgPreferenceInitializer.CodeBlockSize codeBlockSize = (RcfgPreferenceInitializer.CodeBlockSize)iPreferenceProvider.getEnum("Size of a code block", RcfgPreferenceInitializer.CodeBlockSize.class);
        if (!codeBlockSize.isConcurrencySafe() && forkAndGotoInformation.hasSomeForkEdge()) {
            this.mCodeBlockSize = RcfgPreferenceInitializer.CodeBlockSize.OneNontrivialStatement;
            this.mLogger.warn("User set CodeBlockSize to %s but program contains fork statements. Overwriting the user preferences and setting CodeBlockSize to %s.", new Object[]{codeBlockSize, this.mCodeBlockSize});
        } else {
            this.mCodeBlockSize = codeBlockSize;
        }
        this.mCtxSwitchOnlyAtAtomicBoundaries = iPreferenceProvider.getBoolean("Only consider context switches at boundaries of atomic blocks");
        this.mFutureLiveOptimization = iPreferenceProvider.getBoolean("Future-live optimization");
        this.mBoogie2Smt = new Boogie2SMT(managedScript, this.mBoogieDeclarations, this.mServices, bl);
        RCFGBacktranslator rCFGBacktranslator = new RCFGBacktranslator(this.mLogger);
        rCFGBacktranslator.setTerm2Expression(this.mBoogie2Smt.getTerm2Expression());
        this.mRcfgBacktranslator = rCFGBacktranslator;
        ConcurrencyInformation concurrencyInformation = new ConcurrencyInformation(this.mForks, Collections.emptyMap(), this.mJoins);
        this.mIcfg = new BoogieIcfgContainer(this.mServices, this.mBoogieDeclarations, this.mBoogie2Smt, concurrencyInformation);
        this.mCbf = this.mIcfg.getCodeBlockFactory();
        this.mCbf.storeFactory(this.mServices.getStorage());
    }

    public IIcfg<BoogieIcfgLocation> createIcfg(Unit unit) {
        Object object2;
        this.mLogger.info((Object)"Building ICFG");
        this.mTransFormulaAdder = new TransFormulaAdder(this.mBoogie2Smt, this.mServices);
        BoogieIcfgContainer boogieIcfgContainer = this.mIcfg;
        for (Object object2 : this.mBoogieDeclarations.getProcImplementation().keySet()) {
            Body body = ((Procedure)this.mBoogieDeclarations.getProcImplementation().get(object2)).getBody();
            Statement statement = body.getBlock()[0];
            BoogieIcfgLocation boogieIcfgLocation = new BoogieIcfgLocation((DebugIdentifier)new ProcedureEntryDebugIdentifier((String)object2), (String)object2, false, (BoogieASTNode)statement);
            Procedure procedure = (Procedure)this.mBoogieDeclarations.getProcImplementation().get(object2);
            boogieIcfgContainer.getProcedureEntryNodes().put((String)object2, boogieIcfgLocation);
            BoogieIcfgLocation boogieIcfgLocation2 = new BoogieIcfgLocation((DebugIdentifier)new ProcedureFinalDebugIdentifier((String)object2), (String)object2, false, (BoogieASTNode)procedure);
            boogieIcfgContainer.mFinalNode.put((String)object2, boogieIcfgLocation2);
            BoogieIcfgLocation boogieIcfgLocation3 = new BoogieIcfgLocation((DebugIdentifier)new ProcedureExitDebugIdentifier((String)object2), (String)object2, false, (BoogieASTNode)procedure);
            boogieIcfgContainer.getProcedureExitNodes().put((String)object2, boogieIcfgLocation3);
        }
        this.mLogger.info((Object)"Building CFG for each procedure with an implementation");
        object2 = new ProcedureCfgBuilder();
        for (String string : this.mBoogieDeclarations.getProcSpecification().keySet()) {
            if (!this.mBoogieDeclarations.getProcImplementation().containsKey(string)) continue;
            ((ProcedureCfgBuilder)object2).buildProcedureCfgFromImplementation(string);
        }
        for (Summary summary : this.mImplementationSummarys) {
            this.addCallTransitionAndReturnTransition(summary, SIMPLIFICATION_TECHNIQUE);
        }
        if (this.mFutureLiveOptimization) {
            if (!IcfgUtils.isConcurrent((IIcfg)boogieIcfgContainer)) {
                LiveIcfgUtils.applyFutureLiveOptimization(this.mServices, boogieIcfgContainer);
            } else {
                this.mLogger.info((Object)"Omitted future-live optimization because the input is a concurrent program.");
            }
        }
        this.mLogger.info((Object)"Performing block encoding");
        switch (this.mCodeBlockSize) {
            case LoopFreeBlock: {
                new LargeBlockEncoding(this.mServices, this.mIcfg, this.mCbf, LargeBlockEncoding.InternalLbeMode.ALL);
                break;
            }
            case SingleStatement: 
            case OneNontrivialStatement: 
            case SequenceOfStatements: {
                LargeBlockEncoding.InternalLbeMode internalLbeMode = this.mCtxSwitchOnlyAtAtomicBoundaries && IcfgUtils.isConcurrent((IIcfg)this.mIcfg) ? LargeBlockEncoding.InternalLbeMode.ALL_EXCEPT_ATOMIC_BOUNDARIES : LargeBlockEncoding.InternalLbeMode.ONLY_ATOMIC_BLOCK;
                new LargeBlockEncoding(this.mServices, this.mIcfg, this.mCbf, internalLbeMode);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + String.valueOf((Object)this.mCodeBlockSize)));
            }
        }
        AtomicBlockAnalyzer.ensureAtomicCompositionIsComplete(this.mIcfg, this.mLogger);
        Set set = boogieIcfgContainer.getProcedureEntryNodes().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(ULTIMATE_START)).map(Map.Entry::getValue).collect(Collectors.toSet());
        if (set.isEmpty()) {
            this.mLogger.info((Object)"Using library mode");
            boogieIcfgContainer.getInitialNodes().addAll(boogieIcfgContainer.getProcedureEntryNodes().values());
        } else {
            this.mLogger.info((Object)("Using the " + set.size() + " location(s) as analysis (start of procedure ULTIMATE.start)"));
            boogieIcfgContainer.getInitialNodes().addAll(set);
        }
        ModelUtils.copyAnnotations((IElement)unit, (IElement)boogieIcfgContainer);
        this.mLogger.info((Object)("Removed " + this.mRemovedAssumeTrueStatements + " assume(true) statements."));
        return boogieIcfgContainer;
    }

    public Boogie2SMT getBoogie2Smt() {
        return this.mBoogie2Smt;
    }

    private Script constructAndInitializeSolver(IUltimateServiceProvider iUltimateServiceProvider, String string) {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        SolverBuilder.SolverMode solverMode = (SolverBuilder.SolverMode)iPreferenceProvider.getEnum("SMT solver", SolverBuilder.SolverMode.class);
        boolean bl = iPreferenceProvider.getBoolean("Fake non-incremental script");
        boolean bl2 = iPreferenceProvider.getBoolean("Dump SMT script to file");
        boolean bl3 = iPreferenceProvider.getBoolean("Compress dumped SMT script");
        String string2 = iPreferenceProvider.getString("To the following directory");
        String string3 = iPreferenceProvider.getString("Command for external solver");
        boolean bl4 = iPreferenceProvider.getBoolean("Dump unsat core track benchmark to file");
        boolean bl5 = iPreferenceProvider.getBoolean("Dump main track benchmark to file");
        Map map = iPreferenceProvider.getKeyValueMap("Additional SMT options");
        Logics logics = Logics.valueOf((String)iPreferenceProvider.getString("Logic for external solver"));
        SolverBuilder.SolverSettings solverSettings = SolverBuilder.constructSolverSettings().setUseFakeIncrementalScript(bl).setDumpSmtScriptToFile(bl2, string2, string, bl3).setDumpUnsatCoreTrackBenchmark(bl4).setDumpMainTrackBenchmark(bl5).setUseExternalSolver(true, string3, logics).setSolverMode(solverMode).setAdditionalOptions(map);
        return SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)iUltimateServiceProvider, (SolverBuilder.SolverSettings)solverSettings, (String)"CfgBuilderScript");
    }

    private static Expression getNegation(Expression expression) {
        if (expression == null) {
            return null;
        }
        return new UnaryExpression(expression.getLocation(), (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, expression);
    }

    private void addCallTransitionAndReturnTransition(Summary summary, SmtUtils.SimplificationTechnique simplificationTechnique) {
        CallStatement callStatement = summary.getCallStatement();
        String string = callStatement.getMethodName();
        assert (this.mIcfg.getProcedureEntryNodes().containsKey(string)) : "Source code contains call of " + string + " but no such procedure.";
        BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)summary.getSource();
        BoogieIcfgLocation boogieIcfgLocation2 = this.mIcfg.getProcedureEntryNodes().get(string);
        String string2 = boogieIcfgLocation.getProcedure();
        Statements2TransFormula.TranslationResult translationResult = this.mIcfg.getBoogie2SMT().getStatements2TransFormula().inParamAssignment(callStatement, simplificationTechnique);
        Statements2TransFormula.TranslationResult translationResult2 = this.mIcfg.getBoogie2SMT().getStatements2TransFormula().resultAssignment(callStatement, string2, simplificationTechnique);
        HashMap hashMap = new HashMap(translationResult.getOverapproximations());
        hashMap.putAll(translationResult2.getOverapproximations());
        Call call = this.mCbf.constructCall(boogieIcfgLocation, boogieIcfgLocation2, callStatement);
        call.setTransitionFormula(translationResult.getTransFormula());
        if (!hashMap.isEmpty()) {
            new Overapprox(hashMap).annotate((IElement)call);
        }
        BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)summary.getTarget();
        BoogieIcfgLocation boogieIcfgLocation4 = this.mIcfg.getProcedureExitNodes().get(string);
        Return return_ = this.mCbf.constructReturn(boogieIcfgLocation4, boogieIcfgLocation3, call);
        return_.setTransitionFormula(translationResult2.getTransFormula());
    }

    private BoogieIcfgLocation addErrorNode(String string, BoogieASTNode boogieASTNode, Map<DebugIdentifier, BoogieIcfgLocation> map) {
        ProcedureErrorDebugIdentifier.ProcedureErrorType procedureErrorType;
        int n;
        Set<BoogieIcfgLocation> set = this.mIcfg.getProcedureErrorNodes().get(string);
        if (set == null) {
            set = new LinkedHashSet<BoogieIcfgLocation>();
            this.mIcfg.getProcedureErrorNodes().put(string, set);
            n = 0;
        } else {
            n = set.size();
        }
        if (boogieASTNode instanceof AssertStatement) {
            procedureErrorType = ProcedureErrorDebugIdentifier.ProcedureErrorType.ASSERT_VIOLATION;
        } else if (boogieASTNode instanceof EnsuresSpecification) {
            procedureErrorType = ProcedureErrorDebugIdentifier.ProcedureErrorType.ENSURES_VIOLATION;
        } else if (boogieASTNode instanceof RequiresSpecification) {
            procedureErrorType = ProcedureErrorDebugIdentifier.ProcedureErrorType.REQUIRES_VIOLATION;
        } else if (boogieASTNode instanceof ForkStatement) {
            procedureErrorType = ProcedureErrorDebugIdentifier.ProcedureErrorType.INUSE_VIOLATION;
        } else {
            throw new IllegalArgumentException();
        }
        Check check = Check.getAnnotation((IElement)boogieASTNode);
        if (check == null) {
            throw new IllegalArgumentException("Constructing error location without specification for the following AST node: " + String.valueOf(boogieASTNode));
        }
        ProcedureErrorWithCheckDebugIdentifier procedureErrorWithCheckDebugIdentifier = new ProcedureErrorWithCheckDebugIdentifier(string, n, procedureErrorType, check);
        BoogieIcfgLocation boogieIcfgLocation = new BoogieIcfgLocation((DebugIdentifier)procedureErrorWithCheckDebugIdentifier, string, true, boogieASTNode);
        check.annotate((IElement)boogieIcfgLocation);
        map.put((DebugIdentifier)procedureErrorWithCheckDebugIdentifier, boogieIcfgLocation);
        set.add(boogieIcfgLocation);
        return boogieIcfgLocation;
    }

    public ITranslator<IIcfgTransition<IcfgLocation>, BoogieASTNode, Term, Expression, IcfgLocation, String, ILocation> getBacktranslator() {
        return this.mRcfgBacktranslator;
    }

    private static boolean isPlainAssumeTrueStatement(Statement statement) {
        if (statement instanceof AssumeStatement) {
            BooleanLiteral booleanLiteral;
            AssumeStatement assumeStatement = (AssumeStatement)statement;
            if (assumeStatement.getAttributes() != null && assumeStatement.getAttributes().length > 0) {
                return false;
            }
            if (LTLStepAnnotation.getAnnotation((IElement)assumeStatement) != null) {
                return false;
            }
            if (assumeStatement.getFormula() instanceof BooleanLiteral && (booleanLiteral = (BooleanLiteral)assumeStatement.getFormula()).getValue()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isOverapproximation(Statement statement) {
        Overapprox overapprox = Overapprox.getAnnotation((IElement)statement);
        return overapprox != null;
    }

    private static class ForkAndGotoInformation {
        private boolean mHasSomeForkStatement;
        private final Set<String> mAllGotoTargets = new HashSet<String>();

        public ForkAndGotoInformation(BoogieDeclarations boogieDeclarations) {
            for (Map.Entry entry : boogieDeclarations.getProcImplementation().entrySet()) {
                Procedure procedure = (Procedure)entry.getValue();
                Body body = procedure.getBody();
                this.processStatements(body.getBlock());
            }
        }

        private void processStatements(Statement[] statementArray) {
            Statement[] statementArray2 = statementArray;
            int n = statementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray2[n2];
                if (statement instanceof ForkStatement) {
                    this.mHasSomeForkStatement = true;
                } else if (statement instanceof GotoStatement) {
                    this.mAllGotoTargets.addAll(Arrays.asList(((GotoStatement)statement).getLabels()));
                } else if (statement instanceof AtomicStatement) {
                    this.processStatements(((AtomicStatement)statement).getBody());
                } else if (!(statement instanceof AssignmentStatement || statement instanceof AssumeStatement || statement instanceof HavocStatement || statement instanceof Label || statement instanceof JoinStatement || statement instanceof CallStatement || statement instanceof ReturnStatement || statement instanceof AssertStatement)) {
                    throw new UnsupportedOperationException("Did not expect statement of type " + statement.getClass().getSimpleName());
                }
                ++n2;
            }
        }

        public boolean hasSomeForkEdge() {
            return this.mHasSomeForkStatement;
        }

        public Set<String> getAllGotoTargets() {
            return this.mAllGotoTargets;
        }
    }

    private final class ProcedureCfgBuilder {
        private Map<DebugIdentifier, BoogieIcfgLocation> mProcLocNodes;
        private Map<DebugIdentifier, BoogieIcfgLocation> mLabel2LocNodes;
        private Set<String> mLabels;
        private DebugIdentifier mLastLabelName;
        IElement mCurrent;
        List<GotoEdge> mGotoEdges;
        String mCurrentProcedureName;
        Set<CodeBlock> mEdges;
        Map<Integer, Integer> mNameCache;

        private ProcedureCfgBuilder() {
        }

        private void buildProcedureCfgFromImplementation(String string) {
            this.mCurrentProcedureName = string;
            this.mEdges = new HashSet<CodeBlock>();
            this.mGotoEdges = new LinkedList<GotoEdge>();
            this.mLabels = new HashSet<String>();
            this.mNameCache = new HashMap<Integer, Integer>();
            Statement[] statementArray = ((Procedure)CfgBuilder.this.mBoogieDeclarations.getProcImplementation().get(string)).getBody().getBlock();
            if (statementArray.length == 0) {
                throw new UnsupportedOperationException("Procedure contains no statement");
            }
            this.mLabel2LocNodes = new HashMap<DebugIdentifier, BoogieIcfgLocation>();
            this.mProcLocNodes = new HashMap<DebugIdentifier, BoogieIcfgLocation>();
            CfgBuilder.this.mIcfg.getProgramPoints().put(string, this.mProcLocNodes);
            CfgBuilder.this.mLogger.debug((Object)("Start construction of the CFG for" + string));
            BoogieIcfgLocation boogieIcfgLocation = CfgBuilder.this.mIcfg.getProcedureEntryNodes().get(string);
            this.mLastLabelName = boogieIcfgLocation.getDebugIdentifier();
            this.mProcLocNodes.put(this.mLastLabelName, boogieIcfgLocation);
            this.mCurrent = boogieIcfgLocation;
            this.assumeRequires(false);
            boolean bl = false;
            Statement statement = null;
            Object object = statementArray;
            int n = statementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement2 = object[n2];
                if (!CfgBuilder.this.mServices.getProgressMonitorService().continueProcessing()) {
                    CfgBuilder.this.mLogger.warn((Object)"Timeout while constructing control flow graph");
                    throw new ToolchainCanceledException(this.getClass(), "constructing CFG for procedure with " + statementArray.length + "statements");
                }
                if (CfgBuilder.this.mRemoveAssumeTrueStmt && CfgBuilder.isPlainAssumeTrueStatement(statement2) && !CfgBuilder.isOverapproximation(statement2)) {
                    ++CfgBuilder.this.mRemovedAssumeTrueStatements;
                } else {
                    assert (statement2.getLocation() != null) : "location of the following statement is null " + String.valueOf(statement2);
                    boolean bl2 = this.statementIsControlFlowDead(bl, statement, statement2, CfgBuilder.this.mAllGotoTargets);
                    if (!bl2 || statement2 instanceof AtomicStatement) {
                        this.processStatement(string, statement2, statement, false);
                    }
                    bl = bl2;
                    statement = statement2;
                }
                ++n2;
            }
            if (!(statement instanceof ReturnStatement || statement instanceof GotoStatement || bl)) {
                this.processReturnStatement();
            }
            this.assertAndAssumeEnsures();
            boolean bl3 = CfgBuilder.this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Remove goto edges from RCFG");
            if (bl3) {
                CfgBuilder.this.mLogger.debug((Object)"Starting removal of auxiliaryGotoTransitions");
                while (!this.mGotoEdges.isEmpty()) {
                    GotoEdge gotoEdge = this.mGotoEdges.remove(0);
                    n = this.removeAuxiliaryGoto(gotoEdge, true) ? 1 : 0;
                    assert (n != 0) : "goto not removed";
                }
            } else {
                for (GotoEdge gotoEdge : this.mGotoEdges) {
                    boolean bl4 = this.removeAuxiliaryGoto(gotoEdge, false);
                    if (bl4) continue;
                    this.mEdges.add(gotoEdge);
                }
            }
            for (CodeBlock codeBlock : this.mEdges) {
                CfgBuilder.this.mTransFormulaAdder.addTransitionFormulas(codeBlock, string, SIMPLIFICATION_TECHNIQUE);
            }
            BoogieIcfgLocation boogieIcfgLocation2 = CfgBuilder.this.mIcfg.getProcedureEntryNodes().get(string);
            Set<BoogieIcfgLocation> set = this.computeReachableLocations(boogieIcfgLocation2);
            object = CfgBuilder.this.mIcfg.getProcedureExitNodes().get(string);
            Map<DebugIdentifier, BoogieIcfgLocation> map = this.mProcLocNodes;
            this.removeUnreachableProgramPoints(set, map, (BoogieIcfgLocation)((Object)object));
        }

        private void removeUnreachableProgramPoints(Set<BoogieIcfgLocation> set, Map<DebugIdentifier, BoogieIcfgLocation> map, BoogieIcfgLocation boogieIcfgLocation) {
            Iterator<Map.Entry<DebugIdentifier, BoogieIcfgLocation>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<DebugIdentifier, BoogieIcfgLocation> entry = iterator.next();
                if (set.contains((Object)entry.getValue()) || boogieIcfgLocation == entry.getValue()) continue;
                iterator.remove();
                ArrayList arrayList = new ArrayList(entry.getValue().getOutgoingEdges());
                for (IcfgEdge icfgEdge : arrayList) {
                    icfgEdge.disconnectSource();
                    icfgEdge.disconnectTarget();
                    CfgBuilder.this.mLogger.info((Object)("dead code at ProgramPoint " + String.valueOf((Object)entry.getValue()) + ": " + String.valueOf(icfgEdge)));
                    CfgBuilder.this.mImplementationSummarys.remove(icfgEdge);
                }
            }
        }

        private Set<BoogieIcfgLocation> computeReachableLocations(BoogieIcfgLocation boogieIcfgLocation) {
            HashSet<BoogieIcfgLocation> hashSet = new HashSet<BoogieIcfgLocation>();
            ArrayDeque<BoogieIcfgLocation> arrayDeque = new ArrayDeque<BoogieIcfgLocation>();
            arrayDeque.add(boogieIcfgLocation);
            hashSet.add(boogieIcfgLocation);
            while (!arrayDeque.isEmpty()) {
                BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)((Object)arrayDeque.removeFirst());
                for (IcfgLocation icfgLocation : boogieIcfgLocation2.getOutgoingNodes()) {
                    if (hashSet.contains(icfgLocation)) continue;
                    hashSet.add((BoogieIcfgLocation)icfgLocation);
                    arrayDeque.add((BoogieIcfgLocation)icfgLocation);
                }
            }
            return hashSet;
        }

        private void processStatement(String string, Statement statement, Statement statement2, boolean bl) {
            if (statement instanceof Label) {
                if (this.mCurrent instanceof BoogieIcfgLocation) {
                    assert (this.mCurrent == CfgBuilder.this.mIcfg.getProcedureEntryNodes().get(string) || statement2 instanceof Label) : "If st is Label and mCurrent is LocNode, lastSt is Label";
                    CfgBuilder.this.mLogger.debug((Object)("Two Labels in a row: " + String.valueOf(this.mCurrent) + " and " + ((Label)statement).getName() + ". I am expecting that at least one was introduced by the user (or vcc). In the CFG only the first label of those two (or more) will be used"));
                }
                if (this.mCurrent instanceof CodeBlock) {
                    assert (statement2 instanceof AssumeStatement || statement2 instanceof AssignmentStatement || statement2 instanceof HavocStatement || statement2 instanceof AssertStatement || statement2 instanceof CallStatement || statement2 instanceof AtomicStatement || statement2 == null) : "If st is a Label and the last constructed node was a TransEdge, then the last Statement must not be a Label, Return or Goto";
                    CfgBuilder.this.mLogger.warn((Object)"Label in the middle of a codeblock.");
                }
                this.processLabel((Label)statement);
            } else if (statement instanceof AssumeStatement || statement instanceof AssignmentStatement || statement instanceof HavocStatement) {
                if (this.mCurrent instanceof CodeBlock) assert (bl || statement2 instanceof AssumeStatement || statement2 instanceof AssignmentStatement || statement2 instanceof HavocStatement || statement2 instanceof AssertStatement || statement2 instanceof CallStatement || statement2 instanceof AtomicStatement) : "If the last constructed node is a TransEdge, then the last Statement must not be a Label, Return or Goto. (i.e. this is not the first Statement of the block)";
                this.processAssuAssiHavoStatement(statement);
            } else if (statement instanceof AssertStatement) {
                if (this.mCurrent instanceof CodeBlock) assert (bl || statement2 instanceof AssumeStatement || statement2 instanceof AssignmentStatement || statement2 instanceof HavocStatement || statement2 instanceof AssertStatement || statement2 instanceof CallStatement || statement2 instanceof AtomicStatement) : "If the last constructed node is a TransEdge, then the last Statement must not be a Label, Return or Goto. (i.e. this is not the first Statement of the block)";
                this.processAssertStatement((AssertStatement)statement);
            } else if (statement instanceof GotoStatement) {
                if (statement2 instanceof GotoStatement) {
                    CfgBuilder.this.mLogger.warn((Object)"Two Gotos in a row! There was dead code");
                } else {
                    this.processGotoStatement((GotoStatement)statement);
                }
            } else if (statement instanceof CallStatement) {
                if (this.mCurrent instanceof CodeBlock) assert (bl || statement2 instanceof AssumeStatement || statement2 instanceof AssignmentStatement || statement2 instanceof HavocStatement || statement2 instanceof AssertStatement || statement2 instanceof CallStatement) : "If the last constructed node is a TransEdge, then the last Statement must not be a Label, Return or Goto. (i.e. this is not the first Statement of the block)";
                if (this.mCurrent instanceof BoogieIcfgLocation) assert (statement2 instanceof Label || statement2 instanceof CallStatement || statement2 instanceof ForkStatement || statement2 instanceof JoinStatement || statement2 instanceof AtomicStatement) : "If mCurrent is LocNode, then st is first statement of a block; first statement after a call, fork, or join; or follows an atomic block";
                this.processCallStatement((CallStatement)statement);
            } else if (statement instanceof ReturnStatement) {
                this.processReturnStatement();
            } else if (statement instanceof ForkStatement) {
                this.processForkStatement((ForkStatement)statement);
            } else if (statement instanceof JoinStatement) {
                this.processJoinStatement((JoinStatement)statement);
            } else if (statement instanceof AtomicStatement) {
                this.processAtomicStatement(string, (AtomicStatement)statement, statement2);
            } else {
                throw new UnsupportedOperationException("At the moment, only Labels, Assert, Assume, Assignment, Havoc and Goto statements are supported");
            }
        }

        private boolean statementIsControlFlowDead(boolean bl, Statement statement, Statement statement2, Set<String> set) {
            boolean bl2;
            boolean bl3 = bl2 = statement instanceof GotoStatement || statement instanceof ReturnStatement;
            if (bl || bl2) {
                if (statement2 instanceof Label) {
                    Label label = (Label)statement2;
                    return !set.contains(label.getName());
                }
                return true;
            }
            return false;
        }

        private List<EnsuresSpecification> getDummyEnsuresSpecifications(ILocation iLocation) {
            BooleanLiteral booleanLiteral = new BooleanLiteral(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, true);
            EnsuresSpecification ensuresSpecification = new EnsuresSpecification(iLocation, false, (Expression)booleanLiteral);
            ArrayList<EnsuresSpecification> arrayList = new ArrayList<EnsuresSpecification>(1);
            arrayList.add(ensuresSpecification);
            return arrayList;
        }

        private List<RequiresSpecification> getDummyRequiresSpecifications() {
            BooleanLiteral booleanLiteral = new BooleanLiteral(null, (IBoogieType)BoogieType.TYPE_BOOL, true);
            RequiresSpecification requiresSpecification = new RequiresSpecification(null, false, (Expression)booleanLiteral);
            ArrayList<RequiresSpecification> arrayList = new ArrayList<RequiresSpecification>(1);
            arrayList.add(requiresSpecification);
            return arrayList;
        }

        private boolean removeAuxiliaryGoto(GotoEdge gotoEdge, boolean bl) {
            BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)gotoEdge.getSource();
            BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)gotoEdge.getTarget();
            assert (!boogieIcfgLocation2.isErrorLocation());
            for (IcfgEdge icfgEdge : boogieIcfgLocation2.getOutgoingEdges()) {
                if (!(icfgEdge instanceof Call)) continue;
                CfgBuilder.this.mLogger.warn((Object)("Will not remove gotoEdge" + String.valueOf((Object)gotoEdge) + "since this would involve adding/removing calland return edges and bring my naive goto replacing algorithm into terrible trouble"));
                return false;
            }
            CfgBuilder.this.mLogger.debug((Object)("Removed GotoEdge from" + String.valueOf((Object)boogieIcfgLocation) + " to " + String.valueOf((Object)boogieIcfgLocation2)));
            if (boogieIcfgLocation == boogieIcfgLocation2) {
                IcfgEdge icfgEdge;
                boogieIcfgLocation.removeOutgoing((IModifiableMultigraphEdge)gotoEdge);
                gotoEdge.setSource((IcfgLocation)null);
                gotoEdge.setTarget((IcfgLocation)null);
                boogieIcfgLocation2.removeIncoming((IModifiableMultigraphEdge)gotoEdge);
                icfgEdge = boogieIcfgLocation.getBoogieASTNode().getLocation();
                StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence(boogieIcfgLocation, boogieIcfgLocation2, (Statement)new AssumeStatement((ILocation)icfgEdge, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)icfgEdge, (boolean)true)));
                statementSequence.setTransitionFormula(TransFormulaBuilder.getTrivialTransFormula((ManagedScript)CfgBuilder.this.mBoogie2Smt.getManagedScript()));
                CfgBuilder.this.mLogger.debug((Object)"GotoEdge was selfloop");
                return true;
            }
            assert (!boogieIcfgLocation2.getIncomingEdges().isEmpty()) : "there should be at least the goto that might be removed";
            assert (!boogieIcfgLocation.getOutgoingEdges().isEmpty()) : "there should be at least the goto that might be removed";
            if (boogieIcfgLocation2.getIncomingEdges().size() == 1 || boogieIcfgLocation.getOutgoingEdges().size() == 1) {
                boolean bl2;
                boogieIcfgLocation.removeOutgoing((IModifiableMultigraphEdge)gotoEdge);
                gotoEdge.setSource((IcfgLocation)null);
                gotoEdge.setTarget((IcfgLocation)null);
                boogieIcfgLocation2.removeIncoming((IModifiableMultigraphEdge)gotoEdge);
                for (IcfgEdge icfgEdge : boogieIcfgLocation2.getOutgoingEdges()) {
                    ModelUtils.copyAnnotations((IElement)gotoEdge, (IElement)icfgEdge, LoopEntryAnnotation.class);
                    ModelUtils.copyAnnotations((IElement)gotoEdge, (IElement)icfgEdge, LoopExitAnnotation.class);
                }
                boolean bl3 = bl2 = LoopEntryAnnotation.getAnnotation((IElement)boogieIcfgLocation) != null;
                if (bl2) {
                    this.mergeLocNodes(boogieIcfgLocation, boogieIcfgLocation2, false);
                    CfgBuilder.this.mLogger.debug((Object)(String.valueOf((Object)boogieIcfgLocation) + " gets absorbed by " + String.valueOf((Object)boogieIcfgLocation2)));
                } else {
                    this.mergeLocNodes(boogieIcfgLocation2, boogieIcfgLocation, true);
                    CfgBuilder.this.mLogger.debug((Object)(String.valueOf((Object)boogieIcfgLocation2) + " gets absorbed by " + String.valueOf((Object)boogieIcfgLocation)));
                }
                return true;
            }
            if (bl) {
                boogieIcfgLocation.removeOutgoing((IModifiableMultigraphEdge)gotoEdge);
                gotoEdge.setSource((IcfgLocation)null);
                gotoEdge.setTarget((IcfgLocation)null);
                boogieIcfgLocation2.removeIncoming((IModifiableMultigraphEdge)gotoEdge);
                CfgBuilder.this.mLogger.debug((Object)(String.valueOf((Object)boogieIcfgLocation2) + " has " + boogieIcfgLocation2.getIncomingEdges().size() + " predecessors, namely " + String.valueOf(boogieIcfgLocation2.getIncomingNodes())));
                CfgBuilder.this.mLogger.debug((Object)(String.valueOf((Object)boogieIcfgLocation) + " has " + boogieIcfgLocation.getIncomingEdges().size() + " successors, namely " + String.valueOf(boogieIcfgLocation.getOutgoingNodes())));
                CfgBuilder.this.mLogger.debug((Object)("Adding for every successor transition of " + String.valueOf((Object)boogieIcfgLocation2) + " a copy of that transition as successor of " + String.valueOf((Object)boogieIcfgLocation)));
                for (IcfgEdge icfgEdge : boogieIcfgLocation2.getOutgoingEdges()) {
                    BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)icfgEdge.getTarget();
                    CodeBlock codeBlock = CfgBuilder.this.mCbf.copyCodeBlock((CodeBlock)icfgEdge, boogieIcfgLocation, boogieIcfgLocation3);
                    ModelUtils.copyAnnotations((IElement)gotoEdge, (IElement)codeBlock, LoopEntryAnnotation.class);
                    ModelUtils.copyAnnotations((IElement)gotoEdge, (IElement)codeBlock, LoopExitAnnotation.class);
                    if (codeBlock instanceof GotoEdge) {
                        this.mGotoEdges.add((GotoEdge)codeBlock);
                        continue;
                    }
                    this.mEdges.add(codeBlock);
                }
                return true;
            }
            return false;
        }

        private void assertAndAssumeEnsures() {
            AssumeStatement assumeStatement;
            Object object3;
            Object object2;
            List<EnsuresSpecification> list = (List<EnsuresSpecification>)CfgBuilder.this.mBoogieDeclarations.getEnsures().get(this.mCurrentProcedureName);
            if (list == null || list.isEmpty()) {
                object2 = (Procedure)CfgBuilder.this.mBoogieDeclarations.getProcSpecification().get(this.mCurrentProcedureName);
                list = this.getDummyEnsuresSpecifications(object2.getLocation());
            }
            object2 = CfgBuilder.this.mIcfg.mFinalNode.get(this.mCurrentProcedureName);
            this.mLastLabelName = object2.getDebugIdentifier();
            this.mProcLocNodes.put(this.mLastLabelName, (BoogieIcfgLocation)((Object)object2));
            this.mCurrent = object2;
            for (Object object3 : list) {
                assumeStatement = new AssumeStatement(object3.getLocation(), object3.getFormula());
                ModelUtils.copyAnnotations((IElement)object3, (IElement)assumeStatement);
                CfgBuilder.this.mRcfgBacktranslator.putAux((Statement)assumeStatement, new BoogieASTNode[]{object3});
                this.processAssuAssiHavoStatement((Statement)assumeStatement);
            }
            object3 = CfgBuilder.this.mIcfg.getProcedureExitNodes().get(this.mCurrentProcedureName);
            this.mLastLabelName = object3.getDebugIdentifier();
            this.mProcLocNodes.put(this.mLastLabelName, (BoogieIcfgLocation)((Object)object3));
            ((CodeBlock)this.mCurrent).connectTarget((IcfgLocation)object3);
            List list2 = (List)CfgBuilder.this.mBoogieDeclarations.getEnsuresNonFree().get(this.mCurrentProcedureName);
            if (list2 != null && !list2.isEmpty()) {
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    AssumeStatement assumeStatement2;
                    assumeStatement = (EnsuresSpecification)iterator.next();
                    Expression expression = assumeStatement.getFormula();
                    AssumeStatement assumeStatement3 = assumeStatement2 = new AssumeStatement(assumeStatement.getLocation(), CfgBuilder.getNegation(expression));
                    ModelUtils.copyAnnotations((IElement)assumeStatement, (IElement)assumeStatement3);
                    CfgBuilder.this.mRcfgBacktranslator.putAux((Statement)assumeStatement2, new BoogieASTNode[]{assumeStatement});
                    BoogieIcfgLocation boogieIcfgLocation = CfgBuilder.this.addErrorNode(this.mCurrentProcedureName, (BoogieASTNode)assumeStatement, this.mProcLocNodes);
                    StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence((BoogieIcfgLocation)((Object)object2), boogieIcfgLocation, (Statement)assumeStatement2);
                    ModelUtils.copyAnnotations((IElement)assumeStatement, (IElement)statementSequence);
                    ModelUtils.copyAnnotations((IElement)assumeStatement, (IElement)boogieIcfgLocation);
                    this.mEdges.add(statementSequence);
                }
            }
        }

        private void assumeRequires(boolean bl) {
            List<RequiresSpecification> list = (List<RequiresSpecification>)CfgBuilder.this.mBoogieDeclarations.getRequires().get(this.mCurrentProcedureName);
            if ((list == null || list.isEmpty()) && bl) {
                list = this.getDummyRequiresSpecifications();
            }
            if (list != null && !list.isEmpty()) {
                for (RequiresSpecification requiresSpecification : list) {
                    AssumeStatement assumeStatement = new AssumeStatement(requiresSpecification.getLocation(), requiresSpecification.getFormula());
                    ModelUtils.copyAnnotations((IElement)requiresSpecification, (IElement)assumeStatement);
                    CfgBuilder.this.mRcfgBacktranslator.putAux((Statement)assumeStatement, new BoogieASTNode[]{requiresSpecification});
                    this.processAssuAssiHavoStatement((Statement)assumeStatement);
                }
            }
        }

        private DebugIdentifier constructLocDebugIdentifier(Statement statement) {
            ILocation iLocation = statement.getLocation();
            int n = iLocation.getStartLine();
            Integer n2 = this.mNameCache.get(n);
            n2 = n2 == null ? Integer.valueOf(0) : Integer.valueOf(n2 + 1);
            this.mNameCache.put(n, n2);
            LoopEntryAnnotation loopEntryAnnotation = LoopEntryAnnotation.getAnnotation((IElement)statement);
            if (loopEntryAnnotation != null && loopEntryAnnotation.getLoopEntryType() == LoopEntryAnnotation.LoopEntryType.WHILE) {
                return new LoopEntryDebugIdentifier(n, n2.intValue());
            }
            return new OrdinaryDebugIdentifier(n, n2.intValue());
        }

        private BoogieIcfgLocation getLocNodeForLabel(DebugIdentifier debugIdentifier, Statement statement) {
            ILocation iLocation = statement.getLocation();
            LoopEntryAnnotation.getAnnotation((IElement)statement);
            BoogieIcfgLocation boogieIcfgLocation = this.mLabel2LocNodes.get(debugIdentifier);
            if (boogieIcfgLocation != null) {
                while (boogieIcfgLocation != this.mLabel2LocNodes.get(boogieIcfgLocation.getDebugIdentifier())) {
                    boogieIcfgLocation = this.mLabel2LocNodes.get(boogieIcfgLocation.getDebugIdentifier());
                }
                if (CfgBuilder.this.mLogger.isDebugEnabled()) {
                    CfgBuilder.this.mLogger.debug((Object)("LocNode for " + String.valueOf(debugIdentifier) + " already constructed, namely: " + String.valueOf((Object)boogieIcfgLocation)));
                }
                if (statement instanceof Label && boogieIcfgLocation.getDebugIdentifier().equals(debugIdentifier)) {
                    iLocation.annotate((IElement)boogieIcfgLocation);
                }
                ModelUtils.copyAnnotations((IElement)statement, (IElement)boogieIcfgLocation);
                return boogieIcfgLocation;
            }
            boogieIcfgLocation = new BoogieIcfgLocation(debugIdentifier, this.mCurrentProcedureName, false, (BoogieASTNode)statement);
            this.mLabel2LocNodes.put(debugIdentifier, boogieIcfgLocation);
            this.mProcLocNodes.put(debugIdentifier, boogieIcfgLocation);
            if (CfgBuilder.this.mLogger.isDebugEnabled()) {
                CfgBuilder.this.mLogger.debug((Object)("LocNode for " + String.valueOf(debugIdentifier) + " has not existed yet. Constructed it"));
            }
            return boogieIcfgLocation;
        }

        private void processLabel(Label label) {
            boolean bl;
            String string = label.getName();
            boolean bl2 = bl = !this.mLabels.add(string);
            if (bl) {
                throw new AssertionError((Object)("Label " + string + " occurred twice"));
            }
            StringDebugIdentifier stringDebugIdentifier = new StringDebugIdentifier(string);
            this.mLastLabelName = stringDebugIdentifier;
            BoogieIcfgLocation boogieIcfgLocation = this.getLocNodeForLabel((DebugIdentifier)stringDebugIdentifier, (Statement)label);
            if (this.mCurrent instanceof BoogieIcfgLocation) {
                boolean bl3 = LoopExitAnnotation.getAnnotation((IElement)this.mCurrent) == null || LoopEntryAnnotation.getAnnotation((IElement)label) == null;
                this.mergeLocNodes((BoogieIcfgLocation)this.mCurrent, boogieIcfgLocation, bl3);
            } else if (this.mCurrent instanceof CodeBlock) {
                ((IcfgEdge)this.mCurrent).setTarget((IModifiableExplicitEdgesMultigraph)boogieIcfgLocation);
                boogieIcfgLocation.addIncoming((IModifiableMultigraphEdge)((CodeBlock)this.mCurrent));
            }
            this.mCurrent = boogieIcfgLocation;
            LoopEntryAnnotation loopEntryAnnotation = LoopEntryAnnotation.getAnnotation((IElement)label);
            if (loopEntryAnnotation != null && loopEntryAnnotation.getLoopEntryType() == LoopEntryAnnotation.LoopEntryType.WHILE) {
                CfgBuilder.this.mLogger.debug("LocNode %s is marked as loop head (location: %s)", new Object[]{this.mCurrent, label.getLocation()});
                CfgBuilder.this.mIcfg.getLoopLocations().add((BoogieIcfgLocation)this.mCurrent);
            }
        }

        private void processAssuAssiHavoStatement(Statement statement) {
            block8: {
                block9: {
                    block7: {
                        if (!(this.mCurrent instanceof BoogieIcfgLocation)) break block7;
                        this.startNewStatementSequenceAndAddStatement(statement);
                        break block8;
                    }
                    if (!(this.mCurrent instanceof CodeBlock)) break block9;
                    switch (CfgBuilder.this.mCodeBlockSize) {
                        case SequenceOfStatements: 
                        case LoopFreeBlock: {
                            this.addStatementToStatementSequenceThatIsCurrentlyBuilt(statement);
                            break block8;
                        }
                        case OneNontrivialStatement: {
                            if (((StatementSequence)this.mCurrent).isTrivial() || StatementSequence.isAssumeTrueStatement(statement)) {
                                this.addStatementToStatementSequenceThatIsCurrentlyBuilt(statement);
                            } else {
                                this.endCurrentStatementSequence(statement);
                                this.startNewStatementSequenceAndAddStatement(statement);
                            }
                            break block8;
                        }
                        case SingleStatement: {
                            this.endCurrentStatementSequence(statement);
                            this.startNewStatementSequenceAndAddStatement(statement);
                            break block8;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown value: " + String.valueOf((Object)CfgBuilder.this.mCodeBlockSize)));
                        }
                    }
                }
                throw new IllegalArgumentException();
            }
        }

        private void endCurrentStatementSequence(Statement statement) {
            DebugIdentifier debugIdentifier = this.constructLocDebugIdentifier(statement);
            BoogieIcfgLocation boogieIcfgLocation = new BoogieIcfgLocation(debugIdentifier, this.mCurrentProcedureName, false, (BoogieASTNode)statement);
            ((CodeBlock)this.mCurrent).connectTarget(boogieIcfgLocation);
            this.mCurrent = boogieIcfgLocation;
            this.mProcLocNodes.put(debugIdentifier, boogieIcfgLocation);
        }

        private void startNewStatementSequenceAndAddStatement(Statement statement) {
            assert (this.isIntraproceduralBranchFreeStatement(statement)) : "cannot add statement to code block " + String.valueOf(statement);
            StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence((BoogieIcfgLocation)this.mCurrent, null, statement);
            ModelUtils.copyAnnotations((IElement)statement, (IElement)statementSequence);
            this.mEdges.add(statementSequence);
            this.mCurrent = statementSequence;
        }

        private void startNewStatementSequence() {
            StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence((BoogieIcfgLocation)this.mCurrent, null, List.of());
            this.mEdges.add(statementSequence);
            this.mCurrent = statementSequence;
        }

        private void addStatementToStatementSequenceThatIsCurrentlyBuilt(Statement statement) {
            assert (this.isIntraproceduralBranchFreeStatement(statement)) : "cannot add statement to code block " + String.valueOf(statement);
            StatementSequence statementSequence = (StatementSequence)this.mCurrent;
            statementSequence.addStatement(statement);
            ModelUtils.copyAnnotations((IElement)statement, (IElement)statementSequence);
        }

        private boolean isIntraproceduralBranchFreeStatement(Statement statement) {
            if (statement instanceof AssumeStatement) {
                return true;
            }
            if (statement instanceof AssignmentStatement) {
                return true;
            }
            if (statement instanceof HavocStatement) {
                return true;
            }
            if (!(statement instanceof CallStatement)) {
                return false;
            }
            CallStatement callStatement = (CallStatement)statement;
            if (CfgBuilder.this.mBoogieDeclarations.getProcImplementation().containsKey(callStatement.getMethodName())) {
                return false;
            }
            return CfgBuilder.this.mBoogieDeclarations.getRequiresNonFree().get(callStatement.getMethodName()) == null || ((List)CfgBuilder.this.mBoogieDeclarations.getRequiresNonFree().get(callStatement.getMethodName())).isEmpty();
        }

        private void processAssertStatement(AssertStatement assertStatement) {
            if (this.mCurrent instanceof CodeBlock) {
                this.endCurrentStatementSequence((Statement)assertStatement);
            }
            BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)this.mCurrent;
            Expression expression = assertStatement.getFormula();
            AssumeStatement assumeStatement = new AssumeStatement(assertStatement.getLocation(), CfgBuilder.getNegation(expression));
            ModelUtils.copyAnnotations((IElement)assertStatement, (IElement)assumeStatement);
            CfgBuilder.this.mRcfgBacktranslator.putAux((Statement)assumeStatement, new BoogieASTNode[]{assertStatement});
            BoogieIcfgLocation boogieIcfgLocation2 = CfgBuilder.this.addErrorNode(this.mCurrentProcedureName, (BoogieASTNode)assertStatement, this.mProcLocNodes);
            StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence(boogieIcfgLocation, boogieIcfgLocation2, (Statement)assumeStatement);
            ModelUtils.copyAnnotations((IElement)assertStatement, (IElement)boogieIcfgLocation2);
            ModelUtils.copyAnnotations((IElement)assertStatement, (IElement)statementSequence);
            this.mEdges.add(statementSequence);
            AssumeStatement assumeStatement2 = new AssumeStatement(assertStatement.getLocation(), expression);
            assumeStatement2 = CfgBuilder.this.mAddAssumeForEachAssert ? new AssumeStatement(assertStatement.getLocation(), expression) : new AssumeStatement(assertStatement.getLocation(), (Expression)new BooleanLiteral(assertStatement.getLocation(), (IBoogieType)BoogieType.TYPE_BOOL, true));
            AssumeStatement assumeStatement3 = assumeStatement2;
            ModelUtils.copyAnnotations((IElement)assertStatement, (IElement)assumeStatement3);
            CfgBuilder.this.mRcfgBacktranslator.putAux((Statement)assumeStatement2, new BoogieASTNode[]{assertStatement});
            StatementSequence statementSequence2 = CfgBuilder.this.mCbf.constructStatementSequence(boogieIcfgLocation, null, (Statement)assumeStatement2);
            ModelUtils.copyAnnotations((IElement)assertStatement, (IElement)statementSequence2);
            this.mEdges.add(statementSequence2);
            this.mCurrent = statementSequence2;
        }

        private void processGotoStatement(GotoStatement gotoStatement) {
            BoogieIcfgLocation boogieIcfgLocation;
            Object object;
            String[] stringArray = gotoStatement.getLabels();
            assert (stringArray.length != 0) : "Goto must have at least one target";
            CfgBuilder.this.mLogger.debug((Object)("Goto statement with " + stringArray.length + " targets."));
            if (this.mCurrent instanceof CodeBlock) {
                object = this.constructLocDebugIdentifier((Statement)gotoStatement);
                boogieIcfgLocation = new BoogieIcfgLocation((DebugIdentifier)object, this.mCurrentProcedureName, false, (BoogieASTNode)gotoStatement);
                ((CodeBlock)this.mCurrent).connectTarget(boogieIcfgLocation);
                this.mProcLocNodes.put((DebugIdentifier)object, boogieIcfgLocation);
            } else if (this.mCurrent instanceof BoogieIcfgLocation) {
                boogieIcfgLocation = (BoogieIcfgLocation)this.mCurrent;
            } else {
                throw new IllegalArgumentException();
            }
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray2[n2];
                BoogieIcfgLocation boogieIcfgLocation2 = this.getLocNodeForLabel((DebugIdentifier)new StringDebugIdentifier((String)object), (Statement)gotoStatement);
                GotoEdge gotoEdge = CfgBuilder.this.mCbf.constructGotoEdge(boogieIcfgLocation, boogieIcfgLocation2);
                ModelUtils.copyAnnotations((IElement)gotoStatement, (IElement)gotoEdge);
                this.mGotoEdges.add(gotoEdge);
                ++n2;
            }
            this.mCurrent = null;
        }

        private void processCallStatement(CallStatement callStatement) {
            Summary summary;
            BoogieIcfgLocation boogieIcfgLocation;
            DebugIdentifier debugIdentifier;
            boolean bl;
            String string = callStatement.getMethodName();
            if ("__VERIFIER_atomic_begin".equals(string)) {
                this.beginAtomicBlock((Statement)callStatement);
                return;
            }
            if ("__VERIFIER_atomic_end".equals(string)) {
                this.endAtomicBlock((Statement)callStatement);
                return;
            }
            List list = (List)CfgBuilder.this.mBoogieDeclarations.getRequiresNonFree().get(string);
            boolean bl2 = CfgBuilder.this.mBoogieDeclarations.getProcImplementation().containsKey(string);
            boolean bl3 = bl = list == null || list.isEmpty();
            if ((CfgBuilder.this.mCodeBlockSize == RcfgPreferenceInitializer.CodeBlockSize.SequenceOfStatements || CfgBuilder.this.mCodeBlockSize == RcfgPreferenceInitializer.CodeBlockSize.LoopFreeBlock) && !bl2 && bl) {
                if (this.mCurrent instanceof BoogieIcfgLocation) {
                    this.startNewStatementSequenceAndAddStatement((Statement)callStatement);
                } else if (this.mCurrent instanceof CodeBlock) {
                    this.addStatementToStatementSequenceThatIsCurrentlyBuilt((Statement)callStatement);
                } else {
                    throw new AssertionError((Object)"mCurrent must be CodeBlock or BoogieIcfgLocation");
                }
                return;
            }
            if (this.mCurrent instanceof CodeBlock) {
                debugIdentifier = this.constructLocDebugIdentifier((Statement)callStatement);
                boogieIcfgLocation = new BoogieIcfgLocation(debugIdentifier, this.mCurrentProcedureName, false, (BoogieASTNode)callStatement);
                ((CodeBlock)this.mCurrent).connectTarget(boogieIcfgLocation);
                this.mProcLocNodes.put(debugIdentifier, boogieIcfgLocation);
            } else if (this.mCurrent instanceof BoogieIcfgLocation) {
                boogieIcfgLocation = (BoogieIcfgLocation)this.mCurrent;
            } else {
                throw new IllegalArgumentException();
            }
            debugIdentifier = this.constructLocDebugIdentifier((Statement)callStatement);
            BoogieIcfgLocation boogieIcfgLocation2 = new BoogieIcfgLocation(debugIdentifier, this.mCurrentProcedureName, false, (BoogieASTNode)callStatement);
            this.mProcLocNodes.put(debugIdentifier, boogieIcfgLocation2);
            if (CfgBuilder.this.mBoogieDeclarations.getProcImplementation().containsKey(string)) {
                summary2 = summary = CfgBuilder.this.mCbf.constructSummary(boogieIcfgLocation, boogieIcfgLocation2, callStatement, true);
                ModelUtils.copyAnnotations((IElement)callStatement, (IElement)summary2);
                CfgBuilder.this.mImplementationSummarys.add(summary);
            } else {
                summary2 = summary = CfgBuilder.this.mCbf.constructSummary(boogieIcfgLocation, boogieIcfgLocation2, callStatement, false);
                ModelUtils.copyAnnotations((IElement)callStatement, (IElement)summary2);
            }
            this.mEdges.add(summary);
            this.mCurrent = boogieIcfgLocation2;
            if (list != null && !list.isEmpty()) {
                for (Summary summary2 : list) {
                    AssumeStatement assumeStatement;
                    Procedure procedure = CfgBuilder.this.mBoogieDeclarations.getProcImplementation().containsKey(string) ? (Procedure)CfgBuilder.this.mBoogieDeclarations.getProcImplementation().get(string) : (Procedure)CfgBuilder.this.mBoogieDeclarations.getProcSpecification().get(string);
                    Expression expression = CfgBuilder.getNegation(new WeakestPrecondition(summary2.getFormula(), callStatement, procedure).getResult());
                    AssumeStatement assumeStatement2 = assumeStatement = new AssumeStatement(callStatement.getLocation(), expression);
                    ModelUtils.copyAnnotations((IElement)callStatement, (IElement)assumeStatement2);
                    CfgBuilder.this.mRcfgBacktranslator.putAux((Statement)assumeStatement, new BoogieASTNode[]{callStatement, summary2});
                    BoogieIcfgLocation boogieIcfgLocation3 = CfgBuilder.this.addErrorNode(this.mCurrentProcedureName, (BoogieASTNode)summary2, this.mProcLocNodes);
                    StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence(boogieIcfgLocation, boogieIcfgLocation3, (Statement)assumeStatement);
                    ModelUtils.copyAnnotations((IElement)summary2, (IElement)statementSequence);
                    ModelUtils.copyAnnotations((IElement)summary2, (IElement)boogieIcfgLocation3);
                    this.mEdges.add(statementSequence);
                }
            }
        }

        private void processReturnStatement() {
            BoogieIcfgLocation boogieIcfgLocation = CfgBuilder.this.mIcfg.mFinalNode.get(this.mCurrentProcedureName);
            if (this.mCurrent instanceof CodeBlock) {
                CodeBlock codeBlock = (CodeBlock)this.mCurrent;
                codeBlock.connectTarget(boogieIcfgLocation);
                if (CfgBuilder.this.mLogger.isDebugEnabled()) {
                    CfgBuilder.this.mLogger.debug((Object)("Constructed TransEdge " + String.valueOf((Object)codeBlock) + "as predecessr of " + String.valueOf(CfgBuilder.this.mIcfg.mFinalNode)));
                }
            } else if (this.mCurrent instanceof BoogieIcfgLocation) {
                this.mergeLocNodes((BoogieIcfgLocation)this.mCurrent, boogieIcfgLocation, true);
                if (CfgBuilder.this.mLogger.isDebugEnabled()) {
                    CfgBuilder.this.mLogger.debug((Object)("Replacing " + String.valueOf(this.mCurrent) + " by " + String.valueOf((Object)boogieIcfgLocation)));
                }
            } else {
                throw new IllegalArgumentException();
            }
            this.mCurrent = null;
        }

        private void processForkStatement(ForkStatement forkStatement) {
            ForkThreadCurrent forkThreadCurrent;
            BoogieIcfgLocation boogieIcfgLocation;
            DebugIdentifier debugIdentifier;
            if (this.mCurrent instanceof CodeBlock) {
                debugIdentifier = this.constructLocDebugIdentifier((Statement)forkStatement);
                boogieIcfgLocation = new BoogieIcfgLocation(debugIdentifier, this.mCurrentProcedureName, false, (BoogieASTNode)forkStatement);
                ((CodeBlock)this.mCurrent).connectTarget(boogieIcfgLocation);
                this.mProcLocNodes.put(debugIdentifier, boogieIcfgLocation);
            } else if (this.mCurrent instanceof BoogieIcfgLocation) {
                boogieIcfgLocation = (BoogieIcfgLocation)this.mCurrent;
            } else {
                throw new IllegalArgumentException();
            }
            debugIdentifier = this.constructLocDebugIdentifier((Statement)forkStatement);
            BoogieIcfgLocation boogieIcfgLocation2 = new BoogieIcfgLocation(debugIdentifier, this.mCurrentProcedureName, false, (BoogieASTNode)forkStatement);
            this.mProcLocNodes.put(debugIdentifier, boogieIcfgLocation2);
            String string = forkStatement.getProcedureName();
            if (CfgBuilder.this.mBoogieDeclarations.getProcImplementation().containsKey(string)) {
                ForkThreadCurrent forkThreadCurrent2 = forkThreadCurrent = CfgBuilder.this.mCbf.constructForkCurrentThread(boogieIcfgLocation, boogieIcfgLocation2, forkStatement, true);
                ModelUtils.copyAnnotations((IElement)forkStatement, (IElement)forkThreadCurrent2);
                CfgBuilder.this.mForks.put(forkThreadCurrent, null);
            } else {
                ForkThreadCurrent forkThreadCurrent3 = forkThreadCurrent = CfgBuilder.this.mCbf.constructForkCurrentThread(boogieIcfgLocation, boogieIcfgLocation2, forkStatement, false);
                ModelUtils.copyAnnotations((IElement)forkStatement, (IElement)forkThreadCurrent3);
            }
            this.mEdges.add(forkThreadCurrent);
            this.mCurrent = boogieIcfgLocation2;
        }

        private void processJoinStatement(JoinStatement joinStatement) {
            JoinThreadCurrent joinThreadCurrent;
            BoogieIcfgLocation boogieIcfgLocation;
            DebugIdentifier debugIdentifier;
            if (this.mCurrent instanceof CodeBlock) {
                debugIdentifier = this.constructLocDebugIdentifier((Statement)joinStatement);
                boogieIcfgLocation = new BoogieIcfgLocation(debugIdentifier, this.mCurrentProcedureName, false, (BoogieASTNode)joinStatement);
                ((CodeBlock)this.mCurrent).connectTarget(boogieIcfgLocation);
                this.mProcLocNodes.put(debugIdentifier, boogieIcfgLocation);
            } else if (this.mCurrent instanceof BoogieIcfgLocation) {
                boogieIcfgLocation = (BoogieIcfgLocation)this.mCurrent;
            } else {
                throw new IllegalArgumentException();
            }
            debugIdentifier = this.constructLocDebugIdentifier((Statement)joinStatement);
            BoogieIcfgLocation boogieIcfgLocation2 = new BoogieIcfgLocation(debugIdentifier, this.mCurrentProcedureName, false, (BoogieASTNode)joinStatement);
            this.mProcLocNodes.put(debugIdentifier, boogieIcfgLocation2);
            JoinThreadCurrent joinThreadCurrent2 = joinThreadCurrent = CfgBuilder.this.mCbf.constructJoinCurrentThread(boogieIcfgLocation, boogieIcfgLocation2, joinStatement);
            ModelUtils.copyAnnotations((IElement)joinStatement, (IElement)joinThreadCurrent2);
            CfgBuilder.this.mJoins.add(joinThreadCurrent);
            this.mEdges.add(joinThreadCurrent);
            this.mCurrent = boogieIcfgLocation2;
        }

        private void beginAtomicBlock(Statement statement) {
            if (this.mCurrent instanceof CodeBlock) {
                this.endCurrentStatementSequence(statement);
            }
            assert (this.mCurrent instanceof BoogieIcfgLocation) : "Atomic section must begin with ICFG location";
            this.startNewStatementSequence();
            assert (this.mCurrent instanceof CodeBlock) : "Start marker for atomic section must be an edge";
            AtomicBlockInfo.addBeginAnnotation((IIcfgTransition)this.mCurrent);
        }

        private void endAtomicBlock(Statement statement) {
            if (!(this.mCurrent instanceof CodeBlock)) {
                this.startNewStatementSequence();
            }
            assert (this.mCurrent instanceof CodeBlock) : "End marker for atomic section must be an edge";
            if (AtomicBlockInfo.isStartOfAtomicBlock((IIcfgTransition)this.mCurrent)) {
                AtomicBlockInfo.removeAnnotation((IIcfgTransition)this.mCurrent);
                AtomicBlockInfo.addCompleteAnnotation((IIcfgTransition)this.mCurrent);
            } else {
                AtomicBlockInfo.addEndAnnotation((IIcfgTransition)this.mCurrent);
            }
            this.endCurrentStatementSequence(statement);
            assert (this.mCurrent instanceof BoogieIcfgLocation) : "Atomic section must end with ICFG location";
        }

        private void processAtomicStatement(String string, AtomicStatement atomicStatement, Statement statement) {
            this.beginAtomicBlock((Statement)atomicStatement);
            int n = 0;
            while (n < atomicStatement.getBody().length) {
                Statement statement2 = atomicStatement.getBody()[n];
                Statement statement3 = n == 0 ? statement : atomicStatement.getBody()[n - 1];
                this.processStatement(string, statement2, statement3, true);
                ++n;
            }
            this.endAtomicBlock((Statement)atomicStatement);
        }

        private void mergeLocNodes(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, boolean bl) {
            assert (!boogieIcfgLocation.isErrorLocation());
            if (boogieIcfgLocation == boogieIcfgLocation2) {
                return;
            }
            for (IcfgEdge icfgEdge : boogieIcfgLocation.getIncomingEdges()) {
                icfgEdge.setTarget((IModifiableExplicitEdgesMultigraph)boogieIcfgLocation2);
                boogieIcfgLocation2.addIncoming((IModifiableMultigraphEdge)icfgEdge);
            }
            boogieIcfgLocation.clearIncoming();
            for (IcfgEdge icfgEdge : boogieIcfgLocation.getOutgoingEdges()) {
                icfgEdge.setSource((IModifiableExplicitEdgesMultigraph)boogieIcfgLocation2);
                boogieIcfgLocation2.addOutgoing((IModifiableMultigraphEdge)icfgEdge);
            }
            boogieIcfgLocation.clearOutgoing();
            this.mProcLocNodes.remove(boogieIcfgLocation.getDebugIdentifier());
            if (this.mLabel2LocNodes.containsKey(boogieIcfgLocation.getDebugIdentifier())) {
                this.mLabel2LocNodes.put(boogieIcfgLocation.getDebugIdentifier(), boogieIcfgLocation2);
            }
            assert (boogieIcfgLocation != CfgBuilder.this.mIcfg.getProcedureExitNodes().get(this.mCurrentProcedureName));
            if (boogieIcfgLocation == CfgBuilder.this.mIcfg.getProcedureEntryNodes().get(this.mCurrentProcedureName)) {
                CfgBuilder.this.mIcfg.getProcedureEntryNodes().put(this.mCurrentProcedureName, boogieIcfgLocation2);
            }
            if (CfgBuilder.this.mIcfg.getLoopLocations().remove((Object)boogieIcfgLocation)) {
                CfgBuilder.this.mIcfg.getLoopLocations().add(boogieIcfgLocation2);
            }
            if (bl) {
                ModelUtils.copyAnnotations((IElement)boogieIcfgLocation, (IElement)boogieIcfgLocation2);
            } else {
                ModelUtils.copyAnnotationsExcept((IElement)boogieIcfgLocation, (IElement)boogieIcfgLocation2, (Class[])new Class[]{ILocation.class});
            }
        }
    }
}

